/*
  Author: Vincent.GRANET "vg@unice.fr"
  Creation date: 17-Apr-2022 16:14
  Last file update: 15-May-2025 10:42
*/

#include <stdio.h>
#include <stdlib.h>
#include <libsx.h>
#include "data.h"
#include "vue.h"

int main(int argc, char *argv[]) {
    if (OpenDisplay(argc, argv) == 0) {
      fprintf(stderr,"Can't open display\n");
      return EXIT_FAILURE;
    }
    // initialiser la donnée partagée avec le modèle
    ValeurCourante d;    
    initValeurCourante(&d, 8.3333); // 1€ = 8.333 yuan au 15/05/2025

    // créer l'IG et l'afficher à l'écran
    init_display(argc, argv, &d);
    MainLoop();

    return EXIT_SUCCESS;
}

