/*
 * Author: Vincent.GRANET "vg@unice.fr"
 * Creation date: 17-Apr-2022 16:18
 * Last file update: 16-May-2024 09:18
*/

#include <stdlib.h>
#include <stdio.h>
#include <libsx.h>
#include "data.h"
#include "vue.h"
#include "callbacks.h"

/* Callback bouton quit. 
 * Rôle : terminer l'application 
 */
void quit(Widget w, void *d) {
  ...
}

/* Rôle : affiche dans la zone de saisie la valeur v
 */ 
static void afficher(const double v) {
  const int TailleZoneSaisie =
    TextWidth(GetWidgetFont(ZoneSaisie), GetStringEntry(ZoneSaisie));
  char s[TailleZoneSaisie+1];
  sprintf(s,"%-f", v);
  SetStringEntry(ZoneSaisie,s);
}

/* 
 * Rôle :  Callback bouton yuans. 
 *         remplace la valeur en euros qui est de la zone de saisie
 *         par sa valeur convertie en yuans
 */
void yuans(Widget w, void *d) {
  // 1 : récupérer la valeur dans la zone de saisie
  // 2 : mettre cette valeur dans la donnée partagée 
  ...
  // 3 : convertir en yuans
  ...
  // 4 : afficher la conversion
  ...
}


/* 
 * Rôle :  Callback bouton euros. 
 *         remplace la valeur en yuans qui est de la zone de saisie
 *         par sa valeur convertie en euros
 */
void euros(Widget w, void *d) {
  // 1 : récupérer la valeur dans la zone de saisie
  // 2 : mettre cette valeur dans la donnée partagée 
  ...
  // 3 : convertir en euros
  ...
  // 4 : afficher la conversion
  ...
}

