//
// This code was created by Jeff Molofee '99 (ported to Linux/GLUT by Richard Campbell '99)
//
// If you've found this code useful, please let me know.
//
// Visit me at www.demonews.com/hosted/nehe 
// (email Richard Campbell at ulmont@bellsouth.net)
// Largement modif par M.Buffa et F.Devernay pour leurs TDs  l'ESSI ! 
// (buffa@unice.fr, devernay@unice.fr)
//

#include <GL/glut.h>    // Header File For The GLUT Library 
#include <GL/gl.h>	// Header File For The OpenGL32 Library
#include <GL/glu.h>	// Header File For The GLu32 Library
//#include <unistd.h>     // Header File For sleeping.
#include <stdlib.h>   // pour le exit()
#include <math.h>
#include <stdio.h>
#include <mmsystem.h>
#include "trackball.h"  // Pour la boule virtuelle

#define MAX(a,b) (((a) < (b)) ? b : a)
#define MIN(a,b) (((a) < (b)) ? a : b)
#define M_PI 3.14159265359
#define RAD2DEG(x) (x*180/M_PI)
#define DEG2RAD(x) (x*M_PI/180)


/* ASCII code for the escape key. */
#define ESCAPE 27

/* The number of our GLUT window */
int window; 

/* pour stocker la modelview, matrice de positionnement de la scne */
GLfloat modelview[16];

/* matrices de positionnement du triangle et du carr */
GLfloat cubeModelview[16];
GLfloat billeModelview[16];
GLfloat xc, yc, zc;

/* Variable pour les dplacements du point de vue */
GLboolean moving = GL_FALSE, scaling= GL_FALSE;

// Trackball
static GLfloat lastquat[4];
static GLfloat curquat[4];
// Proprits de la fentre
GLint width=512, height=512, posx=80, posy=20;

GLfloat scalefactor= 1.0;
int  startx, starty;


// Une bille
typedef struct bille {
	double color[3];
	double rayon;
	double force[3];
	double pos[3];
	double vit[3];
} Bille;

static Bille b1;
static double gravite[3]={0,-9.8,0};


// Un point 
typedef struct point {
	double x;
	double y;
	double z;
} Point;

static Point point1;
static Point point2;

void InitGL(int Width, int Height);
void drawCube(void);
void drawBille(void);
void recalcModelView(void);
void getModelViewPosition(GLfloat *x, GLfloat *ty, GLfloat *z);
void printModelviewMatrix(void);
void printPositionFromModelviewMatrix(GLfloat *m);
void getObservateurPosition(GLfloat *x, GLfloat *y, GLfloat *z);
double Distance_signee(Point P, Point P1, Point P2, Point P3);

/* A general OpenGL initialization function.  Sets all of the initial parameters. */
void InitGL(int Width, int Height)	        // We call this right after our OpenGL window is created.
{

  glClearColor(1.0f, 1.0f, 1.0f, 0.0f);		// This Will Clear The Background Color To Black
  glClearDepth(1.0);				// Enables Clearing Of The Depth Buffer
  glDepthFunc(GL_LESS);				// The Type Of Depth Test To Do
  glEnable(GL_DEPTH_TEST);			// Enables Depth Testing
  glEnable(GL_NORMALIZE);
  glShadeModel(GL_SMOOTH);			// Enables Smooth Color Shading
  
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();				// Reset The Projection Matrix

  gluPerspective(45.0f,(GLfloat)Width/(GLfloat)Height,0.1f,100.0f);	// Calculate The Aspect Ratio Of The Window

  glMatrixMode(GL_MODELVIEW);

  // Position du cube. Permet d'initialiser sa matrice de positionnement.
  glPushMatrix();
  glLoadIdentity();
  glTranslatef(0.0, 0.0, 0.0);
 //glRotatef(45.0,0.0, 0.0, 1.0);
  glGetFloatv(GL_MODELVIEW_MATRIX, cubeModelview);
  glPopMatrix();

  // Initialisation de la bille
  b1.rayon=0.1;
  b1.color[0]=1.0;
  b1.color[1]=b1.color[2]=0.0;
  b1.pos[0]=b1.pos[1]=b1.pos[2]=0.0;
  point1.x=point1.y=point1.z=0.0;
  b1.vit[0]=0.0;
  b1.vit[1]=-2;
  b1.vit[2]=0.0;
  
  // Position de la bille. Permet d'initialiser sa matrice de positionnement.
  glPushMatrix();	
  glLoadIdentity();
  glTranslatef(0.0, 0.0, 0.0);
  glGetFloatv(GL_MODELVIEW_MATRIX, billeModelview);
  glPopMatrix();

  // Scne 1m au-dessous de la camra, 8m devant.
  glTranslatef(0.0, -1, -8);
  printModelviewMatrix();

  // Pour la boule virtuelle, il est impratif de sauvegarder une premire fois
  // la modelview du dpart, car elle dfinit le centre du repre de la scne, soit
  // le centre de la boule virtuelle.
  trackball(curquat, 0.0f, 0.0f, 0.0f, 0.0f); // Rotation nulle. Set  initialiser la rotation 0
  glPushMatrix();
  recalcModelView(); // initialize the modelview matrix 
}

/*--------------------------------------------------*/
void printPositionFromModelviewMatrix(GLfloat *m) {
/*--------------------------------------------------*/
/* Affiche la position du repre dfini par la matrice m */
	printf("x = %g, y = %g, z = %g\n", m[12], m[13], m[14]);
}



/*---------------------------------------------------------------*/
void getObservateurPosition(GLfloat *x, GLfloat *y, GLfloat *z) {
/*---------------------------------------------------------------*/
/* Affiche la position de l'observateur dans le repre dfini par la modelView  */
	double X,Y,Z;

	glGetFloatv(GL_MODELVIEW_MATRIX, modelview);

	/* position p du repere du monde par rapport a la camera */
	X = modelview[12];
	Y = modelview[13];
	Z = modelview[14];

	/* position de l'observateur dans le repere du monde.
	   c'est la derniere ligne de l'inverse de modelview.
	   la derniere colonne de modelview est 0,0,0,1.
	   l'inverse d'une rotation est sa transposee.
	   donc... */
	*x = modelview[0] * -X + modelview[1] * -Y + modelview[2] * -Z;
	*y = modelview[4] * -X + modelview[5] * -Y + modelview[6] * -Z;
	*z = modelview[8] * -X + modelview[9] * -Y + modelview[10] * -Z;
}


/*-----------------------------*/
void printMatrix(GLfloat *m) {
/*-----------------------------*/
	int i, j;
	
	for(i=0; i < 4; i++) {
		for(j = 0; j < 4; j++) {
			printf("%g(%d)\t\t", m[i*4 + j], i*4 + j);
		}
		printf("\n");
	}
	printf("\n");
}

/*-----------------------------*/
void printModelviewMatrix(void) {
/*-----------------------------*/
	glGetFloatv(GL_MODELVIEW_MATRIX, modelview);
	printMatrix(modelview);
}

/*---------------------------------------------------------------*/
void getModelviewPosition(GLfloat *x, GLfloat *y, GLfloat *z) {
/*---------------------------------------------------------------*/
/* Affiche la position du repre dfinit par la matrice Modelview courante */
	glGetFloatv(GL_MODELVIEW_MATRIX, modelview);

	*x = modelview[12];
	*y = modelview[13];
	*z = modelview[14];
}

/*----------------------------------*/
void printModelviewPosition(void) {
/*----------------------------------*/
/* Affiche le contenu de la matrice modelview */
	GLfloat x, y, z;

	getModelviewPosition(&x, &y, &z);
	printf("x = %g, y = %g, z = %g\n", x, y, z);
}

/*-------------------------------------------------------*/
int translateModelview(float dist, GLfloat *modelview) {
/*-------------------------------------------------------*/

/* Effectue une translation le long de l'axe Z de la modelview passe en
   paramtre. A la sortie, la modelview est translate */

  glPushMatrix();						// Pour ne pas affecter la matrice courante
	  glLoadMatrixf(modelview);			// Matrice courante = la matrice passe en paramtre
	  glTranslatef(0.0, 0.0, dist);		// On translate localement en Z le long de l'axe Z de
										//     la matrice courante. La matrice courante est affecte

	  glGetFloatv(GL_MODELVIEW_MATRIX, modelview);	// On stocke dans modelview la matrice courante
  glPopMatrix();

  return 0;
}


/*-------------------------------------------------------*/
int translateModelview_bis(float distx, float disty, float distz, GLfloat *modelview) {
/*-------------------------------------------------------*/

/* Effectue une translation le long de l'axe Z de la modelview passe en
   paramtre. A la sortie, la modelview est translate */

	//glTranslatef(distx, disty, distz);
  glPushMatrix();						// Pour ne pas affecter la matrice courante
	  glLoadMatrixf(modelview);			// Matrice courante = la matrice passe en paramtre
//	  glLoadIdentity();
	  glTranslatef(distx, disty, distz);		// On translate localement en Z le long de l'axe Z de
										//     la matrice courante. La matrice courante est affecte

	  glGetFloatv(GL_MODELVIEW_MATRIX, modelview);	// On stocke dans modelview la matrice courante
  glPopMatrix();

  return 0;
}

/*-------------------------------------------------------*/
int rotateModelview_z(float angle, GLfloat *modelview) {
/*-------------------------------------------------------*/
/* Effectue une rotation autours de l'axe Y de la modelview passe en
   paramtre. A la sortie, la modelview est tourne */

	glPushMatrix();
	  glLoadIdentity();					// Pour ne pas affecter la matrice courante
	  glLoadMatrixf(modelview);			// Matrice courante = la matrice passe en paramtre
	  glRotatef(angle, 0.0, 0.0, 1.0);  // Rotation locale autours de l'axe Y de la matrice courante
	  glGetFloatv(GL_MODELVIEW_MATRIX, modelview);	// On stocke dans modelview la matrice courante
  glPopMatrix();

  return 0;
}



/*-------------------------------------------------------*/
int rotateModelview(float angle, GLfloat *modelview) {
/*-------------------------------------------------------*/
/* Effectue une rotation autours de l'axe Y de la modelview passe en
   paramtre. A la sortie, la modelview est tourne */

	glPushMatrix();
	  glLoadIdentity();					// Pour ne pas affecter la matrice courante
	  glLoadMatrixf(modelview);			// Matrice courante = la matrice passe en paramtre
	  glRotatef(angle, 0.0, 1.0, 0.0);  // Rotation locale autours de l'axe Y de la matrice courante
	  glGetFloatv(GL_MODELVIEW_MATRIX, modelview);	// On stocke dans modelview la matrice courante
  glPopMatrix();

  return 0;
}

/* The function called when our window is resized (which shouldn't happen, because we're fullscreen) */
void ReSizeGLScene(int Width, int Height)
{
  if (Height==0)				// Prevent A Divide By Zero If The Window Is Too Small
    Height=1;

  glViewport(0, 0, Width, Height);		// Reset The Current Viewport And Perspective Transformation

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();

  gluPerspective(45.0f,(GLfloat)Width/(GLfloat)Height,0.1f,100.0f);
  glMatrixMode(GL_MODELVIEW);

  width = Width; height = Height;
}

/*---------------------------*/
void recalcModelView(void) {
/*---------------------------*/
/* Utilise pour le calcul de la rotation de la scne avec la boule virtuelle */
  GLfloat m[4][4];
  
  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();				// Matrice courante = matrice sur le haut de la pile. Normalement, 
								// la matrice initiale qui contient le centre de la boule virtuelle

  glPushMatrix();			    // On en met une copie sur le haut de la pile. On ne doit jamais perdre la matrice
								// du dbut !

  build_rotmatrix(m, curquat);	// curquat contient la rotation globale somme de toutes les micro-rotations sur la BV
								// On transforme le quaternion en matrice de rotation

  glMultMatrixf(&m[0][0]);		// On multiplie  gauche la matrice initiale par cette matrice de rotation. Fait une
								// rotation locale

  //glScalef(scalefactor, scalefactor, scalefactor); // Mise  l'echelle pour zoom. Non implmente.
  //curquat[0] = curquat[1] =curquat[2] =curquat[3] = 0.0;
}

/*----------------------------------------*/
void suitObjet(GLfloat *modelviewObjet) {
/*----------------------------------------*/
/* Cette fonction oriente la camra sans la dplacer, pour qu'elle vise l'objet dont la matrice de positionnement
   est passe en paramtre. */
	GLfloat x, y, z;

	// On rcupre la position de la camra dans le repre dfini par la matrice dfinissant la position
	// et l'orientation du repre de l'objet que l'on veut suivre, passe en paramtre.
	getObservateurPosition(&x, &y, &z);

	// On remet la camra  l'origine de la scne.
	glLoadIdentity();

	// On positionne la camra l o elle tait avant le glLoadIdentity et on l'oriente
	// pour qu'elle vise l'objet
	gluLookAt(x, y, z,
			  modelviewObjet[12], modelviewObjet[13], modelviewObjet[14],
			  0.0, 1.0, 0.0);
}

/*  Animation */


/* Calcul de l'quation d'un plan passant par trois points*/
/*--------------------------------------------------*/
 void Equation_plan(double *eq, Point P1, Point P2, Point P3){
/*--------------------------------------------------*/
	eq[0]=P2.y*P3.z-P2.y*P1.z-P1.y*P3.z-P3.y*P2.z+P3.y*P1.z+P1.y*P2.z;
	eq[1]=-P3.x*P1.z+P2.x*P1.z+P1.x*P3.z+P3.x*P2.z-P1.x*P2.z-P2.x*P3.z;
	eq[2]=P2.x*P3.y-P2.x*P1.y-P1.x*P3.y-P3.x*P2.y+P1.x*P2.y+P3.x*P1.y;
	eq[3]=-P1.x*P2.y*P3.z+P1.x*P3.y*P2.z+P2.x*P1.y*P3.z-P3.x*P1.y*P2.z-P2.x*P3.y*P1.z+P3.x*P2.y*P1.z;
}


/* Calcul de la distance d'un point a un plan passant par trois points donns*/
/*-----------------------------------------------------------*/
double Distance_carre(Point P, Point P1, Point P2, Point P3){
/*-----------------------------------------------------------*/
	double eq[4];
	double a,b,c,d;

	Equation_plan(eq,P1,P2,P3);
	a=eq[0];
	b=eq[1];
	c=eq[2];
	d=eq[3];
	
	return (pow(a*P.x+b*P.y+c*P.z+d,2) / (a*a+b*b+c*c));
}


/* Calcul de la distance d'un point a un plan passant par trois points donns*/
/*-----------------------------------------------------------*/
double Distance_signee(Point P, Point P1, Point P2, Point P3){
/*-----------------------------------------------------------*/
	double eq[4];
	double a,b,c,d,dist,sign;

	Equation_plan(eq,P1,P2,P3);
	a=eq[0];
	b=eq[1];
	c=eq[2];
	d=eq[3];

	if (fabs(a*P.x+b*P.y+c*P.z+d) > 0.00000000001) {
		dist = pow(a*P.x+b*P.y+c*P.z+d,2) / (a*a+b*b+c*c);
		sign = -((a*P.x+b*P.y+c*P.z+d) / fabs(a*P.x+b*P.y+c*P.z+d));
		return (sqrt(dist)*sign);
	}
	else
		return 0.0;
}


/* inverse un modelview */
/***************************************/
void InvertModelview(GLfloat *m1,GLfloat *b) {
/***************************************/
	b[0] = m1[0];
  	b[1] = m1[4];
	b[2] = m1[8];
	b[4] = m1[1];
	b[5] = m1[5];
	b[6] = m1[9];
	b[8] = m1[2];
	b[9] = m1[6];
	b[10] = m1[10];
  
	b[12] = -( m1[12] * b[0] + m1[13] * b[4] + m1[14] * b[8] );
	b[13] = -( m1[12] * b[1] + m1[13] * b[5] + m1[14] * b[9] );
	b[14] = -( m1[12] * b[2] + m1[13] * b[6] + m1[14] * b[10] );
  
	b[3] = b[7] = b[11] = 0.0f; 
	b[15] = 1.0f;
}


/* multiplie un point par une modelview */
/***************************************/
void MultModelview(GLfloat *m1,Point p, Point *b) {
/***************************************/
	double temp;

	b->x = p.x*m1[0]+p.y*m1[1]+p.z*m1[2]+m1[3];
  	b->y = p.x*m1[4]+p.y*m1[5]+p.z*m1[6]+m1[7];
	b->z = p.x*m1[8]+p.y*m1[9]+p.z*m1[10]+m1[11];
	temp = p.x*m1[12]+p.y*m1[13]+p.z*m1[14]+m1[15];

	b->x /= temp;
	b->y /= temp;
	b->z /= temp;

}


/* produit scalaire de deux vecteurs */
/***************************************/
double MultVector(Point p1,Point p2) {
/***************************************/
	double temp = 0.0;

	temp += p1.x*p2.x;
	temp += p1.y*p2.y;
	temp += p1.z*p2.z;

	return temp;
}

/* Calcule la distance au carre entre deux points */
/***************************************/
double DiffPoint(Point p1,Point p2) {
/***************************************/
	Point temp;

	temp.x = p1.x-p2.x;
	temp.y = p1.y-p2.y;
	temp.z = p1.z-p2.z;

	return MultVector(temp,temp);
}

/* Teste si la bille entre en collision avec une des faces du cube */
/*----------------------------------------*/
BOOL Collisions(double *next_vit, Point *next_point){
/*----------------------------------------*/
	int flag = 0;
	Point P1,P2,P3,P4,P5,P6,x,v_temp,vx;
	Point normale;
	double comp_normale;
	GLfloat	cubeModelviewInv[16];
	double attenuation = 0.8;
	double seuil = 0.5;
	double dist;
	/* sommets du cube dans son propre repre*/
	P1.x=-1.0;P1.y=-1.0;P1.z=1.0;
	P2.x=-1.0;P2.y=-1.0;P2.z=-1.0;
	P3.x=1.0;P3.y=-1.0;P3.z=-1.0;
	P4.x=1.0;P4.y=1.0;P4.z=-1.0;
	P5.x=1.0;P5.y=1.0;P5.z=1.0;
	P6.x=-1.0;P6.y=1.0;P6.z=1.0;

	/* on transforme next_point et old_vit dans le repre du cube */
	InvertModelview(cubeModelview,cubeModelviewInv);
	MultModelview(cubeModelviewInv,*next_point,&x);


	v_temp.x=next_vit[0];
	v_temp.y=next_vit[1];
	v_temp.z=next_vit[2];
	MultModelview(cubeModelviewInv,v_temp,&vx);
	
	/* on teste sur les six faces dfinient par : 
	{P1, P2, P3}
	{P4, P5, P6}
	{P2, P1, P6}
	{P5, P4, P3}
	{P1, P6, P5}
	{P4, P3, P2} */


		if (!((dist=Distance_signee(x, P1, P2, P3)) > b1.rayon)){
			flag = 1;
			normale.x=0.0f;
			normale.y=1.0f;
			normale.z=0.0f;
		}
		else 
			if (!((dist=Distance_signee(x, P4, P5, P6)) < -b1.rayon)) {
				flag = 1;
				normale.x=0.0f;
				normale.y=-1.0f;
				normale.z=0.0f;
			}
			else 
				if (!((dist=Distance_signee(x, P2, P1, P6)) > b1.rayon)) {
					flag = 1;
					normale.x=1.0f;
					normale.y=0.0f;
					normale.z=0.0f;
				}
				else 
					if (!((dist=Distance_signee(x, P5, P4, P3)) < -b1.rayon)) {
						flag = 1;
						normale.x=-1.0f;
						normale.y=0.0f;
						normale.z=0.0f;
					}
					else 
						if (!((dist=Distance_signee(x, P4, P3, P2)) > b1.rayon)) {
							flag = 1;
							normale.x=0.0f;
							normale.y=0.0f;
							normale.z=1.0f;
						}
						else 
							if (!((dist=Distance_signee(x, P1, P6, P5)) < -b1.rayon)) {
								flag = 1;
								normale.x=0.0f;
								normale.y=0.0f;
								normale.z=-1.0f;
						}

	if (flag == 1){
		comp_normale = MultVector(normale,vx);
		/* calcul nouvelle vitesse dans le repere du cube*/
		vx.x -= 2*comp_normale*normale.x;
		vx.y -= 2*comp_normale*normale.y;
		vx.z -= 2*comp_normale*normale.z;
		/* attenuation de la vitesse */
	/*	vx.x *= attenuation;
		vx.y *= attenuation;
		vx.z *= attenuation;*/
		/* expression de la nouvelle vitesse dans le repere du monde */
		MultModelview(cubeModelview,vx,&v_temp);
		next_vit[0] = v_temp.x;
		next_vit[1] = v_temp.y;
		next_vit[2] = v_temp.z;
		/* calcul nouvelle position par symtrie dans le repere du cube*/
		comp_normale = MultVector(normale,x);
		x.x = x.x - 2*comp_normale*normale.x - 2*(1-b1.rayon)*normale.x;
		x.y = x.y - 2*comp_normale*normale.y - 2*(1-b1.rayon)*normale.y;
		x.z = x.z - 2*comp_normale*normale.z - 2*(1-b1.rayon)*normale.z;
		/* expression de la nouvelle position dans le repere du monde */
		MultModelview(cubeModelview,x,&v_temp);
		next_point->x = v_temp.x;
		next_point->y = v_temp.y;
		next_point->z = v_temp.z;
	}

	return flag;
}


/*----------------------------------------*/
void Simulation(int r){
/*----------------------------------------*/
	double next_vit[3];
	double next_pos[3];
	Point next_point;
	int i, choc;
	double dt = 0.08;
	/* seuil  utiliser losque l'on ne fait pas la symetrie dans Collisions */
	//double seuil = 0.0001; /* pour cube droit */
	double seuil = 0.005; /* pour cube inclin */

//	printf("start simulate\n");
	/* Calcul nouvelle vitesse et nouvelle position */
	for (i=0; i<3;i++){
		next_vit[i]=b1.vit[i]+gravite[i]*dt;
		next_pos[i]=b1.pos[i]+dt*next_vit[i]+(dt*dt)/2.0*gravite[i];
	}

	next_point.x=next_pos[0];
	next_point.y=next_pos[1];
	next_point.z=next_pos[2];

	choc = Collisions(next_vit,&next_point);
	
	printf("bille x=%lf y=%lf z=%lf\n",b1.pos[0],b1.pos[1],b1.pos[2]);

	if ( choc == 1){
//		printf("il y a un choc -> changement de la vitesse et de la position puis translation\n");
		/***  utiliser lorsque l'on ne fait pas la symetrie dans Collisions ***/
	/*	{ next_pos[0]=b1.pos[0]+dt*next_vit[0]+(dt*dt)/2.0*gravite[0];
		next_pos[1]=b1.pos[1]+dt*next_vit[1]+(dt*dt)/2.0*gravite[1];
		next_pos[2]=b1.pos[2]+dt*next_vit[2]+(dt*dt)/2.0*gravite[2];
		next_point.x=next_pos[0];
		next_point.y=next_pos[1];
		next_point.z=next_pos[2];
		point2.x=next_point.x-b1.pos[0];
		point2.y=next_point.y-b1.pos[1];
		point2.z=next_point.z-b1.pos[2];
		}
		if (DiffPoint(point1,point2) > seuil) {*/ /*** Ignorer cette ligne si on fait la symetrie dans Collisions ***/
			translateModelview_bis(next_point.x-b1.pos[0],next_point.y-b1.pos[1],next_point.z-b1.pos[2],billeModelview);
			b1.pos[0]=next_point.x;
			b1.pos[1]=next_point.y;
			b1.pos[2]=next_point.z;
			b1.vit[0]=next_vit[0];
			b1.vit[1]=next_vit[1];
			b1.vit[2]=next_vit[2];
			point1.x=point2.x;
			point1.y=point2.y;
			point1.z=point2.z;
	//	}
	}
	else {
//		printf("il n'y a pas de choc, on translate\n");
		translateModelview_bis(next_point.x-b1.pos[0],next_point.y-b1.pos[1],next_point.z-b1.pos[2],billeModelview);
		b1.pos[0]=next_point.x;
		b1.pos[1]=next_point.y;
		b1.pos[2]=next_point.z;
		b1.vit[0]=next_vit[0];
		b1.vit[1]=next_vit[1];
		b1.vit[2]=next_vit[2];
	}

	glutTimerFunc(50, &Simulation,0);
}



/*-----------------------*/
void DrawGLScene(void) {
/*-----------------------*/
/* The main drawing function. */

	// On s'occupe d'abord de positionner toute la scne dans l'espace, en fonction de la Boule virtuelle
	if(moving)
		recalcModelView();

	// On efface la fentre
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	// clairage ambient
	{
		GLfloat lmodel_ambient[] = {6., 6., 6., 1. };
		glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lmodel_ambient);
	}

	// Lampe spot place  5 mtres du sol et l'clairant
	{
		GLfloat light_position[] = { 0.0f, 5.0f, 2.0f, 1.0f }; 
	//	GLfloat spot_direction[] = { 0.0f, -1.0f, 0.0f };
		glLightfv(GL_LIGHT0, GL_POSITION, light_position);
	//	glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, spot_direction);
	}

	glEnable(GL_LIGHT0);
	glEnable(GL_LIGHTING);

	drawBille();

	drawCube();

	glutSwapBuffers();
}


/*---------------------*/
void drawBille(void) {
/*---------------------*/
	glShadeModel(GL_SMOOTH);

	glPushMatrix();
	
	glMultMatrixf(billeModelview);

	glColorMaterial(GL_FRONT, GL_AMBIENT);
	glEnable(GL_COLOR_MATERIAL);
	glColor3f(b1.color[0],b1.color[1],b1.color[2]);

	glutSolidSphere(b1.rayon, 20., 20.);
	glDisable(GL_COLOR_MATERIAL);

	glPopMatrix();
}

/*---------------------*/
void drawCube(void) {
/*---------------------*/
    glPolygonMode(GL_FRONT,GL_LINE);
	glPolygonMode(GL_BACK,GL_LINE);

	glPushMatrix();
	
	glMultMatrixf(cubeModelview);

			{
			GLfloat mat_specular[] = { 0.0, 0.0, 0.0, 1.0 };
			GLfloat mat_ambient[] = { 0.0, 0.0, 0.0, 1.0 };
			GLfloat mat_diffuse[] = { 0.0, 0.0, 0.0, 1.0 };
			glMaterialfv(GL_FRONT, GL_AMBIENT, mat_ambient);
			glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
			glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_diffuse);
			}

			glEnable(GL_BLEND);
			glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

			glNormal3f(0,0,1);
			glBegin(GL_QUADS);	
				glVertex3f(-1.0f, 1.0f, 1.0f);
				glVertex3f( 1.0f, 1.0f, 1.0f);
				glVertex3f( 1.0f,-1.0f, 1.0f);
				glVertex3f(-1.0f,-1.0f, 1.0f);
				glVertex3f(-1.0f,-1.0f, 1.0f);
			glEnd();
			

			glNormal3f(0,0,-1);
			glBegin(GL_QUADS);	
				glVertex3f(-1.0f, 1.0f, -1.0f);
				glVertex3f( 1.0f, 1.0f, -1.0f);
				glVertex3f( 1.0f,-1.0f, -1.0f);
				glVertex3f(-1.0f,-1.0f, -1.0f);
			glEnd();
			

			glNormal3f(1,0,0);
			glBegin(GL_QUADS);
				glVertex3f(1.0f, 1.0f, 1.0f);
				glVertex3f( 1.0f, 1.0f, -1.0f);
				glVertex3f( 1.0f,-1.0f, -1.0f);
				glVertex3f(1.0f,-1.0f, 1.0f);
			glEnd();
			

			glNormal3f(-1,0,0);
			glBegin(GL_QUADS);
				glVertex3f(-1.0f, 1.0f, -1.0f);
				glVertex3f( -1.0f, 1.0f, 1.0f);
				glVertex3f( -1.0f,-1.0f, 1.0f);
				glVertex3f(-1.0f,-1.0f, -1.0f);
			glEnd();

			glNormal3f(0,1,0);
			glBegin(GL_QUADS);
				glVertex3f(-1.0f, 1.0f, 1.0f);
				glVertex3f( 1.0f, 1.0f, 1.0f);
				glVertex3f( 1.0f,1.0f, -1.0f);
				glVertex3f(-1.0f,1.0f, -1.0f);
			glEnd();
		
			glNormal3f(0,-1,0);
			glBegin(GL_QUADS);
				glVertex3f(-1.0f, -1.0f, 1.0f);
				glVertex3f( 1.0f, -1.0f, 1.0f);
				glVertex3f( 1.0f,-1.0f, -1.0f);
				glVertex3f(-1.0f,-1.0f, -1.0f);
			glEnd();

		glDisable(GL_BLEND);
		glPopMatrix();
}


/*********************************************************
 *                 Gestion de la souris                  *
 *********************************************************/

static void mouse(int button, int state, int x, int y)
{
  int modifier =glutGetModifiers();

  if ((button == GLUT_LEFT_BUTTON ) && (modifier == 0)) {
    if (state == GLUT_DOWN) {


	  glutSetCursor(GLUT_CURSOR_CYCLE);
     
	  // Au dbut, rotation nulle
	  trackball(lastquat, 0.0f, 0.0f, 0.0f, 0.0f);
      moving = 1;
      startx = x;
      starty = y;
   }
    if (state == GLUT_UP) {
	  printf("Bouton gauche relch\n");
      moving = 0;
    }
  }

  // Non implment pour le moment...
  if ((button == GLUT_LEFT_BUTTON) && (modifier == GLUT_ACTIVE_SHIFT)) {
    if (state == GLUT_DOWN) {
	  printf("Shift-Bouton gauche enfonc\n");
        glutSetCursor(GLUT_CURSOR_UP_DOWN);
        scaling = 1;
    }
    if (state == GLUT_UP) {
	   printf("Shift-Bouton gauche relch\n");
	   scaling = 0;

    }
  }
}

/**********************************************************
 *           Gestion du mouvement de la souris            *
 **********************************************************/
static void motion(int x, int y)
{
  if (scaling) { // shift appuy
    scalefactor = scalefactor * (1.0f + (((float) (starty - y)) / height));
    startx = x;
    starty = y;
    glutPostRedisplay();
    return;
  }

  if (moving) { 
	// Ici on passe le prcdent point cliqu et le point courant. Les coordonnes sont normalises
	// entre -1 et +1. A la sortie, lastquat correspond  la rotation autours de l'axe dfinit par les
	// deux vecteurs qui vont du centre de la sphre vers les points cliqus,  la surface de la sphre
	// (rayon 1, voir trackball.c)
    trackball(lastquat,
              (2.0f*startx - width) / width,
              (height - 2.0f*starty) / height,
              (2.0f*x - width) / width,
              (height - 2.0f*y) / height);
    startx = x;
    starty = y;

	// On concatne la rotation correspondant au dernier mouvement, avec le prcdent quaternion.
	// Ainsi, si on applique la rotation globale (depuis le premier mouvement)  la matrice modelview
	// du dpart, on effectuera la bonne rotation. Cette ruse permet d'viter de remettre la rotation
	// courante dans le repre de la camra.
    add_quats(lastquat, curquat, curquat);
	
    glutPostRedisplay();
    return;
  } 
}

/*******************************************************
 *           Gestion des touches du clavier            *
 *******************************************************/
static void key(unsigned char c, int x, int y)
{

	switch (c) {

	case 'W':
		glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
		glutPostRedisplay();
		break;
	case 'F':
		glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
		glutPostRedisplay();
		break;
	case 'T':
		/*if(solRenderMode == SOL_TEXTURE)
			solRenderMode = SOL_NON_TEXTURE;
		else
			solRenderMode = SOL_TEXTURE;

		glutPostRedisplay();*/
		break;
	case 'M':
	/*	textureRenderMode = (textureRenderMode + 1) %3;
		initTexture(textureRenderMode, textureAlphaMode);
		glutPostRedisplay();*/
		break;
	case 'm':
	/*	numTextureCourante = (numTextureCourante +1) % 4;
		glutPostRedisplay();*/
		break;
	
	case 'R':
		break;
/*******************************/

	case 'r':
		break;
	case 'q':
		break;
	case 'a':
		break;
	case 'z':
		break;
	case 'e':
		break;
	case 'A':
		break;
	case 'Q':
		break;
	case 'Z':
		break;
	case 'E':
		break;
	case 'o':
		break;
	case 'l':
		break;
	case '-':
		break;
	case '+':
		break;
	case 't':
		break;
	case 'f':
		rotateModelview_z(5.0, cubeModelview);
		suitObjet(cubeModelview);
		glutPostRedisplay();
		break;
	case 'g':
		rotateModelview_z(-5.0, cubeModelview);
		suitObjet(cubeModelview);
		glutPostRedisplay();
		break;
	case 'v':
		break;
	case '1': 
		break;
	case '2': 
		break;
	case '3': 
		break;
	case ESCAPE:
		/* shut down our window */
		glutDestroyWindow(window); 
		
		exit(0);  // Escape permet de quitter le programme.
		break;
	case '*':
		break;
	case '/':
		break;
	}


}

/***********************************************************************************
 *       Gestion des touches speciale du clavier (touches "down", enfonces)       *
 ***********************************************************************************/

static void specialKey(int state, int x, int y)
{
	
	int mod = glutGetModifiers();

  if (mod != GLUT_ACTIVE_SHIFT) {
	switch (state) {
	case GLUT_KEY_UP:
		printf("Flche haut enfonce\n");
		// Translation par rapport  l'axe Z de la camra (du repre origine, en fait)
		glGetFloatv(GL_MODELVIEW_MATRIX, modelview); // On stocke la matrice courante dans modelview
		glLoadIdentity();							 // Matrice courante = identit
		glTranslatef(0.0, 0.0, 1.0);				 // Matrice courante = une matrice de translation en Z
		glMultMatrixf(modelview);					 /* Matrice courante = Matrice courante * T
													      en multipliant  droite et non a gauche, on effectue une
													      rotation non locale. */
		printModelviewPosition();
		break;
	case GLUT_KEY_DOWN:								// idem
		printf("Flche bas enfonce\n");
		glGetFloatv(GL_MODELVIEW_MATRIX, modelview);
		glLoadIdentity();
		glTranslatef(0.0, 0.0, -1.0);		
		glMultMatrixf(modelview);
		printModelviewPosition();
		break;
	case GLUT_KEY_LEFT:								// idem mais avec une rotation autours de l'axe Y
		printf("Flche gauche enfonce\n");
		glGetFloatv(GL_MODELVIEW_MATRIX, modelview);
		glLoadIdentity();
		glRotatef(-1.0, 0.0, 1.0, 0.0);		
		glMultMatrixf(modelview);
		printModelviewPosition();
		break;
	case GLUT_KEY_RIGHT:							// idem
		printf("Flche droite enfonce\n");
		glGetFloatv(GL_MODELVIEW_MATRIX, modelview);
		glLoadIdentity();
		glRotatef(1.0, 0.0, 1.0, 0.0);		
		glMultMatrixf(modelview);
		printModelviewPosition();
		break;
	}
  } else {
	switch (state) {
	case GLUT_KEY_UP:
		printf("Flche haut enfonce\n");
		/* Translation par rapport  l'axe des Z de la matrice courante (celle de la scne, qui dfinit
		    un repre centr entre le triangle et le cube. Revient  crire Matrice courante = T.Matrice Courante */
		glTranslatef(0.0, 0.0, 1.0);		
		printModelviewPosition();
		break;
	case GLUT_KEY_DOWN:								// idem
		printf("Flche bas enfonce\n");
		glTranslatef(0.0, 0.0, -1.0);		
		printModelviewPosition();
		break;
	case GLUT_KEY_LEFT:								// idem mais rotation autours de l'axe Z de la scne (modelview)
		printf("Flche gauche enfonce\n");
		glRotatef(-1.0, 0.0, 1.0, 0.0);		
		break;
	case GLUT_KEY_RIGHT:
		printf("Flche droite enfonce\n");
		glRotatef(1.0, 0.0, 1.0, 0.0);		
		break;
	}
  }

  glutPostRedisplay();
}

/************************************************************************
 *       Gestion des touches speciale du clavier (touches "up", relches)       *
 ************************************************************************/

static void specialKeyUp(int state, int x, int y)
{
	switch (state) {
	case GLUT_KEY_UP:
		printf("Flche haut relche\n");

		break;
	case GLUT_KEY_DOWN:
		printf("Flche bas relche\n");
		break;
	case GLUT_KEY_LEFT:
		printf("Flche gauche relche\n");
		break;
	case GLUT_KEY_RIGHT:
		printf("Flche droite relche\n");
		break;
	}
  glutPostRedisplay();
}

/*************************************************************************
 * Lorsque la fentre n'est pas visible inutile de faire de l'animation. *
 *************************************************************************/
static void visible(int vis)
{
  if (vis == GLUT_VISIBLE) {
	  printf("Fentre graphique visible\n");
      glutIdleFunc(DrawGLScene);
  } else {
	  printf("Fentre graphique invisible\n");
      glutIdleFunc(NULL);
  }
}

int main(int argc, char **argv) 
{  
  /* Initialize GLUT state - glut will take any command line arguments that pertain to it or 
     X Windows - look at its documentation at http://reality.sgi.com/mjk/spec3/spec3.html */  
  glutInit(&argc, argv);  

  /* Select type of Display mode:   
     Double buffer 
     RGBA color
     Alpha components supported 
     Depth buffer */  
  glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_ALPHA | GLUT_DEPTH);  

  /* get a 640 x 480 window */
  glutInitWindowSize(640, 480);  

  /* the window starts at the upper left corner of the screen */
  glutInitWindowPosition(0, 0);  

  /* Open a window */  
  window = glutCreateWindow("Projet openGL - modlisation des chocs d'une bille sur les parois d'un cube");  

  /* Register the function to do all our OpenGL drawing. */
  glutDisplayFunc(DrawGLScene);  

  glutTimerFunc(20, &Simulation,0);

  /* Even if there are no events, redraw our gl scene. */
  glutIdleFunc(DrawGLScene);// NULL);

  /* Register the function called when our window is resized. */
  glutReshapeFunc(ReSizeGLScene);

  /* Pour les clicks souris */
  glutMouseFunc(mouse);

  /* pour les dplacements souris */
  glutMotionFunc(motion);

  /* Pour les touches "normales" du clavier */
  glutKeyboardFunc(key);

  /* Pour les touches "spciales" (flches) du clavier */
  glutSpecialFunc(specialKey);

  /* Pour le relchement des touches spciales */
  glutSpecialUpFunc(specialKeyUp);

  /* Initialize our window. */
  InitGL(width, height);
  
  /* Start Event Processing Engine */  
  glutMainLoop();  

  return 1;
}
