#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>       /* for cos(), sin(), and sqrt() */
#include <GL/glut.h>

#include "glDesktop.h"
#include "texture.h"

#define MAX(a,b) ((a) > (b) ? (a) : (b))
#define MIN(a,b) ((a) < (b) ? (a) : (b))

#define DESK_THICKNESS 0.5
#define DESK_HALF_LENGTH 15
#define DESK_HALF_WIDTH 10

#define X_DESKTOP_FEET 10
#define Z_DESKTOP_FEET 7
#define DESKTOP_FEET_WIDTH 1
#define DESKTOP_FEET_LENGTH 7

#define BALL_DIAMETER 0.5
#define BALL_ALT 2
#define BALL_STEP_1 8
#define BALL_STEP_2 8

#define Z_BARS_POS 3
#define Y_BARS_POS 4

#define X_HALF_BOX 6
#define Y_BOX 6
#define Z_HALF_BOX 3

#define TEX_ATT 1

GLfloat xeye = 0, yeye = 0, zeye = 30;
GLfloat myFov = 40;

GLfloat anglexproj = 0, angleyproj = 0;   /* in degrees */
GLfloat xlocproj=0, ylocproj=0, zlocproj = 0;
GLfloat anglexmodel = 0, angleymodel = 0, anglezmodel = 0;   /* in degrees */

GLfloat decalxmodel = 0, decalymodel = 0;

int moving = 0;
int matrixmodelview = 1;
int beginx, beginy;
int W = 300, H = 300;
GLdouble bodyWidth = 3.0;
int newModel = 1;
int scaling;

int cull_face_p = 0;

int gl_flat_p = 0;

int gl_fog_p = 0;

int table_draw_p = 1;

int ball_draw_p = 1;

int box_draw_p = 1;

float scalefactor = 1.0;

int dist = 30;

GLfloat lightZeroPosition[] = {10.0, 4.0, 10.0, 1.0};
GLfloat lightZeroColor[] = {1.0, 1.0, 1.0, 1.0};

GLfloat lightOnePosition[] = {-1.0, -2.0, 1.0, 0.0};

GLfloat lightOneColor[] = {1.0, 1.0, 1.0, 1.0};

GLfloat skinColor[] = {0.1, 1.0, 0.1, 1.0}, eyeColor[] = {1.0, 0.2, 0.2, 1.0};

float ball_angle = 30;
float ball_angle_step = 5;
GLfloat cylinder_radius = 0.25;
GLfloat cylinder_length_step = 10;
GLfloat cylinder_surface_step = 6;

GLfloat xlocmodel, ylocmodel, zlocmodel;


void initTexture(char *filename) {
  GLfloat table_color[4] = { 0.7f, 0.7f, 0.1f, 0.0f };
  GLfloat fog_color[4], fog_density = 0.05, density, far_cull;
  unsigned *image;
  int width, height, components;
  
  if (filename) {
    image = read_texture(filename, &width, &height, &components);
    if (image == NULL) {
	    fprintf(stderr, "Error: Can't load image file \"%s\".\n",
              filename);
	    exit(EXIT_FAILURE);
    } else {
	    printf("%d x %d image loaded\n", width, height);
    }
    if (components != 1) {
      printf("warning: texture should be a bw image (single component)\n");
    }
  } else {
    int i, j;
    unsigned char *img;
    components = 4; width = height = 512;
    image = (unsigned *) malloc(width*height*sizeof(unsigned));
    img = (unsigned char *)image;
    for (j = 0; j < height; j++)
	    for (i = 0; i < width; i++) {
        int w2 = width/2, h2 = height/2;
        if (i & 32)
          img[4*(i+j*width)+0] = 0xff;
        else
          img[4*(i+j*width)+1] = 0xff;
        if (j&32)
          img[4*(i+j*width)+2] = 0xff;
        if ((i-w2)*(i-w2) + (j-h2)*(j-h2) > 64*64 &&
            (i-w2)*(i-w2) + (j-h2)*(j-h2) < 300*300) img[4*(i+j*width)+3] = 0xff;
	    }
  }
  glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
  glTexEnvfv(GL_TEXTURE_ENV, GL_TEXTURE_ENV_COLOR, table_color);

  glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);



  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  glTexImage2D(GL_TEXTURE_2D, 0, components, width,
               height, 0, GL_RGBA, GL_UNSIGNED_BYTE,
               image);
  glEnable(GL_TEXTURE_2D);
  
  density = 1.- expf(-5.5 * fog_density * fog_density *
                     far_cull * far_cull);
  
  density = MAX(MIN(density, 1.), 0.);
  
  fog_color[0] = .23 + density *.57;
  fog_color[1] = .35 + density *.45;
  fog_color[2] = .78 + density *.22;

  glClearColor(fog_color[0], fog_color[1], fog_color[2], 1.f);
  
  glFogi(GL_FOG_MODE, GL_EXP2);
  glFogf(GL_FOG_DENSITY, fog_density);
  glFogfv(GL_FOG_COLOR, fog_color);
}


void toggleRenderModel()
{
  gl_flat_p = (!gl_flat_p);
  if (gl_flat_p) {
    printf("Render Model = FLAT\n");
    glShadeModel(GL_FLAT);
  } else {
    printf("Render Model = SMOOTH\n");
    glShadeModel(GL_SMOOTH);
  }
}

void toggleFogRendering()
{
  gl_fog_p = (!gl_fog_p);
  if (gl_fog_p) {
  	printf("Fog Rendering = ON\n");
    glEnable(GL_FOG);
  } else {
  	printf("Fog Rendering = OFF\n");  
    glDisable(GL_FOG);
  }
}
  

void recalcModelView(void)
{
  if (moving) {
    glPolygonMode(GL_FRONT, GL_LINE);
    glPolygonMode(GL_BACK, GL_LINE);
  } else {
    glPolygonMode(GL_FRONT, GL_FILL);
    glPolygonMode(GL_BACK, GL_FILL);
  }
  
  // rotate left-right
  glRotatef(anglexmodel, 0.0, 1.0, 0.0);

  // rotate up-down sides
  glRotatef(angleymodel, 0.0, 0.0, 1.0);

  // rotate up-down
  glRotatef(anglezmodel, 1.0, 0.0, 1.0);

  glTranslatef(xlocmodel, ylocmodel, zlocmodel);

  //  glPushMatrix();
  newModel = 0;

  anglexmodel = angleymodel = anglezmodel = 0;

  xlocmodel= ylocmodel = zlocmodel = 0;

}

void drawDesktop()
{
  static GLUquadricObj *dfoot = NULL;
  static GLUquadricObj *disk = NULL;

  static GLfloat dfoot_mat[] = {0.8f, 0.8f, 0.8f, 1.0f};
  static GLfloat disk_mat[] = {0.5f, 0.4f, 0.4f, 1.0f};

  glMatrixMode(GL_TEXTURE);

  // wooden desktop: up side

  disk = gluNewQuadric();
  glMaterialfv(GL_FRONT, GL_AMBIENT, disk_mat);
  glMaterialfv(GL_FRONT, GL_DIFFUSE, disk_mat);
  glMaterialfv(GL_FRONT, GL_SPECULAR, disk_mat);
  glMaterialf(GL_FRONT, GL_SHININESS, 128.0f);


  glNormal3f(0.0, 1.0, 0.0);
  glBegin(GL_POLYGON);
  
  glTexCoord2f(0, 0);
  glVertex3f(-DESK_HALF_LENGTH, 0, -DESK_HALF_WIDTH);    // V0

  glTexCoord2f(0, TEX_ATT);
  glVertex3f(DESK_HALF_LENGTH, 0, -DESK_HALF_WIDTH);  // V1

  glTexCoord2f(TEX_ATT, TEX_ATT);
  glVertex3f(DESK_HALF_LENGTH, 0, DESK_HALF_WIDTH);   // V3

  glTexCoord2f(TEX_ATT, 0);
  glVertex3f(-DESK_HALF_LENGTH, 0, DESK_HALF_WIDTH); // V4

  glEnd();

  // wooden desktop: down side
  glNormal3f(0.0, -1.0, 0.0);
  glBegin(GL_POLYGON);
  
  glTexCoord2f(0, 0);
  glVertex3f(-DESK_HALF_LENGTH, -DESK_THICKNESS, -DESK_HALF_WIDTH);    // V0

  glTexCoord2f(0, TEX_ATT);
  glVertex3f(DESK_HALF_LENGTH, -DESK_THICKNESS, -DESK_HALF_WIDTH);  // V1

  glTexCoord2f(TEX_ATT, TEX_ATT);
  glVertex3f(DESK_HALF_LENGTH, -DESK_THICKNESS, DESK_HALF_WIDTH);   // V3

  glTexCoord2f(TEX_ATT, 0);
  glVertex3f(-DESK_HALF_LENGTH, -DESK_THICKNESS, DESK_HALF_WIDTH); // V4

  glEnd();

  // wooden desktop: front side
  glNormal3f(0.0, 0.0, -1.0);
  glBegin(GL_POLYGON);
  
  glTexCoord2f(0, 0);
  glVertex3f(-DESK_HALF_LENGTH, 0, -DESK_HALF_WIDTH);    // V0

  glTexCoord2f(0, TEX_ATT);
  glVertex3f(DESK_HALF_LENGTH, 0, -DESK_HALF_WIDTH);  // V1

  glTexCoord2f(TEX_ATT, TEX_ATT);
  glVertex3f(DESK_HALF_LENGTH, -DESK_THICKNESS, -DESK_HALF_WIDTH);   // V3

  glTexCoord2f(TEX_ATT, 0);
  glVertex3f(-DESK_HALF_LENGTH, -DESK_THICKNESS, -DESK_HALF_WIDTH); // V4

  glEnd();

  // wooden desktop: back side
  glNormal3f(0.0, 0.0, 1.0);
  glBegin(GL_POLYGON);
  
  glTexCoord2f(0, 0);
  glVertex3f(-DESK_HALF_LENGTH, 0, DESK_HALF_WIDTH);    // V0

  glTexCoord2f(0, TEX_ATT);
  glVertex3f(DESK_HALF_LENGTH, 0, DESK_HALF_WIDTH);  // V1

  glTexCoord2f(TEX_ATT, TEX_ATT);
  glVertex3f(DESK_HALF_LENGTH, -DESK_THICKNESS, DESK_HALF_WIDTH);   // V3

  glTexCoord2f(TEX_ATT, 0);
  glVertex3f(-DESK_HALF_LENGTH, -DESK_THICKNESS, DESK_HALF_WIDTH); // V4

  glEnd();

  // wooden desktop: left side
  glNormal3f(-1.0, 0.0, 0.0);
  glBegin(GL_POLYGON);
  
  glTexCoord2f(0, 0);
  glVertex3f(-DESK_HALF_LENGTH, 0, -DESK_HALF_WIDTH);    // V0

  glTexCoord2f(0, TEX_ATT);
  glVertex3f(-DESK_HALF_LENGTH, 0, DESK_HALF_WIDTH);  // V1

  glTexCoord2f(TEX_ATT, TEX_ATT);
  glVertex3f(-DESK_HALF_LENGTH, -DESK_THICKNESS, DESK_HALF_WIDTH);   // V3

  glTexCoord2f(TEX_ATT, 0);
  glVertex3f(-DESK_HALF_LENGTH, -DESK_THICKNESS, -DESK_HALF_WIDTH); // V4

  glEnd();

  // wooden desktop: right side
  glNormal3f(1.0, 0.0, 0.0);

  glBegin(GL_POLYGON);
  
  glTexCoord2f(0, 0);
  glVertex3f(DESK_HALF_LENGTH, 0, -DESK_HALF_WIDTH);    // V0

  glTexCoord2f(0, TEX_ATT);
  glVertex3f(DESK_HALF_LENGTH, 0, DESK_HALF_WIDTH);  // V1

  glTexCoord2f(TEX_ATT, TEX_ATT);
  glVertex3f(DESK_HALF_LENGTH, -DESK_THICKNESS, DESK_HALF_WIDTH);   // V3

  glTexCoord2f(TEX_ATT, 0);
  glVertex3f(DESK_HALF_LENGTH, -DESK_THICKNESS, -DESK_HALF_WIDTH); // V4

  glEnd();

  // desktop feet
  glMatrixMode(GL_MODELVIEW);

  //  if (!dfoot) {
    dfoot = gluNewQuadric();
/*     gluQuadricDrawStyle(dfoot, GLU_FILL); */
/*     gluQuadricNormals(dfoot, GLU_SMOOTH); */
    glMaterialfv(GL_FRONT, GL_AMBIENT, dfoot_mat);
    glMaterialfv(GL_FRONT, GL_DIFFUSE, dfoot_mat);
    glMaterialfv(GL_FRONT, GL_SPECULAR, dfoot_mat);
    glMaterialf(GL_FRONT, GL_SHININESS, 128.0f);
    // }
  


  // foot 1
  glPushMatrix();
  glTranslatef(-X_DESKTOP_FEET, -DESK_THICKNESS, -Z_DESKTOP_FEET);
  glRotatef(90, 1, 0, 0);
  gluCylinder(dfoot, DESKTOP_FEET_WIDTH, DESKTOP_FEET_WIDTH,
              DESKTOP_FEET_LENGTH, 10, 5);
  glPopMatrix();

  // foot 2
  glPushMatrix();
  glTranslatef(-X_DESKTOP_FEET, -DESK_THICKNESS, Z_DESKTOP_FEET);
  glRotatef(90, 1, 0, 0);
  gluCylinder(dfoot, DESKTOP_FEET_WIDTH, DESKTOP_FEET_WIDTH,
              DESKTOP_FEET_LENGTH, 10, 5);
  glPopMatrix();

  // foot 3
  glPushMatrix();
  glTranslatef(X_DESKTOP_FEET, -DESK_THICKNESS, Z_DESKTOP_FEET);
  glRotatef(90, 1, 0, 0);
  gluCylinder(dfoot, DESKTOP_FEET_WIDTH, DESKTOP_FEET_WIDTH,
              DESKTOP_FEET_LENGTH, 10, 5);
  glPopMatrix();

  // foot 4
  glPushMatrix();
  glTranslatef(X_DESKTOP_FEET, -DESK_THICKNESS, -Z_DESKTOP_FEET);
  glRotatef(90, 1, 0, 0);
  gluCylinder(dfoot, DESKTOP_FEET_WIDTH, DESKTOP_FEET_WIDTH,
              DESKTOP_FEET_LENGTH, 10, 5);
  glPopMatrix();

  gluDeleteQuadric(dfoot);
  gluDeleteQuadric(disk);

}

void drawBalls()
{
  GLUquadricObj *sphere = NULL;
  static GLfloat sphere_mat[] = {1.0f, 0.0f, 0.0f, 1.0f};
  int x_sphere_trans, min_bound = -5 , max_bound = 5;

  glPushMatrix(); /* begin balls */
  sphere = gluNewQuadric();
  gluQuadricNormals(sphere, GLU_SMOOTH);
  glMaterialfv(GL_FRONT, GL_AMBIENT, sphere_mat);



  if (ball_angle < 0) {
    min_bound = -4;
    glPushMatrix();
      glTranslatef((GLfloat) -5, BALL_ALT + Y_BARS_POS, 0.0);
      glRotatef(ball_angle, 0.0, 0.0, 1.0);

      glBegin(GL_LINES);
        glVertex3f(0.0, 0.0, Z_BARS_POS);
        glVertex3f(0.0, -Y_BARS_POS, BALL_DIAMETER);
        glVertex3f(0.0, 0.0, -Z_BARS_POS);
        glVertex3f(0.0, -Y_BARS_POS, -BALL_DIAMETER);      
      glEnd();
      glTranslatef(0.0 , -Y_BARS_POS , 0.0);
      glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, sphere_mat);
      gluSphere(sphere, BALL_DIAMETER, BALL_STEP_1, BALL_STEP_2);    
    glPopMatrix();

  } else if (ball_angle > 0) {
    max_bound = 4;

    glPushMatrix();
      glTranslatef((GLfloat) 5, BALL_ALT + Y_BARS_POS, 0.0);
      glRotatef(ball_angle, 0.0, 0.0, 1.0);

      glBegin(GL_LINES);
        glVertex3f(0.0, 0.0, Z_BARS_POS);
        glVertex3f(0.0, -Y_BARS_POS, BALL_DIAMETER);
        glVertex3f(0.0, 0.0, -Z_BARS_POS);
        glVertex3f(0.0, -Y_BARS_POS, -BALL_DIAMETER);      
      glEnd();
      glTranslatef(0.0 , -Y_BARS_POS , 0.0);
      glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, sphere_mat);
      gluSphere(sphere, BALL_DIAMETER, BALL_STEP_1, BALL_STEP_2);    
    glPopMatrix();
  }

  for (x_sphere_trans = min_bound; x_sphere_trans <= max_bound; x_sphere_trans++) {
    glPushMatrix();
      glTranslatef((GLfloat) x_sphere_trans , BALL_ALT, 0.0);
      glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, sphere_mat);
      gluSphere(sphere, BALL_DIAMETER, BALL_STEP_1, BALL_STEP_2);

      glBegin(GL_LINES);
        glVertex3f(0.0, 0.0, BALL_DIAMETER);
        glVertex3f(0.0, Y_BARS_POS, Z_BARS_POS);

        glVertex3f(0.0, 0.0, -BALL_DIAMETER);
        glVertex3f(0.0, Y_BARS_POS, -Z_BARS_POS);
    
      glEnd();
    glPopMatrix();
  }
  
  gluDeleteQuadric(sphere);
  glPopMatrix();
}

void drawTubeBox()
{
  GLUquadricObj *sphere = NULL, *cyl3d = NULL;
  static GLfloat cyl_mat[] = {0.1f, 0.8f, 0.1f, 1.0f};

  cyl3d = gluNewQuadric();
  glMaterialfv(GL_FRONT, GL_AMBIENT, cyl_mat);
  glMaterialfv(GL_FRONT, GL_DIFFUSE, cyl_mat);
  glMaterialfv(GL_FRONT, GL_SPECULAR, cyl_mat);
  glMaterialf(GL_FRONT, GL_SHININESS, 128.0f);

  sphere = gluNewQuadric();
  glMaterialfv(GL_FRONT, GL_AMBIENT, cyl_mat);
  glMaterialfv(GL_FRONT, GL_DIFFUSE, cyl_mat);
  glMaterialfv(GL_FRONT, GL_SPECULAR, cyl_mat);
  glMaterialf(GL_FRONT, GL_SHININESS, 128.0f);
  
  /* horizontal bar 1  X */
  glPushMatrix();
  glTranslatef(-X_HALF_BOX, Y_BOX, Z_HALF_BOX); 
  glRotatef(90.0, 0.0, 1.0, 0.0);
  gluCylinder(cyl3d, cylinder_radius, cylinder_radius,
                2 * X_HALF_BOX , cylinder_length_step, cylinder_surface_step);
  glPopMatrix(); 
  
  /* little up sphere 1 */
  glPushMatrix(); 
  glTranslatef(-X_HALF_BOX, Y_BOX, Z_HALF_BOX); 
  gluSphere(sphere, cylinder_radius, 8, 8); 
  glPopMatrix(); 
  
  /* little up sphere 2 */
  glPushMatrix(); 
  glTranslatef(X_HALF_BOX, Y_BOX, Z_HALF_BOX); 
  gluSphere(sphere, cylinder_radius, 8, 8); 
  glPopMatrix(); 

  /* horizontal bar 2 X */
  glPushMatrix();
  glTranslatef(-X_HALF_BOX , Y_BOX, -Z_HALF_BOX); 
  glRotatef(90.0, 0.0, 1.0, 0.0);
  gluCylinder(cyl3d, cylinder_radius, cylinder_radius,
              2 * X_HALF_BOX , cylinder_length_step, cylinder_surface_step);
  glPopMatrix(); 

  /* little up sphere 4 */
  glPushMatrix(); 
  glTranslatef(-X_HALF_BOX, Y_BOX, -Z_HALF_BOX); 
  gluSphere(sphere, cylinder_radius, 8, 8); 
  glPopMatrix(); 

  /* little up sphere 3 */
  glPushMatrix(); 
  glTranslatef(X_HALF_BOX, Y_BOX, -Z_HALF_BOX); 
  gluSphere(sphere, cylinder_radius, 8, 8); 
  glPopMatrix(); 

  // vertical bar 1 */
  glPushMatrix(); 
  glTranslatef(-X_HALF_BOX , Y_BOX, Z_HALF_BOX); 
  glRotatef(90.0, 1.0, 0.0, 0.0);
  gluCylinder(cyl3d, cylinder_radius, cylinder_radius,
              Y_BOX - (BALL_DIAMETER / 2) , cylinder_length_step, cylinder_surface_step);
  glPopMatrix(); 

  /* little down sphere 1 */
  glPushMatrix(); 
  glTranslatef(-X_HALF_BOX, BALL_DIAMETER / 2, Z_HALF_BOX); 
  gluSphere(sphere, cylinder_radius, 8, 8); 
  glPopMatrix(); 

  // vertical bar 2 */
  glPushMatrix(); 
  glTranslatef(X_HALF_BOX , Y_BOX, Z_HALF_BOX); 
  glRotatef(90.0, 1.0, 0.0, 0.0);
  gluCylinder(cyl3d, cylinder_radius, cylinder_radius,
              Y_BOX - (BALL_DIAMETER / 2) , cylinder_length_step, cylinder_surface_step);
  glPopMatrix(); 

  /* little down sphere 2 */
  glPushMatrix(); 
  glTranslatef(X_HALF_BOX, BALL_DIAMETER / 2, Z_HALF_BOX); 
  gluSphere(sphere, cylinder_radius, 8, 8); 
  glPopMatrix(); 

  // vertical bar 3 */
  glPushMatrix(); 
  glTranslatef(X_HALF_BOX , Y_BOX, -Z_HALF_BOX); 
  glRotatef(90.0, 1.0, 0.0, 0.0);
  gluCylinder(cyl3d, cylinder_radius, cylinder_radius,
              Y_BOX - (BALL_DIAMETER / 2) , cylinder_length_step, cylinder_surface_step);
  glPopMatrix(); 

  /* little down sphere 3 */
  glPushMatrix(); 
  glTranslatef(X_HALF_BOX, BALL_DIAMETER / 2, -Z_HALF_BOX); 
  gluSphere(sphere, cylinder_radius, 8, 8); 
  glPopMatrix(); 

  // vertical bar 4 */
  glPushMatrix(); 
  glTranslatef(-X_HALF_BOX , Y_BOX, -Z_HALF_BOX); 
  glRotatef(90.0, 1.0, 0.0, 0.0);
  gluCylinder(cyl3d, cylinder_radius, cylinder_radius,
              Y_BOX - (BALL_DIAMETER / 2) , cylinder_length_step, cylinder_surface_step);
  glPopMatrix(); 

  /* little down sphere 4 */
  glPushMatrix(); 
  glTranslatef(-X_HALF_BOX, BALL_DIAMETER / 2, -Z_HALF_BOX); 
  gluSphere(sphere, cylinder_radius, 8, 8); 
  glPopMatrix(); 

  // horizontal floor bar 1 */
  glPushMatrix(); 
  glTranslatef(-X_HALF_BOX , BALL_DIAMETER / 2, -Z_HALF_BOX); 
  gluCylinder(cyl3d, cylinder_radius, cylinder_radius,
              Z_HALF_BOX * 2 , cylinder_length_step, cylinder_surface_step);
  glPopMatrix(); 

  // horizontal floor bar 2 */
  glPushMatrix(); 
  glTranslatef(X_HALF_BOX , BALL_DIAMETER / 2, -Z_HALF_BOX); 
  gluCylinder(cyl3d, cylinder_radius, cylinder_radius,
              Z_HALF_BOX * 2 , cylinder_length_step, cylinder_surface_step);
  glPopMatrix(); 

  gluDeleteQuadric(sphere); 
  gluDeleteQuadric(cyl3d); 
}  

void draw()
{
  glPushMatrix(); /* begin scene */
  if (table_draw_p) {
    drawDesktop();
  }
  if (ball_draw_p) {
    drawBalls();
  }
  if (box_draw_p) {
    drawTubeBox();
  }
  glPopMatrix();

  glFlush();

  newModel = 1;

}

void moveBalls()
{
  if (((ball_angle_step > 0) && (ball_angle >=45)) ||
      ((ball_angle_step < 0) && (ball_angle <= -45))) {
    ball_angle_step = (-ball_angle_step);
    // faire varier ball_angle_step en fonction de l'altitude
  }
  
  ball_angle = ball_angle +  ball_angle_step;
  redraw();
}

void redraw(void)
{
  if (newModel) {
    recalcModelView();
  }
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  draw();  
  glutSwapBuffers();
}

void myReshape(int w, int h)
{
  glViewport(0, 0, w, h);
  W = w;
  H = h;
}

void toggleCullFace()
{
  cull_face_p = (!cull_face_p);
  if (cull_face_p) {
  	printf("Cull Face = ON\n");
    glEnable(GL_CULL_FACE);
  } else {
  	printf("Cull Face = OFF\n");  
    glDisable(GL_CULL_FACE);
  }
}

void toggleTableDraw()
{
  table_draw_p = (!table_draw_p);
  if (table_draw_p) {
  	printf("Draw Table = ON\n");
  } else {
  	printf("Draw Table = OFF\n");  
  }
}

void toggleBallDraw()
{
  ball_draw_p = (!ball_draw_p);
  if (ball_draw_p) {
  	printf("Draw Ball = ON\n");
  } else {
  	printf("Draw Ball = OFF\n");  
  }
}

void toggleBoxDraw()
{
  box_draw_p = (!box_draw_p);
  if (box_draw_p) {
  	printf("Draw Box = ON\n");
  } else {
  	printf("Draw Box = OFF\n");  
  }
}


void
mouse(int button, int state, int x, int y)
{
  if (button == GLUT_LEFT_BUTTON && state == GLUT_DOWN) {
    moving = 1;
    beginx = x;
    beginy = y;
  }
  if (button == GLUT_LEFT_BUTTON && state == GLUT_UP) {
    moving = 0;
  }
  if (button == GLUT_RIGHT_BUTTON && state == GLUT_DOWN) {
    moving = 1;
    beginx = x;
    beginy = y;
  }
  if (button == GLUT_RIGHT_BUTTON && state == GLUT_UP) {
    moving = 0;
  }
}

void
motion(int x, int y)
{
  if (moving) {
    anglexmodel = anglexmodel + (x - beginx);
    angleymodel = angleymodel + (y - beginy);
    beginx = x;
    beginy = y;
    newModel = 1;
    glutPostRedisplay();
  }
}

void
motiondecal(int x, int y)
{
  if (moving) {
    decalxmodel+=x;
    decalymodel+=y;
    beginx = x;
    beginy = y;
    newModel = 1;
    glutPostRedisplay();
  }
}

GLboolean lightZeroSwitch = GL_TRUE, lightOneSwitch = GL_TRUE;

void
menu(int value)
{
  switch (value) {
  case 1:
    lightZeroSwitch = !lightZeroSwitch;
    if (lightZeroSwitch) {
      glEnable(GL_LIGHT0);
    } else {
      glDisable(GL_LIGHT0);
    }
    break;
  case 2:
    lightOneSwitch = !lightOneSwitch;
    if (lightOneSwitch) {
      glEnable(GL_LIGHT1);
    } else {
      glDisable(GL_LIGHT1);
    }
    break;
  case 4:
    anglexmodel =  0;
    angleymodel =  0;
    decalxmodel =  0;
    decalymodel =  0;
    recalcModelView();
    break;
  case 8:
    glutFullScreen();
    break;
  case 9:
    exit(0);
    break;
  }
  glutPostRedisplay();
}

static void
key(unsigned char key, int x, int y)
{
  switch (key) {
  case '+':
    zeye = zeye + 0.1;
    printf("xeye = %f\n", xeye);
    printf("yeye = %f\n", yeye);
    printf("zeye = %f\n", zeye);
    
    glMatrixMode(GL_MODELVIEW);
    gluLookAt(xeye, yeye, zeye,  /* eye is at (0,0,30) */
              0.0, 0.0, 0.0,      /* center is at (0,0,0) */
              0.0, 1.0, 0.);      /* up is in positive Y direction */
    glPopMatrix();       /* dummy push so we can pop on model
                             recalc */
    newModel = 1;
    glutPostRedisplay();
    break;

  case '-':
    zeye = zeye - 0.1;
    printf("xeye = %f\n", xeye);
    printf("yeye = %f\n", yeye);
    printf("zeye = %f\n", zeye);
    
    glMatrixMode(GL_MODELVIEW);
    gluLookAt(xeye, yeye, zeye,  /* eye is at (0,0,30) */
              0.0, 0.0, 0.0,      /* center is at (0,0,0) */
              0.0, 1.0, 0.);      /* up is in positive Y direction */
      glPopMatrix();       /* dummy push so we can pop on model
                                 recalc */
    newModel = 1;    
    glutPostRedisplay();
    break;

  case ' ':
    moveBalls();
    
    break;

  case 'Z':
    zlocmodel =+ 1;

    newModel = 1;
    glutPostRedisplay();
    
    break;

  case 'z':
    zlocmodel =- 1;

    newModel = 1;
    glutPostRedisplay();
    
    break;

  case 'Y':
    ylocmodel =+ 1;

    newModel = 1;
    glutPostRedisplay();
    
    break;

  case 'y':
    ylocmodel =- 1;

    newModel = 1;
    glutPostRedisplay();
    
    break;

  case 'X':
    xlocmodel =+ 1;

    newModel = 1;
    glutPostRedisplay();
    
    break;

  case 'x':
    xlocmodel =- 1;

    newModel = 1;
    glutPostRedisplay();
    
    break;

  case 't':
    toggleTableDraw();
    newModel = 1;
    glutPostRedisplay();
    break;

  case 'b':
    toggleBallDraw();
    newModel = 1;
    glutPostRedisplay();
    break;

  case 'l':
    toggleBoxDraw();
    newModel = 1;
    glutPostRedisplay();
    break;

  case 'c':
    toggleCullFace();
    newModel = 1;
    glutPostRedisplay();
    break;

  case 'f':
    toggleRenderModel();
    newModel = 1;
    glutPostRedisplay();
    break;

  case 'g':
    toggleFogRendering();
    newModel = 1;
    glutPostRedisplay();
    break;

  case 'q': /* q = exit */
    
  case 27: /* escape */
    exit(0);

  default:
    printf("key = %c\n", key);

  }

}

static void
specialkey(int key, int x, int y)
{
  int oldmoving = moving;

  moving=1;

  if (glutGetModifiers() == GLUT_ACTIVE_SHIFT) {
    switch (key) {
    case GLUT_KEY_LEFT:
      beginx = beginy = 0;
      motiondecal(-1,0);
      break;
    case GLUT_KEY_RIGHT:
      beginx = beginy = 0;
      motiondecal(1,0);
      break;
    case GLUT_KEY_UP:
      beginx = beginy = 0;
      motiondecal(0,1);
      break;
    case GLUT_KEY_DOWN:
      beginx = beginy = 0;
      motiondecal(0,-1);
      break;
    }}
  else {
    switch (key) {
    case GLUT_KEY_LEFT:
      anglexmodel =- 1;
      newModel = 1;
      glutPostRedisplay();
      //beginx = beginy = 0;
      //motion(1,0);
      break;
    case GLUT_KEY_RIGHT:
      anglexmodel =+ 1;
      newModel = 1;
      glutPostRedisplay();
      //beginx = beginy = 0;
      //motion(-1,0);
      break;

    case GLUT_KEY_UP:
      //beginx = beginy = 0;
      //motion(0,1);
      anglezmodel =+ 1;
      newModel = 1;
      glutPostRedisplay();
      break;

    case GLUT_KEY_DOWN:
      anglezmodel =- 1;
      newModel = 1;
      glutPostRedisplay();
      //      beginx = beginy = 0;
      // motion(0,-1);
      break;
    }    
  }
  moving=oldmoving;
}

void eyesMovement()
{
  zeye = zeye - 0.01;
  printf("xeye = %f\n", xeye);
  printf("yeye = %f\n", yeye);
  printf("zeye = %f\n", zeye);
  
  glMatrixMode(GL_MODELVIEW);
  gluLookAt(xeye, yeye, zeye,  /* eye is at (0,0,30) */
            0.0, 0.0, 0.0,      /* center is at (0,0,0) */
            0.0, 1.0, 0.);      /* up is in positive Y direction */
  glPopMatrix();       /* dummy push so we can pop on model
                           recalc */
  recalcModelView(); /* initialize the modelview matrix */

  glutPostRedisplay();
}

int main(int argc, char *argv[])
{
  glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH | GLUT_MULTISAMPLE);

  glutCreateWindow("glDesktop");
  glutDisplayFunc(redraw);
  glutReshapeFunc(myReshape);
  glutMouseFunc(mouse);
  glutMotionFunc(motion);
  glutCreateMenu(menu);
  glutKeyboardFunc(key);
  glutSpecialFunc(specialkey);
  glutAddMenuEntry("Toggle right light", 1);
  glutAddMenuEntry("Toggle left light", 2);
  glutAddMenuEntry("Reset", 4);
  glutAddMenuEntry("Full screen", 8);
  glutAddMenuEntry("Quit", 9);
  glutAttachMenu(GLUT_RIGHT_BUTTON);

  initTexture("wood.bw");
  glDisable(GL_CULL_FACE);
  glDisable(GL_BLEND);
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_LIGHTING);
  glMatrixMode(GL_PROJECTION);
  gluPerspective( /* field of view in degree */ myFov,
                  /* aspect ratio */ 1.0,
                  /* Z near */ 1.0, /* Z far */ 400.0);
  glMatrixMode(GL_MODELVIEW);
  gluLookAt(xeye, yeye, zeye,  /* eye is at (0,0,30) */
            0.0, 0.0, 0.0,      /* center is at (0,0,0) */
            0.0, 1.0, 0.);      /* up is in positive Y direction */
  recalcModelView(); /* initialize the modelview matrix */
  glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, 1);
  glLightfv(GL_LIGHT0, GL_POSITION, lightZeroPosition);
  glLightfv(GL_LIGHT0, GL_DIFFUSE, lightZeroColor);
  glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, 0.1);
  glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, 0.05);
  glLightfv(GL_LIGHT1, GL_POSITION, lightOnePosition);
  glLightfv(GL_LIGHT1, GL_DIFFUSE, lightOneColor);
  glEnable(GL_LIGHT0);
  glEnable(GL_LIGHT1);
  glLineWidth(1.0);
  printf("Commandes:\n * ESC, q : quitter\n * f: toggle flat\n * g: toggle fog\n * c: toggle cull face \n * z, Z, x, X, y, Y: deplacement en x, y ou z\n * b, t, l: tracer les boules, la table, le support\n * fleches: pour bouger\n");
  
  glutIdleFunc(moveBalls);
  glutMainLoop();
  return 0;
}
