#ifndef OBJECT_H
#define OBJECT_H

#include <stdio.h>
#include "matrix.h"
#include "color.h"


typedef struct {
  short x, y; /* pixels ! */
} PIXEL;


typedef struct VertexStruct {
  COORD3D ObjectVertex;     /* sommet dans le repere objet */
  COORD3D CameraVertex;    /* sommet dans le repere camera */
  PIXEL ScreenVertex;      /* sommet dans le repere ecran/X11 */
  COORD3D N;               /* normale en ce sommet */
  Color color;             /* Couleur en ce sommet */
  double I;                /* Intensite en ce sommet */
} VERTEX;

typedef struct TriStruct {
  int PtVertex[3];
  COORD3D N;         /* normale en cette face */
} Tri;

typedef struct {
  Color color;  /* Couleur de l'objet */
  double Ka;    /* Coefficient de reflexion de la lumiere ambiante 
		   (entre 0 et 1)*/
  double Kd;    /* Coefficient de diffusion de la lumiere diffuse
		   (entre 0 et 1)*/
  double Ks;    /* Coefficient de diffusion de la lumiere speculaire
		   (entre 0 et 1)*/
  int m;        /* Coefficient de directivite des reflet */

} SURFACE_ATTRIBUTES;

typedef struct QuadStruct {
  int PtVertex[4];   /* 4 indices de sommets dans le tableau des VERTEX de la BBox */
  COORD3D N;         /* normale en cette face, servira plus tard pour dessiner la BBox */
} Quad;

typedef struct BBoxStruct {
  VERTEX Vertex[8];   /* 8 sommets */
  Quad QuadList[6];   /* 6 faces rectangulaires */
  double hauteur, largeur, profondeur;
  double plusGrandCote;
} BBox;

typedef struct ObjectStruct {
  /* position of the object in 3D space */
  Matrix4 LocalToGlobal;
  Matrix4 GlobalToLocal;
  Matrix4 LocalToCamera;
  BBox boundingBox;
  /* list of vertices as a table of 3D points */
  int NbVertices;           /* Nombre de sommets */
  VERTEX *Vertex;           /* Liste des sommets */
  /* List of triangular faces, a tab of index to vertices */
  int NbTri;
  Tri *TriList;
  /* Caracteristiques de diffusion/reflexion de la lumiere */
  SURFACE_ATTRIBUTES material;

 // double TailleBBox;        /*taille de la bounding box */

} Object;

typedef struct CameraStruct {
  Matrix4 LocalToGlobal;
  Matrix4 GlobalToLocal;

  double fovX, fovY;             /* Field of view in x, y (degrees), in camera
				    coordinate system */
  int resX, resY;                /* Screen resolution, in screen coordinate 
                                    system (the one used by X11) */
  double sx, sy;                 /* used for the camera -> screen 
				    transformation */
  double tx, ty;
  int render_mode;    /* Mode de rendu : fil de fer, gouraud, etc... */
  int use_pixmap;     /* Utilisation d'un pixmap comme buffer image ? */
  char *image;        /* Buffer contenant l'image finale, associ  une XImage */

} Camera;


/* Fonctions exportees du module object.c */

extern void ReadObject(char *filename, Object *obj);
extern void ReadCamera(char *filename, Camera *obj);
extern void UpdateLocalToCamera(Object *obj, Camera *cam);
extern void TranslateObject(Object *obj, double tx, double ty, double tz);
extern void RotateObject(Object *obj, double rx, double ry, double rz);
extern void RotateObjectLocal(Object *obj, double rx, double ry, double rz);
extern void TranslateCamera(Camera *obj, double tx, double ty, double tz);
extern void RotateCamera(Camera *obj, double rx, double ry, double rz);
extern void RotateCameraLocal(Camera *obj, double rx, double ry, double rz);

extern void PlacerCamera(Camera *cam,Object *obj);


#endif
