#include <stdio.h>
#include <math.h>
#include "object.h"
#include "matrix.h"

/* Useful macros */
#define   intpar(str, x)   sscanf(str, "%*s %d", &(x))
#define   int3par(str, x1, x2, x3)   sscanf(str, "%*s %d%d%d", &(x1), &(x2), &(x3))
#define   int4par(str, x1, x2, x3, x4)   sscanf(str, "%*s %d%d%d%d", &(x1), &(x2), &(x3), &(x4))
#define   lngpar(str, x)   sscanf(str, "%*s %ld", &(x))
#define   dblpar(str, x)   sscanf(str, "%*s %lf", &(x))
#define   dbl3par(str, x, y, z)  sscanf(str, "%*s %lf%lf%lf", &(x), &(y), &(z))
#define   dbl4par(str, x1, x2, x3, x4)  sscanf(str, "%*s %lf%lf%lf%lf", &(x1), &(x2), &(x3), &(x4))
#define   dblpar(str, x)   sscanf(str, "%*s %lf", &(x))
#define   strpar(str, x)   sscanf(str, "%*s %s", (x))

#define MAX(a,b)         (((a) < (b)) ? b : a)

/* Forward declarations */
void VertexIndexesMoins1(Object *obj);
static void ComputeCameraToScreenTransformation(Camera *cam);
static void CenterObjectPoints(Object *obj);


// Calcul des normales
static void precalculeNormales(Object *obj) {
  COORD3D v1, v2;
  int i;

  for (i=0; i<obj->NbVertices; ++i) {
    obj->Vertex[i].N.x = 0;
    obj->Vertex[i].N.y = 0;
    obj->Vertex[i].N.z = 0;
  }
  for (i=0; i<obj->NbTri; ++i) {
    DiffPoint3D(&(obj->Vertex[obj->TriList[i].PtVertex[1]].ObjectVertex), &(obj->Vertex[obj->TriList[i].PtVertex[0]].ObjectVertex), &v1);
    DiffPoint3D(&(obj->Vertex[obj->TriList[i].PtVertex[2]].ObjectVertex), &(obj->Vertex[obj->TriList[i].PtVertex[0]].ObjectVertex), &v2);
    CrossProdPoint3D(&v1, &v2, &(obj->TriList[i].N));
    NormalizeVector3D(&(obj->TriList[i].N));
    obj->Vertex[obj->TriList[i].PtVertex[0]].N.x += obj->TriList[i].N.x;
    obj->Vertex[obj->TriList[i].PtVertex[0]].N.y += obj->TriList[i].N.y;
    obj->Vertex[obj->TriList[i].PtVertex[0]].N.z += obj->TriList[i].N.z;
    obj->Vertex[obj->TriList[i].PtVertex[1]].N.x += obj->TriList[i].N.x;
    obj->Vertex[obj->TriList[i].PtVertex[1]].N.y += obj->TriList[i].N.y;
    obj->Vertex[obj->TriList[i].PtVertex[1]].N.z += obj->TriList[i].N.z;
    obj->Vertex[obj->TriList[i].PtVertex[2]].N.x += obj->TriList[i].N.x;
    obj->Vertex[obj->TriList[i].PtVertex[2]].N.y += obj->TriList[i].N.y;
    obj->Vertex[obj->TriList[i].PtVertex[2]].N.z += obj->TriList[i].N.z;
  }
  for (i=0; i<obj->NbVertices; ++i) {
    NormalizeVector3D(&(obj->Vertex[i].N));
  }
}


/*--------------------------------------*/
void ReadObject(char *filename, Object *obj)
/*--------------------------------------*/
/* Lit un fichier de description d'objet, met a jour les champs de la 
   structure objet */
{
  FILE *fp;
  char  line[1024], command[1024];
  int current_vertex, current_tri;
  double x, y, z, pitch, roll, yaw;
  short DeplacerIndicesDe_0_a_1 = 0;
  int r, g, b;
  int LitCouleur = 0;

  if ((fp = fopen (filename, "r")) == NULL) {
    fprintf (stderr, "Attention: file %s  can not open !!!\n", filename) ;
    exit(0);
  }

  SetMatrixToIdentity(&(obj->LocalToGlobal));
  SetMatrixToIdentity(&(obj->GlobalToLocal));
  SetMatrixToIdentity(&(obj->LocalToCamera));

  current_vertex = current_tri = 0;

  while(fgets(line, 1024, fp) != NULL) 
    if(line[0] != '#') {
      if(sscanf(line, "%s", command) != 0) {

	if(!strcmp(command, "Position")) 
	  /* Pos 3D du repere associe a l'objet */
	  dbl3par(line, x, y, z);

	if(!strcmp(command, "Orientation")) 
	  /* Orientation 3D du repere associe a l'objet */
	  dbl3par(line, pitch, yaw, roll);

	/* Les sommets */
	if(!strcmp(command, "NbVertices")) {
	  intpar(line, obj->NbVertices);
	  /* alloc the room for all the vertices */
	  obj->Vertex = (VERTEX *) malloc(obj->NbVertices*sizeof(VERTEX));
	}

        if(!strcmp(command, "Vertex")) {
	  /* Read the vertex */
          dbl3par(line, 
		  obj->Vertex[current_vertex].ObjectVertex.x, 
		  obj->Vertex[current_vertex].ObjectVertex.y, 
		  obj->Vertex[current_vertex].ObjectVertex.z);
	  current_vertex++;
	}

	/* Les faces */
	if(!strcmp(command, "NbTri")) {
	  intpar(line, obj->NbTri);
	  /* alloc the room for all the Triangular faces */
	  obj->TriList = (Tri *) malloc(obj->NbTri * sizeof(Tri));
	}
  
        if(!strcmp(command, "Tri")) {
	  /* Read the triangular face as vertex indexes */
          int3par(line, 
		  obj->TriList[current_tri].PtVertex[0],
		  obj->TriList[current_tri].PtVertex[1],
		  obj->TriList[current_tri].PtVertex[2]);
	  current_tri++;
	}

	/* Indexs comemncent a 0 ou a 1 ? */
        if(!strcmp(command, "FirstIndexIs_1")) {
	  DeplacerIndicesDe_0_a_1 = 1;
	}

	if(!strcmp(command, "Color")) {
	  LitCouleur = 1;
	  int3par(line, r, g ,b);
	  obj->material.color.r=r;
	  obj->material.color.g=g;
	  obj->material.color.b=b;
	}

	/* Caracteristiques de la surface */
	if(!strcmp(command, "Ka")) 
	  dblpar(line, obj->material.Ka);

	if(!strcmp(command, "Kd")) 
	  dblpar(line, obj->material.Kd);

	if(!strcmp(command, "Ks")) 
	  dblpar(line, obj->material.Ks);

	if(!strcmp(command, "m")) 
	  intpar(line, obj->material.m);
      }
    }
  fclose(fp);
  
  printf("NB Vertex Lus : %d, Nb Tri Lus : %d\n", current_vertex, current_tri);

  if (!LitCouleur) {
    obj->material.color.r=255;
    obj->material.color.g=0;
    obj->material.color.b=0;
  }

  /* Petit hack pour lire des fichiers objets dont les indices des sommets 
     commencent a 1 et non a 0 */
  if(DeplacerIndicesDe_0_a_1)
    VertexIndexesMoins1(obj);

  /* Transformation des points de l'objet pour que le repere objet se trouve 
     au centre de l'objet */
  CenterObjectPoints(obj); 
  
  // Calcul des normales
  precalculeNormales(obj);

  /* Positionnement de l'objet a la position desiree */
  RotateObject(obj, pitch, yaw, roll);
  TranslateObject(obj, x, y, z);
}


/*-----------------------------------------*/
void VertexIndexesMoins1(Object *obj)
/*-----------------------------------------*/
/* Utile pour travailler avec des objets dont les indices de sommets 
   commencent a 1 et non a 0 */
{
  int i;

  for (i=0; i < obj->NbTri; i++) {
    obj->TriList[i].PtVertex[0]--;
    obj->TriList[i].PtVertex[1]--;
    obj->TriList[i].PtVertex[2]--;
  }
} 


/*------------------------------------------*/
static void CenterObjectPoints(Object *obj)
/*------------------------------------------*/
/* Positionne le centre du repere objet sur le barycentre de l'objet  et 
   calcule la bounding box de l'objet */
{
  /* CODE A ECRIRE FACULTATIF */
  double bx=0,by=0,bz=0;
  int i;
  COORD3D ObjCoord;
  double Xmin,Xmax,Ymin,Ymax,Zmin,Zmax;

  for (i=0;i<obj->NbVertices;++i) {
    bx+=obj->Vertex[i].ObjectVertex.x;
    by+=obj->Vertex[i].ObjectVertex.y;
    bz+=obj->Vertex[i].ObjectVertex.z;
  }
  bx/=obj->NbVertices;
  by/=obj->NbVertices;
  bz/=obj->NbVertices;
  for (i=0;i<obj->NbVertices;++i) {
    obj->Vertex[i].ObjectVertex.x-=bx;
    obj->Vertex[i].ObjectVertex.y-=by;
    obj->Vertex[i].ObjectVertex.z-=bz;
  }

  // Calcul Bounding Box
  Xmin=Xmax=obj->Vertex[0].ObjectVertex.x;
  Ymin=Ymax=obj->Vertex[0].ObjectVertex.y;
  Zmin=Zmax=obj->Vertex[0].ObjectVertex.z;
  for (i=1;i<obj->NbVertices;++i) {
    ObjCoord=obj->Vertex[i].ObjectVertex;
    if (Xmin>ObjCoord.x)
      Xmin=ObjCoord.x;
    if (Xmax<ObjCoord.x)
      Xmax=ObjCoord.x;
    if (Ymin>ObjCoord.y)
      Ymin=ObjCoord.y;
    if (Ymax<ObjCoord.y)
      Ymax=ObjCoord.y;
    if (Zmin>ObjCoord.z)
      Zmin=ObjCoord.z;
    if (Zmax<ObjCoord.z)
      Zmax=ObjCoord.z;
  }
  obj->boundingBox.Vertex[0].ObjectVertex.x=Xmin;
  obj->boundingBox.Vertex[0].ObjectVertex.y=Ymin;
  obj->boundingBox.Vertex[0].ObjectVertex.z=Zmin;
  obj->boundingBox.Vertex[1].ObjectVertex.x=Xmin;
  obj->boundingBox.Vertex[1].ObjectVertex.y=Ymin;
  obj->boundingBox.Vertex[1].ObjectVertex.z=Zmax;
  obj->boundingBox.Vertex[2].ObjectVertex.x=Xmin;
  obj->boundingBox.Vertex[2].ObjectVertex.y=Ymax;
  obj->boundingBox.Vertex[2].ObjectVertex.z=Zmax;
  obj->boundingBox.Vertex[3].ObjectVertex.x=Xmin;
  obj->boundingBox.Vertex[3].ObjectVertex.y=Ymax;
  obj->boundingBox.Vertex[3].ObjectVertex.z=Zmin;
  obj->boundingBox.Vertex[4].ObjectVertex.x=Xmax;
  obj->boundingBox.Vertex[4].ObjectVertex.y=Ymin;
  obj->boundingBox.Vertex[4].ObjectVertex.z=Zmin;
  obj->boundingBox.Vertex[5].ObjectVertex.x=Xmax;
  obj->boundingBox.Vertex[5].ObjectVertex.y=Ymin;
  obj->boundingBox.Vertex[5].ObjectVertex.z=Zmax;
  obj->boundingBox.Vertex[6].ObjectVertex.x=Xmax;
  obj->boundingBox.Vertex[6].ObjectVertex.y=Ymax;
  obj->boundingBox.Vertex[6].ObjectVertex.z=Zmax;
  obj->boundingBox.Vertex[7].ObjectVertex.x=Xmax;
  obj->boundingBox.Vertex[7].ObjectVertex.y=Ymax;
  obj->boundingBox.Vertex[7].ObjectVertex.z=Zmin;
  obj->boundingBox.QuadList[0].PtVertex[0]=0;
  obj->boundingBox.QuadList[0].PtVertex[1]=3;
  obj->boundingBox.QuadList[0].PtVertex[2]=2;
  obj->boundingBox.QuadList[0].PtVertex[3]=1;
  obj->boundingBox.QuadList[1].PtVertex[0]=2;
  obj->boundingBox.QuadList[1].PtVertex[1]=3;
  obj->boundingBox.QuadList[1].PtVertex[2]=7;
  obj->boundingBox.QuadList[1].PtVertex[3]=6;
  obj->boundingBox.QuadList[2].PtVertex[0]=7;
  obj->boundingBox.QuadList[2].PtVertex[1]=4;
  obj->boundingBox.QuadList[2].PtVertex[2]=5;
  obj->boundingBox.QuadList[2].PtVertex[3]=6;
  obj->boundingBox.QuadList[3].PtVertex[0]=4;
  obj->boundingBox.QuadList[3].PtVertex[1]=0;
  obj->boundingBox.QuadList[3].PtVertex[2]=1;
  obj->boundingBox.QuadList[3].PtVertex[3]=5;
  obj->boundingBox.QuadList[4].PtVertex[0]=2;
  obj->boundingBox.QuadList[4].PtVertex[1]=6;
  obj->boundingBox.QuadList[4].PtVertex[2]=5;
  obj->boundingBox.QuadList[4].PtVertex[3]=1;
  obj->boundingBox.QuadList[5].PtVertex[0]=0;
  obj->boundingBox.QuadList[5].PtVertex[1]=4;
  obj->boundingBox.QuadList[5].PtVertex[2]=7;
  obj->boundingBox.QuadList[5].PtVertex[3]=3;
  obj->boundingBox.hauteur=Ymax-Ymin;
  obj->boundingBox.largeur=Xmax-Xmin;
  obj->boundingBox.profondeur=Zmax-Zmin;
  obj->boundingBox.plusGrandCote=obj->boundingBox.hauteur;
  if (obj->boundingBox.plusGrandCote<obj->boundingBox.largeur)
    obj->boundingBox.plusGrandCote=obj->boundingBox.largeur;
  if (obj->boundingBox.plusGrandCote<obj->boundingBox.profondeur)
    obj->boundingBox.plusGrandCote=obj->boundingBox.profondeur;

}

/*--------------------------------------*/
void ReadCamera(char *filename, Camera *obj)
/*--------------------------------------*/
{
  FILE *fp;
  char  line[1024], command[1024];
  double x, y, z, pitch, roll, yaw;

  if ((fp = fopen (filename, "r")) == NULL) {
    fprintf (stderr, "Attention: file %s  can not open !!!\n", filename) ;
    exit(0);
  }

  SetMatrixToIdentity(&(obj->LocalToGlobal));
  SetMatrixToIdentity(&(obj->GlobalToLocal));

  while(fgets(line, 1024, fp) != NULL) 
    if(line[0] != '#') {
      if(sscanf(line, "%s", command) != 0) {

	if(!strcmp(command, "Position")) 
	  /* Pos 3D du repere associe a l'objet */
	  dbl3par(line, x, y, z);

	if(!strcmp(command, "Orientation")) 
	  /* Orientation 3D du repere associe a l'objet */
	  dbl3par(line, pitch, yaw, roll);

	if(!strcmp(command, "fovX")) 
	  /* Champ de vision en X */
	  dblpar(line, obj->fovX);

	if(!strcmp(command, "fovY")) 
	  /* Champ de vision en y */
	  dblpar(line, obj->fovY);
	
	if(!strcmp(command, "resX")) 
	  /* Resolution de l'ecran en X */
	  intpar(line, obj->resX);

	if(!strcmp(command, "resY")) 
	  /* Resolution de l'ecran en Y */
	  intpar(line, obj->resY);
      }
    }
  fclose(fp);

  /* Positionne la camera dans l'espace */
  RotateCamera(obj, pitch, yaw, roll);
  TranslateCamera(obj, x, y, z);
  
  /* calcule les parametres camera : facteurs d'echelle et translation pour 
     passer vers le repere X11 */
  ComputeCameraToScreenTransformation(obj);
}

/*----------------------------------------------------------*/
static void ComputeCameraToScreenTransformation(Camera *cam)
/*----------------------------------------------------------*/
/* Calcul de cam->sx, cam->sy, cam->tx, cam->ty en fonction de cam->fovX, 
   cam->fovY, cam->resX et cam->resY */
{
  /* CODE A ECRIRE */
  cam->sx=cam->resX/(2*tan(cam->fovX*M_PI/180.0));
  cam->sy=cam->resY/(2*tan(cam->fovY*M_PI/180.0));
  cam->tx=cam->resX/2.0;
  cam->ty=cam->resY/2.0;
}

/*-------------------------------------------*/
void UpdateLocalToCamera(Object *obj, Camera *cam)
/*-------------------------------------------*/
/* Calcul de obj->LocalToCamera en fonction de cam->GlobalToLocal et 
   obj->LocalToGlobal */
{
  /* CODE A ECRIRE */
  MultiplyMatrix(&(cam->GlobalToLocal), &(obj->LocalToGlobal), &(obj->LocalToCamera));
}


/*-----------------------------------------------------------*/
void TranslateObject(Object *obj, double tx, double ty, double tz)
/*-----------------------------------------------------------*/
/* Applique une translation (tx, ty, tz) a l'objet. met a jour 
   obj->LocalToGlobal et obj->GlobalToLocal */
{
  /* CODE A ECRIRE */
  Matrix4 TransM,InvTransM;

//  SetMatrixToIdentity(&TransM);
//  SetMatrixToIdentity(&InvTransM);
  GetTranslationMatrix(tx, ty, tz, &TransM, &InvTransM);
  MultiplyMatrix(&TransM, &(obj->LocalToGlobal), &(obj->LocalToGlobal));
  MultiplyMatrix(&(obj->GlobalToLocal), &InvTransM, &(obj->GlobalToLocal));
}

/*--------------------------------------------------------*/
void RotateObject(Object *obj, double rx, double ry, double rz)
/*--------------------------------------------------------*/
/* Applique a l'objet obj une rotation (rx, ry, rz) dans le repere du monde. 
   Met a jour obj->LocalToGlobal et obj->GlobalToLocal */
{
  /* CODE A ECRIRE */
  Matrix4 RotM,InvRotM;

//  SetMatrixToIdentity(&RotM);
//  SetMatrixToIdentity(&InvRotM);
//  if (!rx && !ry)
//    GetRotationMatrixZ(rz,&RotM,&InvRotM);
//  else if (!rx && !rz)
//    GetRotationMatrixY(ry,&RotM,&InvRotM);
//  else if (!ry && !rz)
//    GetRotationMatrixX(rx,&RotM,&InvRotM);
//  else 
  GetRotationMatrixXYZ(rx, ry, rz, &RotM, &InvRotM);
  MultiplyMatrix(&RotM, &(obj->LocalToGlobal), &(obj->LocalToGlobal));
  MultiplyMatrix(&(obj->GlobalToLocal), &InvRotM, &(obj->GlobalToLocal));
}

/*------------------------------------------------------------------*/
void RotateObjectLocal(Object *obj, double rx, double ry, double rz)
/*------------------------------------------------------------------*/
/* Applique a l'objet obj une rotation (rx, ry, rz) dans son propre repere 
   (il tourne autours de ses propres axes). Met a jour obj->LocalToGlobal et 
   obj->GlobalToLocal */
{
  /* CODE A ECRIRE (facultatif, a faire en plus tard) */
}

/*-----------------------------------------------------------*/
void TranslateCamera(Camera *obj, double tx, double ty, double tz)
/*-----------------------------------------------------------*/
/* Applique a la camera obj une translation (tx, ty, tz). met a jour 
   obj->LocalToGlobal et obj->GlobalToLocal */
{
  /* CODE A ECRIRE */
  Matrix4 TransM,InvTransM;

//  SetMatrixToIdentity(&TransM);
//  SetMatrixToIdentity(&InvTransM);
  GetTranslationMatrix(tx, ty, tz, &TransM, &InvTransM);
  MultiplyMatrix(&TransM, &(obj->LocalToGlobal), &(obj->LocalToGlobal));
  MultiplyMatrix(&(obj->GlobalToLocal), &InvTransM, &(obj->GlobalToLocal));
}

/*--------------------------------------------------------*/
void RotateCamera(Camera *obj, double rx, double ry, double rz)
/*--------------------------------------------------------*/
/* Applique a la camera obj une rotation (rx, ry, rz) dans le repere du monde. 
   Met a jour obj->LocalToGlobal et obj->GlobalToLocal */
{
  /* CODE A ECRIRE */
  Matrix4 RotM,InvRotM;

//  SetMatrixToIdentity(&RotM);
//  SetMatrixToIdentity(&InvRotM);
//  if (!rx && !ry)
//    GetRotationMatrixZ(rz,&RotM,&InvRotM);
//  else if (!rx && !rz)
//    GetRotationMatrixY(ry,&RotM,&InvRotM);
//  else if (!ry && !rz)
//    GetRotationMatrixX(rx,&RotM,&InvRotM);
//  else 
  GetRotationMatrixXYZ(rx, ry, rz, &RotM, &InvRotM);
  MultiplyMatrix(&RotM, &(obj->LocalToGlobal), &(obj->LocalToGlobal));
  MultiplyMatrix(&(obj->GlobalToLocal), &InvRotM, &(obj->GlobalToLocal));
}

/*------------------------------------------------------------------*/
void RotateCameraLocal(Camera *obj, double rx, double ry, double rz)
/*------------------------------------------------------------------*/
/* Applique a la camera obj une rotation (rx, ry, rz) dans son propre repere 
   (elle tourne autours de ses propres axes). Met a jour obj->LocalToGlobal et 
   obj->GlobalToLocal */
{
  /* CODE A ECRIRE (facultatif, a faire en plus tard) */
}

/*-------------------------------------------*/
void PlacerCamera(Camera *cam,Object *obj) {
  double D;

  SetMatrixToIdentity(&cam->LocalToGlobal);
  SetMatrixToIdentity(&cam->GlobalToLocal);
  RotateCamera(cam, 180.0, 0, 0);
  D = (obj->boundingBox.plusGrandCote/2.)*(1+1/tan(cam->fovX*M_PI/180.0));
  TranslateCamera(cam, obj->LocalToGlobal.elem[0][3], obj->LocalToGlobal.elem[1][3], obj->LocalToGlobal.elem[2][3]+ 1.2*D);
}

