#include <stdio.h>
#include <math.h>
#include "line_command_options.h"
#include "object.h"
#include "graphics.h"
#include "param.h"
#include "light.h"


Object cube;         /* Les deux objets que l'on manipule : un objet et la 
			camera */
Camera cam;

Light lum;

GlobalParams params; /* Contiennent les parametres generaux de l'application
			mode de visu : file de fer, shading, faces cachees, 
			etc.... */

/* Forward declarations */
static void init_parameters(void);
static void read_obj_and_cam(char *obj_filename, char *cam_filename);

/*-------------------------------*/
void main(int argc, char *argv[])
/*-------------------------------*/
{
  char obj_filename[256], cam_filename[256], lum_filename[256];

  /* Initialise les parametres genraux par defaut */
  init_parameters();

  /* Lecture des options sur la ligne de commande */
  init_line_command_options(argc, argv);

  if(get_parameter("obj", "%s", obj_filename)) 
    fprintf(stderr,"Using %s object file\n",obj_filename);
  else
    print_usage(argv);

  if(get_parameter("cam", "%s", cam_filename)) 
    fprintf(stderr,"Using %s camera filename\n",cam_filename);
  else
    sprintf(cam_filename,"%s","cam_default.obj");

  if(get_parameter("l", "%s", lum_filename)) 
    fprintf(stderr,"Using %s light filename\n",lum_filename);
  else
    sprintf(lum_filename,"%s","light_default.obj");

  if(get_opt("bw")) 
    params.color_mode = BLACK_AND_WHITE_MODE;
  else
    params.color_mode = COLOR_MODE;

  /* Lecture de l'objet et de la camera sur disque */
  read_obj_and_cam(obj_filename, cam_filename);

  ReadLight(lum_filename, &lum);

  /* Ouverture de la fenetre graphique et affichage de l'objet */
  init_graphics(cam.resX, cam.resY);
}

/*-------------------------------*/
static void init_parameters(void)
/*-------------------------------*/
{
  params.render_mode = WIREFRAME;
  params.display_vertex_index = 0;
  params.color_mode = COLOR_MODE;
}

/*------------------------------------------------------------------*/
static void read_obj_and_cam(char *obj_filename, char *cam_filename)
/*------------------------------------------------------------------*/
{
  /* Lecture de l'objet sur disque */
  ReadObject(obj_filename, &cube);

  /* lecture de la camera */
  ReadCamera(cam_filename, &cam);

  // Placage camera
  PlacerCamera(&cam,&cube);

  /* Calculer cube.LocalToCamera. cette matrice sert a faire passer les 
     points de l'objet (exprimes dans le repere objet) dans le repere de la 
     camera */
  UpdateLocalToCamera(&cube, &cam);
}


