#ifndef LIGHT_H
#define LIGHT_H

#include "matrix.h"
#include "color.h"
#include "object.h"

#define  DIRECTIONAL       0
#define  SPOT_LIGHT        1
#define  CONE_LIGHT        2
#define  ATTENUATED_LIGHT  3

typedef struct LightStruct {
    Matrix4 LocalToGlobal;  /* Une lampe est un vrai objet 3d avec une position
                               et une orientation */
    Matrix4 GlobalToLocal;
    
    int     Type;       /* type de la source lumieuse */
    double  angle;      /* sert pour la cone_light angle d'ouverture */
    double  intensite;  /* intensite de la lumiere comprise entre 0 et 1 */
    int     puissance;  /* puissance d attenuation des lumieres ponctuelles */
    double  attenuation; /* factuer d'attenuation */
    Color   color;
} Light;

extern void ReadLight(char *filename, Light *Lumiere);
extern void TranslateLight(Light *obj, double tx, double ty, double tz);
extern void RotateLight(Light *obj, double rx, double ry, double rz);

extern int LumiereAmbiente(Light *lum,  Object *obj);
extern int LumiereDiffuse(Light *lum, Object *obj, int nFace, COORD3D *Normale);
extern int LumiereSpeculaire(Light *lum, Object *obj, Camera *cam, int nFace, COORD3D *Normale);

#endif
