#include "light.h"
#include <stdio.h>
#include <math.h>

/* Useful macros */
#define   intpar(str, x)   sscanf(str, "%*s %d", &(x))
#define   int3par(str, x1, x2, x3)   sscanf(str, "%*s %d%d%d", &(x1), &(x2), &(x3))
#define   int4par(str, x1, x2, x3, x4)   sscanf(str, "%*s %d%d%d%d", &(x1), &(x2), &(x3), &(x4))
#define   lngpar(str, x)   sscanf(str, "%*s %ld", &(x))
#define   dblpar(str, x)   sscanf(str, "%*s %lf", &(x))
#define   dbl3par(str, x, y, z)  sscanf(str, "%*s %lf%lf%lf", &(x), &(y), &(z))
#define   dbl4par(str, x1, x2, x3, x4)  sscanf(str, "%*s %lf%lf%lf%lf", &(x1), &(x2), &(x3), &(x4))
#define   dblpar(str, x)   sscanf(str, "%*s %lf", &(x))
#define   strpar(str, x)   sscanf(str, "%*s %s", (x))

#define MAX(a,b)         (((a) < (b)) ? b : a)


// Fonction puissance
int puiss(double a,int b) {
  int i;
  double res = a;

  if (b==0)
    return 1;
  for (i=1; i<b ;++i)
    res *= a;
  return res;
}

/*--------------------------------------*/
void ReadLight(char *filename, Light *Lumiere)
/*--------------------------------------*/
{
  FILE *fp;
  char  line[1024], command[1024];
  double x, y, z;
  int r, g, b;

  if ((fp = fopen (filename, "r")) == NULL) {
    fprintf (stderr, "Attention: file %s  can not open !!!\n", filename) ;
    exit(0);
  }

  SetMatrixToIdentity(&(Lumiere->LocalToGlobal));
  SetMatrixToIdentity(&(Lumiere->GlobalToLocal));

  while(fgets(line, 1024, fp) != NULL) 
    if((line[0] != '#') && (line[0] != 10)){
      if(sscanf(line, "%s", command) != 0) {

        if(!strcmp(command, "Position")) 
          /* Pos 3D du repere associe a la lumiere */
          dbl3par(line, x, y, z);

        if(!strcmp(command, "Type")) 
          intpar(line, Lumiere->Type);

        if(!strcmp(command, "Intensite")) 
          dblpar(line, Lumiere->intensite);

        if(!strcmp(command, "Angle")) 
          dblpar(line, Lumiere->angle);

        if(!strcmp(command, "Attenuation")) 
          dblpar(line, Lumiere->attenuation);

        if(!strcmp(command, "Color")) {
          /* Couleur de la lampe */
          int3par(line, r, g, b);
          Lumiere->color.r = (unsigned char) r;
          Lumiere->color.g = (unsigned char) g; 
          Lumiere->color.b = (unsigned char) b; 
        }

        if(!strcmp(command, "Puissance")) 
          intpar(line, Lumiere->puissance);

      }
    }
  fclose(fp);

  Lumiere->angle = cos(Lumiere->angle*M_PI/180);

  /* Positionne la camera dans l'espace */
  TranslateLight(Lumiere, x, y, z);
  
}

/*-----------------------------------------------------------*/
void TranslateLight(Light *obj, double tx, double ty, double tz)
/*-----------------------------------------------------------*/
/* Applique une translation (tx, ty, tz) a l'objet. met a jour 
   obj->LocalToGlobal et obj->GlobalToLocal */
{
  Matrix4 TransM,InvTransM;

  GetTranslationMatrix(tx, ty, tz, &TransM, &InvTransM);
  MultiplyMatrix(&TransM, &(obj->LocalToGlobal), &(obj->LocalToGlobal));
  MultiplyMatrix(&(obj->GlobalToLocal), &InvTransM, &(obj->GlobalToLocal));
}

/*--------------------------------------------------------*/
void RotateLight(Light *obj, double rx, double ry, double rz)
/*--------------------------------------------------------*/
/* Applique a l'objet obj une rotation (rx, ry, rz) dans le repere du monde. 
   Met a jour obj->LocalToGlobal et obj->GlobalToLocal */
{
  Matrix4 RotM,InvRotM;

  GetRotationMatrixXYZ(rx, ry, rz, &RotM, &InvRotM);
  MultiplyMatrix(&RotM, &(obj->LocalToGlobal), &(obj->LocalToGlobal));
  MultiplyMatrix(&(obj->GlobalToLocal), &InvRotM, &(obj->GlobalToLocal));
}



int LumiereAmbiente(Light *lum,  Object *obj) {
/*  Color c;
  c.r = (char)((obj->material.Ka *  lum->intensite * (double)(obj->material.color.r)/255.)*255);
  c.g = (char)((obj->material.Ka * lum->intensite * (double)(obj->material.color.g)/255.)*255);
  c.b = (char)((obj->material.Ka * lum->intensite * (double)(obj->material.color.b)/255.)*255);
    return RGBTOONE(c.r, c.g, c.b);*/

// Version B&W
  int c;
  c = (int)((obj->material.Ka *  lum->intensite * 1.)*255);
  return c;
}


int LumiereDiffuse(Light *lum, Object *obj, int nFace, COORD3D *Normale) {
//  Color c;
  int c;
  COORD3D V;
  double scalaire;

  // Calcul vecteur lumiere  - face
  V.x = lum->LocalToGlobal.elem[0][3];
  V.y = lum->LocalToGlobal.elem[1][3];
  V.z = lum->LocalToGlobal.elem[2][3];
  TransformPoint(&V, &obj->GlobalToLocal, &V);
  V.x -= obj->Vertex[obj->TriList[nFace].PtVertex[1]].ObjectVertex.x;
  V.y -= obj->Vertex[obj->TriList[nFace].PtVertex[1]].ObjectVertex.y;
  V.z -= obj->Vertex[obj->TriList[nFace].PtVertex[1]].ObjectVertex.z;
  NormalizeVector3D(&V);

  // Calcul du produit scalaire
  scalaire =   DotProdPoint3D(&V, Normale);
  if (scalaire<0)
    scalaire = 0;

  // Calcul de la couleur
/*  c.r = (char)((obj->material.Kd *  lum->intensite * scalaire * (double)(obj->material.color.r)/255.)*255);
  c.g = (char)((obj->material.Kd * lum->intensite * scalaire * (double)(obj->material.color.g)/255.)*255);
  c.b = (char)((obj->material.Kd * lum->intensite * scalaire * (double)(obj->material.color.b)/255.)*255);
    return RGBTOONE(c.r, c.g, c.b);*/
  c = (int)((obj->material.Kd * lum->intensite * scalaire * 1.)*255);
  return c;
}


int LumiereSpeculaire(Light *lum, Object *obj, Camera *cam, int nFace, COORD3D *Normale) {
//  Color c;
  int c;
  COORD3D V, S, N;
  double scalaire;

  // Calcul du vecteur lumiere - face
  V.x = lum->LocalToGlobal.elem[0][3];
  V.y = lum->LocalToGlobal.elem[1][3];
  V.z = lum->LocalToGlobal.elem[2][3];
  TransformPoint(&V, &obj->GlobalToLocal, &V);
  V.x -= obj->Vertex[obj->TriList[nFace].PtVertex[1]].ObjectVertex.x;
  V.y -= obj->Vertex[obj->TriList[nFace].PtVertex[1]].ObjectVertex.y;
  V.z -= obj->Vertex[obj->TriList[nFace].PtVertex[1]].ObjectVertex.z;
  NormalizeVector3D(&V);

  // Calcul vecteur camera - face
  S.x = cam->LocalToGlobal.elem[0][3];
  S.y = cam->LocalToGlobal.elem[1][3];
  S.z = cam->LocalToGlobal.elem[2][3];
  TransformPoint(&S, &obj->GlobalToLocal, &S);
  S.x -= obj->Vertex[obj->TriList[nFace].PtVertex[1]].ObjectVertex.x;
  S.y -= obj->Vertex[obj->TriList[nFace].PtVertex[1]].ObjectVertex.y;
  S.z -= obj->Vertex[obj->TriList[nFace].PtVertex[1]].ObjectVertex.z;
  NormalizeVector3D(&S);

  // Calcul du produit scalaire
  scalaire =   DotProdPoint3D(&V, Normale);
  N.x = 2 * scalaire * Normale->x;
  N.y = 2 * scalaire * Normale->y;
  N.z = 2 * scalaire * Normale->z;
  DiffPoint3D(&N, &V, &N);
  scalaire = DotProdPoint3D(&N, &S);
  scalaire = puiss(scalaire, obj->material.m);
  if (scalaire<0)
    scalaire = 0;

  // Calcul de la couleur
/*  c.r = (char)((obj->material.Ks * lum->intensite * scalaire * (double)(lum->color.r)/255.)*255);
  c.g = (char)((obj->material.Ks * lum->intensite * scalaire * (double)(lum->color.g)/255.)*255);
  c.b = (char)((obj->material.Ks * lum->intensite * scalaire * (double)(lum->color.b)/255.)*255);
    return RGBTOONE(c.r, c.g, c.b);*/
// Version B&W
  c = (int)((obj->material.Ks * lum->intensite * scalaire * 1.)*255);
  return c;
}
