#include <X11/Xlib.h>

#include <stdio.h>
#include <math.h>

#include "color.h"

/* Forward declarations */
static void SetRGB_CMap(Display *dpy, Colormap cmap, int n, 
			int r, int g, int b);

/*------------------------------------------------------------------------*/
static void SetRGB_CMap(Display *dpy, Colormap cmap, int n, 
			int r, int g, int b)
/*------------------------------------------------------------------------*/
/* Initialise la n-ieme couleur de la colormap avec la couleur definie par 
   (r, g, b) */
{
  XColor Col;

  Col.pixel = (unsigned long)n;
  Col.red = (unsigned short)r << 8 ;     /* car sous X11, les valeurs red, 
					    green, blue sont codees entre 0 et
					    64000, non pas entre 0 et 255 */
  Col.green = (unsigned short)g << 8 ;
  Col.blue = (unsigned short)b << 8 ;
  Col.flags = DoRed | DoGreen | DoBlue;

  XStoreColor(dpy, cmap, &Col);
}

/*-----------------------------------------------*/
void Lut_GreyLevels(Display *dpy, Colormap cmap)
/*-----------------------------------------------*/
{
  long i;

  /* pour nous, noir = (0, 0, 0), blanc = (255, 255, 255) */
  for (i=0; i < 256; i++)
    SetRGB_CMap(dpy, cmap, i, i, i, i);
}

/*---------------------------------------*/
void Lut_16M(Display *dpy, Colormap cmap)
/*---------------------------------------*/
{
  long r,g,b,a=0;

  for (r=0;r<8;r++)
    for (g=0;g<8;g++)
      for (b=0;b<4;b++)
	SetRGB_CMap(dpy, cmap ,a++ , r<<5, g<<5, b<<6);
}


/*------------------------------------------------*/
void Lut_Random_Color(Display *dpy, Colormap cmap)
/*------------------------------------------------*/
{
  long i;

  srand(time(NULL));

  for (i=0;i<256;i++) 
    SetRGB_CMap(dpy, cmap, i, rand()%256, rand()%256, rand()%256);
}

/*------------------------------------------------*/
void Lut_Smooth_Color(Display *dpy, Colormap cmap)
/*------------------------------------------------*/
{
  long i;

  for (i=0;i<64;i++) {
      SetRGB_CMap(dpy, cmap, i,     i<<2, 0,    i<<2);
      SetRGB_CMap(dpy, cmap, i+64,  0,    i<<2, i<<2);
      SetRGB_CMap(dpy, cmap, i+128, i<<2, i<<2, 0);
      SetRGB_CMap(dpy, cmap, i+192, i<<2, i<<2, i<<2);
  }
}

/*------------------------------------------------*/
void Lut_Random_Gray(Display *dpy, Colormap cmap)
/*------------------------------------------------*/
{
  long i,a;

  printf("\nMise en Place de la Lut de simulations random grise\n");
  srand(time(NULL));

  for (i=0;i<256;i++) {
    a=rand()%256;
    SetRGB_CMap(dpy, cmap, i, a, a, a);
    }
}

/*-------------------------------------------------------------*/
void Shift_L_Palette(Display *dpy, Colormap cmap, int NbColors)
/*-------------------------------------------------------------*/
{
  long i;
  XColor TCol[257];
	
  for (i=0; i < NbColors+1; i++) {
    TCol[i].pixel = (unsigned long)i;
    TCol[i].flags = DoRed | DoGreen | DoBlue;
  }

  XQueryColors(dpy, cmap, TCol, 256);
	
  TCol[256]=TCol[0];
	
  for (i=0; i < NbColors+1; i++) 
    (TCol+1)[i].pixel = (unsigned long) i;
  	
  XStoreColors(dpy, cmap, TCol+1, 256);
}

/*--------------------------------------------------------------*/
void Shift_R_Palette(Display *dpy, Colormap cmap, int NbColors)
/*--------------------------------------------------------------*/
{
  long i;
  XColor TCol[257];
	
  for (i=0; i<NbColors+1; i++) {
    TCol[i].pixel = (unsigned long)i;
    TCol[i].flags = DoRed | DoGreen | DoBlue;
  }

  XQueryColors(dpy, cmap, TCol+1, 256);
	
  TCol[0]=TCol[256];

  for (i=0; i<NbColors+1; i++) 
    TCol[i].pixel = (unsigned long) i;

  XStoreColors(dpy, cmap, TCol,256);
}

/*----------------------------------------------------------*/
void Show_Palette(Display *dpy, Colormap cmap, int NbColors)
/*----------------------------------------------------------*/
{
  int i;
  XColor Col;
       	
  Col.flags = DoRed | DoGreen | DoBlue;

  for (i=0; i<NbColors; i++) {
      Col.pixel=i;
      XQueryColor(dpy, cmap, &Col);
      printf("Couleur %d Valeur:r %d g %d b %d\n", i, 
	     Col.red>>8, Col.green>>8, Col.blue>>8);
    }
}
