

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <limits.h>                         /* INT_MAX/INT_MIN */

#include "object.h"
#include "Tracage.h"

char *G_buffer;
int HW_SCREEN_X_SIZE;
int HW_SCREEN_Y_SIZE;

int *G_start;
int *G_end;
int G_miny,G_maxy;                          /* vertical boundaries */

double *IntensiteDebut, *IntensiteFin;


void SetImageBuffer(Camera *cam);
void AllocateTableau();
void GI_scan(int x1, int y1, int x2, int y2, double I1, double I2);
void GI_boarder_array_init(void);
void G_polygon(int nTri, Object *obj, Camera *cam, Light *lum);
void T_polygon(int nTri, Object *obj, Camera *cam, Light *lum);


/*-------------------------------*/
void SetImageBuffer(Camera *cam)
/*-------------------------------*/
/* Initialisation du buffer camera. DOIT ETRE APPELEE AVANT TOUTES LES AUTRES ! */
{
  G_buffer = cam->image;
  HW_SCREEN_X_SIZE=cam->resX;
  HW_SCREEN_Y_SIZE=cam->resY;

   /* Allocation du tableau pour le trace des polygones */
  AllocateTableau();
}



void AllocateTableau() {

  /* Allocation du tableau des lignes */
  G_start = (int *) malloc(HW_SCREEN_Y_SIZE * sizeof(int));
  G_end = (int *) malloc(HW_SCREEN_Y_SIZE * sizeof(int));

  IntensiteDebut = (double *) malloc(HW_SCREEN_Y_SIZE * sizeof(double));
  IntensiteFin   = (double *) malloc(HW_SCREEN_Y_SIZE * sizeof(double));
}


void GI_scan(int x1, int y1, int x2, int y2, double I1, double I2)
/* Balayage de l'arete et remplissage des tableaux G_start et G_end */

{
 int dx,dy,long_d,short_d;
 int d,add_dh,add_dl;
 int inc_xh,inc_yh,inc_xl,inc_yl;
 register int i; 
 double delta;

 dx=x2-x1; dy=y2-y1;                          /* ranges */

  if(y1<G_miny) G_miny=y1;
  if(y1>G_maxy) G_maxy=y1;
  if(y2<G_miny) G_miny=y2;
  if(y2>G_maxy) G_maxy=y2;                  /* updating vertical size */


  if(dx<0){dx=-dx; inc_xh=-1; inc_xl=-1;}   /* making sure dx and dy >0 */
  else    {        inc_xh=1;  inc_xl=1; }   /* adjusting increments */
  if(dy<0){dy=-dy; inc_yh=-1; inc_yl=-1;}
  else    {        inc_yh=1;  inc_yl=1; }

  if(dx>dy){long_d=dx;short_d=dy;inc_yl=0;} /* long range,&making sure either */
  else     {long_d=dy;short_d=dx;inc_xl=0;} /* x or y is changed in L case */

  d=2*short_d-long_d;                       /* initial value of d */
  add_dl=2*short_d;                         /* d adjustment for H case */
  add_dh=2*short_d-2*long_d;                /* d adjustment for L case */

  delta = (I2-I1)/long_d;

  for(i=0;i<=long_d;i++) {                 /* for all points in longer range */
    if(x1<G_start[y1]) {                        /* further then rightmost */
      G_start[y1]=x1;                           /* the begining of scan line */
      IntensiteDebut[y1] = I1;
    }

   if(G_end[y1]<x1) {                          /* further the leftmost */
     G_end[y1]=x1;                             /* the end of scan line */
     IntensiteFin[y1] = I1;
   }

   if(d>=0){x1+=inc_xh;y1+=inc_yh;d+=add_dh;} /* previous point was H type */
   else    {x1+=inc_xl;y1+=inc_yl;d+=add_dl;} /* previous point was L type */

   I1 += delta;
  }
}


void GI_boarder_array_init(void)
{
 G_miny=INT_MAX;                            /* polygon starts here */
 G_maxy=INT_MIN;                            /* polygon ends here */

 G_start = (int *) memset((char *)G_start, 127, HW_SCREEN_Y_SIZE*sizeof(char*));
 G_end =(int *)  memset((char *)G_end, 0, HW_SCREEN_Y_SIZE*sizeof(char*));
}


void G_polygon(int nTri, Object *obj, Camera *cam, Light *lum)
{
 register unsigned char *l_adr,*adr,*end; 
 int i0, i1, i2;

 Tri *tri;
 double delta;
 double *IDebut, *IFin;
 double I, I0, I1, I2;


 tri = &(obj->TriList[nTri]);
 /* Initialisation du tableau */
 GI_boarder_array_init();                   /* initializing the arrays */


 /* Parcours des faces */
 i0 = tri->PtVertex[0];
 i1 = tri->PtVertex[1];
 i2 = tri->PtVertex[2];

 I0 = LumiereAmbiente(lum, obj) + LumiereDiffuse(lum, obj, nTri, &obj->Vertex[i0].N) + LumiereSpeculaire(lum, obj, cam, nTri, &obj->Vertex[i0].N);
 if (I0>255)
   I0 = 255;
 I1 = LumiereAmbiente(lum, obj) + LumiereDiffuse(lum, obj, nTri, &obj->Vertex[i1].N) + LumiereSpeculaire(lum, obj, cam, nTri, &obj->Vertex[i1].N);
 if (I1>255)
   I1 = 255;
 I2 = LumiereAmbiente(lum, obj) + LumiereDiffuse(lum, obj, nTri, &obj->Vertex[i2].N) + LumiereSpeculaire(lum, obj, cam, nTri, &obj->Vertex[i2].N);
 if (I2>255)
   I2 = 255;

 GI_scan(obj->Vertex[i0].ScreenVertex.x,
         obj->Vertex[i0].ScreenVertex.y,
         obj->Vertex[i1].ScreenVertex.x,
         obj->Vertex[i1].ScreenVertex.y, I0, I1); 

 GI_scan(obj->Vertex[i1].ScreenVertex.x,
         obj->Vertex[i1].ScreenVertex.y,
         obj->Vertex[i2].ScreenVertex.x,
         obj->Vertex[i2].ScreenVertex.y, I1, I2); 

 GI_scan(obj->Vertex[i2].ScreenVertex.x,
         obj->Vertex[i2].ScreenVertex.y,
         obj->Vertex[i0].ScreenVertex.x,
         obj->Vertex[i0].ScreenVertex.y, I2, I0); 


  /* nothing to do? */
 if(G_miny<=G_maxy)  {
  l_adr=G_buffer+G_miny*HW_SCREEN_X_SIZE;   /* addr of 1st byte of 1st line */

  IDebut = IntensiteDebut + G_miny;
  IFin = IntensiteFin + G_miny;

  /* rendering all lines */
  for(; G_miny<=G_maxy; G_miny++, l_adr+=HW_SCREEN_X_SIZE) {
    adr=l_adr+G_start[G_miny];         /* addr of the current line */
    end=l_adr+G_end[G_miny]+1;

    I = *IDebut;
    delta = (double)((*IFin)-I)/(end-adr);
    for(;adr<end;adr++) {
      *adr=(char)(I);
      I+=delta;
    }
    IDebut++;
    IFin++;    
  }
 }
}


void T_polygon(int nTri, Object *obj, Camera *cam, Light *lum)
{
 register unsigned char *l_adr,*adr,*end; 
 int i0, i1, i2;
 double alpha = 0.7;

 Tri *tri;
 double delta;
 double *IDebut, *IFin;
 double I, I0, I1, I2;


 tri = &(obj->TriList[nTri]);
 /* Initialisation du tableau */
 GI_boarder_array_init();                   /* initializing the arrays */


 /* Parcours des faces */
 i0 = tri->PtVertex[0];
 i1 = tri->PtVertex[1];
 i2 = tri->PtVertex[2];

 I0 = LumiereAmbiente(lum, obj) + LumiereDiffuse(lum, obj, nTri, &obj->Vertex[i0].N) + LumiereSpeculaire(lum, obj, cam, nTri, &obj->Vertex[i0].N);
 if (I0>255)
   I0 = 255;
 I1 = LumiereAmbiente(lum, obj) + LumiereDiffuse(lum, obj, nTri, &obj->Vertex[i1].N) + LumiereSpeculaire(lum, obj, cam, nTri, &obj->Vertex[i1].N);
 if (I1>255)
   I1 = 255;
 I2 = LumiereAmbiente(lum, obj) + LumiereDiffuse(lum, obj, nTri, &obj->Vertex[i2].N) + LumiereSpeculaire(lum, obj, cam, nTri, &obj->Vertex[i2].N);
 if (I2>255)
   I2 = 255;

 GI_scan(obj->Vertex[i0].ScreenVertex.x,
         obj->Vertex[i0].ScreenVertex.y,
         obj->Vertex[i1].ScreenVertex.x,
         obj->Vertex[i1].ScreenVertex.y, I0, I1); 

 GI_scan(obj->Vertex[i1].ScreenVertex.x,
         obj->Vertex[i1].ScreenVertex.y,
         obj->Vertex[i2].ScreenVertex.x,
         obj->Vertex[i2].ScreenVertex.y, I1, I2); 

 GI_scan(obj->Vertex[i2].ScreenVertex.x,
         obj->Vertex[i2].ScreenVertex.y,
         obj->Vertex[i0].ScreenVertex.x,
         obj->Vertex[i0].ScreenVertex.y, I2, I0); 


  /* nothing to do? */
 if(G_miny<=G_maxy)  {
  l_adr=G_buffer+G_miny*HW_SCREEN_X_SIZE;   /* addr of 1st byte of 1st line */

  IDebut = IntensiteDebut + G_miny;
  IFin = IntensiteFin + G_miny;

  /* rendering all lines */
  for(; G_miny<=G_maxy; G_miny++, l_adr+=HW_SCREEN_X_SIZE) {
    adr=l_adr+G_start[G_miny];         /* addr of the current line */
    end=l_adr+G_end[G_miny]+1;

    I = *IDebut;
    delta = (double)((*IFin)-I)/(end-adr);
    for(;adr<end;adr++) {
      *adr = (char)(alpha*(*adr)+(1-alpha)*I);
      I+=delta;
    }
    IDebut++;
    IFin++;    
  }
 }
}
