#include <math.h>
#include "matrix.h"
#include "object.h"
#include "virtualball.h"

#define MIN(a,b) (((a)<(b)) ? a : b)

COORD3D pixel2vector(Camera *cam, int x, int y)
{
  int d;
  COORD3D v;

  x -= cam->resX/2;
  y -= cam->resY/2;

  d=MIN(cam->resX/2, cam->resY/2);
  d=d*d-x*x-y*y;
  if(d>0)
    return v=(COORD3D){x,y,sqrt(d)};
  else
    return v=(COORD3D){x,y,0};
}

void TwoVectRotate(COORD3D *v1, COORD3D *v2, Matrix4 *R, Matrix4 *INV_R)
// renvoie la matrice de rotation autour de l'axe perpendiculaire a (v1,v2) et son inverse
{
  COORD3D u,v,w;
  Matrix4 Rot,M,INV_M,M_temp;
  double alpha,tmp;

  NormalizeVector3D(v1);
  NormalizeVector3D(v2);

  // On va prendre u=v1
  u=*v1;

  // w = v1^v2
  CrossProdPoint3D(v1,v2,&w);

  // On normalise w car v1 pas forcement orthogonal a v2
  NormalizeVector3D(&w);

  // v = w^u, et v est normalise car u et w orthogonaux
  CrossProdPoint3D(&w,&u,&v);

  // Calcul de l'angle de rotation
  alpha=acos(tmp=DotProdPoint3D(v1,v2));

  // construction de la matrice de rotation de alpha autour de z
  Rot.elem[0][0]=Rot.elem[1][1]=tmp;
  Rot.elem[0][1]=tmp=sin(alpha);
  Rot.elem[1][0]=-tmp;
  Rot.elem[2][2]=Rot.elem[3][3]=1;
  Rot.elem[2][0]=Rot.elem[3][0]=Rot.elem[2][1]=Rot.elem[3][1]=Rot.elem[3][2]=0;
  Rot.elem[0][2]=Rot.elem[1][2]=Rot.elem[0][3]=Rot.elem[1][3]=Rot.elem[2][3]=0;

  // construction de la matrice de changement de base (u,v,w)->(x,y,z)
  M.elem[0][0]=u.x; M.elem[0][1]=u.y; M.elem[0][2]=u.z; M.elem[0][3]=0;
  M.elem[1][0]=v.x; M.elem[1][1]=v.y; M.elem[1][2]=v.z; M.elem[1][3]=0;
  M.elem[2][0]=w.x; M.elem[2][1]=w.y; M.elem[2][2]=w.z; M.elem[2][3]=0;
  M.elem[3][0]=0;   M.elem[3][1]=0;   M.elem[3][2]=0;   M.elem[3][3]=1;

  // construction de la matrice de changement de base (x,y,z)->(u,v,w)
  GetTransposedMatrix(&M, &INV_M);

  // calcule la matrice de rotation finale a renvoyer
  MultiplyMatrix(&Rot,&M,&M_temp);
  MultiplyMatrix(&INV_M,&M_temp,R);

  // Rot(alpha) devient Rot(-alpha)
  Rot.elem[0][1]=-Rot.elem[0][1];
  Rot.elem[1][0]=-Rot.elem[0][1];

  // calcule l'inverse de la matrice finale de rotation
  MultiplyMatrix(&Rot, &M, &M_temp);
  MultiplyMatrix(&INV_M, &M_temp, INV_R);
}


void RotateObjectVB(Camera *cam, Object *obj, int x1, int y1, int x2, int y2)
{
  COORD3D v1,v2;
  Matrix4 R,INV_R;

  v1=pixel2vector(cam,x1,y1);
  v2=pixel2vector(cam,x2,y2);

  TwoVectRotate(&v1,&v2,&R,&INV_R);

  MultiplyMatrix(&R,&obj->LocalToGlobal,&obj->LocalToGlobal);
  MultiplyMatrix(&obj->GlobalToLocal,&INV_R,&obj->GlobalToLocal);
}
