#ifndef OBJECT_H
#define OBJECT_H

#include <stdio.h>
#include "matrix.h"
#include "color.h"

#define  DIRECTIONAL       0
#define  SPOT_LIGHT        1
#define  CONE_LIGHT        2
#define  ATTENUATED_LIGHT  3

typedef struct
{
  short x, y; /* pixels ! */
} PIXEL;

typedef struct VertexStruct
{
  COORD3D ObjectVertex;    /* sommet dans le repere objet */
  COORD3D CameraVertex;    /* sommet dans le repere camera */
  PIXEL ScreenVertex;      /* sommet dans le repere ecran/X11 */
  COORD3D N;               /* normale en ce sommet */
  Color color;             /* Couleur en ce sommet */
  double I;                /* Intensite en ce sommet */
} VERTEX;

typedef struct QuadStruct
{
  int PtVertex[4];   /* 4 indices de sommets dans le tableau des VERTEX de la BBox */
  COORD3D N;         /* normale en cette face, servira plus tard pour dessiner la BBox */
} Quad;

typedef struct BBoxStruct
{
  VERTEX Vertex[8];   // 8 sommets
  Quad QuadList[6];   // 6 faces rectangulaires
  double hauteur, largeur, profondeur;
  double plus_grand_cote_sur_2;
} BBox;

typedef struct TriStruct
{
  int PtVertex[3];
  COORD3D N;         /* normale en cette face */
} Tri;

typedef struct
{
  Color color; // Couleur de l'objet
  double Ka;   // Coeff de reflexion de la lumiere ambiante (entre 0 et 1)
  double Kd;   // Coeff de diffusion de la lumiere diffuse (entre 0 et 1)
  double Ks;   // Coeff de diffusion de la lumiere speculaire (entre 0 et 1)
  int m;       // Coeff de directivite des reflet
} SURFACE_ATTRIBUTES;

typedef struct ObjectStruct
{
  /* position of the object in 3D space */
  Matrix4 LocalToGlobal;
  Matrix4 GlobalToLocal;
  Matrix4 LocalToCamera;
  BBox boundingBox;
  /* list of vertices as a table of 3D points */
  int NbVertices;           /* Nombre de sommets */
  VERTEX *Vertex;           /* Liste des sommets */
  /* List of triangular faces, a tab of index to vertices */
  int NbTri;
  Tri *TriList;
  /* Caracteristiques de diffusion/reflexion de la lumiere */
  SURFACE_ATTRIBUTES material;
  double TailleBBox;        /*taille de la bounding box */
} Object;


typedef struct LightStruct
{
  Matrix4 LocalToGlobal;
  Matrix4 GlobalToLocal;
  Matrix4 LocalToCamera;
  int     Type;        /* type de la source lumieuse */
  double  angle;       /* sert pour la cone_light angle d ouverture */
  double  intensite;   /* intensite de la lumiere comprise entre 0 et 1 */
  int     puissance;   /* puissance d'attenuation des lumieres ponctuelles */
  double  attenuation;
  Color   color;
} Light;


typedef struct CameraStruct
{
  Matrix4 LocalToGlobal;
  Matrix4 GlobalToLocal;
  double fovX, fovY; /* Field of view in x, y (degrees), in camera coordinate system */
  int resX, resY;    /* Screen resolution, in screen coordinate system (the one used by X11) */
  double sx, sy;     /* used for the camera -> screen transformation */
  double tx, ty;
  int render_mode;
  int use_pixmap;
  char *image;
  double *zbuffer;
} Camera;


/* Fonctions exportees du module object.c */

extern void ReadObject(char *filename, Object *obj);
extern void ReadCamera(char *filename, Camera *obj);
extern void UpdateLocalToCamera(Object *obj, Camera *cam);
extern void TranslateObject(Object *obj, double tx, double ty, double tz);
extern void RotateObject(Object *obj, double rx, double ry, double rz);
extern void TranslateCamera(Camera *obj, double tx, double ty, double tz);
extern void RotateCamera(Camera *obj, double rx, double ry, double rz);
extern void PlaceCamera(Camera *cam, Object *obj);
extern void PlaceLight(Light *lumiere, Object *obj, Camera *cam);
extern void ReadLight(char *filename, Light *Lumiere);
extern void TranslateLight(Light *lumiere, double tx, double ty, double tz);
extern void DirigeLight(Light *lumiere, Object *obj);
extern void FillTrg(GC *gc, double *ZBuffer, Object *obj, Camera *cam, VERTEX *P1,
                VERTEX *P2, VERTEX *P3);
extern void precalculeNormales(Object *obj);

#endif
