#ifndef MATRIX_H
#define MATRIX_H

//#define M_PI 3.141592654

typedef struct Matrix4Struct
{
  double elem[4][4];
} Matrix4;

typedef  struct
{
  double  x, y, z;
} COORD3D;


/* Fonctions exportables par le module matrix.c */

extern void MultiplyMatrix(Matrix4 *a, Matrix4 *b, Matrix4 *c);
extern void CopyMatrix(Matrix4 *Mdest, Matrix4 *Msource);
extern void SetMatrixToIdentity(Matrix4 *M);
extern void GetTransposedMatrix(Matrix4 *M, Matrix4 *Mtransposed);

extern void GetTranslationMatrix(double tx, double ty, double tz, 
				    Matrix4 *M, Matrix4 *M_INV);
extern void GetRotationMatrixX(double theta, Matrix4 *M, Matrix4 *M_INV);
extern void GetRotationMatrixY(double theta, Matrix4 *M, Matrix4 *M_INV);
extern void GetRotationMatrixZ(double theta, Matrix4 *M, Matrix4 *M_INV);
extern void GetRotationMatrixXYZ(double thetax, double thetay, double thetaz, 
				 Matrix4 *M, Matrix4 *M_INV);

extern void DiffPoint3D(COORD3D *u, COORD3D *v, COORD3D *res);
extern void AddPoint3D(COORD3D *u, COORD3D *v, COORD3D *res);
extern void CrossProdPoint3D(COORD3D *u, COORD3D *v, COORD3D *w);
extern double DotProdPoint3D(COORD3D *u, COORD3D *v);
extern double NormePoint3D(COORD3D *p);
extern void NormalizeVector3D(COORD3D *u);

extern void TransformPoint(COORD3D *ptold, Matrix4 *M, COORD3D *ptnew);
extern void TransformVector(COORD3D *vold, Matrix4 *M, COORD3D *vnew);

#endif
