#include <stdio.h>
#include <math.h>
#include "line_command_options.h"
#include "object.h"
#include "graphics.h"
#include "param.h"
#include "light.h"


Object obj;          /* Les trois objets que l'on manipule : un objet, la 
			camera et la lumiere */
Camera cam;

Light light;

char *texture;

GlobalParams params; /* Contiennent les parametres generaux de l'application
			mode de visu : file de fer, shading, faces cachees, 
			etc.... */

/* Forward declarations */
static void init_parameters(void);
static void read_obj_and_cam(char *obj_filename, char *cam_filename, char *light_filename);

/*-------------------------------*/
void main(int argc, char *argv[])
/*-------------------------------*/
{
  FILE *f;
  char obj_filename[256], cam_filename[256], light_filename[256];

  /* Charge la texture */
  texture=(char *)malloc(256*256);
  if((f=fopen("EnvLogo.cnk","r+b"))!=NULL)
  {
    fread(texture,1,256*256,f);
    fclose(f);
  }

  /* Initialise les parametres genraux par defaut */
  init_parameters();

  /* Lecture des options sur la ligne de commande */
  init_line_command_options(argc, argv);

  if(get_parameter("obj", "%s", obj_filename)) 
    fprintf(stderr,"Using %s object file\n",obj_filename);
  else
    print_usage(argv);

  if(get_parameter("cam", "%s", cam_filename)) 
    fprintf(stderr,"Using %s camera filename\n",cam_filename);
  else
    sprintf(cam_filename,"%s","cam_default.obj");

  if(get_parameter("light", "%s", obj_filename))
    fprintf(stderr,"Using %s light filename\n",light_filename);
  else
    sprintf(light_filename,"light_default.obj");

  if(get_opt("bw")) 
    params.color_mode = BLACK_AND_WHITE_MODE;
  else
    params.color_mode = COLOR_MODE;

  /* Lecture de l'objet et de la camera sur disque */
  read_obj_and_cam(obj_filename, cam_filename, light_filename);

  /* Ouverture de la fenetre graphique et affichage de l'objet */
  init_graphics(cam.resX, cam.resY);
}

/*-------------------------------*/
static void init_parameters(void)
/*-------------------------------*/
{
  params.render_mode = WIREFRAME;
  params.display_vertex_index = 0;
  params.color_mode = COLOR_MODE;
  params.palette_mode = GREY;
}

/*---------------------------------------------------------------------------*/
static void read_obj_and_cam(char *obj_filename, char *cam_filename, char *light_filename)
/*---------------------------------------------------------------------------*/
{
  // Lecture de l'objet sur disque
  ReadObject(obj_filename, &obj);

  // lecture de la camera
  ReadCamera(cam_filename, &cam);

  // lecture de la lumiere
  ReadLight(light_filename, &light);

  PlaceCamera(&cam,&obj);

  PlaceLumiere(&cam,&light);

  /* Calculer cube.LocalToCamera. cette matrice sert a faire passer les 
     points de l'objet (exprimes dans le repere objet) dans le repere de la 
     camera */
  UpdateLocalToCamera(&obj, &cam);
}
