#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "line_command_options.h"

static int argc;
static char **argv;
int xargc;
char **xargv;

/* Forward declarations */
static void panic(char *c);

/*----------------------*/
int get_opt(char *text)
/*----------------------*/
/* retourne 1 si text figure dans les options, 0 sinon */
{
  int i;
    
  for(i=1; i<argc; ++i)
    if(*argv[i]=='-' && !strcmp(argv[i]+1,text)) return 1;

  return (0);
}

/*------------------------------------------------------*/
int get_parameter(char *text, char *format, char *var)
/*------------------------------------------------------*/
/* retourne 1 si text figure dans les options, 0 sinon. Alors,
   remplit var au format adequat */
{
  int i,j,np;
  char *c;
  char buf[1000];
    
  for(i=1; i<argc-1; i++)
    if(*argv[i]=='-' && !strcmp(argv[i]+1,text))
    {
      /* On concatene les argv qui restent pour lire dans une seule chaine */
      buf[0]='\0';
      for(j=i+1; j<argc; j++)
      {
        strcat(buf,argv[j]);
        strcat(buf," ");
      }
      /* On compte les % dans la chaine format */
      np=0;
      for(c=format; *c!='\0'; c++)
        if(*c=='%')
          np++;
      /* Pour l'instant c'est ainsi... varargs plus tard */
      if(np!=1)
        panic("Format d'option trop complexe");

      /* On peut scanner maintenant */
      if(sscanf(buf,format,var)==np)
        return i;
      else
      {
        fprintf(stderr,"Parametre %s: mauvais format",argv[i]+1);
        print_usage (xargv);
      }
    }
  return 0;
}

/*---------------------*/
int get_posopt(char *text)
/*---------------------*/
/* retourne la position de text dans les options, sinon retourne -1 */
{
  int i;
    
  for(i=1; i<argc-1; i++)
    if(*argv[i]=='-' && !strcmp(argv[i]+1,text))
      return i;

  return -1;
}

/*--------------------------*/
void print_usage(char **av)
/*--------------------------*/
{
  printf("Usage: %s -obj <file.obj> [-cam <file.obj>] [-light <file.obj>] [-bw] \n",av[0]);
  exit(0);
}


/*------------------------------------------------*/
void init_line_command_options(int ac, char **av)
/*------------------------------------------------*/
/* effectue avant tout le reste, s'occupe du manuel et des initialisations */
{
  argc=ac, argv=av;
  xargc=ac, xargv=av;

  if(get_opt("?") || get_opt("h") || get_opt("help")) print_usage(av);
  //(void)srand(getpid());
}

/*-----------------------*/
static void panic(char *c)
/*-----------------------*/
{
  fprintf(stderr,"%s\n",c);
  exit(-1);
}
