#include "matrix.h"
#include <math.h>
#include "object.h"
#include "light.h"
#include "virtualball.h"

void PlaceLumiere(Camera *cam, Light *light)
{
  int i,j;

  for(i=0; i<4; i++)
    for(j=0; j<4; j++)
    {
      light->LocalToGlobal.elem[i][j]=cam->LocalToGlobal.elem[i][j];
      light->GlobalToLocal.elem[i][j]=cam->GlobalToLocal.elem[i][j];
    }
  MultiplyMatrix(&cam->GlobalToLocal,&light->LocalToGlobal,&light->LocalToCamera);
}

double IntensityFace(Object *obj, Light *light, Camera *cam, Tri *T)
{
  SURFACE_ATTRIBUTES *Attr=&obj->material;
  COORD3D N,L;
  double facecolor,scal,finalcolor;
  double Ca,Cd,Cs;
  int i;

  // couleur de l'objet
  facecolor=1.0;

  // Coeff. lumiere ambiante
  Ca=facecolor*0.5;

  // recupere la normale a la face dans le repere camera
  TransformVector(&T->N,&obj->LocalToCamera,&N);
  NormalizeVector3D(&N);

  // calcule le vecteur lumiere qui va sur cette face
  i=T->PtVertex[0];
  L.x = light->LocalToCamera.elem[0][3] - obj->Vertex[i].CameraVertex.x;
  L.y = light->LocalToCamera.elem[1][3] - obj->Vertex[i].CameraVertex.y;
  L.z = light->LocalToCamera.elem[2][3] - obj->Vertex[i].CameraVertex.z;
  NormalizeVector3D(&L);

  // Coeff. lumiere diffusee
  scal=N.x*L.x + N.y*L.y + N.z*L.z;
  if(scal<=0) return Attr->Ka*Ca;
  Cd=facecolor*light->intensite*scal;

  // on veut N=(2N(N.L)-L)
  N.x = 2*scal*N.x - L.x;
  N.y = 2*scal*N.y - L.y;
  N.z = 2*scal*N.z - L.z;
  NormalizeVector3D(&N);

  // calcul du vecteur observateur-face
  L.x = - obj->Vertex[i].CameraVertex.x ;
  L.y = - obj->Vertex[i].CameraVertex.y;
  L.z = - obj->Vertex[i].CameraVertex.z;
  NormalizeVector3D(&L);

  // scal=r.s
  scal = N.x*L.x + N.y*L.y + N.z*L.z;

  if(scal<=0) return Attr->Ka*Ca+Attr->Kd*Cd;
  Cs=facecolor*light->intensite*pow(scal,obj->material.m);
  if((finalcolor=Attr->Ka*Ca+Attr->Kd*Cd+Attr->Ks*Cs) > 1.0)
    return 1.0;
  else
    return finalcolor;
}


double IntensityPoint(Object *obj, Light *light, Camera *cam, VERTEX *V)
{
  SURFACE_ATTRIBUTES *Attr=&obj->material;
  COORD3D N,L;
  double facecolor,scal,finalcolor;
  double Ca,Cd,Cs;

  // couleur de l'objet
  facecolor=1.0;

  // Coeff. lumiere ambiante
  Ca=facecolor*0.5;

  // recupere la normale au point dans le repere camera
  TransformVector(&V->N,&obj->LocalToCamera,&N);
  NormalizeVector3D(&N);

  // calcule le vecteur lumiere qui va sur ce point
  L.x = light->LocalToCamera.elem[0][3] - V->CameraVertex.x;
  L.y = light->LocalToCamera.elem[1][3] - V->CameraVertex.y;
  L.z = light->LocalToCamera.elem[2][3] - V->CameraVertex.z;
  NormalizeVector3D(&L);

  // Coeff. lumiere diffusee
  scal=N.x*L.x + N.y*L.y + N.z*L.z;
  if(scal<=0) return Attr->Ka*Ca;
  Cd=facecolor*light->intensite*scal;

  // on veut N=(2N(N.L)-L)
  N.x = 2*scal*N.x - L.x;
  N.y = 2*scal*N.y - L.y;
  N.z = 2*scal*N.z - L.z;
  NormalizeVector3D(&N);

  // calcul du vecteur observateur-face
  L.x = -V->CameraVertex.x ;
  L.y = -V->CameraVertex.y;
  L.z = -V->CameraVertex.z;
  NormalizeVector3D(&L);

  // scal=r.s
  scal = N.x*L.x + N.y*L.y + N.z*L.z;

  if(scal<=0) return Attr->Ka*Ca+Attr->Kd*Cd;
  Cs=facecolor*light->intensite*pow(scal,obj->material.m);
  if((finalcolor=Attr->Ka*Ca+Attr->Kd*Cd+Attr->Ks*Cs) > 1.0)
    return 1.0;
  else
    return finalcolor;
}


Color RGBIntensityPoint(Object *obj, Light *light, Camera *cam, VERTEX *V)
{
  SURFACE_ATTRIBUTES *Attr=&obj->material;
  COORD3D N,L;
  double tmp,scal;
  ColorDouble Ca,Cd,Cs,facecolor;
  Color finalcolor;

  // couleur de l'objet
  facecolor.r=obj->material.color.r/255.0;
  facecolor.g=obj->material.color.g/255.0;
  facecolor.b=obj->material.color.b/255.0;;

  // Coeff. lumiere ambiante
  Ca.r=facecolor.r*0.5;
  Ca.g=facecolor.g*0.5;
  Ca.b=facecolor.b*0.5;

  // recupere la normale au point dans le repere camera
  TransformVector(&V->N,&obj->LocalToCamera,&N);
  NormalizeVector3D(&N);

  // calcule le vecteur lumiere qui va sur ce point
  L.x = light->LocalToCamera.elem[0][3] - V->CameraVertex.x;
  L.y = light->LocalToCamera.elem[1][3] - V->CameraVertex.y;
  L.z = light->LocalToCamera.elem[2][3] - V->CameraVertex.z;
  NormalizeVector3D(&L);

  // Coeff. lumiere diffusee
  scal=N.x*L.x + N.y*L.y + N.z*L.z;
  if(scal<=0) return (Color){(int)(240*Attr->Ka*Ca.r),(int)(240*Attr->Ka*Ca.g),(int)(240*Attr->Ka*Ca.b)};
  Cd.r=facecolor.r*light->intensite*scal;
  Cd.g=facecolor.g*light->intensite*scal;
  Cd.b=facecolor.b*light->intensite*scal;

  // on veut N=(2N(N.L)-L)
  N.x = 2*scal*N.x - L.x;
  N.y = 2*scal*N.y - L.y;
  N.z = 2*scal*N.z - L.z;
  NormalizeVector3D(&N);

  // calcul du vecteur observateur-face
  L.x = -V->CameraVertex.x ;
  L.y = -V->CameraVertex.y;
  L.z = -V->CameraVertex.z;
  NormalizeVector3D(&L);

  // scal=r.s
  scal = N.x*L.x + N.y*L.y + N.z*L.z;

  if(scal<=0) return (Color){(int)(240*(Attr->Ka*Ca.r+Attr->Kd*Cd.r)),(int)(240*(Attr->Ka*Ca.g+Attr->Kd*Cd.g)),(int)(240*(Attr->Ka*Ca.b+Attr->Kd*Cd.b))};
  tmp=light->intensite*pow(scal,obj->material.m);
  Cs.r=facecolor.r*tmp;
  Cs.g=facecolor.g*tmp;
  Cs.b=facecolor.b*tmp;
  finalcolor=(Color){(int)(240*(Attr->Ka*Ca.r+Attr->Kd*Cd.r+Attr->Ks*Cs.r)),
		     (int)(240*(Attr->Ka*Ca.g+Attr->Kd*Cd.g+Attr->Ks*Cs.g)),
		     (int)(240*(Attr->Ka*Ca.b+Attr->Kd*Cd.b+Attr->Ks*Cs.b))};
  if(finalcolor.r>240 || finalcolor.g>240 || finalcolor.b>240)
    return (Color){240,240,240};
  else
    return finalcolor;
}


void TranslateLight(Light *light, double tx, double ty, double tz)
{
  Matrix4 T,T_inv;

  GetTranslationMatrix(tx,ty,tz,&T,&T_inv);
  MultiplyMatrix(&T,&light->LocalToGlobal,&light->LocalToGlobal);
  MultiplyMatrix(&light->GlobalToLocal,&T_inv,&light->GlobalToLocal);
}


void RotateLight(Light *light, double rx, double ry, double rz)
{
  Matrix4 m,mi;
int i,j;
  GetRotationMatrixXYZ(rx,ry,rz,&m,&mi);
printf("\nAvant:\n");
for(i=0; i<4; i++)
{
  for(j=0; j<4; j++)
    printf("%f  ",light->LocalToGlobal.elem[j][i]);
  printf("\n");
}
  MultiplyMatrix(&m,&light->LocalToGlobal,&light->LocalToGlobal);
printf("\n\nApres:\n");
for(i=0; i<4; i++)
{
  for(j=0; j<4; j++)
    printf("%f  ",light->LocalToGlobal.elem[j][i]);
  printf("\n");
}
  MultiplyMatrix(&light->GlobalToLocal,&mi,&light->GlobalToLocal);
}

void LightUpdateLocalToCamera(Light *light, Camera *cam)
{
  MultiplyMatrix(&cam->GlobalToLocal,&light->LocalToGlobal,&light->LocalToCamera);
}


void RotateLightVB(Camera *cam, Light *light, int x1, int y1, int x2, int y2)
{
  COORD3D v1,v2;
  Matrix4 R,INV_R;

  v1=pixel2vector(cam,x1,y1);
  v2=pixel2vector(cam,x2,y2);

  TwoVectRotate(&v1,&v2,&R,&INV_R);
  MultiplyMatrix(&R,&light->LocalToGlobal,&light->LocalToGlobal);
  MultiplyMatrix(&light->GlobalToLocal,&INV_R,&light->GlobalToLocal);
}
