#ifndef COLOR_H
#define COLOR_H
#include <X11/Xlib.h>

/* Permet de transformer une couleur 24 bits (r, g, b) en un index dans la 
   table de couleur approximee parmi 256, cree par Lut_16M */

#define RGBTOONE(r,g,b) (((r) & 224) + (((g) & 224)>>3) + (((b) & 192)>>6))

typedef struct
{
   unsigned char r, g, b;
}   Color;

typedef struct
{
   double r, g, b;
}   ColorDouble;

/* Fonctions exportees par le module color.c */
extern unsigned char CouleurTramee(long x, long y, unsigned char R, unsigned char G, 
		      unsigned char B);
extern void Lut_GreyLevels(Display *dpy, Colormap cmap);
extern void Lut_16M(Display *dpy, Colormap cmap);
extern void Lut_Random_Color(Display *dpy, Colormap cmap);
extern void Lut_Smooth_Color(Display *dpy, Colormap cmap);
extern void Lut_Random_Gray(Display *dpy, Colormap cmap);
extern void Shift_L_Palette(Display *dpy, Colormap cmap, int NbColors);
extern void Shift_R_Palette(Display *dpy, Colormap cmap, int NbColors);
extern void Show_Palette(Display *dpy, Colormap cmap, int NbColors);
extern void SetEnvPalette(Display *dpy, Colormap cmap);


#endif
