#include <X11/Xlib.h>

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "color.h"

/* Forward declarations */
static void SetRGB_CMap(Display *dpy, Colormap cmap, int n, 
			int r, int g, int b);


unsigned char CouleurTramee(long x, long y, unsigned char R, unsigned char G, 
		      unsigned char B)
/* Renvoie l'index dans une colormap preparee de la couleur 24 bits du pixel 
   a la position x, y */
{
    static unsigned char D8[8][8] =
    {
	{0, 32, 8, 40, 2, 34, 10, 42},
	{48, 16, 56, 24, 50, 18, 58, 26},
	{12, 44, 4, 36, 14, 46, 6, 38},
	{60, 28, 52, 20, 62, 30, 54, 22},
	{3, 35, 11, 43, 1, 33, 9, 41},
	{51, 19, 59, 27, 49, 17, 57, 25},
	{15, 47, 7, 39, 13, 45, 5, 37},
	{63, 31, 55, 23, 61, 29, 53, 21}
    };   



    static unsigned char D4[4][4] =
    {
	{0, 8, 2, 10},
	{12, 4, 14, 6},
	{3, 11, 1, 9},
	{15, 7, 13, 5}
    };   



    short d4tmp = D4[x & 3][y & 3];
    short r, v, b, modr, modv, modb;

    r = R >> 1;
    v = G >> 1;
    b = B;

    modr = r & 15;
    modv = v & 15;
    modb = b & 63;

    r >>= 4;
    v >>= 4;
    b >>= 6;

    if ((modr >= d4tmp) && (r != 7))
	r++;
    if ((modv >= d4tmp) && (v != 7))
	v++;
    if ((modb >= D8[x & 7][y & 7]) && (b != 3))
	b++;
    return ((unsigned char) ((r << 5) + (v << 2) + b));
}

/*------------------------------------------------------------------------*/
static void SetRGB_CMap(Display *dpy, Colormap cmap, int n, 
			int r, int g, int b)
/*------------------------------------------------------------------------*/
/* Initialise la n-ieme couleur de la colormap avec la couleur definie par 
   (r, g, b) */
{
  XColor Col;

  Col.pixel = (unsigned long)n;
  Col.red = (unsigned short)r << 8 ;     /* car sous X11, les valeurs red, 
					    green, blue sont codees entre 0 et
					    64000, non pas entre 0 et 255 */
  Col.green = (unsigned short)g << 8 ;
  Col.blue = (unsigned short)b << 8 ;
  Col.flags = DoRed | DoGreen | DoBlue;

  XStoreColor(dpy, cmap, &Col);
}

/*-----------------------------------------------*/
void Lut_GreyLevels(Display *dpy, Colormap cmap)
/*-----------------------------------------------*/
{
  long i;

  /* pour nous, noir = (0, 0, 0), blanc = (255, 255, 255) */
  for (i=0; i < 256; i++)
    SetRGB_CMap(dpy, cmap, i, i, i, i);
}

/*---------------------------------------*/
void Lut_16M(Display *dpy, Colormap cmap)
/*---------------------------------------*/
{
  long r,g,b,a=0;

  for (r=0;r<8;r++)
    for (g=0;g<8;g++)
      for (b=0;b<4;b++)
	SetRGB_CMap(dpy, cmap ,a++ , r<<5, g<<5, b<<6);
}


/*------------------------------------------------*/
void Lut_Random_Color(Display *dpy, Colormap cmap)
/*------------------------------------------------*/
{
  long i;

  srand(time(NULL));

  for (i=0;i<256;i++) 
    SetRGB_CMap(dpy, cmap, i, rand()%256, rand()%256, rand()%256);
}

/*------------------------------------------------*/
void Lut_Smooth_Color(Display *dpy, Colormap cmap)
/*------------------------------------------------*/
{
  long i;

  for (i=0;i<64;i++) {
      SetRGB_CMap(dpy, cmap, i,     i<<2, 0,    i<<2);
      SetRGB_CMap(dpy, cmap, i+64,  0,    i<<2, i<<2);
      SetRGB_CMap(dpy, cmap, i+128, i<<2, i<<2, 0);
      SetRGB_CMap(dpy, cmap, i+192, i<<2, i<<2, i<<2);
  }
}

/*------------------------------------------------*/
void Lut_Random_Gray(Display *dpy, Colormap cmap)
/*------------------------------------------------*/
{
  long i,a;

  printf("\nMise en Place de la Lut de simulations random grise\n");
  srand(time(NULL));

  for (i=0;i<256;i++) {
    a=rand()%256;
    SetRGB_CMap(dpy, cmap, i, a, a, a);
    }
}

/*-------------------------------------------------------------*/
void Shift_L_Palette(Display *dpy, Colormap cmap, int NbColors)
/*-------------------------------------------------------------*/
{
  long i;
  XColor TCol[257];
	
  for (i=0; i < NbColors+1; i++) {
    TCol[i].pixel = (unsigned long)i;
    TCol[i].flags = DoRed | DoGreen | DoBlue;
  }

  XQueryColors(dpy, cmap, TCol, 256);
	
  TCol[256]=TCol[0];
	
  for (i=0; i < NbColors+1; i++) 
    (TCol+1)[i].pixel = (unsigned long) i;
  	
  XStoreColors(dpy, cmap, TCol+1, 256);
}

/*--------------------------------------------------------------*/
void Shift_R_Palette(Display *dpy, Colormap cmap, int NbColors)
/*--------------------------------------------------------------*/
{
  long i;
  XColor TCol[257];
	
  for (i=0; i<NbColors+1; i++) {
    TCol[i].pixel = (unsigned long)i;
    TCol[i].flags = DoRed | DoGreen | DoBlue;
  }

  XQueryColors(dpy, cmap, TCol+1, 256);
	
  TCol[0]=TCol[256];

  for (i=0; i<NbColors+1; i++) 
    TCol[i].pixel = (unsigned long) i;

  XStoreColors(dpy, cmap, TCol,256);
}

/*----------------------------------------------------------*/
void Show_Palette(Display *dpy, Colormap cmap, int NbColors)
/*----------------------------------------------------------*/
{
  int i;
  XColor Col;
       	
  Col.flags = DoRed | DoGreen | DoBlue;

  for (i=0; i<NbColors; i++) {
      Col.pixel=i;
      XQueryColor(dpy, cmap, &Col);
      printf("Couleur %d Valeur:r %d g %d b %d\n", i, 
	     Col.red>>8, Col.green>>8, Col.blue>>8);
    }
}


/*---------------------------------------------*/
void SetEnvPalette(Display *dpy, Colormap cmap)
/*---------------------------------------------*/
{
  FILE *f;
  int i;
  long r,g,b;

  if((f=fopen("EnvLogo.pal","r+b"))==NULL) return;

  for(i=0; i<256; i++)
  {
    fgetc(f);
    r=fgetc(f);
    g=fgetc(f);
    b=fgetc(f);
    SetRGB_CMap(dpy,cmap,i,r,g,b);
  }
}
