#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>       
#include <GL/glut.h>
#include "character.h"

/**************************************************
 *            Creation du personnage              *
 **************************************************/

void makeCharacter(int renderball,int renderbear, int slice, int stack)
{

	if(renderball) {
		
		// Ball1
		glNewList(BALL1, GL_COMPILE);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, ball1Color);
		glPushMatrix();
		glutSolidSphere(0.7,slice, stack); 
		glPopMatrix();
		glEndList();

		// Ball2
		glNewList(BALL2, GL_COMPILE);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, ball2Color);
		glPushMatrix();
		glutSolidSphere(0.7,slice, stack); 
		glPopMatrix();
		glEndList();

		// Ball3
		glNewList(BALL3, GL_COMPILE);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, ball3Color);
		glPushMatrix();
		glutSolidSphere(0.7,slice, stack); 
		glPopMatrix();
		glEndList();
	}

	if (renderbear) {

		// BODY                     // 4.9 en y
		glNewList(BODY,GL_COMPILE);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, bodyColor);
		glPushMatrix();

		glTranslatef(0.0,2.8+2.0,0.0);                   // corps a 2.0 du sol

		// sup
		glPushMatrix();
		glTranslatef(0.0,3.2,0.0);
		glScalef(0.9,1.0,0.9);
		glutSolidSphere(2.5,slice, stack); // 2.5 en y
		glPopMatrix();
		// long devant
		glMaterialfv(GL_FRONT, GL_DIFFUSE, bellyColor);
		glPushMatrix();
		glTranslatef(0.0,1.5,-0.7);
		glScalef(1.0,1.8,1.0);
		glutSolidSphere(2.0,slice, stack); // 2.5 en y
		glPopMatrix();
		// long derriere
		glMaterialfv(GL_FRONT, GL_DIFFUSE, bodyColor);
		glPushMatrix();
		glTranslatef(0.0,1.5,0.7);
		glScalef(1.0,1.8,1.0);
		glutSolidSphere(2.0,slice, stack); // 2.5 en y
		glPopMatrix();

		glPopMatrix();
		glEndList();

		glNewList(BUTTOCK,GL_COMPILE);
		glPushMatrix();

		glTranslatef(0.0,2.8+2.0,0.0); 

		glPushMatrix();
		glScalef(1.0,0.8,1.0);
		glutSolidSphere(3.0,slice, stack); // 2.4 en y
		glPopMatrix();

		glPopMatrix();
		glEndList();

		// NOMBRILE                    
		glNewList(NOMBRIL,GL_COMPILE);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, bodyColor);
		glPushMatrix();

		glTranslatef(0.0,2.8+2.0,0.0);                   // corps a 2.0 du sol

		glPushMatrix();
		glTranslatef(0.0,1.5,-2.7);
		glutSolidTorus(0.1,0.2,slice, stack);
		glPopMatrix();

		glPopMatrix();
		glEndList();


         // FINGER
		glNewList(FINGER,GL_COMPILE);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, fingerColor);
        glPushMatrix();
        glScalef(1.0,1.5,1.0);
        glutSolidSphere(0.1,slice, stack); 
        glPopMatrix();
        glEndList();

		// HAND
        glNewList(HAND,GL_COMPILE);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, handColor);
        glPushMatrix();
        glScalef(1.0,1.0,0.4);
        glutSolidSphere(0.72,slice, stack); // paume
        glPopMatrix();

        glPushMatrix();
        glRotatef(-35,0.0,0.0,1.0);
        glTranslatef(0.0,-0.7,0.0);
        glCallList(FINGER); // doigt 1
        glPopMatrix();

        glPushMatrix();
        glTranslatef(0.0,-0.7,0.0); 
        glCallList(FINGER);  // doigt 2
        glPopMatrix();

        glPushMatrix();
        glRotatef(35,0.0,0.0,1.0);
        glTranslatef(0.0,-0.7,0.0); 
        glCallList(FINGER);  // doigt 3
        glPopMatrix();

        glPushMatrix();
        glRotatef(90,0.0,0.0,1.0);
        glTranslatef(0.0,-0.7,0.0); 
        glCallList(FINGER);  // doigt 4
        glPopMatrix();
        glEndList();

		// HAND_RIGHT
        glNewList(HAND_RIGHT,GL_COMPILE);
        glPushMatrix();
		glTranslatef(4.0,5.0,0.0);
		glRotatef(45+20,0.0,1.0,0.0);
		glRotatef(30,0.0,0.0,1.0);
        glCallList(HAND);  // main standard
        glPopMatrix();
        glEndList();
        
		// HAND_LEFT
        glNewList(HAND_LEFT,GL_COMPILE);
        glPushMatrix();
		glTranslatef(-4.0,5.0,0.0);
		glRotatef(180-45-20,0.0,1.0,0.0);
		glRotatef(30,0.0,0.0,1.0);
        glCallList(HAND);  // main standard
        glPopMatrix();
        glEndList();

		// HEAD
        glNewList(HEAD,GL_COMPILE);
        glPushMatrix();
		glRotatef(-20,1.0,0.0,0.0);

		glMaterialfv(GL_FRONT, GL_DIFFUSE, headColor);
		glPushMatrix();                 // Partie inferieure de la tete
        glScalef(1.0,0.7,1.0); 
        glutSolidSphere(2.0,slice, stack);     // 1.4 en y
        glPopMatrix();
  
        glPushMatrix();                 // Dessus de la tete
		glTranslatef(0.0,1.0,0.6);
        glScalef(1.0,1.0,0.7);
        glutSolidSphere(1.7,slice, stack);     // 2.7 en y
        glPopMatrix();
        
		glMaterialfv(GL_FRONT, GL_DIFFUSE, eyeColor);
		glPushMatrix();                 // oeil droit
		glTranslatef(0.8,1.7,-0.3);
        glScalef(1.0,1.0,0.2);
        glutSolidSphere(0.4,slice, stack); 
		glPopMatrix();

		glPushMatrix();                 // oeil gauche
		glTranslatef(-0.8,1.7,-0.3);
        glScalef(1.0,1.0,0.2);
        glutSolidSphere(0.4,slice, stack); 
		glPopMatrix();

        glPushMatrix();                 // Nez et truffe    
		glTranslatef(0.0,1.0,-1.0);
        glScalef(1.0,0.7,1.0);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, noseColor);
        glutSolidSphere(1.0,slice, stack); 
        glTranslatef(0.0,1.0,-0.4);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, truffleColor);
        glutSolidSphere(0.2,slice, stack); 
		glPopMatrix();
               
		glMaterialfv(GL_FRONT, GL_DIFFUSE, earColor);
        glPushMatrix();                 // Oreille droite
		glTranslatef(1.0,2.5,1.0);
		glScalef(1.0,1.0,0.4);
		glutSolidSphere(0.8,slice, stack); 
		glPopMatrix();

        glPushMatrix();                 // Oreille gauche
		glTranslatef(-1.0,2.5,1.0);
		glScalef(1.0,1.0,0.4);
		glutSolidSphere(0.8,slice, stack); 
		glPopMatrix();

		glPopMatrix();
        glEndList();


		// LEG
        glNewList(LEG,GL_COMPILE);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, bodyColor);
        glPushMatrix();
		glScalef(0.2,0.7,0.2);
		glutSolidSphere(3.0,slice, stack); 
        glPopMatrix();
        glEndList();

		// FOREARM_RIGHT
        glNewList(FOREARM_RIGHT,GL_COMPILE);
        glPushMatrix();
		glTranslatef(2.5,8.0,0.0);
		glRotatef(30,0.0,0.0,1.0);
		glCallList(LEG);
        glPopMatrix();
        glEndList();

		// FOREARM_LEFT
        glNewList(FOREARM_LEFT,GL_COMPILE);
        glPushMatrix();
		glTranslatef(-2.5,8.0,0.0);
		glRotatef(-30,0.0,0.0,1.0);
		glCallList(LEG);
        glPopMatrix();
        glEndList();

		// ARM_RIGHT
        glNewList(ARM_RIGHT,GL_COMPILE);
        glPushMatrix();
		glCallList(FOREARM_RIGHT);
		glCallList(HAND_RIGHT);
        glPopMatrix();
        glEndList();

		// ARM_LEFT
        glNewList(ARM_LEFT,GL_COMPILE);
        glPushMatrix();
		glCallList(FOREARM_LEFT);
		glCallList(HAND_LEFT);
        glPopMatrix();
        glEndList();


        glNewList(LEG_RIGHT,GL_COMPILE);
		glPushMatrix();
		glTranslatef(1.5,3.0,0.0); // jambe droite
		glRotatef(-15,0.0,0.0,1.0);
		glCallList(LEG);
		glPopMatrix();
		glPushMatrix();	// pied droit
		glTranslatef(1.5,0.64,0.0);
		glRotatef(90,1.0,0.0,0.0);
		glRotatef(180,0.0,1.0,0.0);
		glCallList(HAND);
		glPopMatrix();
        glEndList();

        glNewList(LEG_LEFT,GL_COMPILE);
		glPushMatrix();
		glTranslatef(-1.5,3.0,0.0); // jambe gauche
		glRotatef(15,0.0,0.0,1.0);
		glCallList(LEG);
		glPopMatrix();
		glPushMatrix();	// pied gauche
		glTranslatef(-1.5,0.64,0.0);
		glRotatef(90,1.0,0.0,0.0);
		glCallList(HAND);
		glPopMatrix();
        glEndList();


	}
}
