/* druid-'s GLJournal distribution:
		http://www-scf.usc.udu/~sfranke/glj/
			Project 08 - Texture Mapped Cube
				-Version 1.0	-	3/14/98
					Uses druid-'s GLSetup
					Visual C++ 5 Project

	by Scott Franke [druid-]
		sfranke@scf.usc.edu
*/

#ifndef LINUX
#include <windows.h>
#endif
#include <GL/glut.h>
#include <stdio.h>

#include "tex.h"

#ifdef __cplusplus
extern "C" {
#endif

GLubyte buffer[256*256*3];

/* Loads a 24-bit RAW image file into a memory buffer 
		Must supply complete file name
*/
void texLoadRAW (char *filename, GLubyte *picbuffer, int x, int y, int mode)
{
	FILE *fp;
	long i,j,k;

	if ((x > 256) || (y > 256))
	{
#ifndef LINUX
		MessageBox (NULL, "Texture too large", "Error Loading Texture", MB_ICONSTOP);
#endif
		exit (1);
	}

	memset (buffer, 0, sizeof(buffer));

	fp = fopen (filename,"r");
	if (fp == NULL)
	{
#ifndef LINUX
		MessageBox (NULL, filename, "ERROR: Texture Not Found", MB_ICONSTOP);
#endif
		exit (1);
	}

	fread (buffer, x*y*3, 1, fp);
//	for(i=0;i<x;i++)
//		for(j=0;j<y;j++)
//			for(k=0;k<3;k++)
//				buffer[i][j][k] = fgetc (fp);

	for (i=0;i<x;i++)
	{
		for (j=0;j<y;j++)
		{
			picbuffer[j*4*x+i*4+2] = buffer[j*3*x+3*i+0];
	 		picbuffer[j*4*x+i*4+0] = buffer[j*3*x+3*i+1];
			picbuffer[j*4*x+i*4+1] = buffer[j*3*x+3*i+2];

			switch (mode)
			{
			case TEXMODE_RA:
			case TEXMODE_GA:
			case TEXMODE_BA:
				picbuffer[j*4*x+i*4+3] = picbuffer[j*4*x+i*4+mode];
				break;
			case TEXMODE_SOLID:
				picbuffer[j*4*x+i*4+3] = 255;
				break;
			case TEXMODE_ALPHA:
				if((picbuffer[j*4*x+i*4+0] == 0) &&
				   (picbuffer[j*4*x+i*4+1] == 0) &&
				   (picbuffer[j*4*x+i*4+2] == 0)) {
					picbuffer[j*4*x+i*4+3] = 128;
				}
				break;
				//picbuffer[j*4*x+i*4+3] = 0.5;
			case TEXMODE_BLACK_ALPHA:
				if((picbuffer[j*4*x+i*4+0] == 0) &&
				   (picbuffer[j*4*x+i*4+1] == 0) &&
				   (picbuffer[j*4*x+i*4+2] == 0)) {
					picbuffer[j*4*x+i*4+3] = 0;
				}else{
					picbuffer[j*4*x+i*4+3] = 255;
				}
				break;
			case TEXMODE_AVG:
				picbuffer[j*4*x+i*4+3] = 0;
				for(k=1;k<3;k++)
					picbuffer[j*4*x+i*4+3] += picbuffer[j*4*x+i*4+k];
				picbuffer[j*4*x+i*4+3] /= 3;
				break;
			case TEXMODE_HIGH:
				picbuffer[j*4*x+i*4+3] = picbuffer[j*4*x+i*4+0];
				for(k=1;k<3;k++)
					if((picbuffer[j*4*x+i*4+k]) > (picbuffer[j*4*x+i*4+3]))
						picbuffer[j*4*x+i*4+3] = picbuffer[j*4*x+i*4+k];
				break;
			}
		}
	}

	fclose (fp);
}

/* Loads a 24-bit RAW and sets it up for GL to use
		mip = 1, uses gluBuild2DMipmaps
		mip = 0, uses glTexImage2d
*/
void texGLLoadRAW (char *filename, int x, int y, int texmode, int mip)
{
	GLubyte *pic;

	pic = (GLubyte *)malloc (x*y*4);

	texLoadRAW(filename, pic, x, y, texmode);

	if(mip)
	{
		gluBuild2DMipmaps (GL_TEXTURE_2D,
								 4,					// 4 components
								 x, y,				// width, height
								 GL_RGBA,			// pixel data format
								 GL_UNSIGNED_BYTE,// data type
								 pic);				// data
	}
	else
	{
		glTexImage2D (GL_TEXTURE_2D,
						  0,							// level 0 (no mipmaps)
						  4,							// 4 components
						  x, y,						// width, height
						  0,							// no border
						  GL_RGBA,					// pixel data format
						  GL_UNSIGNED_BYTE,		// data type
						  pic);						// data
	}

	free(pic);
}

#ifdef __cplusplus
}
#endif
