
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>       
#include <GL/glut.h>
#include "tex.h"
#include "decor.h"
#include "character.h"
#include "global.h"

#ifndef M_PI
#define M_PI 3.14159265
#endif

static void specialKey(int state, int x, int y);
static void specialKeyUp(int state, int x, int y);

/***************************************************
 *            Variables de controle                *
 ***************************************************/

// ********* Modes de rendus et effets ************
static int renderbear  =		1;
static int renderball  =		1;
static int animation   =		1;
static int slice =				5;
static int stack =				3;
static int textureRenderMode =  0;

// ********** Vitesse et animation ************
static float lightAngle  =	     2.9;
static float timeDivider =		50.0;
static int lightHeight =		20.0;
GLfloat angle =					-150;
GLfloat angle2 =				  30;
int moving, startx, starty;
static int lightStartX;
static int lightStartY;
static int signe =			1;
static int signe_old =		1;
static int cpteur =			0;
static int is_juggling =	0;
static int is_walking =		0;

static int is_turning =		0;
static float juggle =		0.0;
static float juggle_old =	0.0;
static int jugglingPace =			0.0;
static int jugglingPace_old =		0.0;
static int walkPace =		0.0;

// ********* juggling parameters ************
static float width =  16.0;
static float height = 12.0;
static float alpha =   -0.2;
static float beta =    7.5;
static int offset =		 1;

// ******** walking parameters *************
static float directionAngle = 0;
static float posX = 0;
static float posZ = 0;

// **************** Textures ***************
static int num_texture = 1;

/**************************************************
 *              Dessin de l'ours                  *
 **************************************************/
static void drawbear(void)
{
	glPushMatrix();

	glTranslatef(posX,0.0,posZ);	
	glRotatef(directionAngle,0.0,1.0,0.0);

	// Dessin du corps
	glPushMatrix();
	glCallList(BODY);
	glPopMatrix();

	// Dessin des fesses
	glPushMatrix();
	if(is_walking == 1) {
		glTranslatef(0.0,4.0,0.0);
		glRotatef(10*sin((walkPace)*6*M_PI/180.0), 0.0, 0.0, 1.0);
		glTranslatef(0.0,-4.0,0.0); 
	}
	if(is_walking == 2) {
		glTranslatef(0.0,4.0,0.0);
		glRotatef(-10*sin((walkPace)*6*M_PI/180.0), 0.0, 0.0, 1.0);
		glTranslatef(0.0,-4.0,0.0); 
	}
	glCallList(BUTTOCK);
	glCallList(NOMBRIL);
	glPopMatrix();

	// Dessin de la tete
	glPushMatrix();
	glTranslatef(0.0,12.0,0.0);
	glScalef(0.9,0.9,0.9);
	glCallList(HEAD);
	glPopMatrix();
	
	// Dessin des membres
	glPushMatrix();             // bras droit
	if(is_juggling == 1) {
		glTranslatef(2.5,9.4,0.0);
		glRotatef(40*(-cascadeHandPathX[(jugglingPace+offset)%60]/2.0)/width , 0.0, 1, 0.0 );
		glRotatef(2.7*width-55, 0.0, 1, 0.0 );
		glRotatef(35*((-cascadeHandPathY[(jugglingPace+offset)%60]/2.0)/height + 2.0), 1, 0.0, 0.0);
		glRotatef(-2.5*height+70, 1.0, 0.0, 0.0 );
		glTranslatef(-2.5,-9.4,0.0);
	}
	if(is_juggling == 2) {
		glTranslatef(2.5,9.4,0.0);
		glRotatef(40*(-cascadeHandPathX[(jugglingPace+offset)%60]/2.0)/width , 0.0, 1, 0.0 );
		glRotatef(2.7*width-55, 0.0, 1, 0.0 );
		glRotatef(35*((-cascadeHandPathY[(jugglingPace+offset)%60]/2.0)/height + 2.0), 1, 0.0, 0.0);
		glRotatef(-2.5*height+70, 1.0, 0.0, 0.0 );
		glTranslatef(-2.5,-9.4,0.0);
	}
	if(is_walking == 1 && is_juggling == 0) {
		glTranslatef(2.5,9.4,0.0);
		glRotatef(30*sin(((walkPace+30)%60)*6*M_PI/180.0), 1.0, 0.0, 0.0);
		glTranslatef(-2.5,-9.4,0.0);
	}
	if(is_walking == 2 && is_juggling == 0) {
		glTranslatef(2.5,9.4,0.0);
		glRotatef(-30*sin(((walkPace+30)%60)*6*M_PI/180.0), 1.0, 0.0, 0.0);
		glTranslatef(-2.5,-9.4,0.0);
	}
	glCallList(ARM_RIGHT);
	glPopMatrix();

	glPushMatrix();             // bras gauche
	if(is_juggling == 1) {
		glTranslatef(-2.5,9.4,0.0);
		glRotatef(40*(cascadeHandPathX[(jugglingPace+10+offset)%60]/2.0)/width, 0.0, 1, 0.0 );
		glRotatef(-2.7*width+55, 0.0, 1, 0.0 );
		glRotatef(35*((-cascadeHandPathY[(jugglingPace+10+offset)%60]/2.0)/height + 2.0), 1, 0.0, 0.0);
		glRotatef(-2.5*height+70, 1.0, 0.0, 0.0 );
		glTranslatef(2.5,-9.4,0.0);
	}
	if(is_juggling == 2) {
		glTranslatef(-2.5,9.4,0.0);
		glRotatef(40*(cascadeHandPathX[(jugglingPace+10+offset)%60]/2.0)/width, 0.0, 1, 0.0 );
		glRotatef(-2.7*width+55, 0.0, 1, 0.0 );
		glRotatef(35*((-cascadeHandPathY[(jugglingPace+10+offset)%60]/2.0)/height + 2.0), 1, 0.0, 0.0);
		glRotatef(-2.5*height+70, 1.0, 0.0, 0.0 );
		glTranslatef(2.5,-9.4,0.0);
	}
	if(is_walking == 1 && is_juggling == 0) {
		glTranslatef(-2.5,9.4,0.0);
		glRotatef(30*sin((walkPace)*6*M_PI/180.0), 1.0, 0.0, 0.0);
		glTranslatef(2.5,-9.4,0.0);
	}
	if(is_walking == 2 && is_juggling == 0) {
		glTranslatef(-2.5,9.4,0.0);
		glRotatef(-30*sin((walkPace)*6*M_PI/180.0), 1.0, 0.0, 0.0);
		glTranslatef(2.5,-9.4,0.0);
	}
	glCallList(ARM_LEFT);
	glPopMatrix();

	glPushMatrix();
	if(is_walking == 1) {
		glTranslatef(1.5,4,0.0);
		glRotatef(30*sin((walkPace)*6*M_PI/180.0), 1, 0.0, 0.0);
		glTranslatef(-1.5,-4,0.0); 
	}
	if(is_walking == 2) {
		glTranslatef(1.5,4,0.0);
		glRotatef(-30*sin((walkPace)*6*M_PI/180.0), 1, 0.0, 0.0);
		glTranslatef(-1.5,-4,0.0); 
	}
	glCallList(LEG_RIGHT);
	glPopMatrix();

	glPushMatrix();
	if(is_walking == 1) {
		glTranslatef(-1.5,4,0.0);
		glRotatef(30*sin(((walkPace+30)%60)*6*M_PI/180.0), 1, 0.0, 0.0);
		glTranslatef(1.5,-4,0.0); 
	}
	if(is_walking == 2) {
		glTranslatef(-1.5,4,0.0);
		glRotatef(-30*sin(((walkPace+30)%60)*6*M_PI/180.0), 1, 0.0, 0.0);
		glTranslatef(1.5,-4,0.0); 
	}
	glCallList(LEG_LEFT);
	glPopMatrix();
	glPopMatrix();
}

/**************************************************
 *              Dessin des balles                 *
 **************************************************/
static void drawball(void)
{
	glPushMatrix();

	glTranslatef(posX,0.0,posZ);	
	glRotatef(directionAngle,0.0,1.0,0.0);
	// Dessin de la 1ere balle
	glPushMatrix();
	if( is_juggling > 0) {
		if(animation) {
			if( is_juggling == 1) {  // cascade
				glTranslatef((cascadeBallPathX[jugglingPace]-6-68)/(width-0.5) + alpha ,
					         (78-cascadeBallPathY[jugglingPace])/height + beta, -4.5);
			} else if( is_juggling == 2) { //carambole
				glTranslatef((caramboleBallPathX[jugglingPace]-6-68)/(width-0.5) + alpha ,
					         (78-caramboleBallPathY[jugglingPace])/height + beta, -4.5);
			}
		} else {
		glTranslatef((cascadeHandPathX[(jugglingPace+offset)%60])/width, 8.0, -3.7);
		glTranslatef(-4.3, (cascadeHandPathY[(jugglingPace+offset)%60])/height, 0.0);
		//glTranslatef(5.0, 11.0, -3.7);
		}
	} else if(is_walking == 1 && is_juggling == 0) {
		glTranslatef(2.5,9.4,0.0);
		glRotatef(30*sin(((walkPace+30)%60)*6*M_PI/180.0), 1.0, 0.0, 0.0);
		glTranslatef(-2.5,-9.4,0.0);
		glTranslatef(4.0, 5.0, 0.0);
	} else if(is_walking == 2 && is_juggling == 0) {
		glTranslatef(2.5,9.4,0.0);
		glRotatef(-30*sin(((walkPace+30)%60)*6*M_PI/180.0), 1.0, 0.0, 0.0);
		glTranslatef(-2.5,-9.4,0.0);
		glTranslatef(4.0, 5.0, 0.0);
	} else {
		glTranslatef(4.0, 5.0, 0.0);
	}
	glCallList(BALL1);
	glPopMatrix();

	// Dessin de la 2ieme balle
	glPushMatrix();
	if( is_juggling > 0) {
		if(animation) {
			if( is_juggling == 1) {  // cascade
				glTranslatef((cascadeBallPathX[(jugglingPace+20)%60]-6-68)/(width-0.5) + alpha,
							 (78-cascadeBallPathY[(jugglingPace+20)%60])/height + beta, -4.5);
			} else if( is_juggling == 2) { //carambole
				glTranslatef((caramboleBallPathX[(jugglingPace+20)%60]-6-68)/(width-0.5) + alpha,
							 (78-caramboleBallPathY[(jugglingPace+20)%60])/height + beta, -4.5);
			}
		} else {
		glTranslatef(-(cascadeHandPathX[(jugglingPace+10+offset)%60])/width, 8, -3.7);
		glTranslatef(4.3, (cascadeHandPathY[(jugglingPace+10+offset)%60])/height, 0.0);
		}
	} else if(is_walking == 1 && is_juggling == 0) {
		glTranslatef(-2.5,9.4,0.0);
		glRotatef(30*sin(((walkPace)%60)*6*M_PI/180.0), 1.0, 0.0, 0.0);
		glTranslatef(2.5,-9.4,0.0);
		glTranslatef(-4.0, 5.0, 0.0);
	} else if(is_walking == 2 && is_juggling == 0) {
		glTranslatef(-2.5,9.4,0.0);
		glRotatef(-30*sin(((walkPace)%60)*6*M_PI/180.0), 1.0, 0.0, 0.0);
		glTranslatef(2.5,-9.4,0.0);
		glTranslatef(-4.0, 5.0, 0.0);
	} else {
		glTranslatef(-4.0, 5.0, 0.0);
	}

	glCallList(BALL2);
	glPopMatrix();
	
	// Dessin de la 3ieme balle
	glPushMatrix();
	if( is_juggling > 0) {
		if(animation) {
			if( is_juggling == 1) {  // cascade
				glTranslatef((cascadeBallPathX[(jugglingPace+40)%60]-6-68)/(width-0.5) + alpha,
							 (78-cascadeBallPathY[(jugglingPace+40)%60])/height + beta, -4.5);
			} else if( is_juggling == 2) { //carambole
				glTranslatef((caramboleBallPathX[(jugglingPace+40)%60]-6-68)/(width-0.5) + alpha,
							 (78-caramboleBallPathY[(jugglingPace+40)%60])/height + beta, -4.5);
			}
		} else {
		glTranslatef(-(cascadeHandPathX[(jugglingPace+11+offset)%60])/width, 8, -3.7);
		glTranslatef(4.3, (cascadeHandPathY[(jugglingPace+11+offset)%60])/height, 0.0);
		}
	} else if(is_walking == 1 && is_juggling == 0) {
		glTranslatef(2.5,9.4,0.0);
		glRotatef(30*sin(((walkPace+30)%60)*6*M_PI/180.0), 1.0, 0.0, 0.0);
		glTranslatef(-2.5,-9.4,0.0);
		glTranslatef(4.3, 5.0, 0.0);
	} else if(is_walking == 2 && is_juggling == 0) {
		glTranslatef(2.5,9.4,0.0);
		glRotatef(-30*sin(((walkPace+30)%60)*6*M_PI/180.0), 1.0, 0.0, 0.0);
		glTranslatef(-2.5,-9.4,0.0);
		glTranslatef(4.3, 5.0, 0.0);
	} else {
		glTranslatef(4.3, 5.0, 0.0);
	}
	glCallList(BALL3);
	glPopMatrix();

	glPopMatrix();
}

/*****************************************************
 *                    Redraw()                       *
 *****************************************************/
static void redraw(void)
{
  int i;

  // **************************************************
  //         Effacement des stencils utiliss

  if (renderReflection || renderShadow) {
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);
  } else {
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  }
		
  // **************************************************
  //       Repositionnement des sources de lumire 

  lightPosition[0][0] = 12*cos(lightAngle);
  lightPosition[0][1] = lightHeight;
  lightPosition[0][2] = 12*sin(lightAngle);
  if (directionalLight[0]) {
    lightPosition[0][3] = 0.0;
  } else {
    lightPosition[0][3] = 1.0;
  }

  lightPosition[1][0] = 3;
  lightPosition[1][1] = 15;
  lightPosition[1][2] = 0;
  if (directionalLight[1]) {
    lightPosition[1][3] = 0.0;
  } else {
    lightPosition[1][3] = 1.0;
  }

  lightPosition[2][0] = 10*cos(lightAngle*1.5);//+M_PI/3);
  lightPosition[2][1] = lightHeight/1.5;
  lightPosition[2][2] = 10*sin(lightAngle*1.5);//+M_PI/3);
  if (directionalLight[2]) {
    lightPosition[2][3] = 0.0;
  } else {
    lightPosition[2][3] = 1.0;
  }

  // **************************************************
	//          Calcul des matrices d'ombres

	for (i=0; i<NB_LIGHTS; i++) 
		if (lights_enabled[i])
			shadowMatrix(floorShadow[i], floorPlane, lightPosition[i]);

	glPushMatrix();
    // Rotations effectues par le mouvement de la souris
    glRotatef(angle2, 1.0, 0.0, 0.0);
    glRotatef(angle, 0.0, 1.0, 0.0);
     
    glLightfv(GL_LIGHT0, GL_POSITION, lightPosition[0]);
    glLightfv(GL_LIGHT1, GL_POSITION, lightPosition[1]);
    glLightfv(GL_LIGHT2, GL_POSITION, lightPosition[2]);

  // **************************************************
  // Affichage de la rflection sur le sol
    if (renderReflection && (renderbear || renderball)) {
        /* We can eliminate the visual "artifact" of seeing the "flipped"
           perso underneath the floor by using stencil.  The idea is
           draw the floor without color or depth update but so that 
           a stencil value of one is where the floor will be.  Later when
           rendering the perso reflection, we will only update pixels
           with a stencil value of 1 to make sure the reflection only
           lives on the floor, not below the floor. */

        // Don't update color or depth.
        glDisable(GL_DEPTH_TEST);
        glColorMask(GL_FALSE, GL_FALSE, GL_FALSE, GL_FALSE);

        // Draw 1 into the stencil buffer. 
        glEnable(GL_STENCIL_TEST);
        glStencilOp(GL_REPLACE, GL_REPLACE, GL_REPLACE);
        glStencilFunc(GL_ALWAYS, 1, 0xffffffff);

        // Now render floor; floor pixels just get their stencil set to 1.
        drawFloor(useTexture, num_texture);
	
        // Re-enable update of color and depth. 
        glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
        glEnable(GL_DEPTH_TEST);

        // Now, only render where stencil is set to 1.
        glStencilFunc(GL_EQUAL, 1, 0xffffffff);  // draw if ==1 
        glStencilOp(GL_KEEP, GL_KEEP, GL_KEEP);

		glPushMatrix();

        // The critical reflection step: Reflect perso through the floor
        // (the Y=0 plane) to make a relection. 
        glScalef(1.0, -1.0, 1.0);

        // Reflect the light position. 
        glLightfv(GL_LIGHT0, GL_POSITION, lightPosition[0]);

        // To avoid our normals getting reversed and hence botched lighting
        // on the reflection, turn on normalize.  
        glEnable(GL_NORMALIZE);
        glCullFace(GL_FRONT);

        // Draw the reflected perso. 
		if(renderbear) {
			drawbear();
		}
		if(renderball) {
			drawball();
		}
        // Disable normalize again and re-enable back face culling. 
        glDisable(GL_NORMALIZE);
        glCullFace(GL_BACK);

      glPopMatrix();

      // Switch back to the unreflected light position.
      glLightfv(GL_LIGHT0, GL_POSITION, lightPosition[0]);

      glDisable(GL_STENCIL_TEST);
    }

  // **************************************************
  // Affichage du sol
    /* Back face culling will get used to only draw either the top or the
       bottom floor.  This let's us get a floor with two distinct
       appearances.  The top floor surface is reflective and kind of red.
       The bottom floor surface is not reflective and blue. */

    // Draw "bottom" of floor in blue.
    glFrontFace(GL_CW);  // Switch face orientation.
    glColor4f(0.1, 0.1, 1.0, 1.0);
    drawFloor(useTexture, num_texture);
	glFrontFace(GL_CCW);

  // **************************************************
  // Affichage des ombres
    if (renderShadow) {
        /* Draw the floor with stencil value 3.  This helps us only 
           draw the shadow once per floor pixel (and only on the
           floor pixels). */
        glEnable(GL_STENCIL_TEST);
        glStencilFunc(GL_ALWAYS, 3, 0xffffffff);
        glStencilOp(GL_KEEP, GL_KEEP, GL_REPLACE);
    }

    // Draw "top" of floor.  Use blending to blend in reflection.
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    //glColor4f(1.0, 1.0, 1.0, 0.7);
	glMaterialfv(GL_FRONT, GL_DIFFUSE, topFloorColor);
    drawFloor(useTexture, num_texture);
    glDisable(GL_BLEND);

  // **************************************************
  // Affichage du personnage
    if (renderbear) {
      // Draw "actual" perso, not its reflection.
      drawbear();
    }
    if (renderball) {
      // Draw "actual" perso, not its reflection.
      drawball();
    }

  // **************************************************
  // Affichage des ombres
    if (renderShadow && (renderbear || renderball)) {

      // Render the projected shadow.

   /* Now, only render where stencil is set above 2 (ie, 3 where
      the top floor is).  Update stencil with 2 where the shadow
      gets drawn so we don't redraw (and accidently reblend) the
      shadow).*/
      glStencilFunc(GL_LESS, 2, 0xffffffff);  // draw if ==1 
      glStencilOp(GL_REPLACE, GL_REPLACE, GL_REPLACE);
  
   /* To eliminate depth buffer artifacts, we use polygon offset
      to raise the depth of the projected shadow slightly so
      that it does not depth buffer alias with the floor. */
      glEnable(GL_POLYGON_OFFSET_FILL);

      // Render 50% black shadow color on top of whatever the floor appareance is.
      glEnable(GL_BLEND);
      glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
      glDisable(GL_LIGHTING);  // Force the 50% black. 
      glColor4f(0.0, 0.0, 0.0, 0.5);

	  // Projection de l'ombre sur le sol
	  for (i=0; i<NB_LIGHTS; i++) {
		  if (lights_enabled[i]) {
			glPushMatrix();
			// Project the shadow. 
			glMultMatrixf((GLfloat *) floorShadow[i]);
			if(renderbear) {
				drawbear();
			} 
			if(renderball) {
			drawball();
			}
			glPopMatrix();
		  }
	  }

      glDisable(GL_BLEND);
      glEnable(GL_LIGHTING);

	  glDisable(GL_POLYGON_OFFSET_FILL);
      
      glDisable(GL_STENCIL_TEST);
    }


	//**************************************************
	//Dessin des lampes dans la scene 
	if (draw_lights) {
		glDisable(GL_LIGHTING);

		for (i=0; i<NB_LIGHTS; i++) {
		  if (lights_enabled[i]) {
			  glPushMatrix();
			  glColor3fv(lightColor[i]);
			  if (directionalLight[i]) {
				// Draw an arrowhead. 
				glDisable(GL_CULL_FACE);
				glTranslatef(lightPosition[i][0], lightPosition[i][1], lightPosition[i][2]);
				if (i == 0) { // 1re lumire
					glRotatef(lightAngle * -180.0 / M_PI, 0, 1, 0);
					glRotatef(atan(lightHeight/12) * 180.0 / M_PI, 0, 0, 1);
				}
				else if (i == 1) { // 2me lumire
					glRotatef(atan(lightHeight/12) * 180.0 / M_PI, 0, 0, 1);
				}
				else if (i == 2) { // 3me lumire
					glRotatef((lightAngle * -180.0 / M_PI)-60, 0, 1, 0);
				}
				glBegin(GL_TRIANGLE_FAN);
					glVertex3f(0, 0, 0);
					glVertex3f(2, 1, 1);
					glVertex3f(2, -1, 1);
					glVertex3f(2, -1, -1);
					glVertex3f(2, 1, -1);
					glVertex3f(2, 1, 1);
				glEnd();
				// Draw a white line from light direction. 
				glColor3f(1.0, 1.0, 1.0);
				glBegin(GL_LINES);
					glVertex3f(0, 0, 0);
					glVertex3f(5, 0, 0);
				glEnd();
				glEnable(GL_CULL_FACE);
			  } else {
				// Draw a ball at the light source. 
				glTranslatef(lightPosition[i][0], lightPosition[i][1], lightPosition[i][2]);
				glutSolidSphere(1.0, 5, 5);
			  }
			  glPopMatrix();
		  } // Fin if
		} // Fin for
		glEnable(GL_LIGHTING);

	} 

  glPopMatrix();
  glutSwapBuffers();
}


/*********************************************************
 *                 Gestion de la souris                  *
 *********************************************************/
static void mouse(int button, int state, int x, int y)
{
  int modifier =glutGetModifiers();
  if ((button == GLUT_LEFT_BUTTON ) && (modifier == 0)) {
    if (state == GLUT_DOWN) {
      moving = 1;
      startx = x;
      starty = y;
    }
    if (state == GLUT_UP) {
      moving = 0;
    }
  }
  if ((button == GLUT_LEFT_BUTTON) && (modifier == GLUT_ACTIVE_SHIFT)) {
    if (state == GLUT_DOWN) {
      lightMoving = 1;
      lightStartX = x;
      lightStartY = y;
    }
    if (state == GLUT_UP) {
      lightMoving = 0;
    }
  }
}

/**********************************************************
 *           Gestion du mouvement de la souris            *
 **********************************************************/
static void motion(int x, int y)
{
  if (moving) {
    angle = angle + (x - startx);
    angle2 = angle2 + (y - starty);
    startx = x;
    starty = y;
    glutPostRedisplay();
  }
  if (lightMoving) {
    lightAngle += (x - lightStartX)/40.0;
    lightHeight += (lightStartY - y)/20.0;
    lightStartX = x;
    lightStartY = y;
    glutPostRedisplay();
  }
}


/*************************************************************
 *     Variation des paramtres pour les divers mouvements   *
 *************************************************************/
static void idle(void)
{
	static float time = 0.0;
	juggle_old = juggle;
	jugglingPace_old = jugglingPace;

	time = glutGet(GLUT_ELAPSED_TIME) / timeDivider;

	juggle = 4.0 * fabs(sin(time)*0.5);
	jugglingPace = ((int)time)%60;
	walkPace = ((int)time*2)%60;
	if (!lightMoving) {
		lightAngle += 0.04;
	}
	//printf("walkPace: %d\n",walkPace);
	//printf("IDLE is_walking: %d\n",is_walking);
	glutPostRedisplay();
}

/*************************************************************
 *                 Controle des lumieres                     *
 *************************************************************/
static void controlLights(int value)
{
  switch (value) {

  case M_NONE:
    return;
  case M_LIGHT_MOTION:
    lightMoving = 1 - lightMoving;
    if (animation) {
      glutIdleFunc(idle);
    } else {
      glutIdleFunc(NULL);
    }
    break;
  case M_TEXTURE:
    useTexture = !useTexture;
    break;
  case M_DRAW_LIGHTS:
    draw_lights = !draw_lights;
    break;
  case M_SHADOWS:
    renderShadow = 1 - renderShadow;
    break;
  case M_REFLECTION:
    renderReflection = 1 - renderReflection;
    break;
  case M_BEAR:
    renderbear  = 1 - renderbear;
    break;
  case M_BALL:
	renderball = 1 - renderball;
    break;
  }
  glutPostRedisplay();
}

/******************************************************************
 * When not visible, stop animating.  Restart when visible again. *
 ******************************************************************/
static void visible(int vis)
{
  if (vis == GLUT_VISIBLE) {
    if (animation)
      glutIdleFunc(idle);
  } else {
    if (!animation)
      glutIdleFunc(NULL);
  }
}

/*******************************************************
 *           Gestion des touches du clavier            *
 *******************************************************/
static void key(unsigned char c, int x, int y)
{

	switch (c) {

	// ********* Rendu vido *************
	case 'W':
		glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
		break;
	case 'S':
		glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
		break;
	// ******** Rendu de texture *********
	case 'r':
		textureRenderMode = (++textureRenderMode)%3;
		if (textureRenderMode == 0) {
			printf("textureRenderMode: GL_NEAREST\n");
		}
		if (textureRenderMode == 1) {
			printf("textureRenderMode: GL_LINEAR\n");
		}
		if (textureRenderMode == 2) {
			printf("textureRenderMode: GL_LINEAR_MIPMAP_LINEAR\n");
		}
		initTexture(textureRenderMode);
		break;

	// ******** Juggling parameters ******
	case 'q':
		if(height <= 30.0)
		height = height + 1.0 ;
		else height = 30.0;
		break;
	case 'a':
		if(height >= 9.0)
		height = height - 1.0 ;
		else height = 9.0;
		break;
	case 'z':
		if(width <= 26.0)
		width = width + 1.0 ;
		else width = 26.0;
		break;
	case 'e':
		if(width >= 15.0)
		width = width - 1.0 ;
		else width = 15.0;
		break;
	case 'A':
		if(beta <= 20.0)
		beta = beta + 1.0 ;
		else beta = 20.0;
		break;
	case 'Q':
		if(beta >= 1.0)
		beta = beta - 1.0 ;
		else beta = 1.0;
		break;
	case 'Z':
		if(alpha <= 20.0)
		alpha = alpha + 1.0 ;
		else alpha = 20.0;
		break;
	case 'E':
		if(alpha >= -20.0)
		alpha = alpha - 1.0 ;
		else alpha = -20.0;
		break;
	case 'o':
		if(offset <= 19)
		offset = ++offset;
		else offset = 19;
		break;
	case 'l':
		if(offset >= 1)
		offset = --offset;
		else offset = 1;
		break;
	case '-':
		if(timeDivider <= 390.0)
		timeDivider = timeDivider + 10.0 ;
		else timeDivider = 400.0;
		break;
	case '+':
		if(timeDivider >= 20.0)
		timeDivider = timeDivider - 10.0 ;
		else timeDivider = 10.0;
		break;
		
	// ********* Gestion des mouvements ***********
	case 'j':
		is_juggling = (++is_juggling) % 3;
		break;
	case 't':
		num_texture = (++num_texture)%5;
		break;

	// ********* Gestion des lumires **********
	case '1': // 1re lumire
		if (lights_enabled[0] && !directionalLight[0])
			directionalLight[0] = 1;
		else {
			directionalLight[0] = 0;
			lights_enabled[0] = 1 - lights_enabled[0];
			if (lights_enabled[0])
				glEnable(GL_LIGHT0);
			else
				glDisable(GL_LIGHT0);
		}
		break;
	case '2': // 2me lumire
		if (lights_enabled[1] && !directionalLight[1])
			directionalLight[1] = 1;
		else {
			directionalLight[1] = 0;
			lights_enabled[1] = 1 - lights_enabled[1];
			if (lights_enabled[1])
				glEnable(GL_LIGHT1);
			else
				glDisable(GL_LIGHT1);
		}
		break;
	case '3': // 3me lumire
		if (lights_enabled[2] && !directionalLight[2])
			directionalLight[2] = 1;
		else {
			directionalLight[2] = 0;
			lights_enabled[2] = 1 - lights_enabled[2];
			if (lights_enabled[2])
				glEnable(GL_LIGHT2);
			else
				glDisable(GL_LIGHT2);
		}
		break;
	case 27:
		exit(0);  // Escape permet de quitter le programme.
		break;

	// ********* Gestion de la resolution des facettes ********
	case '*':
		if(stack < 20) {
			stack = ++stack;
			slice =	++slice;
		}
		else {
			stack = 20;
			slice = 18;
		}
		makeCharacter(renderball,renderbear,slice,stack);
		break;
	case '/':
		if(stack > 5) {
			stack = --stack;
			slice = --slice;
		}
		else {
			stack = 5;
			slice = 3;
		}
		makeCharacter(renderball,renderbear,slice,stack);
		break;
	}

	glutPostRedisplay();
}

/************************************************************************
 *       Gestion des touches speciale du clavier (touches "down")       *
 ************************************************************************/

static void specialKey(int state, int x, int y)
{
	switch (state) {
	case GLUT_KEY_UP:
		is_walking = 1;
		posX+= -sin((float)directionAngle*M_PI/180)*22/timeDivider;
		posZ+= -cos((float)directionAngle*M_PI/180)*22/timeDivider;
		//printf("posX: %f\n",posX);
		//printf("posZ: %f\n",posZ);
		break;
	case GLUT_KEY_DOWN:
		is_walking = 2;
		posX-= -sin((float)directionAngle*M_PI/180)*22/timeDivider;
		posZ-= -cos((float)directionAngle*M_PI/180)*22/timeDivider;
		break;
	case GLUT_KEY_LEFT:
		directionAngle+=10;
			if(directionAngle>350)
				directionAngle=0;
		break;
	case GLUT_KEY_RIGHT:
		directionAngle-=10;
			if(directionAngle < 0)
				directionAngle=350;
		break;
	}
  glutPostRedisplay();
}

/************************************************************************
 *       Gestion des touches speciale du clavier (touches "up")       *
 ************************************************************************/

static void specialKeyUp(int state, int x, int y)
{
	switch (state) {
	case GLUT_KEY_UP:
		is_walking = 0;
		break;
	case GLUT_KEY_DOWN:
		is_walking = 0;
		break;
	}
  glutPostRedisplay();
}

/***********************************************************
 * Cration d'un Menu associ au bouton droit de la souris *
 ***********************************************************/
static void createMenu(void) 
{
  glutCreateMenu(controlLights);

  glutAddMenuEntry("Toggle lightmotion", M_LIGHT_MOTION);
  glutAddMenuEntry("-----------------------", M_NONE);
  glutAddMenuEntry("Toggle textures", M_TEXTURE);
  glutAddMenuEntry("Toggle shadows", M_SHADOWS);
  glutAddMenuEntry("Toggle reflection", M_REFLECTION);
  glutAddMenuEntry("Toggle bear", M_BEAR);
  glutAddMenuEntry("Toggle ball", M_BALL);
  glutAddMenuEntry("----------------------", M_NONE);
  glutAddMenuEntry("Draw light sources", M_DRAW_LIGHTS);
  glutAttachMenu(GLUT_RIGHT_BUTTON);
}

/*******************************************************
 *             Corps principal du programme            *
 *******************************************************/
int main(int argc, char **argv)
{
  glutInitWindowPosition(100, 100);
  glutInitWindowSize(200, 200);
  glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH | GLUT_STENCIL | GLUT_MULTISAMPLE);

  if (!(glutCreateWindow("Juggling"))) {
    fprintf(stderr, "Error opening a window.\n");
    exit(-1);
  }

  glutDisplayFunc(redraw);
  glutMouseFunc(mouse);
  glutMotionFunc(motion);
  glutVisibilityFunc(visible);
  glutKeyboardFunc(key);
  glutSpecialFunc(specialKey);
  glutSpecialUpFunc(specialKeyUp);

  checkPolygonOffset();

  glEnable(GL_CULL_FACE);
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_TEXTURE_2D);
  glLineWidth(1.0);

  glMatrixMode(GL_PROJECTION);
  gluPerspective(
	  60.0, // angle de vision
	  1.0,  // chelle
	  4.0, // distance min.
	  100.0 // distance max.
	  );
  glMatrixMode(GL_MODELVIEW);
  gluLookAt(0.0, 8.0, 30.0,  // eye is at (0,8,60)
    0.0, 8.0, 0.0,			 // center is at (0,8,0)
    0.0, 1.0, 0.);			 // up is in positive Y direction
	
  initLights();
  initTexture(textureRenderMode);
  createMenu();
  makeCharacter(renderball,renderbear,slice,stack);

  // Equation du plan pour le calcul des ombres
  findPlane(floorPlane, floorVertices[1], floorVertices[2], floorVertices[3]);

  glutMainLoop();
  return 0; 
}
