
typedef enum Texture {
	TEXTURE_CARRE, TEXTURE_LAVA, TEXTURE_MOSAIC, 
	TEXTURE_SPACE, TEXTURE_FLOWERS
} Texture;

/*******************************************************
 *                  Texture pour le sol                *
 *******************************************************/
/*static char *carres[] = {
  "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
  "x.............................yx",
  "x.xxxxxxxxxxxxxxxxxxxxxxxxxxxxyx",
  "x.xxxxxxxxxxxxxxxxxxxxxxxxxxxxyx",
  "x.xxxxxxxxxxxxxxxxxxxxxxxxxxxxyx",
  "x.xxxxxxxxxxxxxxxxxxxxxxxxxxxxyx",
  "x.xxxxyyyyyyyyyyyyyyyyyyyyxxxxyx",
  "x.xxxxyxxxxxxxxxxxxxxxxxx.xxxxyx",
  "x.xxxxyxxxxxxxxxxxxxxxxxx.xxxxyx",
  "x.xxxxyxx.............yxx.xxxxyx",
  "x.xxxxyxx.xxxxxxxxxxxxyxx.xxxxyx",
  "x.xxxxyxx.xxxxxxxxxxxxyxx.xxxxyx",  
  "x.xxxxyxx.xxxxxxxxxxxxyxx.xxxxyx",
  "x.xxxxyxx.xxxxxxxxxxxxyxx.xxxxyx",
  "x.xxxxyxx.xxxxyyyyyyyyyxx.xxxxyx", 
  "x.xxxxyxx.xxxxyxxxxxxxxxx.xxxxyx",
  "x.xxxxyxx.xxxxyxxxxxxxxxx.xxxxyx",
  "x.xxxxyxx.xxxxyxx.........xxxxyx",
  "x.xxxxyxx.xxxxyxx.xxxxxxxxxxxxyx",
  "x.xxxxyxx.xxxxyxx.xxxxxxxxxxxxyx",
  "x.xxxxyxx.xxxxyxx.xxxxxxxxxxxxyx",
  "x.xxxxyxx.xxxxyxx.xxxxxxxxxxxxyx",
  "x.xxxxyxx.xxxxyxxyyyyyyyyyyyyyyx",
  "x.xxxxyxx.xxxxyxxxxxxxxxxxxxxxxx",
  "x.xxxxyxx.xxxxyxxxxxxxxxxxxxxxxx",
  "..xxxxyxx.xxxxy.................",
  "xxxxxxyxx.xxxxxxxxxxxxxxxxxxxxxx",
  "xxxxxxyxx.xxxxxxxxxxxxxxxxxxxxxx",
  "xxxxxxyxx.xxxxxxxxxxxxxxxxxxxxxx",
  "xxxxxxyxx.xxxxxxxxxxxxxxxxxxxxxx",
  "yyyyyyyxxyyyyyyyyyyyyyyyyyyyyyyy",
  "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
};
*/
static char *carres[] = {
  "vbvbvbvb",
  "bbb.b.bb",
  "v.bbvbbb",
  "bbvbbbvv",
  "bbvbbbvv",
  "v.bbvbbb",
  "bbb.b.bb",
  "vbvbvbvb",
};

/*static char *carres[] = {
  "voorbb.v",
  "rrorrbrr",
  "vrvvbrr.",
  "vvrbvvvv",
  "obbro.oo",
  "b.vvvb.b",
  ".vrbbvbb",
  "vorrb.vv",
};
*/
/******************************************************
 *                 Definition du sol                  *
 ******************************************************/
static GLfloat floorVertices[4][3] = {
  { -96.0, 0.0,  96.0 },
  {  96.0, 0.0,  96.0 },
  {  96.0, 0.0, -96.0 },
  { -96.0, 0.0, -96.0 },
};

static int useTexture =			1;

#define NB_LIGHTS 3 // Nombre de lumires max.

// *********** Lumires ****************

static int nblight = NB_LIGHTS;
static int lights_enabled[NB_LIGHTS] = {1, 1, 1};
static int directionalLight[NB_LIGHTS] = {1, 1, 1};
static GLboolean draw_lights = GL_FALSE;
static GLfloat lightPosition[NB_LIGHTS][4];

static GLfloat lightColor[NB_LIGHTS][3] = {
	{0.8, 0.6, 0.6}, // 1re lumire: rouge
	{0.8, 0.9, 0.8}, // 2me lumire: vert
	{0.6, 0.6, 0.9}, // 3me lumire: bleue
}; 

static int renderReflection =	0;
static int renderShadow =		0;

/*************************************************************/

static GLfloat ambient[] =			{0.8, 0.8, 0.8, 1.0}; // lumiere ambiente de la scene
static GLfloat topFloorColor[] =	{1.0, 1.0, 1.0, 0.7};

// *************************************************

static GLfloat floorPlane[4];
static GLfloat floorShadow[NB_LIGHTS][4][4];

enum {
  X, Y, Z, W
};
enum {
  A, B, C, D
};

// *****************************************
enum {
  MISSING, EXTENSION, ONE_DOT_ONE
};
static int forceExtension =		0;
static int polygonOffsetVersion;

#ifdef __cplusplus
extern "C" {
#endif

void initTexture(int textureRenderMode);
void drawFloor(int useTexture, int num_texture);
void shadowMatrix(GLfloat shadowMat[4][4], GLfloat groundplane[4], GLfloat lightpos[4]);
void findPlane(GLfloat plane[4], GLfloat v0[3], GLfloat v1[3], GLfloat v2[3]);
void initLights(void);
int supportsOneDotOne(void);
void checkPolygonOffset(void);

#ifdef __cplusplus
}
#endif