#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>       
#include <GL/glut.h>
#include "tex.h"
#include "decor.h"
#include "global.h"
#include "character.h"

#ifndef M_PI
#define M_PI 3.14159265
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*******************************************************
 *            Initialisation des textures              *
 *******************************************************/
void initTexture(int textureRenderMode)
{
  GLubyte floorTexture[8][8][3];
  GLubyte *loc;
  int s, t;

  loc = (GLubyte*) floorTexture;
  for (t = 0; t < 8; t++) {
    for (s = 0; s < 8; s++) {
      if (carres[t][s] == 'b') {
		// bleu
        loc[0] = 0x2f; // 1f
        loc[1] = 0x2f; // 8f
        loc[2] = 0xff; // 1f
      } else if(carres[t][s] == 'o'){
        // orange
        loc[0] = 0xbf;
        loc[1] = 0x4f;
        loc[2] = 0x4f;
      } else if(carres[t][s] == 'r'){
        // rouge
        loc[0] = 0xff;
        loc[1] = 0x2f;
        loc[2] = 0x2f;
      } else if(carres[t][s] == 'v'){
        // vert
        loc[0] = 0x2f;
        loc[1] = 0xff;
        loc[2] = 0x2f;
      } else {
        // blanc casse
        loc[0] = 0x10;
        loc[1] = 0x10;
        loc[2] = 0x10;
      }
      loc += 3;
    }
  }

  // 1ere texture
	glBindTexture(GL_TEXTURE_2D, TEXTURE_CARRE);
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	if(textureRenderMode > 0) {
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	} 
	if(textureRenderMode == 0) {
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	} 

	glTexImage2D(GL_TEXTURE_2D, 0, 3, 8, 8, 0, GL_RGB, GL_UNSIGNED_BYTE, floorTexture);

  // 2eme texture
  	glBindTexture(GL_TEXTURE_2D, TEXTURE_MOSAIC);
	texGLLoadRAW ("textures/tex3.raw", 96, 96, TEXMODE_SOLID, 1);
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	if(textureRenderMode == 0) {
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	} 
	if(textureRenderMode == 1) {
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	} 
	if(textureRenderMode == 2) {
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_LINEAR);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
	} 
    glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	// 3eme texture
  	glBindTexture(GL_TEXTURE_2D, TEXTURE_SPACE);
	texGLLoadRAW ("textures/a042.raw", 96, 96, TEXMODE_SOLID, 1);
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	if(textureRenderMode == 0) {
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	} 
	if(textureRenderMode == 1) {
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	} 
	if(textureRenderMode == 2) {
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_LINEAR);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
	} 
    glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	// 4eme texture
  	glBindTexture(GL_TEXTURE_2D, TEXTURE_FLOWERS);
	texGLLoadRAW ("textures/blue96.raw", 96, 96, TEXMODE_SOLID, 1);
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	if(textureRenderMode == 0) {
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	} 
	if(textureRenderMode == 1) {
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	} 
	if(textureRenderMode == 2) {
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_LINEAR);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
	} 
    glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

  // 5eme texture
	glBindTexture(GL_TEXTURE_2D, TEXTURE_LAVA);
	texGLLoadRAW ("textures/lavalamp_riot.raw", 200, 200, TEXMODE_SOLID, 1);
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	if(textureRenderMode == 0) {
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	} 
	if(textureRenderMode == 1) {
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	} 
	if(textureRenderMode == 2) {
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_LINEAR);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
	}
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

}

/******************************************************
 *                 Dessin du sol                      *
 ******************************************************/
void drawFloor(int useTexture, int num_texture)
{
	int i,j;
	float t = 0.0;
	glNormal3f(0,1,0);
	if (useTexture) {
    glEnable(GL_TEXTURE_2D);
	if (num_texture == 0) {
		glBindTexture(GL_TEXTURE_2D, TEXTURE_CARRE);
		t = 16.0;
	}
	else if (num_texture == 1){
		glBindTexture(GL_TEXTURE_2D, TEXTURE_MOSAIC);
		t = 4.0;
	}
	else if (num_texture == 2){
		glBindTexture(GL_TEXTURE_2D, TEXTURE_SPACE);
		t = 1.0;
	}
	else if (num_texture == 3){
		glBindTexture(GL_TEXTURE_2D, TEXTURE_FLOWERS);
		t = 2.0;
	}
	else if (num_texture == 4){
		glBindTexture(GL_TEXTURE_2D, TEXTURE_LAVA);
		t = 1.0;
	}

  }

  
  for (i=0; i<11; i++) {
	glBegin(GL_QUAD_STRIP);
	for (j=0; j<10; j++) {
		glTexCoord2f((i+1)/(float)(10)*t, j/(float)(10)*t);
		glVertex3f(-30+(i+1)*6,0,-30+j*6);
		glTexCoord2f(i/(float)(10)*t, j/(float)(10)*t);
		glVertex3f(-30+i*6,0,-30+j*6);
	}
	glEnd();
  }

  if (useTexture) {
    glDisable(GL_TEXTURE_2D);
  }

  glEnable(GL_LIGHTING);
}

/*************************************************************
 *   Creation de la matrice de projection pour l'ombre       *
 *************************************************************/
void shadowMatrix(GLfloat shadowMat[4][4],
  GLfloat groundplane[4],
  GLfloat lightpos[4])
{
  GLfloat dot;

  //Find dot product between light position vector and ground plane normal. 
  dot = groundplane[X] * lightpos[X] +
    groundplane[Y] * lightpos[Y] +
    groundplane[Z] * lightpos[Z] +
    groundplane[W] * lightpos[W];

  shadowMat[0][0] = dot - lightpos[X] * groundplane[X];
  shadowMat[1][0] = 0.f - lightpos[X] * groundplane[Y];
  shadowMat[2][0] = 0.f - lightpos[X] * groundplane[Z];
  shadowMat[3][0] = 0.f - lightpos[X] * groundplane[W];

  shadowMat[X][1] = 0.f - lightpos[Y] * groundplane[X];
  shadowMat[1][1] = dot - lightpos[Y] * groundplane[Y];
  shadowMat[2][1] = 0.f - lightpos[Y] * groundplane[Z];
  shadowMat[3][1] = 0.f - lightpos[Y] * groundplane[W];

  shadowMat[X][2] = 0.f - lightpos[Z] * groundplane[X];
  shadowMat[1][2] = 0.f - lightpos[Z] * groundplane[Y];
  shadowMat[2][2] = dot - lightpos[Z] * groundplane[Z];
  shadowMat[3][2] = 0.f - lightpos[Z] * groundplane[W];

  shadowMat[X][3] = 0.f - lightpos[W] * groundplane[X];
  shadowMat[1][3] = 0.f - lightpos[W] * groundplane[Y];
  shadowMat[2][3] = 0.f - lightpos[W] * groundplane[Z];
  shadowMat[3][3] = dot - lightpos[W] * groundplane[W];
}

/*****************************************************
 *       Equation du plan passant par 3 points       *
 *****************************************************/
void findPlane(GLfloat plane[4],
  GLfloat v0[3], GLfloat v1[3], GLfloat v2[3])
{
  GLfloat vec0[3], vec1[3];

  /* Need 2 vectors to find cross product. */
  vec0[X] = v1[X] - v0[X];
  vec0[Y] = v1[Y] - v0[Y];
  vec0[Z] = v1[Z] - v0[Z];

  vec1[X] = v2[X] - v0[X];
  vec1[Y] = v2[Y] - v0[Y];
  vec1[Z] = v2[Z] - v0[Z];

  /* find cross product to get A, B, and C of plane equation */
  plane[A] =   vec0[Y] * vec1[Z] - vec0[Z] * vec1[Y];
  plane[B] = -(vec0[X] * vec1[Z] - vec0[Z] * vec1[X]);
  plane[C] =   vec0[X] * vec1[Y] - vec0[Y] * vec1[X];

  plane[D] = -(plane[A] * v0[X] + plane[B] * v0[Y] + plane[C] * v0[Z]);
}


/*******************************************************
 *              Initialisation des lumires            *
 *******************************************************/
void initLights(void) 
{
  glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, 1);
//  glLightModelfv(GL_LIGHT_MODEL_AMBIENT, ambient);

  glLightfv(GL_LIGHT0, GL_DIFFUSE, lightColor[0]);
  glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);
  glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, 0.1);
  glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, 0.05);
  glEnable(GL_LIGHT0);

  glLightfv(GL_LIGHT1, GL_DIFFUSE, lightColor[1]);
  glLightfv(GL_LIGHT1, GL_SPECULAR, lightColor[1]);
  glLightf(GL_LIGHT1, GL_SHININESS, 50);
  glLightf(GL_LIGHT1, GL_CONSTANT_ATTENUATION, 0.1);
  glLightf(GL_LIGHT1, GL_LINEAR_ATTENUATION, 0.05);
  glEnable(GL_LIGHT1);

  glLightfv(GL_LIGHT2, GL_DIFFUSE, lightColor[2]);
  glLightf(GL_LIGHT2, GL_CONSTANT_ATTENUATION, 0.1);
  glLightf(GL_LIGHT2, GL_LINEAR_ATTENUATION, 0.05);
  glEnable(GL_LIGHT2);

  glEnable(GL_LIGHTING);

  glClearColor(0.3,0.4,1.0,1.0);
}

/*******************************************************
 *                  Polygon Offset                     *
 *******************************************************/

void checkPolygonOffset(void) {
#ifdef GL_VERSION_1_1
  if (supportsOneDotOne() && !forceExtension) {
    polygonOffsetVersion = ONE_DOT_ONE;
    glPolygonOffset(-2.0, -1.0);
  } else
#endif
  {
#ifdef GL_EXT_polygon_offset
  /* check for the polygon offset extension */
  if (glutExtensionSupported("GL_EXT_polygon_offset")) {
    polygonOffsetVersion = EXTENSION;
    glPolygonOffsetEXT(-0.1, -0.002);
	printf("\ndef GL_EXT_polygon_offset.\n");

  } else 
#endif
    {
      polygonOffsetVersion = MISSING;
      printf("\nScene: Missing polygon offset.\n");
      printf("         Expect shadow depth aliasing artifacts.\n\n");
    }
  }

}

int supportsOneDotOne(void)
{
  const char *version;
  int major, minor;

  version = (char *) glGetString(GL_VERSION);
  if (sscanf(version, "%d.%d", &major, &minor) == 2)
    return major >= 1 && minor >= 1;
  return 0;            /* OpenGL version string malformed! */
}

#ifdef __cplusplus
}
#endif
