/*
=============
Client / Server Demo

Author : Nate 'm|d' Miller
Date   : 9/02/99
Web    : http://members.home.com/vandals1
Email  : vandals1@home.com
=============
*/
#define TRUE                        1
#define FALSE                       0
#define PACKET_SIZE                 125 /* buffer size used for our packets */
#define SERVER_CHECK                100 /* how often should we check for new data? */

#include <conio.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include <winsock.h>

SOCKADDR_IN saServer; /* our address, used to bind to our socket */
clock_t ticker;
short port = 1369;
int sock;

/*
=============
getClock
=============
    Returns the clock cycles that have elapsed since this app has started.
*/
clock_t getClock (void)
{
    return clock ();
}
/*
=============
winsockInit
=============
    Initializes Winsock so that we can use it.  I just assume that Winsock 
Version 2.2 is on the computer.  If this fails for you change it.  This is one
of the many areas in the app where a good deal of work could be put it to 
ensure that the server will work with any version of Winsock or only versions
above a certain number.  My error checking here works, it just does not provide
any extended information about what went wrong.  
*/
int winsockInit (void)
{
    WORD version = MAKEWORD(2,2);
    WSADATA data;
    int ret;

    ret = WSAStartup (version, &data);
    
    if (ret != 0) /* There was an error in Winsock startup */
        return FALSE;

    return TRUE;
}
/*
=============
winsockClose
=============
    Cleans up Winsock.  
*/
void winsockClose (void)
{
    WSACleanup ();
}
/*
=============
socketCheck
=============
    This function queries a socket to see if there is data waiting to be read
off of it.  The socket is the paramater 'p'.  Here is another place where
extensive error checking would be done after select is called.  If select 
returns an error I just return FALSE from the function which isn't the correct
thing to do but it works.  There should be some sort of error checking and
handling here to see if exactly what is wrong with the socket that we just 
tried to check.  
*/
int socketCheck (int p)
{
	fd_set rread;
	struct timeval to;
	int sr;

	FD_ZERO (&rread);
	FD_SET (p, &rread);	

	memset (&to, 0, sizeof (to));

	to.tv_usec = 1;
	sr = select (1, &rread, NULL, NULL, &to);
 
	if (sr < 0) /* There was an error */
    	return FALSE;

	if (sr > 0)
		if (FD_ISSET (p,&rread))
			return TRUE;

	return FALSE;
}
/*
=============
serverInit
=============
    This function sets up the server so that it will have a socket on a
specific port.  I am using UDP for this example as you already know.  What is 
done here is first of all I create a specific type of socket, a UDP socket.  
After that I setup the address that this socket will be bound too by defining 
the address family, the IP address and the port.  After the setup I bind to 
this address.  Again there is plenty of room in this function for error 
checking.  You should check for errors after socket and after bind.  
*/
int serverInit (void)
{
    int ret;
    
    sock = socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    
    if (!sock) /* Error socket was not created */
        return FALSE;


    saServer.sin_family = AF_INET;
    saServer.sin_addr.s_addr = INADDR_ANY; 
    saServer.sin_port = htons (port);

    ret = bind (sock, (SOCKADDR *)&saServer, sizeof(SOCKADDR));

    if (ret) /* There was an error binding this socket */
        return FALSE;

    return TRUE;
}
/*
=============
serverHandleData
=============
    This function is called when there is data waiting on the servers socket to
be read.  Fist we call recvfrom to read the data off of the socket and then we
send the data right back to the client that sent it.  
*/
void serverHandleData (void)
{
    SOCKADDR from;
    char buffer[PACKET_SIZE];
    int bytesRead;
    int bytesSent;
    int len = sizeof (SOCKADDR);

    memset (buffer, '\0', PACKET_SIZE);

    bytesRead = recvfrom (sock, buffer, PACKET_SIZE, 0, &from, &len);

    /* 
        There was some sort of error.  This is normally happens when the buffer
        that we are reading into is too small for the data that is waiting.  
        Since the client application should not send data like this we assume 
        that it isn't from our client app and we just ignore the data.  Could
        be another error though, call WSAGetLastError () to be certain.
    */
    if (bytesRead == -1)
        return;
    
    printf ("Packet : \"%s\", %d bytes, ", buffer, bytesRead);

    bytesSent = sendto (sock, buffer, strlen (buffer), 0, (SOCKADDR *)&from, sizeof (SOCKADDR));

    printf ("echoed %d bytes back\n", bytesSent);
}
/*
=============
serverWork
=============
    This is the main loop of the application.  Here we loop until there is a 
keypress.  While we are looping we have a simple timer to check for data. 
Since this isn't a high performance server and time is not important we check 
for new data on our socket every SEVER_CHECK milliseconds.  By default it is
100.  After the timer has expired we check to first see if there is even data 
to be read.  If there isn't we reset the time and continue looping.  If there
is data we call out data handler function which will take care of the data.  
*/
void serverWork (void)
{
    clock_t now;

    ticker = getClock () + SERVER_CHECK;

    while (!_kbhit ())
    {
        now = getClock ();

        if (ticker < now)
        {
            if (socketCheck (sock))
                serverHandleData ();

            ticker = getClock () + SERVER_CHECK;
        }
    }
}
/*
=============
serverClose
=============
    Closes our socket.  
*/
void serverClose (void)
{
    closesocket (sock);
}
void main (void)
{
    winsockInit ();
    serverInit ();
    serverWork ();
    serverClose ();
    winsockClose ();
}