/*
=============
Client / Server Demo

Author : Nate 'm|d' Miller
Date   : 9/02/99
Web    : http://members.home.com/vandals1
Email  : vandals1@home.com
=============
*/
#define PACKET_SIZE                 125 /* buffer size used for our packets */
#define TRUE                        1
#define FALSE                       0
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <windows.h>
#include <winsock.h>

SOCKADDR_IN remote; /* remote address of our "server" */
short port = 1369;  /* port that we will be sending data on */
int sock;           /* our socket */

/*
=============
winsockInit
=============
    Initializes Winsock so that we can use it.  I just assume that Winsock 
Version 2.2 is on the computer.  If this fails for you change it.  This is one
of the many areas in the app where a good deal of work could be put in to 
ensure that the client will work with any version of Winsock or only versions
above a certain number.  My error checking here works, it just does not provide
any extended information about what went wrong.  
*/
int winsockInit (void)
{
    WORD version = MAKEWORD(2,2);
    WSADATA data;
    int ret;

    ret = WSAStartup (version, &data);

    if (data.wVersion != version)
    {	
        printf ("oh shit bad version\n");
        return FALSE;
    }
    return TRUE;
}
/*
=============
winsockClose
=============
    Cleans up Winsock.  
*/
void winsockClose (void)
{
    WSACleanup ();
}
/*
=============
clientInit
=============
    Here we create a UDP socket and we also try to resolve the hostname or IP 
that was entered.  Once the socket is created we fill our remote info in with
the info that we got from gethostbyname.  We need this info so that we know 
where to send our packets.  We do not create a dedicated connection with the 
server, that would be done using TCP not UDP.  
*/
int clientInit (void)
{
    LPHOSTENT hostentry;
    char serverName[255];

    printf ("Enter a IP or host to connect to : ");
    gets (serverName);

    hostentry = gethostbyname (serverName);

    if (hostentry == NULL)
    {
        printf ("error gethostbyname()\n");
        return FALSE;
    }	

    sock = socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP);

    if (sock == INVALID_SOCKET)
    {
        printf ("error socket()\n");
        return FALSE;
    }

    remote.sin_family = AF_INET;
    remote.sin_addr = *((LPIN_ADDR)*hostentry->h_addr_list);
    remote.sin_port = htons (port);	
    
    return TRUE;
}
/*
=============
clientWork
=============
    This is where everything is done for the client.  Here we loop and have the
user enter data.  Once the data has been entered we send it off to the server.  
After we send the data we wait for the server to respond to our data.  If the 
server never responds we will hang at the recvfrom call since it is blocking.  
A note about the input code below.  You CAN overflow the input buffer by typing
out more than PACKET_SIZE characters.  I didn't change this because this is 
just a example so it isn't all that important and also I don't feel like
writing an input handler for a client server demo.  Sorry about that, this is 
a demo on network programming not charater input :)  
*/
void clientWork (void)
{
    SOCKADDR from;
    char buffer[PACKET_SIZE];
    char inBuffer[PACKET_SIZE];
    int len = sizeof (SOCKADDR);
    int go = 1;

    printf ("Type \"quit\" to exit...\n");

    while (go)
    {
        memset (buffer, '\0', PACKET_SIZE);
        memset (inBuffer, '\0', PACKET_SIZE);

        printf ("Enter data : ");
        gets (buffer);
        
        if (!strcmp ("quit", buffer))
            go = 0;

        sendto (sock, buffer, strlen (buffer), 0, (SOCKADDR *)&remote, sizeof (SOCKADDR));
        
        recvfrom (sock, inBuffer, PACKET_SIZE, 0, &from, &len);

        printf ("Recieved %s back from server!\n\n", inBuffer);
    }
}
/*
=============
clientClose
=============
    Close our socket.  
*/
void clientClose (void)
{
    closesocket (sock);
}
void main (void)
{
    winsockInit ();
    clientInit ();
    clientWork ();
    clientClose ();
    winsockClose ();
}