/*
=============
OpenGL Tutor : Animation

Author  : Nate 'm|d' Miller
Date    : 8/27/99
Contact : vandals1@home.com
Web     : http://members.home.com/vandals1
=============

    This is just a simple example of animation using textures.  It should
render at about 30 fps which is what film and television run at from what I 
have been told.  Nothing fancy at all here, even the textures are bland :)
The animation is achieved by loading several textures and then cycling through
them at a specific interval.  The order in which the texture will be cycled is 
in 'frames'.  The variable 'redraw' tells the application how often to change
the current frame and update the screen with it.  'redraw' is a number in 
milliseconds.  

    If you want to compile this make sure that you have my glTexFont library.  
I used the library because its the best way to output text to the screen that I 
have and I would rather not use the GLUT font stuff.  Here are the libraries that
I linked too : msvcrt.lib opengl32.lib glu32.lib glut32.lib glTexFont.lib 

*/
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <GL/glut.h>
#include <glTexFont.h>
#include "tga.h"

static char *appName = "OpenGL Tutor : Animation";

int frames[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 7, 6, 5, 4, 3, 2, 1, 0};  /* the frames for our animation */
int numFrames = sizeof (frames) / sizeof (frames[0]); /* number of frames in the animation */

int winW = 640;
int winH = 480;
int frameIndex = 0; /* index to the current frame we are at */
int redraw = 33; /* how often do we redraw, every 33 milliseconds, can change */
int isAlive = 1; /* are we alive and animating? */
clock_t appTicker; /* used for animation timing */

/*
=============
getClock
=============
    Returns the processor time that has elapsed.  
*/
clock_t getClock (void)
{
    return clock ();
}
/*
=============
drawQuad
=============
    Draws a texture quad based on the current frame.
*/
void drawQuad (void)
{
    glBindTexture (GL_TEXTURE_2D, frames[frameIndex]);

    glColor4f (1.0f, 1.0f, 1.0f, 1.0f);

    glBegin (GL_QUADS);
        glTexCoord2f (0,0);
        glVertex2f (-100, -100);
        glTexCoord2f (1,0);
        glVertex2f (100, -100);
        glTexCoord2f (1,1);
        glVertex2f (100, 100);
        glTexCoord2f (0,1);
        glVertex2f (-100, 100);
    glEnd ();
}
/*
=============
glutDisplay
=============
    Our display function.
*/
void glutDisplay (void)
{
    glClear (GL_COLOR_BUFFER_BIT);

    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity ();

    drawQuad (); /* draw the simple quad */

    fontSize (14);
    fontColor (1, 1, 1);
    fontGradient ();
    fontGradientColor (0.25, 0.5, 0.5);
    fontDrawString (0, 90, "\t\tAnimation Rate is %d ms", redraw);
    fontDrawString (0, 36, "\t\t+\tIncrease animate rate\n\t\t-\tDecrease animate rate\n\t\tSpace to pause");

    glutSwapBuffers ();
}
/*
=============
gludIdleFunc
=============
    Function that is called when we are idle.  Advances the animation frame at 
the correct time.  
*/
void glutIdle (void)
{
    clock_t current = getClock ();

    if (current > appTicker && isAlive)
    {
        frameIndex ++;
        if (frameIndex >= numFrames)
            frameIndex = 0;

        glutPostRedisplay ();
        appTicker = getClock () + redraw;
    }
}
/*
=============
glutResize
=============
    Called when the window is resized.
*/
void glutResize (int w, int h)
{
    winW = w;
    winH = h;

    glViewport (0, 0, w, h);

    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();

    glOrtho (-w, w, -h, h, -1, 1);

    glutPostRedisplay ();
}
/*
=============
glutKeyboard
=============
    Handles our keyboard input.
*/
void glutKeyboard (unsigned char key, int x, int y)
{
    switch (key)
    {
        case '=':
            redraw --;

            if (redraw <= 0)
                redraw = 1;
        break;
        case '-':
            redraw ++;
        break;
        case ' ':
            isAlive = !isAlive;
        break;
    }
    glutPostRedisplay ();
}
/*
=============
glutAppInit
=============
    Called when the app starts.  Loads the frames of our animation and the font. 
The application ticker is also started.
*/
void glutAppInit (void)
{
    char imageName[25];
    int i;

    for (i = 0; i < 9; i ++)
    {
        sprintf (imageName, "frame0%d.tga", i);
        loadTGA (imageName, i);
    }

    fontLoad ("font.tga");

    glDisable (GL_DEPTH_TEST);     
    glEnable (GL_TEXTURE_2D);
    
    appTicker = getClock () + redraw;
}   
void main (void)
{
    glutInitDisplayMode (GLUT_RGB | GLUT_DOUBLE);
    glutInitWindowSize (winW, winH);
    glutCreateWindow (appName);
    glutDisplayFunc (glutDisplay);
    glutReshapeFunc (glutResize);
    glutIdleFunc (glutIdle);
    glutKeyboardFunc (glutKeyboard);

    glutAppInit ();
    
    glutMainLoop();
}