/*
	UConsole Demo Version 0.4
	Copyright 1999 by Nate 'm|d' Miller
	For non-commercial use only!

	File		-- main.c
	Author		-- Nate 'm|d' Miller
	Contact		-- vandals1@home.com
	Web			-- http://members.home.com/vandals1

	Notes
	-----
	* just a REALLY simple example on how to use the console
*/
#include "h.h"
#include "console.h"

int winW = 640;
int winH = 480;

typedef float vec3_t[3];

extern command_t table[];

#define VERTS 24
vec3_t cube[] = 
{
	{-10,-10,10},
	{10,-10,10},
	{10,10,10},
	{-10,10,10},

	{-10,-10,-10},
	{10,-10,-10},
	{10,10,-10},
	{-10,10,-10},

	{-10,-10,-10},
	{-10,-10,10},
	{-10,10,10},
	{-10,10,-10},

	{10,-10,-10},
	{10,-10,10},
	{10,10,10},
	{10,10,-10},

	{-10,10,10},
	{10,10,10},
	{10,10,-10},
	{-10,10,-10},

	{-10,-10,10},
	{10,-10,10},
	{10,-10,-10},
	{-10,-10,-10},
};

vec3_t colors[] = 
{
	{1,0,0},
	{0,1,0},
	{0,0,1},
	{1,1,0},
	{1,0,1},
	{0,1,1}
};

console_t con;
vec3_t rot = {0,0,0};
int ani = 1;
int fill = 1;

void glutResize (int w, int h)
{
	winW = w;
	winH = h;
	consoleResize (&con, w, h);
	glutPostRedisplay ();
}
void cubeDraw (void)
{
	int i;

	glBegin (GL_QUADS);
		for (i = 0; i < 24; i ++)
		{
			glColor3fv (colors[(i % 7)]);
			glVertex3fv (cube[i]);	
		}
	glEnd ();
}
void glutDisplay (void)
{
	// don't want a divide by zero
	if (!winH)
		return;
	glClear (GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
	glViewport (0, 0, winW, winH);

	glMatrixMode (GL_PROJECTION);
	glLoadIdentity ();
	gluPerspective (90, winW / winH, 1, 9999);
	glTranslatef (0,0,-30);
	glMatrixMode (GL_MODELVIEW);
	glLoadIdentity ();
	
	glRotatef (rot[0], 1.0, 0.0, 0.0);
	glRotatef (rot[1], 0.0, 1.0, 0.0);
	glRotatef (rot[2], 0.0, 0.0, 1.0);
	cubeDraw ();
	consoleDraw (&con);
	
	glutSwapBuffers ();
}
void glutKeyboard (unsigned char key, int x, int y)
{
	if (con.conState == DOWN)
	{
		if (key == con.conChar)
			if (!con.conAni)
				con.conAni = 1;

		consoleAddChar (&con, (char)key);
		glutPostRedisplay ();
		return;
	}
	switch (key)
	{
		case C_CONSOLECHAR:
			con.conAni = !con.conAni;
		break;
	}
	glutPostRedisplay ();
}
void glutSpecial (int key, int x, int y)
{
	switch (key)
	{
		case GLUT_KEY_UP:
			consoleHistoryRecall (&con);
		break;
		case GLUT_KEY_DOWN:
			consoleCommandLineClear (&con);
		break;
		case GLUT_KEY_PAGE_UP:
			consoleBufferMove (&con, UP);
		break;
		case GLUT_KEY_PAGE_DOWN:
			consoleBufferMove (&con, DOWN);
		break;
		case GLUT_KEY_HOME:
			consoleBufferMove (&con, HOME);
		break;
	}
}
void clamp (vec3_t v)
{
	int i;

	for (i = 0; i < 3; i ++)
		if (v[i] > 360)
			v[i] = 0;
}
void glutIdle (void)
{
	if (con.conAni)
	{
		consoleAnimate (&con);
		glutPostRedisplay ();
	}
	if (ani)
	{
		rot[0] += 0.75f;
		rot[1] -= 1.0f;
		rot[2] += 0.3f;
		clamp (rot);
		glutPostRedisplay ();
	}
}
void glInit (void)
{
	glClearColor (0,0,0,0);
	glEnable(GL_DEPTH_TEST);
	glPolygonMode (GL_FRONT_AND_BACK, GL_FILL);
}
// this is just a REALLY REALLY simple parser
void genericParse (int commandId, char *s)
{
	switch (commandId)
	{
		case C_ID_QUIT:
			exit (1);
		break;
		case C_ID_ABOUT:
			consoleBufferAdd (&con, "%s by Nate \'m|d\' Miller", C_APP);
		break;
		case C_ID_VERSION:
			consoleBufferAdd (&con, "Version: %f", C_VERSION);
		break;
		case C_ID_ECHO:
			consoleBufferAdd (&con, "%s", s);
		break;
		case C_ID_CLEAR:
			consoleClearBuffers (&con);
		break;
	}
}	
int isChars (char *s)
{
	// can only have 0-9
	for (; *s; *s ++)
		if (*s != '0' && *s != '1' && *s != '2' &&
			*s != '3' && *s != '4' && *s != '5' &&
			*s != '6' && *s != '7' && *s != '8' && *s != '9')
				return 1;
	return 0;
}
void toggleVarState (int commandId, char *s)
{
	int temp;

	if (s == NULL || isChars (s))
	{
		if (commandId == 0)
			consoleBufferAdd (&con, "\"ani\" is \"%d\"", ani);
		else if (commandId == 1) 
			consoleBufferAdd (&con, "\"fill\" is \"%d\"", fill);
		return;
	}
	
	temp = atoi (s);

	if (temp == 0 || temp == 1)
	{
		if (commandId == 0)
		{
			ani = temp;
			consoleBufferAdd (&con, "\"ani\" is \"%d\"", ani);
		} else if (commandId == 1) {
			fill = temp;
			if (fill)
				glPolygonMode (GL_FRONT_AND_BACK, GL_FILL);
			else glPolygonMode (GL_FRONT_AND_BACK, GL_LINE);
			consoleBufferAdd (&con, "\"fill\" is \"%d\"", fill);
		}
	}
}
void commandDump (int commandId, char *s)
{
	int i;

	consoleBufferAdd (&con, "Commands:");

	for (i = 0; i < consoleGetCommandNum (); i ++)
		consoleBufferAdd (&con, "%s", table[i].comm);
}
void main (void)
{
	glutInitDisplayMode (GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH);
	glutInitWindowSize (winW,winH);
	glutCreateWindow (C_APP);
	glutDisplayFunc (glutDisplay);
	glutReshapeFunc (glutResize);
	glutKeyboardFunc (glutKeyboard);
	glutSpecialFunc (glutSpecial);
	glutIdleFunc (glutIdle);
	glInit ();
	consoleInit (&con, winW, winH, glutDisplay, "font.tga", 13, "back.tga", 14);
	glutMainLoop();
}