/*-------------------------------------------------------------------

   Copyright (c) Ohio State University. All Rights Reserved.
   Zhiyuan Zhao    < zhao.29.osu.edu>
   Alan Saalfeld   < saalfeld.1@osu.edu>

   Department of Geodetic Science and Surveying
   Ohio State University, Columbus, OH 43210, U.S.A.

   06/19/1996  first version of Java
   10/09/1996  second version,  add Voronoi diagram
   10/17/1996  second version,  add node deletion
   11/10/1996  third version, change data structures

   Permission to use, copy, modify, and distribute this program for
   non-commercial purpose without fee is granted as long as this
   copyright note is included and an email is send to the authors

-------------------------------------------------------------------*/

import java.awt.*;
import java.applet.*;
import java.lang.*;
import java.util.*;
import java.io.*;



public class delaunay extends Applet

{
  DrawPad dp;
  Button bt_cl;
  Checkbox cb_pt,cb_tri,cb_vor,cb_cc;

  public void init()
    {
      setLayout(new BorderLayout());
      Panel p = new Panel();
      add("North", p);
      p.add(bt_cl=new Button("Reset"));
      p.add(cb_pt=new Checkbox("Show Nodes"));
      p.add(cb_tri=new Checkbox("Triangulation"));
      p.add(cb_cc=new Checkbox("Cercles circonscrits"));
      p.add(cb_vor=new Checkbox("Voronoi Diagramme"));
      add("Center",dp= new DrawPad());
      cb_pt.setState(true);
      cb_tri.setState(true);
      cb_vor.setState(true);
      cb_cc.setState(false);
    }

  public boolean action(Event e, Object o)
    {
      if(e.target==bt_cl) { dp.Clear(); return true; }
      if(e.target==cb_pt) { dp.showpt=!dp.showpt; dp.repaint(); return true; }
      if(e.target==cb_tri) { dp.showtri=!dp.showtri; dp.repaint(); return true; }
      if(e.target==cb_vor) { dp.showvor=!dp.showvor; dp.repaint(); return true; }
      if(e.target==cb_cc) { dp.showcir=!dp.showcir; dp.repaint(); return true; }
      return false;
    }

}



class DrawPad extends Panel
{
//    DelaunayT dt;
    WeatherMap dt;
    boolean showpt=true,showtri=true, showcir=false,showvor=true;

    public DrawPad()
      {
        dt=new WeatherMap(200);
        setBackground(Color.lightGray);
        System.out.println("lecture d un fichier nlle methode");
        dt.readNodesFronFile((String)"MapFile.dat"); 
      }

    public boolean mouseDown(Event e, int x, int y)
      {
        if(e.metaDown()) 
        {
        System.out.println("appel delete"); 
        dt.Delete(x,y); // destruction du noeud
        dt.WriteVRML("toto.wrl");
        }
        else {
        System.out.println("appel insert");
        dt.Insert(new Node(x,y)); //insertion d un nouveau noeud
 //       dt.Insert(x,y); //insertion d un nouveau noeud
        } 
        repaint();
        return true;
      }
 
    public boolean mouseUp(Event e, int x, int y)
      {
        System.out.println("appel insert");
        // if(e.metaDown())  dt.Insert(new Node(x,y));
        repaint();
        return true;
      }

    public void paint(Graphics g)
      {
        if(showcir==true) dt.DrawCircles(g,Color.green);
        if(showtri==true) dt.DrawTriangles(g,Color.yellow);
        if(showvor==true) dt.DrawVoronoiDigram(g,Color.blue);
        if(showpt==true)  dt.DrawPoints(g,Color.black);
      }

    void Clear() { dt.Clear(); repaint(); }

}



class Node extends Object

{
     int   x,y;       // coordonee X,Y
     Edge anEdge;     // arete commancant de ce noeud
     char  type;      // type du noeud 1: noeud interrieur, 2: sur l enveloppe convexe, 3: ...

     public Node() {this.x=0; this.y=0;anEdge=null;}
     public Node(int x, int y) {this.x=x; this.y=y;anEdge=null;}

     public Edge GetEdge() { return anEdge;}

     public double Distance(double px, double py)

       { double dx=px-x;

         double dy=py-y;

         return (Math.sqrt(dx*dx+dy*dy));

       }
  public int getX(){return x;}
  public int getY(){return y;}

}

class Node2D5 extends Node
// noeuds de la weatherMap
// classe des noeud 3D avec une info pour chaque jour
{
     double  Z[] ;       //  liste des coordonees Z

      Node2D5() 
     	{
		this.x=0;
		this.y=0;
		anEdge=null;
		Z=new double[365];
		for(int i=0;i<365;i++)
			Z[i]=0;
		}
      Node2D5(int x, int y,double[] dataZ,int nbData) 
     	{
		System.out.println("creation d un noeud");
		this.x=x;
		this.y=y;
		anEdge=null;
		Z=new double[nbData];
		for(int i=0;i<nbData;i++)
			Z[i]=dataZ[i];
		}


}


class Edge extends Object
{
     Node         p1,p2;         // Point de depart et de fin de l arete
     Edge         invE=null;     // inverse edge (p2->p1)
     Edge         nextE=null;    // arete suivante ds le triangle ds le sens anti-trigo
     Edge         nextH=null;    // lien a l enveloppe convexe
     Triangle     inT=null;      // triangle contenant l arete
     double a,b,c;               // parametres de l equation de droite. aX+bY+c=0

    public Edge(Node p1, Node p2) { Update(p1,p2); }

    public void Update(Node p1, Node p2) 
    	{ 
    	// affecattion des deux sommets
    	this.p1=p1; this.p2=p2;
    	// calcul des coeffs de la droite
    	 Setabc(); 
    	// Lie le premier sommet a la nouvelle arete 
    	 AsIndex(); }

    Node P1() { return p1;}

    Node P2() { return p2;}

    Edge InvE() { return invE;}

    Edge NextE() { return nextE;}

    Edge NextH() { return nextH;}

    Triangle Tri() { return inT;}

    void setNextE(Edge e) {nextE=e;}

    void setNextH(Edge e) {nextH=e;}

    void setTri(Triangle t) {inT=t;}

    void setInvE(Edge e) {invE=e;}

    Edge MakeSymm() { Edge e=new Edge(p2,p1); LinkSymm(e); return e; }

    void LinkSymm(Edge e) { this.invE=e; if(e!=null) e.invE=this; }

    public int onSide(Node nd)
       { double s=a*nd.x+b*nd.y+c;
         if(s>0.0) return 1;
         if(s<0.0) return -1;
         return 0;
       }

    void Setabc()   
    // set parameters of a,b,c
    // calcul l equation de la droite du segment
       { a=p2.y-p1.y; b=p1.x-p2.x; c=p2.x*p1.y-p1.x*p2.y; }

	// affecte cette arette au point p1
    void AsIndex()  { p1.anEdge=this;}

	// retourne l arete la plus a gauche
    Edge MostLeft()
       { Edge ee,e=this; // on part de l arrete courante
         while((ee=e.NextE().NextE().InvE())!=null && ee!=this) e=ee;
         return e.NextE().NextE();
       }

	// retourne l arete la plus a droite
    Edge MostRight()
       { Edge ee,e=this; // on part de l arrete courante
         while(e.InvE()!=null && (ee=e.InvE().NextE())!=this) e=ee;
         return e;
       }

	// retourne l arete suivante sur l enveloppe convexe
    Edge NextInHull()
       { Edge ee,e=this; // on part de l arrete courante
     //    while(e.InvE()!=null && (ee=e.InvE().NextE())!=this) e=ee;
         return e;
       }


   // dessin de l arete
    public void Draw(Graphics g) { g.drawLine(p1.x,p1.y,p2.x,p2.y); }

}



class Triangle extends Object
{
     Edge    anEdge;      // arete liant le triangle a la liste des aretes le formant
     double  c_cx;        // centre du cercle circonscrit: X
     double  c_cy;        // centre du cercle circonscrit: Y
     double  c_r;         // rayon du cercle

 	// construction avec trois aretes deja	 connues
     public  Triangle(Edge e1, Edge e2, Edge e3) {Update(e1,e2,e3);}

	// construction avec de nouvelles aretes
     public  Triangle(Vector edges, Edge e1, Edge e2, Edge e3)
       {
         Update(e1,e2,e3);
         edges.addElement(e1);
         edges.addElement(e2);
         edges.addElement(e3);
       }

     public void Update(Edge e1, Edge e2, Edge e3)
       {
     // mise a jour des aretes formant le triangle
     // on attache le triangle a la 1er arete
         anEdge=e1;
     // on chaine les trois aretes
         e1.setNextE(e2);
         e2.setNextE(e3);
         e3.setNextE(e1);
     // Pour chacune de ces aretes on les lie a ce triangle
         e1.setTri(this);
         e2.setTri(this);
         e3.setTri(this);
     // On recherche le cercle circonscrit a ce triangle
         FindCircle();
       }

	// retourne l arete de liant le triangle a la liste de ses aretes 
     public Edge GetEdge() { return anEdge;}

    // retourne si le noeud est includ dans le cercle circonsrit ou non
     boolean InCircle(Node nd) { return nd.Distance(c_cx,c_cy)<c_r; }

     void RemoveEdges(Vector edges)
    // destruction de la liste des aretes lors de la destruction du triangle
       {
         edges.removeElement(anEdge);
         edges.removeElement(anEdge.NextE());
         edges.removeElement(anEdge.NextE().NextE());
       }

     void FindCircle()
    // recherche du cercle circonscrit au triangle
       {
    // recuperation des coordonnees des sommets
         double x1=(double) anEdge.P1().x;
         double y1=(double) anEdge.P1().y;
         double x2=(double) anEdge.P2().x;
         double y2=(double) anEdge.P2().y;
         double x3=(double) anEdge.NextE().P2().x;
         double y3=(double) anEdge.NextE().P2().y;
 	// calcul des coeeficients du syteme a resoudre
         double a=(y2-y3)*(x2-x1)-(y2-y1)*(x2-x3);
         double a1=(x1+x2)*(x2-x1)+(y2-y1)*(y1+y2);
         double a2=(x2+x3)*(x2-x3)+(y2-y3)*(y2+y3);
	// resolution du systeme -> centre du cercle
         c_cx=(a1*(y2-y3)-a2*(y2-y1))/a/2;
         c_cy=(a2*(x2-x1)-a1*(x2-x3))/a/2;
    // rayon du cercle = distance centre a l un des sommets du triangle
         c_r=anEdge.P1().Distance(c_cx,c_cy);
       }

     public void DrawCircles(Graphics g)
     // dessin du cercle circonscrit au triangle
       {
		g.drawArc((int)(c_cx-c_r),(int)(c_cy-c_r),(int)(2*c_r),(int)(2*c_r),0,360);
 /*        int x0,y0,x,y;
         int angle;

         x0=(int)(c_cx+c_r);
         y0=(int)(c_cy);
         for(angle=0;angle<=360;angle++)
           {
             x=(int)(Math.cos(3.1415926/180.0*angle)*c_r+c_cx);
             y=(int)(Math.sin(3.1415926/180.0*angle)*c_r+c_cy);
             g.drawLine(x0,y0,x,y);
             x0=x; y0=y;
           }
  */     }
}



class DelaunayT
{
   Vector nodes;        // liste des noeuds
   Vector edges;        // liste des aretes
   Vector tris;         // liste des triangles
   Edge   hullStart;    // arete de depart de l'enveloppe convexe
   Edge   actE;

   public DelaunayT()
     {
       tris=new Vector(200);
       nodes=new Vector(3*200);
       edges=new Vector(3*200);
     }

   public DelaunayT(int size)
     {
       tris=new Vector(size);
       nodes=new Vector(3*size);
       edges=new Vector(3*size);
     }

   public void Clear()
     {
       nodes.removeAllElements();
       edges.removeAllElements();
       tris.removeAllElements();
     }

   public void Insert(int px, int py)
      {
      // passage des coo d un nouveau point
        int eid;
System.out.println("insertion");
     //on cree l'objet noeud (nd) et on l ajoute a sa liste
        Node nd=new Node(px,py);
        nodes.addElement(nd);

     // si on a moins de trois neouds ->on ne fait rien
        if(nodes.size()<3) return;
     // si on a trois noeud disponibles on construit le premier triangle
        if(nodes.size()==3)    // create the first triangle
          {
     // on prend les trois sommets
            Node p1=(Node)nodes.elementAt(0);
            Node p2=(Node)nodes.elementAt(1);
            Node p3=(Node)nodes.elementAt(2);
     // on cree les trois arretes du triangle 
            Edge e1=new Edge(p1,p2);
            if(e1.onSide(p3)==0) { nodes.removeElement(nd); return; }
            if(e1.onSide(p3)==-1)  // right side
              {
                p1=(Node)nodes.elementAt(1);
                p2=(Node)nodes.elementAt(0);
                e1.Update(p1,p2);
              }
            Edge e2=new Edge(p2,p3);
            Edge e3=new Edge(p3,p1);
     // mise a jour des arretes voisine (cycle du triangle)
            e1.setNextH(e2);
            e2.setNextH(e3);
            e3.setNextH(e1);
     // initialisation de l enveloppe convex sur la premiere arette
            hullStart=e1;
     // creation du premier triangle
            tris.addElement(new Triangle(edges,e1,e2,e3));
            return;
          }

     //  premiere arete de la liste
        actE=(Edge)edges.elementAt(0);

	// si l arete acte est voisine de la nouvelle (nd)
        if(actE.onSide(nd)==-1)
          { if(actE.InvE()==null) eid=-1;
            else eid=SearchEdge(actE.InvE(),nd);
          }
        else eid=SearchEdge(actE,nd);

        if(eid==0) { nodes.removeElement(nd); return; }

        if(eid>0) ExpandTri(actE,nd,eid);   // nd is inside or on a triangle
	        else ExpandHull(nd);                // nd is outside convex hull

      }

    public void Delete(int px, int py)
      {
        if(nodes.size()<=3) return;   // not allow deletion for only 1 triangle
        Node nd=Nearest((double)px,(double)py);
        if(nd==null) return;          // not found
        nodes.removeElement(nd);
        Edge e,ee,start;
        start=e=nd.GetEdge().MostRight();

        int nodetype=0;
        int idegree=-1;
        Edge index[]=new Edge[100];
        while(nodetype==0)
         {
           edges.removeElement(ee=e.NextE());
           index[++idegree]=ee;
           ee.AsIndex();
           tris.removeElement(e.Tri());   // delete triangles involved
           edges.removeElement(e);
           edges.removeElement(ee.NextE());
           e=ee.NextE().InvE();            // next left edge
           if(e==null) nodetype=2;         // nd on convex hull
           if(e==start) nodetype=1;        // inner node
         }

        // generate new triangles and add to triangulation
        int cur_i=0,cur_n=0;
        int last_n=idegree;
        Edge e1=null,e2=null,e3;
        while(last_n>=1)
          {
             e1=index[cur_i];
             e2=index[cur_i+1];
             if(last_n==2 && nodetype==1)
               {
                 tris.addElement(new Triangle(edges,e1,e2,index[2]));
                 SwapTest(e1);
                 SwapTest(e2);
                 SwapTest(index[2]);
                 break;
               }
             if(last_n==1 && nodetype==1)
               {
                 index[0].InvE().LinkSymm(index[1].InvE());
                 index[0].InvE().AsIndex();
                 index[1].InvE().AsIndex();
                 SwapTest(index[0].InvE());
                 break;
               }
             if(e1.onSide(e2.P2())==1)  // left side
               {
                 e3=new Edge(e2.P2(),e1.P1());
                 cur_i+=2;
                 index[cur_n++]=e3.MakeSymm();
                 tris.addElement(new Triangle(edges,e1,e2,e3));
                 SwapTest(e1);
                 SwapTest(e2);
               }
             else index[cur_n++]=index[cur_i++];
             if(cur_i==last_n) index[cur_n++]=index[cur_i++];
             if(cur_i==last_n+1)
               {
                 if(last_n==cur_n-1) break;
                 last_n=cur_n-1;
                 cur_i=cur_n=0;
               }
          }

        if(nodetype==2)   // reconstruct the convex hull
         {
           index[last_n].InvE().MostLeft().setNextH(hullStart=index[last_n].InvE());
           for(int i=last_n;i>0;i--)
             { index[i].InvE().setNextH(index[i-1].InvE());
               index[i].InvE().setInvE(null);
             }
           index[0].InvE().setNextH(start.NextH());
           index[0].InvE().setInvE(null);
         }
     }

   void ExpandTri(Edge e, Node nd, int type)
     {
       Edge e1=e;
       Edge e2=e1.NextE();
       Edge e3=e2.NextE();
       Node p1=e1.P1();
       Node p2=e2.P1();
       Node p3=e3.P1();
       if(type==2)    // nd is inside of the triangle
         {
          Edge e10=new Edge(p1,nd);
          Edge e20=new Edge(p2,nd);
          Edge e30=new Edge(p3,nd);
          e.Tri().RemoveEdges(edges);
          tris.removeElement(e.Tri());     // remove old triangle
          tris.addElement(new Triangle(edges,e1,e20,e10.MakeSymm()));
          tris.addElement(new Triangle(edges,e2,e30,e20.MakeSymm()));
          tris.addElement(new Triangle(edges,e3,e10,e30.MakeSymm()));
          SwapTest(e1);   // swap test for the three new triangles
          SwapTest(e2);
          SwapTest(e3);
         }
       else           // nd is on the edge e
         {
          Edge e4=e1.InvE();
          if(e4==null || e4.Tri()==null)           // one triangle involved
            {
              Edge e30=new Edge(p3,nd);
              Edge e02=new Edge(nd,p2);
              Edge e10=new Edge(p1,nd);
              Edge e03=e30.MakeSymm();
              e10.AsIndex();
              e1.MostLeft().setNextH(e10);
              e10.setNextH(e02);
              e02.setNextH(e1.NextH());
              hullStart=e02;
              tris.removeElement(e1.Tri());                   // remove oldtriangle               // add two new triangles
              edges.removeElement(e1);
              edges.addElement(e10);
              edges.addElement(e02);
              edges.addElement(e30);
              edges.addElement(e03);
              tris.addElement(new Triangle(e2,e30,e02));
              tris.addElement(new Triangle(e3,e10,e03));
              SwapTest(e2);   // swap test for the two new triangles
              SwapTest(e3);
              SwapTest(e30);
            }
          else         // two triangle involved
            {
              Edge e5=e4.NextE();
              Edge e6=e5.NextE();
              Node p4=e6.P1();
              Edge e10=new Edge(p1,nd);
              Edge e20=new Edge(p2,nd);
              Edge e30=new Edge(p3,nd);
              Edge e40=new Edge(p4,nd);
              tris.removeElement(e.Tri());                   // remove oldtriangle
              e.Tri().RemoveEdges(edges);
              tris.removeElement(e4.Tri());               // remove old triangle
              e4.Tri().RemoveEdges(edges);
              e5.AsIndex();   // because e, e4 removed, reset edge index of node p1 and p2
              e2.AsIndex();
              tris.addElement(new Triangle(edges,e2,e30,e20.MakeSymm()));
              tris.addElement(new Triangle(edges,e3,e10,e30.MakeSymm()));
              tris.addElement(new Triangle(edges,e5,e40,e10.MakeSymm()));
              tris.addElement(new Triangle(edges,e6,e20,e40.MakeSymm()));
              SwapTest(e2);   // swap test for the three new triangles
              SwapTest(e3);
              SwapTest(e5);
              SwapTest(e6);
              SwapTest(e10);
              SwapTest(e20);
              SwapTest(e30);
              SwapTest(e40);
            }
         }
     }

   void ExpandHull(Node nd)
     {
        Edge e1,e2,e3=null,enext;
        Edge e=hullStart;
        Edge comedge=null,lastbe=null;
        while(true)
          {
            enext=e.NextH();
            if(e.onSide(nd)==-1)   // right side
              {
                if(lastbe!=null)
                  {
                     e1=e.MakeSymm();
                     e2=new Edge(e.P1(),nd);
                     e3=new Edge(nd,e.P2());
                     if(comedge==null)
                       {
                         hullStart=lastbe;
                         lastbe.setNextH(e2);
                         lastbe=e2;
                       }
                     else comedge.LinkSymm(e2);
                     comedge=e3;
                     tris.addElement(new Triangle(edges,e1,e2,e3));
                     SwapTest(e);
                  }
              }
            else
              {
                if(comedge!=null) break;
                lastbe=e;
              }
            e=enext;
          }
        lastbe.setNextH(e3);
        e3.setNextH(e);
     }

   int SearchEdge(Edge e, Node nd)
// recherche d une arette
     {
      int f2,f3;
      Edge e0=null;

      if((f2=e.NextE().onSide(nd))==-1)
        { if(e.NextE().InvE()!=null) return SearchEdge(e.NextE().InvE(),nd);
          else { actE=e; return -1;}
        }
      if(f2==0) e0=e.NextE();
      Edge ee=e.NextE();
      if((f3=ee.NextE().onSide(nd))==-1)
        { if(ee.NextE().InvE()!=null) return SearchEdge(ee.NextE().InvE(),nd);
          else { actE=ee.NextE(); return -1;}
        }
      if(f3==0) e0=ee.NextE();
      if(e.onSide(nd)==0) e0=e;
      if(e0!=null)
        {
          actE=e0;
          if(e0.NextE().onSide(nd)==0) {actE=e0.NextE(); return 0;}
          if(e0.NextE().NextE().onSide(nd)==0) return 0;
          return 1;
        }
      actE=ee;
      return 2;
     }

   void SwapTest(Edge e11)
     {
       Edge e21=e11.InvE();
       if(e21==null || e21.Tri()==null) return;
       Edge e12=e11.NextE();
       Edge e13=e12.NextE();
       Edge e22=e21.NextE();
       Edge e23=e22.NextE();
       if(e11.Tri().InCircle(e22.P2()) || e21.Tri().InCircle(e12.P2()))
         {
           e11.Update(e22.P2(),e12.P2());
           e21.Update(e12.P2(),e22.P2());
           e11.LinkSymm(e21);
           e13.Tri().Update(e13,e22,e11);
           e23.Tri().Update(e23,e12,e21);
           e12.AsIndex();
           e22.AsIndex();
           SwapTest(e12);
           SwapTest(e22);
           SwapTest(e13);
           SwapTest(e23);
         }
     }

   Node Nearest(double x, double y)
     {
       // locate a node nearest to (px,py)
       double dismin=0.0,s;
       Node nd=null;

       for(int i=0;i<nodes.size();i++)
         {
           s=((Node)nodes.elementAt(i)).Distance(x,y);
           if(s<dismin||nd==null) { dismin=s;nd=(Node)nodes.elementAt(i);}
         }
       return nd;

     }

   public void DrawPoints(Graphics g, Color color)
     {
       g.setColor(color);
       for(int i=0;i<nodes.size();i++)
         g.drawRect(((Node)nodes.elementAt(i)).x-1,((Node)nodes.elementAt(i)).y-1,2,2);
     }

   public void DrawTriangles(Graphics g, Color color)
     {
       g.setColor(color);
       if(nodes.size()==1)
         g.drawRect(((Node)nodes.elementAt(0)).x,((Node)nodes.elementAt(0)).y,1,1);
       if(nodes.size()==2)
         g.drawLine(((Node)nodes.elementAt(0)).x,((Node)nodes.elementAt(0)).y,((Node)nodes.elementAt(1)).x,((Node)nodes.elementAt(1)).y);
       for (int i=0; i<edges.size(); i++) ((Edge)edges.elementAt(i)).Draw(g);
       for (int i=0; i<tris.size(); i++)
         { Triangle t=(Triangle)tris.elementAt(i);
           t.anEdge.Draw(g);
           t.anEdge.NextE().Draw(g);
           t.anEdge.NextE().NextE().Draw(g);
         }
     }
   public void DrawConvexHull(Graphics g, Color color)
   // affichage de l enveloppe convexe
     {
     Edge   temp=hullStart; // on part avec l arete de lien a l enveloppe convexe
       g.setColor(color);
		temp.Draw(g);
		
		while (temp.NextInHull() != hullStart)
		{
		(temp.NextInHull()).Draw(g);
		temp = temp.NextInHull();
		
		}
     }

   public void DrawCircles(Graphics g, Color color)
     {
       g.setColor(color);
       for(int i=0;i<tris.size();i++)  ((Triangle)tris.elementAt(i)).DrawCircles(g);
     }

   public void DrawVoronoiDigram(Graphics g, Color color)
     {
        g.setColor(color);
        double tcx,tcy;
        for (int i=0; i<edges.size(); i++)
          {
            Edge e = (Edge)edges.elementAt(i);
            Edge ee=e.InvE();
            if(ee==null || ee.Tri()==null)
              {
                tcx=e.Tri().c_cx-e.P2().y+e.P1().y;
                tcy=e.Tri().c_cy-e.P1().x+e.P2().x;
              }
           else
             {
               tcx=ee.Tri().c_cx;
               tcy=ee.Tri().c_cy;
             }
           g.drawLine((int)e.Tri().c_cx,(int)e.Tri().c_cy,(int)tcx,(int)tcy);
         }
     }
}

class WeatherMap extends DelaunayT
{
   public WeatherMap(int size)
     {
       super(size);
     }

	// methode generique d insertion d un noeud
   public void Insert(Node nd)
      {
        int eid;

	System.out.println("insertion d un noeud ds weatherMap");			    

     // On ajoute le noeud a la liste
        nodes.addElement(nd);

     // si on a moins de trois noeuds ->on ne fait rien
        if(nodes.size()<3) return;
     // si on a trois noeud disponibles on construit le premier triangle
        if(nodes.size()==3)    // create the first triangle
          {
     // on prend les trois sommets
            Node p1=(Node)nodes.elementAt(0);
            Node p2=(Node)nodes.elementAt(1);
            Node p3=(Node)nodes.elementAt(2);
     // on cree les trois arretes du triangle 
            Edge e1=new Edge(p1,p2);
            if(e1.onSide(p3)==0) { nodes.removeElement(nd); return; }
            if(e1.onSide(p3)==-1)  // right side
              {
                p1=(Node)nodes.elementAt(1);
                p2=(Node)nodes.elementAt(0);
                e1.Update(p1,p2);
              }
            Edge e2=new Edge(p2,p3);
            Edge e3=new Edge(p3,p1);
     // mise a jour des arretes voisine (cycle du triangle)
            e1.setNextH(e2);
            e2.setNextH(e3);
            e3.setNextH(e1);
     // initialisation de l enveloppe convex sur la premiere arette
            hullStart=e1;
     // creation du premier triangle
            tris.addElement(new Triangle(edges,e1,e2,e3));
            return;
          }
     //  premiere arete de la liste
        actE=(Edge)edges.elementAt(0);

	// si l arete acte est voisine de la nouvelle (nd)
        if(actE.onSide(nd)==-1)
          { if(actE.InvE()==null) eid=-1;
            else eid=SearchEdge(actE.InvE(),nd);
          }
        else eid=SearchEdge(actE,nd);

        if(eid==0) { nodes.removeElement(nd); return; }

        if(eid>0) ExpandTri(actE,nd,eid);   // nd is inside or on a triangle
	        else ExpandHull(nd);                // nd is outside convex hull

      }

	public void readNodesFronFile(String filename)
	{
	FileInputStream fis=null;
	StreamTokenizer st=null;

	int nbNoeuds=0;
	int nbMesures=0;
	int i,j;

	int x,y;
	double[] Zdata;
	Node2D5 nd;
	
	System.out.println("Lecture du fichier :"+ filename);
	System.out.println("Lecture AUTOMATIQUE :");

	try {fis = new FileInputStream(filename);}
	catch(FileNotFoundException e)
		{System.out.println("probleme");
		try{fis.close();} catch(IOException e1) {}
		System.exit(1);
		}

	System.out.println("TOKENNIZING :");
	st = new StreamTokenizer(fis);

	System.out.println("Ouverture ok affectaction des carracteristiques ");
	st.eolIsSignificant(false); // fin de ligne = separateur
	st.commentChar((int)'#');  // les lignes de commentaires commencent par #
	st.wordChars((int)'.',(int)'.');    // . fait partie des mots (double)
	st.whitespaceChars((int)';',(int)';');
	
	
	// lecture de l entete du fichier
	System.out.println("Lecture ENTETE :");
		try
			{
			System.out.println("1 terme :");
			st.nextToken();//st.nextToken();
			if (st.ttype== st.TT_NUMBER) nbNoeuds = (int)st.nval;
			System.out.println("nombre de noeuds "+ nbNoeuds);
			
			System.out.println("2 terme :");
			st.nextToken();//st.nextToken();
			if (st.ttype== st.TT_NUMBER) nbMesures = (int)st.nval;
			System.out.println("nombre de mesures "+ nbMesures);
			
			Zdata = new  double[nbMesures];

			// lecture des noeuds
			for(i=0;i<nbNoeuds;i++)
			  {
			    st.nextToken();
			    x = (int)st.nval;
			    System.out.println("x:"+st.nval);			    

			    st.nextToken();
			    y = (int)st.nval;
			    System.out.println("y:"+st.nval);
			    
			    for(j=0;j<nbMesures;j++)
			      {
				st.nextToken();
				Zdata[j] = st.nval;
				System.out.println("z:"+st.nval);	
			      }

			    //instanciation du nouveau noeud
			    nd = new Node2D5(x,y,Zdata,nbMesures); 
     	
			    // insertion du nouveau noeud
			    this.Insert(nd);
			    //this.repaint();
			  }
			}
		catch(IOException e) 
		{System.out.println("Erreur de lecture");}
		{try{fis.close();} catch(IOException e) {}}
	
	
	
	
	// fermeture du fichier
	try{fis.close();} catch(IOException e) {}
	}
	
	
public void WriteVRML(String filename)
  // ecriture du fichier VRML de base contenant la triangulation
	{
	FileOutputStream fis=null;
	PrintStream myOutput=null;
	
	try {
		fis = new FileOutputStream(filename);
		myOutput = new PrintStream(fis);
		}
	catch(IOException e)
		{System.out.println("probleme ECRITURE");
		System.exit(1);
		}
       	String ligneAEcrire;// containaire du texte
	int i1=0,i2=0,i3=0; // references des 3 sommets d un triangle
	
	
	// ecriture de l entete
	ligneAEcrire =(String)("#VRML V2.0 utf8\n");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("Group {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("    children [");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("	Shape {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("	    appearance Appearance {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		    material Material {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("			    diffuseColor 1.0 0.0 0.0");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("			}");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		}");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("	    geometry IndexedFaceSet {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		    coord Coordinate {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("# coordonnees des germes");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("			    point [");
	myOutput.println(ligneAEcrire);

	// ecriture des noeuds
       for(int i=0;i<nodes.size();i++)
	 {
ligneAEcrire =
(String)((double)(((Node)nodes.elementAt(i)).getX())+","+(double)(((Node)nodes.elementAt(i)).getY())+","+(double)20*(i%2)+",");
	myOutput.println(ligneAEcrire);
	 }
       // suite du code VRML
	ligneAEcrire =(String)("			    ]");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("			}");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		    color Color {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("			color [");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("			    1.0 0.0 0.0,");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		            0.0 1.0 0.0,");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		            0.0 0.0 1.0,");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		            1.0 1.0 0.0,");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		            0.0 1.0 1.0,");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		            1.0 0.0 1.0,");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		            1.0 1.0 1.0,");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		            0.5 0.5 0.5,");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		            1.0 0.2 0.0");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("			]");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		    }");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		    solid FALSE");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		    creaseAngle	0.5\n");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("# facette des triangles");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		    coordIndex	[ ");
	myOutput.println(ligneAEcrire);

	// ecriture des facettes
       for (int i=0; i<tris.size(); i++)
         { Triangle t=(Triangle)tris.elementAt(i);
	 // recherche des indexes des trois sommets
	   i1 = nodes.indexOf((Node)(t.anEdge.P1()),0);
	   i2 = nodes.indexOf((Node)(t.anEdge.P2()),0);
	   i3 = nodes.indexOf((Node)(((t.anEdge).NextE()).P2()),0);
	   // ecriture de la facette
	   ligneAEcrire =(String)(i1+","+i2+","+i3+","+(-1)+",");
	   myOutput.println(ligneAEcrire);
	 }
	ligneAEcrire =(String)("]");// fermeture de la liste des coo des facettes
	myOutput.println(ligneAEcrire);

	// ecriture du colorindex des facettes (meme couleur pour tt le monde
	ligneAEcrire =(String)("	    colorIndex	[");
	myOutput.println(ligneAEcrire);

       for (int i=0; i<tris.size(); i++)
         { ligneAEcrire =(String)(" 2, 2, 2, -1");
	   myOutput.println(ligneAEcrire);
	 }
	ligneAEcrire =(String)("]");// fermeture de la liste des couleurs des facettes
	myOutput.println(ligneAEcrire);

	ligneAEcrire =(String)("		}");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("	}");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("    ] ");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("} ");
	myOutput.println(ligneAEcrire);

	System.out.println("fin ecriture:");

	}
}

// ------- end of the file ------------------------------------------



