import java.awt.*;
import java.applet.*;
import java.lang.*;
import java.util.*;
import java.io.*;

public class WeatherMap extends DelaunayT
{
  int nbNoeuds;
  int nbMesures;
  int time;

   public WeatherMap(int size)
     {
       super(size);
       time=0;
       nbNoeuds=0;
       nbMesures=0;
     }

   public WeatherMap(int size,int startTime)
     {
       super(size);
       time=startTime;
     }

	// methode generique d insertion d un noeud
   public void Insert(Node nd)
      {
        int eid;

	System.out.println("insertion d un noeud ds weatherMap");			    

     // On ajoute le noeud a la liste
        nodes.addElement(nd);

     // si on a moins de trois noeuds ->on ne fait rien
        if(nodes.size()<3) return;
     // si on a trois noeud disponibles on construit le premier triangle
        if(nodes.size()==3)    // create the first triangle
          {
     // on prend les trois sommets
            Node p1=(Node)nodes.elementAt(0);
            Node p2=(Node)nodes.elementAt(1);
            Node p3=(Node)nodes.elementAt(2);
     // on cree les trois arretes du triangle 
            Edge e1=new Edge(p1,p2);
            if(e1.onSide(p3)==0) { nodes.removeElement(nd); return; }
            if(e1.onSide(p3)==-1)  // right side
              {
                p1=(Node)nodes.elementAt(1);
                p2=(Node)nodes.elementAt(0);
                e1.Update(p1,p2);
              }
            Edge e2=new Edge(p2,p3);
            Edge e3=new Edge(p3,p1);
     // mise a jour des arretes voisine (cycle du triangle)
            e1.setNextH(e2);
            e2.setNextH(e3);
            e3.setNextH(e1);
     // initialisation de l enveloppe convex sur la premiere arette
            hullStart=e1;
     // creation du premier triangle
            tris.addElement(new Triangle(edges,e1,e2,e3));
            return;
          }
     //  premiere arete de la liste
        actE=(Edge)edges.elementAt(0);

	// si l arete acte est voisine de la nouvelle (nd)
        if(actE.onSide(nd)==-1)
          { if(actE.InvE()==null) eid=-1;
            else eid=SearchEdge(actE.InvE(),nd);
          }
        else eid=SearchEdge(actE,nd);

        if(eid==0) { nodes.removeElement(nd); return; }

        if(eid>0) ExpandTri(actE,nd,eid);   // nd is inside or on a triangle
	        else ExpandHull(nd);                // nd is outside convex hull

      }

  public void readNodesFronFile(String filename)
	{
	FileInputStream fis=null;
	StreamTokenizer st=null;

	int i,j;

	int x,y;
	double[] Zdata;
	Node2D5 nd;
	
	System.out.println("Lecture du fichier :"+ filename);
	System.out.println("Lecture AUTOMATIQUE :");

	try {fis = new FileInputStream(filename);}
	catch(FileNotFoundException e)
		{System.out.println("probleme");
		try{fis.close();} catch(IOException e1) {}
		System.exit(1);
		}

	System.out.println("TOKENNIZING :");
	st = new StreamTokenizer(fis);

	System.out.println("Ouverture ok affectaction des carracteristiques ");
	st.eolIsSignificant(false); // fin de ligne = separateur
	st.commentChar((int)'#');  // les lignes de commentaires commencent par #
	st.wordChars((int)'.',(int)'.');    // . fait partie des mots (double)
	st.whitespaceChars((int)';',(int)';');
	
	
	// lecture de l entete du fichier
	System.out.println("Lecture ENTETE :");
		try
			{
			System.out.println("1 terme :");
			st.nextToken();//st.nextToken();
			if (st.ttype== st.TT_NUMBER) nbNoeuds = (int)st.nval;
			System.out.println("nombre de noeuds "+ nbNoeuds);
			
			System.out.println("2 terme :");
			st.nextToken();//st.nextToken();
			if (st.ttype== st.TT_NUMBER) nbMesures = (int)st.nval;
			System.out.println("nombre de mesures "+ nbMesures);
			
			Zdata = new  double[nbMesures];

			// lecture des noeuds
			for(i=0;i<nbNoeuds;i++)
			  {
			    st.nextToken();
			    x = (int)st.nval;
			    System.out.println("x:"+st.nval);			    

			    st.nextToken();
			    y = (int)st.nval;
			    System.out.println("y:"+st.nval);
			    
			    for(j=0;j<nbMesures;j++)
			      {
				st.nextToken();
				Zdata[j] = st.nval;
				System.out.println("z:"+st.nval);	
			      }

			    //instanciation du nouveau noeud
			    nd = new Node2D5(x,y,Zdata,nbMesures); 
     	
			    // insertion du nouveau noeud
			    this.Insert(nd);
			    //this.repaint();
			  }
			}
		catch(IOException e) 
		{System.out.println("Erreur de lecture");}
		{try{fis.close();} catch(IOException e) {}}
	
	
	
	
	// fermeture du fichier
	try{fis.close();} catch(IOException e) {}
	}
	
	
  public void WriteVRML(String filename)
  // ecriture du fichier VRML de base contenant la triangulation
	{
	FileOutputStream fis=null;
	PrintStream myOutput=null;
	
	try {
		fis = new FileOutputStream(filename);
		myOutput = new PrintStream(fis);
		}
	catch(IOException e)
		{System.out.println("probleme ECRITURE");
		System.exit(1);
		}
       	String ligneAEcrire;// contenaire du texte
	int i1=0,i2=0,i3=0; // references des 3 sommets d un triangle
	
	
	// ecriture de l entete
	ligneAEcrire =(String)("#VRML V2.0 utf8\n");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("WorldInfo {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("  title \"New node\"");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("}");
	myOutput.println(ligneAEcrire);


	ligneAEcrire =(String)("Viewpoint {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("   position 1 0 10");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("   orientation 0 1 0 0");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("}");
	myOutput.println(ligneAEcrire);

	ligneAEcrire =(String)("NavigationInfo {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("   type \"WALK\"");
	ligneAEcrire =(String)("   speed 5");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("}");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("");
	myOutput.println(ligneAEcrire);

	// DESCRIPTION LE L OBJET VRML
	// ecriture de l indexed face set
	ligneAEcrire =(String)("Group {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("    children [");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("	Shape {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("	    appearance Appearance {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		    material Material {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("			    diffuseColor 1.0 0.0 0.0");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("			}");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		}");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("	    geometry IndexedFaceSet {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		    coord Coordinate {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("# coordonnees des germes");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("			    point [");
	myOutput.println(ligneAEcrire);

	// ecriture des noeuds
       for(int i=0;i<nodes.size();i++)
	 {
ligneAEcrire =
(String)((double)(((Node)nodes.elementAt(i)).getX())+","+(double)(((Node)nodes.elementAt(i)).getY())+","
+(double)(((Node)nodes.elementAt(i)).getZAt(time))+",");
	myOutput.println(ligneAEcrire);
	 }
       // suite du code VRML
	ligneAEcrire =(String)("			    ]");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("			}");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		    color Color {");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("			color [");
	myOutput.println(ligneAEcrire);

	// ecriture la liste des couleurs: 1 couleur pour chaque noeud
       for(int i=0;i<nodes.size();i++)
	 {
	   //ligneAEcrire =(String)((double)(((((Node)nodes.elementAt(i)).getZAt(time)))/1000)+" 0.0 0.0,");
ligneAEcrire =(String)( (double)(((((Node)nodes.elementAt(i)).getZAt(time)))/1000)+" "+
(double)(1-((((Node)nodes.elementAt(i)).getZAt(time)))/1000)+" "+
(double)((((Node)nodes.elementAt(i)).getZAt(time))/1000)+",");
	myOutput.println(ligneAEcrire);
	 }


	ligneAEcrire =(String)("			]");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		    }");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		    solid FALSE");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		    creaseAngle	0.5\n");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("# facette des triangles");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("		    coordIndex	[ ");
	myOutput.println(ligneAEcrire);

	// ecriture des facettes
       for (int i=0; i<tris.size(); i++)
         { Triangle t=(Triangle)tris.elementAt(i);
	 // recherche des indexes des trois sommets
	   i1 = nodes.indexOf((Node)(t.anEdge.P1()),0);
	   i2 = nodes.indexOf((Node)(t.anEdge.P2()),0);
	   i3 = nodes.indexOf((Node)(((t.anEdge).NextE()).P2()),0);
	   // ecriture de la facette
	   ligneAEcrire =(String)(i1+","+i2+","+i3+","+(-1)+",");
	   myOutput.println(ligneAEcrire);
	 }
	ligneAEcrire =(String)("]");// fermeture de la liste des coo des facettes
	myOutput.println(ligneAEcrire);

	// ecriture du colorindex des facettes (meme couleur pour tt le monde
	ligneAEcrire =(String)("	    colorIndex	[");
	myOutput.println(ligneAEcrire);

	// ecriture des couleurs des sommets
       for (int i=0; i<tris.size(); i++)
         { Triangle t=(Triangle)tris.elementAt(i);
	 // recherche des indexes des trois sommets
	   i1 = nodes.indexOf((Node)(t.anEdge.P1()),0);
	   i2 = nodes.indexOf((Node)(t.anEdge.P2()),0);
	   i3 = nodes.indexOf((Node)(((t.anEdge).NextE()).P2()),0);
	   // ecriture des indexes de couleur = index des coo du sommet car une couleur par sommet
	   ligneAEcrire =(String)(i1+","+i2+","+i3+","+(-1)+",");
	   myOutput.println(ligneAEcrire);
	 }

/*       for (int i=0; i<tris.size(); i++)
         { ligneAEcrire =(String)(" 2, 2, 2, -1");
	   myOutput.println(ligneAEcrire);
	 }*/
	ligneAEcrire =(String)("]");// fermeture de la liste des couleurs des facettes
	myOutput.println(ligneAEcrire);

	ligneAEcrire =(String)("		}");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("	}");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("    ] ");
	myOutput.println(ligneAEcrire);
	ligneAEcrire =(String)("} ");
	myOutput.println(ligneAEcrire);

	System.out.println("fin ecriture:");

	}

public String buildVRMLString()
  // genere la String VRML permettant d instancier dynamiquement l indexedFace set
  {
       	String ligneAEcrire;// contenaire du texte
	int i1=0,i2=0,i3=0; // references des 3 sommets d un triangle


	ligneAEcrire =(String)("    children [\n");
	ligneAEcrire =ligneAEcrire +(String)("	Shape {\n");
	ligneAEcrire =ligneAEcrire +(String)("	    appearance Appearance {\n");
	ligneAEcrire =ligneAEcrire +(String)("		    material Material {\n");
	ligneAEcrire =ligneAEcrire +(String)("			    diffuseColor 1.0 0.0 0.0\n");
	ligneAEcrire =ligneAEcrire +(String)("			}\n");
	ligneAEcrire =ligneAEcrire +(String)("		}\n");
	ligneAEcrire =ligneAEcrire +(String)("	    geometry DEF WEATHERMAP IndexedFaceSet {\n");
	ligneAEcrire =ligneAEcrire +(String)("		    coord DEF WeatherMapGermes Coordinate {\n");
	ligneAEcrire =ligneAEcrire +(String)("# coordonnees des germes\n");
	ligneAEcrire =ligneAEcrire +(String)("			    point [\n");
	// ecriture des noeuds
       for(int i=0;i<nodes.size();i++)
	 {
ligneAEcrire =ligneAEcrire +
(String)((double)(((Node)nodes.elementAt(i)).getX())+","+(double)(((Node)nodes.elementAt(i)).getY())+","
+(double)(((Node)nodes.elementAt(i)).getZAt(time))+",\n");
	 }
       // suite du code VRML
	ligneAEcrire =ligneAEcrire +(String)("			    ]\n");	
        ligneAEcrire =ligneAEcrire +(String)("			}\n");	
	ligneAEcrire =ligneAEcrire +(String)("		    color Color {\n");
	ligneAEcrire =ligneAEcrire +(String)("			color [\n");
	

	// ecriture la liste des couleurs: 1 couleur pour chaque noeud
       for(int i=0;i<nodes.size();i++)
	 {
ligneAEcrire = ligneAEcrire + (String)((double)(((((Node)nodes.elementAt(i)).getZAt(time))+50)/100)+" 0.0 0.0,\n");
	
	 }
	ligneAEcrire = ligneAEcrire + (String)("			]\n");
	ligneAEcrire = ligneAEcrire + (String)("		    }\n");
	ligneAEcrire = ligneAEcrire + (String)("		    solid FALSE\n");
	ligneAEcrire = ligneAEcrire + (String)("		    creaseAngle	0.5\n\n");
	ligneAEcrire = ligneAEcrire + (String)("# facette des triangles\n");
	ligneAEcrire = ligneAEcrire + (String)("		    coordIndex	[ \n");
	

	// ecriture des facettes
       for (int i=0; i<tris.size(); i++)
         { Triangle t=(Triangle)tris.elementAt(i);
	 // recherche des indexes des trois sommets
	   i1 = nodes.indexOf((Node)(t.anEdge.P1()),0);
	   i2 = nodes.indexOf((Node)(t.anEdge.P2()),0);
	   i3 = nodes.indexOf((Node)(((t.anEdge).NextE()).P2()),0);
	   // ecriture de la facette
	   ligneAEcrire = ligneAEcrire + (String)(i1+","+i2+","+i3+","+(-1)+",\n");
	   
	 }
	ligneAEcrire = ligneAEcrire + (String)("]\n");// fermeture de la liste des coo des facettes
	

	// ecriture du colorindex des facettes (meme couleur pour tt le monde
	ligneAEcrire = ligneAEcrire + (String)("	    colorIndex	[\n");
	

	// ecriture des couleurs des sommets
       for (int i=0; i<tris.size(); i++)
         { Triangle t=(Triangle)tris.elementAt(i);
	 // recherche des indexes des trois sommets
	   i1 = nodes.indexOf((Node)(t.anEdge.P1()),0);
	   i2 = nodes.indexOf((Node)(t.anEdge.P2()),0);
	   i3 = nodes.indexOf((Node)(((t.anEdge).NextE()).P2()),0);
	   // ecriture des indexes de couleur = index des coo du sommet car une couleur par sommet
	   ligneAEcrire = ligneAEcrire + (String)(i1+","+i2+","+i3+","+(-1)+",\n");
	   
	 }

	ligneAEcrire = ligneAEcrire + (String)("]\n");// fermeture de la liste des couleurs des facettes	
	ligneAEcrire = ligneAEcrire + (String)("		}\n");	
	ligneAEcrire = ligneAEcrire + (String)("	}\n");	
	ligneAEcrire = ligneAEcrire + (String)("    ] \n");	
	

	System.out.println("fin de generation de la string:\n");
	return (ligneAEcrire);

  }

/*  public String getCOOAtTime(int time)
  {
       	String ligneAEcrire;// contenaire du texte
	int i1=0,i2=0,i3=0; // references des 3 sommets d un triangle
  }
*/
    public String GetCoordinatesAtTime(int time)
  {
       	String ligneAEcrire;// contenaire du texte

	ligneAEcrire =(String)("Coordinate {");
	ligneAEcrire =ligneAEcrire +(String)("point [");
	// ecriture des noeuds
       for(int i=0;i<nodes.size();i++)
	 {
ligneAEcrire =ligneAEcrire +
(String)((double)(((Node)nodes.elementAt(i)).getX())+","+(double)(((Node)nodes.elementAt(i)).getY())+","
+(double)(((Node)nodes.elementAt(i)).getZAt(time))+",");
	 }
       // suite du code VRML
	ligneAEcrire =ligneAEcrire +(String)("]}");	

	return(ligneAEcrire);
  }



    public String GetColorsOfCoordinatesAtTime(int time)
  {
       	String ligneAEcrire;// contenaire du texte

	ligneAEcrire =(String)("Color {color [");

	// ecriture la liste des couleurs: 1 couleur pour chaque noeud
       for(int i=0;i<nodes.size();i++)
	 {
	   //ligneAEcrire = ligneAEcrire + (String)((double)(((((Node)nodes.elementAt(i)).getZAt(time))+50)/100)+" 0.0 0.0,");
ligneAEcrire = ligneAEcrire + (String)( (double)(((((Node)nodes.elementAt(i)).getZAt(time))+50)/100)+" "+
(double)(1-((((Node)nodes.elementAt(i)).getZAt(time))+50)/100)+" "+
(double)((((Node)nodes.elementAt(i)).getZAt(time))+50)/1000+",");
	
	 }
	ligneAEcrire = ligneAEcrire + (String)("]}");
	return(ligneAEcrire);
  }

    public int[]  GetCoordinateIndexAtTime(int time)
  {
       	String ligneAEcrire;// contenaire du texte
	int j=0; // references des 3 sommets d un triangle
	int A[];


	A = new int[(tris.size()*4)];
	for (int i=0; i<tris.size(); i++)
	  { Triangle t=(Triangle)tris.elementAt(i);
	  // recherche des indexes des trois sommets
	  A[j++] = nodes.indexOf((Node)(t.anEdge.P1()),0);
	  A[j++] = nodes.indexOf((Node)(t.anEdge.P2()),0);
	  A[j++] = nodes.indexOf((Node)(((t.anEdge).NextE()).P2()),0);
	  A[j++] = -1;
	  }
	return(A);
  }


   public int[]  GetColorIndexAtTime(int time)
  {
    return(this.GetCoordinateIndexAtTime(time));
  }

   public int  GetNbMesures()
  {
    return(nbMesures);
  }


}
