import java.awt.*;
import java.applet.*;
import java.lang.*;
import java.util.*;
import java.io.*;

public class Triangle extends Object
{
     Edge    anEdge;      // arete liant le triangle a la liste des aretes le formant
     double  c_cx;        // centre du cercle circonscrit: X
     double  c_cy;        // centre du cercle circonscrit: Y
     double  c_r;         // rayon du cercle

 	// construction avec trois aretes deja	 connues
     public  Triangle(Edge e1, Edge e2, Edge e3) {Update(e1,e2,e3);}

	// construction avec de nouvelles aretes
     public  Triangle(Vector edges, Edge e1, Edge e2, Edge e3)
       {
         Update(e1,e2,e3);
         edges.addElement(e1);
         edges.addElement(e2);
         edges.addElement(e3);
       }

     public void Update(Edge e1, Edge e2, Edge e3)
       {
     // mise a jour des aretes formant le triangle
     // on attache le triangle a la 1er arete
         anEdge=e1;
     // on chaine les trois aretes
         e1.setNextE(e2);
         e2.setNextE(e3);
         e3.setNextE(e1);
     // Pour chacune de ces aretes on les lie a ce triangle
         e1.setTri(this);
         e2.setTri(this);
         e3.setTri(this);
     // On recherche le cercle circonscrit a ce triangle
         FindCircle();
       }

	// retourne l arete de liant le triangle a la liste de ses aretes 
     public Edge GetEdge() { return anEdge;}

    // retourne si le noeud est includ dans le cercle circonsrit ou non
     boolean InCircle(Node nd) { return nd.Distance(c_cx,c_cy)<c_r; }

     void RemoveEdges(Vector edges)
    // destruction de la liste des aretes lors de la destruction du triangle
       {
         edges.removeElement(anEdge);
         edges.removeElement(anEdge.NextE());
         edges.removeElement(anEdge.NextE().NextE());
       }

     void FindCircle()
    // recherche du cercle circonscrit au triangle
       {
    // recuperation des coordonnees des sommets
         double x1=(double) anEdge.P1().x;
         double y1=(double) anEdge.P1().y;
         double x2=(double) anEdge.P2().x;
         double y2=(double) anEdge.P2().y;
         double x3=(double) anEdge.NextE().P2().x;
         double y3=(double) anEdge.NextE().P2().y;
 	// calcul des coeeficients du syteme a resoudre
         double a=(y2-y3)*(x2-x1)-(y2-y1)*(x2-x3);
         double a1=(x1+x2)*(x2-x1)+(y2-y1)*(y1+y2);
         double a2=(x2+x3)*(x2-x3)+(y2-y3)*(y2+y3);
	// resolution du systeme -> centre du cercle
         c_cx=(a1*(y2-y3)-a2*(y2-y1))/a/2;
         c_cy=(a2*(x2-x1)-a1*(x2-x3))/a/2;
    // rayon du cercle = distance centre a l un des sommets du triangle
         c_r=anEdge.P1().Distance(c_cx,c_cy);
       }

     public void DrawCircles(Graphics g)
     // dessin du cercle circonscrit au triangle
       {
		g.drawArc((int)(c_cx-c_r),(int)(c_cy-c_r),(int)(2*c_r),(int)(2*c_r),0,360);
 /*        int x0,y0,x,y;
         int angle;

         x0=(int)(c_cx+c_r);
         y0=(int)(c_cy);
         for(angle=0;angle<=360;angle++)
           {
             x=(int)(Math.cos(3.1415926/180.0*angle)*c_r+c_cx);
             y=(int)(Math.sin(3.1415926/180.0*angle)*c_r+c_cy);
             g.drawLine(x0,y0,x,y);
             x0=x; y0=y;
           }
  */     }
}
