import vrml.*;
import vrml.field.*;
import vrml.node.*;
import java.awt.*;
import java.applet.*;
import java.lang.*;
import java.lang.SecurityManager;
import java.util.*;
import java.io.*;

import java.lang.LaxSecurityManager;


public class NoeudJava extends Script{

  private Browser myBrowser;
  private BaseNode myNode[];
  private int x = 3;
  

  private SFBool action;
  private MFNode nodes;


  public WeatherMap wm;         // lien avec la classe weather map
  private SFNode coordonnees;   // champs liste des points a mettre a jour (VRML)
  private SFNode couleurs;      // champs liste des couleurs a mettre a jour (VRML)
  private MFInt32 couleursIndex;
  private MFInt32 facettesIndex;
  private int time=0;
  private int nbMes=0;


  public void initialize() {
 
   System.out.println("Initialisation du noeud java .");

    myBrowser = getBrowser();
    nodes = (MFNode)getEventOut("NewNode");
   	
    // les deux lignes suivante permettent de charger de nouvelles classes
    // dans ce #$%!!?? de Liquid Reality....
    // lots of thanks to Cyril Demurcia and Michael Niemaz !!!!! 
    SecurityManager sm = new LaxSecurityManager();
    System.setSecurityManager(sm);

    // initialisation et chargement des noeuds de la triangulation
    wm = new WeatherMap(200);
    System.out.println("lecture d un fichier nlle methode");
    wm.readNodesFronFile((String)"MapFile2.dat"); 


    // COORDONNEEES
    coordonnees = (SFNode) getEventOut("set_coord");
    try {
      System.out.println("NoeudJava: String de coordonnees.");
      myNode = myBrowser.createVrmlFromString(wm.GetCoordinatesAtTime(time));
    }
    catch (InvalidVRMLSyntaxException e) 
      {
	System.out.println("vrml.InvalidVRMLSyntaxException");
	return;
      }
    coordonnees.setValue(myNode[0]);

    // COLORS
    couleurs = (SFNode) getEventOut("set_color");
    try {
      System.out.println("NoeudJava: String de couleurs.");
      myNode = myBrowser.createVrmlFromString(wm.GetColorsOfCoordinatesAtTime(time));
    } 
    catch (InvalidVRMLSyntaxException e) 
      {
	System.out.println("vrml.InvalidVRMLSyntaxException");
	return;
      }
    couleurs.setValue(myNode[0]);

    // COORD INDEX
    System.out.println("NoeudJava: indexe des coordonnees.");
    facettesIndex = (MFInt32) getEventOut("set_coordIndex");
     facettesIndex.setValue(wm.GetCoordinateIndexAtTime(time));

    // COLORS INDEX
    System.out.println("NoeudJava: index des  couleurs.");
    couleursIndex = (MFInt32) getEventOut("set_colorIndex");
    couleursIndex.setValue(wm.GetColorIndexAtTime(time));

    nbMes = wm.GetNbMesures();
    System.out.println("NoeudJava: time:"+time+" mbMesures:"+nbMes);
    System.out.println("NoeudJava: initialize() done.");
  }



  public void processEvent(vrml.Event event) 
  {

    System.out.println("NoeudJava: processEvent() "+event.getName());
    System.out.println("NoeudJava: ENTREE processEvent : time"+time+" mbMesures:"+nbMes);

    if (event.getName().equals("actionUP")) 
      { 
	time = (time==(nbMes-1)) ? 0 : time+1;
      }
    if (event.getName().equals("actionDOWN"))  
      {
	time = (time==0) ? (nbMes-1) : time-1;
      }
    if (event.getName().equals("actionZAP"))
      {
	time = (time==(nbMes-1)) ? 0 : time+1;
      }
    // COORDONNEEES
	coordonnees = (SFNode) getEventOut("set_coord");
	try {
	  System.out.println("NoeudJava: String de coordonnees.");
	  myNode = myBrowser.createVrmlFromString(wm.GetCoordinatesAtTime(time));
	}
	catch (InvalidVRMLSyntaxException e) 
	  {
	    System.out.println("vrml.InvalidVRMLSyntaxException");
	    return;
	  }
	coordonnees.setValue(myNode[0]);
	
	// COLORS
	couleurs = (SFNode) getEventOut("set_color");
	try {
	  System.out.println("NoeudJava: String de couleurs.");
	  myNode = myBrowser.createVrmlFromString(wm.GetColorsOfCoordinatesAtTime(time));
	} 
	catch (InvalidVRMLSyntaxException e) 
	  {
	    System.out.println("vrml.InvalidVRMLSyntaxException");
	    return;
	  }
	couleurs.setValue(myNode[0]);
      
    System.out.println("NoeudJava: SORTIE processEvent time:"+ time+" mbMesures:"+nbMes);
    if (event.getName().equals("actionZAP")) 
      {
	System.out.println("NoeudJava: appel de ZAPOUT.");
	((SFBool)getEventOut("actionZAPOUT")).setValue(true);
      }
    System.out.println("NoeudJava: processEvent() done.");
  }

}
