import java.awt.*;
import java.applet.*;
import java.lang.*;
import java.util.*;
import java.io.*;

public class Edge extends Object
{
     Node         p1,p2;         // Point de depart et de fin de l arete
     Edge         invE=null;     // inverse edge (p2->p1)
     Edge         nextE=null;    // arete suivante ds le triangle ds le sens anti-trigo
     Edge         nextH=null;    // lien a l enveloppe convexe
     Triangle     inT=null;      // triangle contenant l arete
     double a,b,c;               // parametres de l equation de droite. aX+bY+c=0

    public Edge(Node p1, Node p2) { Update(p1,p2); }

    public void Update(Node p1, Node p2) 
    	{ 
    	// affecattion des deux sommets
    	this.p1=p1; this.p2=p2;
    	// calcul des coeffs de la droite
    	 Setabc(); 
    	// Lie le premier sommet a la nouvelle arete 
    	 AsIndex(); }

    Node P1() { return p1;}

    Node P2() { return p2;}

    Edge InvE() { return invE;}

    Edge NextE() { return nextE;}

    Edge NextH() { return nextH;}

    Triangle Tri() { return inT;}

    void setNextE(Edge e) {nextE=e;}

    void setNextH(Edge e) {nextH=e;}

    void setTri(Triangle t) {inT=t;}

    void setInvE(Edge e) {invE=e;}

    Edge MakeSymm() { Edge e=new Edge(p2,p1); LinkSymm(e); return e; }

    void LinkSymm(Edge e) { this.invE=e; if(e!=null) e.invE=this; }

    public int onSide(Node nd)
       { double s=a*nd.x+b*nd.y+c;
         if(s>0.0) return 1;
         if(s<0.0) return -1;
         return 0;
       }

    void Setabc()   
    // set parameters of a,b,c
    // calcul l equation de la droite du segment
       { a=p2.y-p1.y; b=p1.x-p2.x; c=p2.x*p1.y-p1.x*p2.y; }

	// affecte cette arette au point p1
    void AsIndex()  { p1.anEdge=this;}

	// retourne l arete la plus a gauche
    Edge MostLeft()
       { Edge ee,e=this; // on part de l arrete courante
         while((ee=e.NextE().NextE().InvE())!=null && ee!=this) e=ee;
         return e.NextE().NextE();
       }

	// retourne l arete la plus a droite
    Edge MostRight()
       { Edge ee,e=this; // on part de l arrete courante
         while(e.InvE()!=null && (ee=e.InvE().NextE())!=this) e=ee;
         return e;
       }

	// retourne l arete suivante sur l enveloppe convexe
    Edge NextInHull()
       { Edge ee,e=this; // on part de l arrete courante
     //    while(e.InvE()!=null && (ee=e.InvE().NextE())!=this) e=ee;
         return e;
       }


   // dessin de l arete
    public void Draw(Graphics g) { 
      if ((p1.type()==2) && (p2.type()==2)) g.setColor(Color.red);
                                      else  g.setColor(Color.yellow);
      g.drawLine(p1.x,p1.y,p2.x,p2.y); 
	}

}
