import java.awt.*;
import java.applet.*;
import java.lang.*;
import java.util.*;
import java.io.*;


public class DelaunayT extends Object
{
   Vector nodes;        // liste des noeuds
   Vector edges;        // liste des aretes
   Vector tris;         // liste des triangles
   Edge   hullStart;    // arete de depart de l'enveloppe convexe
   Edge   actE;

   public DelaunayT()
     {
       tris=new Vector(200);
       nodes=new Vector(3*200);
       edges=new Vector(3*200);
     }

   public DelaunayT(int size)
     {
       tris=new Vector(size);
       nodes=new Vector(3*size);
       edges=new Vector(3*size);
     }

   public void Clear()
     {
       nodes.removeAllElements();
       edges.removeAllElements();
       tris.removeAllElements();
     }

   public void Insert(int px, int py)
      {
      // passage des coo d un nouveau point
        int eid;
System.out.println("insertion");
     //on cree l'objet noeud (nd) et on l ajoute a sa liste
        Node nd=new Node(px,py);
        nodes.addElement(nd);

     // si on a moins de trois neouds ->on ne fait rien
        if(nodes.size()<3) return;
     // si on a trois noeud disponibles on construit le premier triangle
        if(nodes.size()==3)    // create the first triangle
          {
     // on prend les trois sommets
            Node p1=(Node)nodes.elementAt(0);
            Node p2=(Node)nodes.elementAt(1);
            Node p3=(Node)nodes.elementAt(2);
     // on cree les trois arretes du triangle 
            Edge e1=new Edge(p1,p2);
            if(e1.onSide(p3)==0) { nodes.removeElement(nd); return; }
            if(e1.onSide(p3)==-1)  // right side
              {
                p1=(Node)nodes.elementAt(1);
                p2=(Node)nodes.elementAt(0);
                e1.Update(p1,p2);
              }
            Edge e2=new Edge(p2,p3);
            Edge e3=new Edge(p3,p1);
     // mise a jour des arretes voisine (cycle du triangle)
            e1.setNextH(e2);
            e2.setNextH(e3);
            e3.setNextH(e1);
     // initialisation de l enveloppe convex sur la premiere arette
            hullStart=e1;
     // creation du premier triangle
            tris.addElement(new Triangle(edges,e1,e2,e3));
            return;
          }

     //  premiere arete de la liste
        actE=(Edge)edges.elementAt(0);

	// si l arete acte est voisine de la nouvelle (nd)
        if(actE.onSide(nd)==-1)
          { if(actE.InvE()==null) eid=-1;
            else eid=SearchEdge(actE.InvE(),nd);
          }
        else eid=SearchEdge(actE,nd);

        if(eid==0) { nodes.removeElement(nd); return; }

        if(eid>0) ExpandTri(actE,nd,eid);   // nd is inside or on a triangle
	        else ExpandHull(nd);                // nd is outside convex hull

      }

    public void Delete(int px, int py)
      {
        if(nodes.size()<=3) return;   // not allow deletion for only 1 triangle
        Node nd=Nearest((double)px,(double)py);
        if(nd==null) return;          // not found
        nodes.removeElement(nd);
        Edge e,ee,start;
        start=e=nd.GetEdge().MostRight();

        int nodetype=0;
        int idegree=-1;
        Edge index[]=new Edge[100];
        while(nodetype==0)
         {
           edges.removeElement(ee=e.NextE());
           index[++idegree]=ee;
           ee.AsIndex();
           tris.removeElement(e.Tri());   // delete triangles involved
           edges.removeElement(e);
           edges.removeElement(ee.NextE());
           e=ee.NextE().InvE();            // next left edge
           if(e==null) nodetype=2;         // nd on convex hull
           if(e==start) nodetype=1;        // inner node
         }

        // generate new triangles and add to triangulation
        int cur_i=0,cur_n=0;
        int last_n=idegree;
        Edge e1=null,e2=null,e3;
        while(last_n>=1)
          {
             e1=index[cur_i];
             e2=index[cur_i+1];
             if(last_n==2 && nodetype==1)
               {
                 tris.addElement(new Triangle(edges,e1,e2,index[2]));
                 SwapTest(e1);
                 SwapTest(e2);
                 SwapTest(index[2]);
                 break;
               }
             if(last_n==1 && nodetype==1)
               {
                 index[0].InvE().LinkSymm(index[1].InvE());
                 index[0].InvE().AsIndex();
                 index[1].InvE().AsIndex();
                 SwapTest(index[0].InvE());
                 break;
               }
             if(e1.onSide(e2.P2())==1)  // left side
               {
                 e3=new Edge(e2.P2(),e1.P1());
                 cur_i+=2;
                 index[cur_n++]=e3.MakeSymm();
                 tris.addElement(new Triangle(edges,e1,e2,e3));
                 SwapTest(e1);
                 SwapTest(e2);
               }
             else index[cur_n++]=index[cur_i++];
             if(cur_i==last_n) index[cur_n++]=index[cur_i++];
             if(cur_i==last_n+1)
               {
                 if(last_n==cur_n-1) break;
                 last_n=cur_n-1;
                 cur_i=cur_n=0;
               }
          }

        if(nodetype==2)   // reconstruct the convex hull
         {
           index[last_n].InvE().MostLeft().setNextH(hullStart=index[last_n].InvE());
           for(int i=last_n;i>0;i--)
             { index[i].InvE().setNextH(index[i-1].InvE());
               index[i].InvE().setInvE(null);
             }
           index[0].InvE().setNextH(start.NextH());
           index[0].InvE().setInvE(null);
         }
     }

   void ExpandTri(Edge e, Node nd, int type)
     {
       Edge e1=e;
       Edge e2=e1.NextE();
       Edge e3=e2.NextE();
       Node p1=e1.P1();
       Node p2=e2.P1();
       Node p3=e3.P1();
       if(type==2)    // nd is inside of the triangle
         {
          Edge e10=new Edge(p1,nd);
          Edge e20=new Edge(p2,nd);
          Edge e30=new Edge(p3,nd);
          e.Tri().RemoveEdges(edges);
          tris.removeElement(e.Tri());     // remove old triangle
          tris.addElement(new Triangle(edges,e1,e20,e10.MakeSymm()));
          tris.addElement(new Triangle(edges,e2,e30,e20.MakeSymm()));
          tris.addElement(new Triangle(edges,e3,e10,e30.MakeSymm()));
          SwapTest(e1);   // swap test for the three new triangles
          SwapTest(e2);
          SwapTest(e3);
         }
       else           // nd is on the edge e
         {
          Edge e4=e1.InvE();
          if(e4==null || e4.Tri()==null)           // one triangle involved
            {
              Edge e30=new Edge(p3,nd);
              Edge e02=new Edge(nd,p2);
              Edge e10=new Edge(p1,nd);
              Edge e03=e30.MakeSymm();
              e10.AsIndex();
              e1.MostLeft().setNextH(e10);
              e10.setNextH(e02);
              e02.setNextH(e1.NextH());
              hullStart=e02;
              tris.removeElement(e1.Tri());                   // remove oldtriangle               // add two new triangles
              edges.removeElement(e1);
              edges.addElement(e10);
              edges.addElement(e02);
              edges.addElement(e30);
              edges.addElement(e03);
              tris.addElement(new Triangle(e2,e30,e02));
              tris.addElement(new Triangle(e3,e10,e03));
              SwapTest(e2);   // swap test for the two new triangles
              SwapTest(e3);
              SwapTest(e30);
            }
          else         // two triangle involved
            {
              Edge e5=e4.NextE();
              Edge e6=e5.NextE();
              Node p4=e6.P1();
              Edge e10=new Edge(p1,nd);
              Edge e20=new Edge(p2,nd);
              Edge e30=new Edge(p3,nd);
              Edge e40=new Edge(p4,nd);
              tris.removeElement(e.Tri());                   // remove oldtriangle
              e.Tri().RemoveEdges(edges);
              tris.removeElement(e4.Tri());               // remove old triangle
              e4.Tri().RemoveEdges(edges);
              e5.AsIndex();   // because e, e4 removed, reset edge index of node p1 and p2
              e2.AsIndex();
              tris.addElement(new Triangle(edges,e2,e30,e20.MakeSymm()));
              tris.addElement(new Triangle(edges,e3,e10,e30.MakeSymm()));
              tris.addElement(new Triangle(edges,e5,e40,e10.MakeSymm()));
              tris.addElement(new Triangle(edges,e6,e20,e40.MakeSymm()));
              SwapTest(e2);   // swap test for the three new triangles
              SwapTest(e3);
              SwapTest(e5);
              SwapTest(e6);
              SwapTest(e10);
              SwapTest(e20);
              SwapTest(e30);
              SwapTest(e40);
            }
         }
     }

   void ExpandHull(Node nd)
     {
        Edge e1,e2,e3=null,enext;
        Edge e=hullStart;
        Edge comedge=null,lastbe=null;
        while(true)
          {
            enext=e.NextH();
            if(e.onSide(nd)==-1)   // right side
              {
                if(lastbe!=null)
                  {
                     e1=e.MakeSymm();
                     e2=new Edge(e.P1(),nd);
                     e3=new Edge(nd,e.P2());
                     if(comedge==null)
                       {
                         hullStart=lastbe;
                         lastbe.setNextH(e2);
                         lastbe=e2;
                       }
                     else comedge.LinkSymm(e2);
                     comedge=e3;
                     tris.addElement(new Triangle(edges,e1,e2,e3));
                     SwapTest(e);
                  }
              }
            else
              {
                if(comedge!=null) break;
                lastbe=e;
              }
            e=enext;
          }
        lastbe.setNextH(e3);
        e3.setNextH(e);
     }

   int SearchEdge(Edge e, Node nd)
// recherche d une arette
     {
      int f2,f3;
      Edge e0=null;

      if((f2=e.NextE().onSide(nd))==-1)
        { if(e.NextE().InvE()!=null) return SearchEdge(e.NextE().InvE(),nd);
          else { actE=e; return -1;}
        }
      if(f2==0) e0=e.NextE();
      Edge ee=e.NextE();
      if((f3=ee.NextE().onSide(nd))==-1)
        { if(ee.NextE().InvE()!=null) return SearchEdge(ee.NextE().InvE(),nd);
          else { actE=ee.NextE(); return -1;}
        }
      if(f3==0) e0=ee.NextE();
      if(e.onSide(nd)==0) e0=e;
      if(e0!=null)
        {
          actE=e0;
          if(e0.NextE().onSide(nd)==0) {actE=e0.NextE(); return 0;}
          if(e0.NextE().NextE().onSide(nd)==0) return 0;
          return 1;
        }
      actE=ee;
      return 2;
     }

   void SwapTest(Edge e11)
     {
       Edge e21=e11.InvE();
       if(e21==null || e21.Tri()==null) return;
       Edge e12=e11.NextE();
       Edge e13=e12.NextE();
       Edge e22=e21.NextE();
       Edge e23=e22.NextE();
       if(e11.Tri().InCircle(e22.P2()) || e21.Tri().InCircle(e12.P2()))
         {
           e11.Update(e22.P2(),e12.P2());
           e21.Update(e12.P2(),e22.P2());
           e11.LinkSymm(e21);
           e13.Tri().Update(e13,e22,e11);
           e23.Tri().Update(e23,e12,e21);
           e12.AsIndex();
           e22.AsIndex();
           SwapTest(e12);
           SwapTest(e22);
           SwapTest(e13);
           SwapTest(e23);
         }
     }

   Node Nearest(double x, double y)
     {
       // locate a node nearest to (px,py)
       double dismin=0.0,s;
       Node nd=null;

       for(int i=0;i<nodes.size();i++)
         {
           s=((Node)nodes.elementAt(i)).Distance(x,y);
           if(s<dismin||nd==null) { dismin=s;nd=(Node)nodes.elementAt(i);}
         }
       return nd;

     }

   public void DrawPoints(Graphics g, Color color)
     {
       g.setColor(color);
       for(int i=0;i<nodes.size();i++)
	 {
	 if ( (((Node)nodes.elementAt(i)).type()) == 1) g.setColor(Color.black);
	 else  g.setColor(Color.red);
         g.drawRect(((Node)nodes.elementAt(i)).x-1,((Node)nodes.elementAt(i)).y-1,2,2);
	 }
     }

   public void DrawTriangles(Graphics g, Color color)
     {
       g.setColor(color);
       if(nodes.size()==1)
         g.drawRect(((Node)nodes.elementAt(0)).x,((Node)nodes.elementAt(0)).y,1,1);
       if(nodes.size()==2)
         g.drawLine(((Node)nodes.elementAt(0)).x,((Node)nodes.elementAt(0)).y,((Node)nodes.elementAt(1)).x,((Node)nodes.elementAt(1)).y);
       for (int i=0; i<edges.size(); i++) ((Edge)edges.elementAt(i)).Draw(g);
       for (int i=0; i<tris.size(); i++)
         { Triangle t=(Triangle)tris.elementAt(i);
           t.anEdge.Draw(g);
           t.anEdge.NextE().Draw(g);
           t.anEdge.NextE().NextE().Draw(g);
         }
     }
   public void DrawConvexHull(Graphics g, Color color)
   // affichage de l enveloppe convexe
     {
     Edge   temp=hullStart; // on part avec l arete de lien a l enveloppe convexe
       g.setColor(color);
		temp.Draw(g);
		
		while (temp.NextInHull() != hullStart)
		{
		(temp.NextInHull()).Draw(g);
		temp = temp.NextInHull();
		
		}
     }

   public void DrawCircles(Graphics g, Color color)
     {
       g.setColor(color);
       for(int i=0;i<tris.size();i++)  ((Triangle)tris.elementAt(i)).DrawCircles(g);
     }

   public void DrawVoronoiDiagram(Graphics g, Color color)
     {
        g.setColor(color);
        double tcx,tcy;
        for (int i=0; i<edges.size(); i++)
          {
            Edge e = (Edge)edges.elementAt(i);
            Edge ee=e.InvE();
            if(ee==null || ee.Tri()==null)
              {
                tcx=e.Tri().c_cx-e.P2().y+e.P1().y;
                tcy=e.Tri().c_cy-e.P1().x+e.P2().x;
              }
           else
             {
               tcx=ee.Tri().c_cx;
               tcy=ee.Tri().c_cy;
             }
           g.drawLine((int)e.Tri().c_cx,(int)e.Tri().c_cy,(int)tcx,(int)tcy);
         }
     }
}
