//-----------------------------------------------------------------------------
// Internet project
// WebMailer Application v1
//
// Coded by Philippe PHUNG / Thomas Hacquet
//
// First release     : 27.03.97
// Last modification : 27.03.97
//-----------------------------------------------------------------------------

import java.awt.*;
import java.io.*;
import java.net.*;
import java.util.*;

//-----------------------------------------------------------------------------
// Classe Webmailer
//
// Fonction : Interface graphique avec le robot principal RobotAltaVista
//-----------------------------------------------------------------------------

class Webmailer extends Frame
{
   // Graphical interface's components	

   MonCanvas canvas= null;	      // progress indicators canvas	
   TextField tf=null;                 // Search field 
   TextArea status_area;              // Status message area 
   Button b1=null, b2=null, b3=null;  // Start Close
   StatusCanvas stat_can=null;	      // Status panel canvas
   MenuBar mbar=null;                 // Main menu bar
   Menu m=null, mop=null;             // File & Mail menus
   CheckboxMenuItem chkmenu1=null;    // Mail Simulation checkbox
   GridBagLayout gbl=null;            // Panel3's layout 
   GridBagConstraints gbc=null;	      //     "    constraints
   Label label1=null;                 // "Search" TextField's label
   Label label2=null;		      // "X" Scanner's label
   Label label3=null;		      // "Status" TextArea's label
   Scanner scanner=null;	      // Application Watchdog
   ComposeFen composef=null;          // Compose Mail window

   RobotAltaVista vista_rob=null;     // Main search robot
   
   
   public Webmailer()
    { 
      // Build the interface

      setTitle("WebMailer");
      Panel p =  new Panel();
      Panel p2 = new Panel();
      Panel p3 = new Panel();
      
      setLayout(new BorderLayout());
 
      gbl = new GridBagLayout();
      p.setLayout(new FlowLayout());
      p2.setLayout(gbl);

      gbc = new GridBagConstraints();
      gbc.gridx = 0;
      gbc.gridy = 0;
      gbc.gridwidth=3;
      gbc.gridheight=1;

      add("North",p);
      add("South",p2);

      tf = new TextField("",25);
      b1 = new Button(" Start ! ");
      b2 = new Button("Skip step");
      b2.disable();
      b3 = new Button("Exit");
      status_area = new TextArea(1,30);
      canvas = new MonCanvas();
      stat_can= new StatusCanvas();
      label1 = new Label("Search:");
      label2 = new Label("Status:");
      label3 = new Label("|");      

      p.add(label1);
      p.add(tf);
      p.add(b1);
      p.add(b2);
      p.add(b3);

      gbc.weightx = 50;
      gbc.weighty = 30;

      gbc.gridx = 2;
      gbc.gridy = 0;
      gbc.gridwidth=2;
      gbc.gridheight=1;
      gbl.setConstraints(label3, gbc);

      gbc.gridx = 0;
      gbc.gridy = 2;
      gbc.gridwidth=1;
      gbc.gridheight=1;
      gbl.setConstraints(label2, gbc);

      gbc.gridx = 2;
      gbc.gridy = 2;
      gbc.gridwidth=3;
      gbc.gridheight=1;
      gbl.setConstraints(status_area, gbc);

      gbc.gridx = 2;
      gbc.gridy = 0;
      gbc.gridwidth=2;
      gbc.gridheight=1;
      gbl.setConstraints(stat_can, gbc);

      p2.add(label3);
      p2.add(label2);
      p2.add(status_area);
      p2.add(stat_can);
        
      add("Center",canvas);

      // This is the watchdog

      scanner = new Scanner(label3);
      scanner.setPriority(10);
      scanner.start();
      scanner.suspend();

      // Build a lovely menu bar 

      mbar = new MenuBar();
      m = new Menu("File");
      m.add(new MenuItem("Exit"));
      mbar.add(m);
      m = new Menu("Mail");
      m.add(new MenuItem("Compose"));
      m.addSeparator();
      chkmenu1=new CheckboxMenuItem("Simulation");
      chkmenu1.setState(true);
      m.add(chkmenu1);
      mbar.add(m);	
      setMenuBar(mbar); // Apply menubar to the current frame	    
     }

     public void paint(Graphics g){
	    canvas.show();
	    stat_can.show();
     }

     public boolean handleEvent(Event evt)
     {  if (evt.id == Event.WINDOW_DESTROY) System.exit(0);
        return super.handleEvent(evt);
     }

     public boolean action(Event evt, Object arg)
     {
         if (evt.target instanceof Button){		
           if (arg.equals(" Start ! ") | arg.equals("Restart")) {
				     vista_rob = new RobotAltaVista(param_rec(),this,scanner);
				     vista_rob.setPriority(1); // Set a low priority
				     vista_rob.start(); // Lancement recherche pages Alta
				     b1.disable(); // Desactiver bouton Start!
				     msg("Begin search ...");
				     // Resume the watchdog process
				     scanner.resume();
				     }
	   else if (arg.equals("Skip step")) {
		   System.out.println("Skip step");
		   vista_rob.skip();		  
		   }
	   	   
	   else if (arg.equals("Exit")) System.exit(0); // Quit 
	   else return false;
	 } 
	 else if (evt.target instanceof MenuItem){
	         if (arg.equals("Exit")) System.exit(0);
	         else if (arg.equals("Compose")) {
						 // Launch the Compose Mail window
						 System.out.println("Compose");
						 composef = new ComposeFen();
						 composef.resize(700,310);
						 composef.show();
						 }
		 else if (arg.equals("Simulation")) System.out.println("Simulation");		 
	      }
	 return true;
     }
 
     public void setSkipState(boolean bool){
	    if(bool) {b2.enable();}
	    else{ b2.disable();}	
     }

     // Retourne l'etat du checkboxmenuitem "Simulation"  true= simulation demande false= pas de simulation
     public boolean getSimulationFlag(){
	    return chkmenu1.getState();
     }

     public void maj(int numbar, int valeur, boolean incrementation){
	    canvas.maj(numbar, valeur, incrementation);
     }

     public void setNbRefs(int nb){ // Transmet au canvas le total des references potentielles
	    canvas.setNbRefs(nb); 
     }
     public void setNbDocs(int nbd){ // Transmet au canvas le total des docs potentiels
	    canvas.setNbDocs(nbd); 
     }
     public void setNbMails(int nbm){ // Transmet au canvas le total des emails potentiels
	    canvas.setNbMails(nbm);
     }

     // Renvoie le critere de recherche donne par l'utilisateur      
     public String param_rec(){
	    String aString="";
	    aString = tf.getText();
	    return aString.toLowerCase(); // convertion en minuscule du critere de recherche
					  // (cf. DocTech. Chap. AltaVista
     }

     // Change le label du bouton Start en Restart apres le premier incident de connection
     // with AltaVista 
     public void restart(){
	b1.setLabel("Restart");
	b1.enable(); 	    
     }

     // Change le message de status 
     public void msg(String message){
	status_area.replaceText(message,0,50);
     }
     
     public static void main(String[] args)
     {  Frame f = new Webmailer();
        f.resize(500,300);
	f.show();

     }
}

//-----------------------------------------------------------------------------------------------
// classe RobotAltaVista
//
// Fonction : Dirige toutes les operations de recherches de documents, de filtrage, de mailing
//            Cette classe constitue le coeur veritable de l'application
//-----------------------------------------------------------------------------------------------

class RobotAltaVista extends Thread
{

	String CIBLE=null;                               // Chaine de carateres recherchee
	String REQUETE=null;
	// Entete de la requete initiale envoyee a AltaVista
	String HEADER1="GET /cgi-bin/query?pg=q&what=web&fmt=&text=yes&q=";
	// Entete des autres requetes AltaVista       
	String HEADER2="GET /cgi-bin/query?pg=q&stq=";
	String ADR_SRV="altavista.digital.com";          // URL d'Alta-Vista

	// Alta Vista	
	Socket soc_alta=null;          // Socket connection avec Alta-Vista
	DataInputStream inVista=null;  // Flot d'entree      
	PrintStream outVista=null;     // Flot de sortie

	// Fichier de sauvegarde
	FileOutputStream fout = null;  // Fichier de sauvegarde  
	PrintStream pout = null;       // Canal de sauvegarde

	String ligne_stats=null;

	String ligne_alta=null, temp =null; // Chaine de car a traiter
	int res=-1;               // resultat de la recherche
	int ind;                  // index de boucle
	int nb_pages=0;           // nb de page a rapatrier
	String nb_pages_str=""; 
        int total_docs=0;         // nb total documents repondant a la requete      
	String total_docs_str=""; 
	int nb_docs=0;            // nb de documents de la requete courante
	String nb_docs_str="";

	Webmailer finder=null;

	int nb_pages_r=1;       // nb de pages resultat retournees (1 = premiere page)
	int nb_pages_e=0;       // nb de pages resultat non retournees
	int nb_docs_r=0;        // nb de pages HTML retournees
	int nb_docs_e=0;        // nb de pages HTML non retournees
	int nb_mails_tot=0;     // nb de mails potentiels
	int nb_mails_r=0;       // nb de mails envoyes
		
	Scanner scanner=null;

	ThreadGroup threadgrp=null;

	// Inputs constructeur:
	// 
	// String s  : chaine de caractere recherche
	// Webmailer f  : interface de l'application
	// Scanner s : execution watchdog
	//
	public RobotAltaVista(String s, Webmailer f, Scanner scan) {
	       CIBLE=s;
	       finder = f;
	       scanner=scan;
	       REQUETE=HEADER1+CIBLE; // Constitution de la requete initiale vers Alta-Vista
	       System.out.println("");
	       System.out.print("Requete initiale : "+REQUETE+"\n");
	}

	// Renvoie le threadgroup des threads en cours
	public ThreadGroup theGroup(){
	       return threadgrp;
	}

	// Permet d'interrompre la phase de rapatriement des document pour passer a la phase
	// de filtrage des mails. Tres pratique pour les tests (surtout quand on est presse).

	public void skip(){
	       try{
	          fout.close();  // fermer le fichier de sauvegarde des documents 
	       threadgrp.stop(); // Arreter tous les threads RobotTelnet en cours
	       System.out.println("Lancement filtreMAIL"); // Avertir l'utilisateur
	       finder.msg("Get EMAILs ...");
	       nb_mails_tot = filtreMAIL("r3","r4"); // Lancer le filtrage
	       finder.setNbMails(nb_mails_tot); // Passer a l'afficheur le nb de mails trouve
	       resume(); // reveiller le robot principal AltaVista
	       }
	       catch(IOException e){ System.out.println("Skip procedure failed");}
	}

	// Cette fonction est appellee chaque fois qu'un RobotTelnet s'acheve.
	// Inputs :
	//     int numbar : indique le numero de la barre de progression a modifier
	//                  1 = Collect AltaVista results
	//		    2 = Collect HTML documents
	//		    3 = Mailing
	//     boolean typeinc : si operation bien termine = true
	//                       sinon false (il faut signaler l'erreur)
 
	public void inc(int numbar,boolean typeinc)
	{
		if (numbar==1){ // Barre de AltaVista
		   
		   if(typeinc){  // Pas d'erreurs
				nb_pages_r++;
				finder.maj(numbar,((nb_pages_r) *100)/(nb_pages+1),typeinc);
		   }
		   else {  // Erreur -> barre d'erreurs
				nb_pages_e++;
				finder.maj(numbar,((nb_pages_e) *100)/(nb_pages+1),typeinc);
		   }

		   finder.show();
		   if ((nb_pages_r+nb_pages_e)==(nb_pages+1)) {
		      try {   
			   fout.close();
			   }
		      catch(Exception e) {System.out.println("Fermeture fichier impossible");};
		      System.out.println("100% des resultats. Fermeture du fichier");
		      System.out.println("Lancement filtreURL");
		      finder.msg("Get URLs ...");
		      finder.setNbDocs(filtre("<P><dt>","r1","r2"));
		      resume();
		   }		
		} // end if

		if (numbar==2){ // Barre des URL rapatriee
		   if(typeinc){ // Augmenter barre des hits
		       nb_docs_r++;
		       finder.maj (numbar,((nb_docs_r*100)/total_docs),typeinc);
		   }
		   else {  // Augmenter barre des erreurs
		       nb_docs_e++; 
		       finder.maj (numbar,((nb_docs_e*100)/total_docs),typeinc);
	           }
	
		   finder.show();
		   // Tester si tous les documents demandes nous sont parvenus (erreurs incluses)
		   if((nb_docs_r+nb_docs_e)==total_docs) {
		      try {
			   fout.close(); // fermer le fichier resultat
			   }
		      catch(Exception e) {System.out.println("Fermeture fichier impossible");};
		      System.out.println("100% des resultats. Fermeture du fichier");
		      System.out.println("Lancement filtreMAIL");
		      finder.msg("Get EMAILs ...");

		      nb_mails_tot = filtreMAIL("r3","r4");
		      finder.setNbMails(nb_mails_tot);
		      resume();
		   }
		} // end if
	}

	// Fonction   : Filtre les URLs 
	// Inputs :   
	//	      String st : chaine de caracteres recherchee
	//	      String inputfile : nom du fichier d'entree
	//	      String outputfilename : nom du fichier de sortie

	public int filtre(String st,String inputfilename, String outputfilename)
	{
	    String inName;
	    String outName;	
	    FileInputStream inFile=null;
	    DataInputStream inFileStream=null;	    
	    FileOutputStream outFile=null;
	    PrintStream outFileStream=null;
	    
	    String cur_line="";
	    int rcode=0;
	    String SEARCHED_STRING=st;
 
	    inName=inputfilename;
	    outName=outputfilename;
	    
	    int counter=0; // contient le nb de lignes qui correspondent au critere st

	    try {
	      inFile = new FileInputStream(inName);
	      inFileStream = new DataInputStream(inFile);		
	      outFile = new FileOutputStream(outName);
	      outFileStream = new PrintStream(outFile);

	      String tempo="";
	      String url_string="";

	      // Tant qu'il y a des lignes
	      while ((cur_line = inFileStream.readLine())!=null) 
	      {
		rcode = cur_line.indexOf(SEARCHED_STRING);
		if (rcode!= -1) { // Si le tag recherche est dans la ligne courante
		   counter++;
		   StringTokenizer tkk = new StringTokenizer(cur_line,"\"");		    
		   tempo = tkk.nextToken();
		   url_string = tkk.nextToken();
		   outFileStream.println(url_string);
		} 
	      }
		
	      inFile.close();
	      outFile.close();
	      inFileStream.close();
	      outFileStream.close();
	      System.out.println("Filtrage URL termine !!!");
	      return(counter);
	    }
	    catch(Exception e) {
			    System.out.println("Erreur: filtreURL");
			    return(counter); 
	    }
	} // end filtreURL

	// Fonction : Filtre les MAILs 
	// Inputs :   
	//	      String st : tag des emails (ex : "mailto:")
	//	      String inputfile : nom du fichier d'entree
	//	      String outputfilename : nom du fichier de sortie
	// Output : nombre de mails detectes

	public int filtreMAIL(String inputfilename, String outputfilename)
	{
	  String inName;
	  String outName;	
	  FileInputStream inFile=null;
	  DataInputStream inFileStream=null;	    
	  FileOutputStream outFile=null;
	  PrintStream outFileStream=null;
	  
	  String cur_line="";
	  int cursor=0, end_index=0, begin_index=0;
	  char currentChar;
	  
	  inName=inputfilename;
	  outName=outputfilename;
	  
	  int counter=0; // contient le nb de lignes qui correspondent au critere st
	  
	  try {
	    inFile = new FileInputStream(inName);
	    inFileStream = new DataInputStream(inFile);		
	    outFile = new FileOutputStream(outName);
	    outFileStream = new PrintStream(outFile);
	    
	    // pour extraire les emails deja rencontre
	    String EmailsFind="";	      
	    
	    // entier permettant de determiner l'etat de l'automate
	    int alphanum1=1, firstSeparator=2, alphanum2=3, pointSeparator=4, accept=5, end=6, currentState=1;
	    
	    // pour chaque ligne on cherche "nomalphanum@nomalphanum." et on prend la suite jusqu'au premier caractere non alphanumerique et different de '.' 
	    while ((cur_line = inFileStream.readLine())!=null) 
	      {
		currentState = alphanum1;
		cursor = 0;
		begin_index = 0;
		
		try {
		  
		  while (currentState != end)  
		    {
		      currentChar = cur_line.charAt(cursor);
		      cursor++;
		      
		      switch (currentState)
			{
			case 1:
			  if ( ((currentChar >= 'A') && (currentChar <= 'Z')) || ((currentChar >= 'a') && (currentChar <= 'z'))
			       || ((currentChar >= '0') && (currentChar <= '9')) )
			    currentState = firstSeparator;
			  else
			    begin_index = cursor;
			  break;
			  
			case 2:
			  if ( !( ((currentChar >= 'A') && (currentChar <= 'Z')) || ((currentChar >= 'a') && (currentChar <= 'z'))
			       || ((currentChar >= '0') && (currentChar <= '9')) || (currentChar=='.') ) )
			    if (currentChar == '@')
			      currentState = alphanum2;
			    else
			      {
				begin_index = cursor;
				currentState = alphanum1;
			      }
			  break;
			  
			case 3:
			  if ( ((currentChar >= 'A') && (currentChar <= 'Z')) || ((currentChar >= 'a') && (currentChar <= 'z'))
			       || ((currentChar >= '0') && (currentChar <= '9')))
			    currentState = pointSeparator;
			  else
			    {
			      begin_index = cursor;
			      currentState = alphanum1;
			    }
			  break;
			  
			case 4:
			  if ( !( ((currentChar >= 'A') && (currentChar <= 'Z')) || ((currentChar >= 'a') && (currentChar <= 'z'))
			       || ((currentChar >= '0') && (currentChar <= '9')) ) )
			    if (currentChar == '.')
			      currentState = accept;
			    else
			      {
				begin_index = cursor;
				currentState = alphanum1;
			      }
			  break;
			
			case 5:
			  if ( !( ((currentChar >= 'A') && (currentChar <= 'Z')) || ((currentChar >= 'a') && (currentChar <= 'z'))
			       || ((currentChar >= '0') && (currentChar <= '9')) || (currentChar == '.') ))
			    {
			      currentState = end;
			      end_index = cursor - 1;
			    }
			  break;
			  
			}
		    }
		}
		catch(StringIndexOutOfBoundsException e) {}
		
		if (currentState == accept)
		  end_index = cursor;

		if (currentState == end || currentState == accept)
		  {
		    // on stock la sous chaine dans le fichier si elle n'y est pas
		    String nx = cur_line.substring(begin_index, end_index);
		    if (EmailsFind.indexOf(nx) == -1) // Email rencontre pour la premiere fois
		      {
			EmailsFind=EmailsFind.concat(nx);
			counter++;
			System.out.println(nx);
			outFileStream.println(nx);
		      }		
		  }
	      }
	     
		
	      inFile.close();
	      outFile.close();
	      inFileStream.close();
	      outFileStream.close();
	      System.out.println("Filtrage MAIL termine !!!");
	      return(counter);
	    }
	    catch(Exception e) {
	      System.out.println("Erreur: filtreMAIL");
	      return(counter); 
	    }
	} // end filtreMAIL




	// Corps de RobotAltaVista
	// Fonction : Initie toutes les recherches de documents, lance les filtrages
	//            et la phase de mailing.
	public void run()
	{
	try {

	    // Connection serveur
	    soc_alta = new Socket(ADR_SRV, 80);
	    inVista = new DataInputStream(soc_alta.getInputStream());	
	    outVista = new PrintStream(soc_alta.getOutputStream());
	    finder.msg("Waiting for Alta-Vista reply...");
	    System.out.println("Connection AltaVista realisee");

	    // Ouverture fichier sauvegarde
	    fout = new FileOutputStream("r1");
	    pout = new PrintStream(fout);
	    System.out.println("Ouverture fichier de sauvegarde");

	    //----------------------------------------------------------------------
	    // Demander la premiere page d'Alta-vista
	    //----------------------------------------------------------------------
 
	    System.out.println("+------------------------------------------------+");
	    System.out.println("| Demande premiere page resultat d'Alta-vista    |");
	    System.out.println("+------------------------------------------------+");

	    outVista.println(REQUETE);
	    System.out.println("-- Attente reponse ... --\n");    
	    
	    while ((ligne_alta = inVista.readLine())!=null) 
	    {
	      res = ligne_alta.indexOf("Documents");
	      if (res!= -1) { 
	         System.out.println("");
	         System.out.print("Reponse Alta-vista : ");
	         System.out.print(ligne_alta.substring(0,40)+" ...\n"); 
	         ligne_stats = ligne_alta; // On sauve pour plus tard
	         pout.println(ligne_alta);		
              }
	    }

	    soc_alta.close();    // Fermeture du socket
	    System.out.println("Cloture connection AltaVista");
	    inVista.close();     // Fermeture canal lecture sur Alta-Vista
	    outVista.close();    // Fermeture canal ecriture sur Alta-Vista

	    // Maintenant on a enfin de temps de traiter la ligne

	    StringTokenizer tok = new StringTokenizer(ligne_stats," -");		    
	    temp = tok.nextToken();
	    temp = tok.nextToken();
	    nb_docs_str = tok.nextToken();
	    nb_docs = new Integer(nb_docs_str).intValue();
	    temp = tok.nextToken();
	    temp = tok.nextToken();		    	
	    total_docs_str = tok.nextToken();
	    total_docs= new Integer(total_docs_str).intValue();	
	    System.out.println("Nombre total d'URL repondant a la requete = "+total_docs_str);
	    System.out.println("Nombre d'URL recuperee = " + nb_docs_str);		    
	    // Calcul du nombre de pages reponses
	    nb_pages = (total_docs / nb_docs);
	    nb_pages--;
	    nb_pages_str = new Integer(nb_pages).toString();
	    System.out.println("Nombre de pages reponse restantes = "+ nb_pages_str);
	       
	    finder.setNbRefs(total_docs);   
	    finder.maj(1,100/(nb_pages+1),true);
	    finder.show();

	    //-----------------------------------------------------------------------
	    // Demander les autres pages HTML d'Alta-vista
	    //-----------------------------------------------------------------------

	    System.out.println("+------------------------------------------------+");
	    System.out.println("| Demande des autres pages resultat d'Alta-vista |");
	    System.out.println("+------------------------------------------------+");

	    int borne = nb_pages;

	    threadgrp = new ThreadGroup("Groupe");

	    // Lancement des RobotTelnet en // pour la recuperation des reponses

	    for(ind=0;ind< borne;ind++){
	       REQUETE=HEADER2+nb_docs_str+"&q="+CIBLE;

	       RobotTelnet rob = new RobotTelnet(ADR_SRV, REQUETE, 80, this, pout, 1, threadgrp);
	       rob.setPriority(1);
	       rob.start();
	       nb_docs = nb_docs + 10;
	       nb_docs_str = new Integer(nb_docs).toString();
	    }
	    System.out.println("Suspend RobotAltaVista");
	    suspend();
	    System.out.println("Resume RobotAltaVista");
	    finder.setSkipState(true);
	    finder.msg("Retrieve HTML documents ...");
	    RetourURL("r2","r3");
	    System.out.println("Suspend RobotAltaVista");
	    suspend();
	    System.out.println("Resume RobotAltaVista");
	    finder.setSkipState(false);

	    // Si simulation utiliser un faux fichier d'adresse
	    if(finder.getSimulationFlag()) {
		System.out.println("Mode simulation : utilisation d'un fichier d'emails de test");
	        Mail("fake_r4","message");
	    }		
	    else {
		System.out.println("Mode reel : utilisation du veritable fichier d'emails");
		//-----------------------------------------------------------------------------------------------
		// Pour des raisons de securite la ligne permettant l'envoi reel de mails a ete mise en commentaire
		//-----------------------------------------------------------------------------------------------
		//Mail("r4","message");
	    }		    

	    finder.msg("Process finished. Se ya later...");    	    
	    scanner.suspend();
	}

	catch(Exception e){ 
			System.out.println("Erreur (RobotAltaVista) : ");
			finder.restart();
			finder.msg("Connection broken. Please restart. ");
			scanner.suspend();
	}
    }

    //
    // Fonction : Recupere tous les documents dont les URLs sont dans fichier_entree
    //            dans fichier_sortie
    //
    public void RetourURL(String fichier_entree, String fichier_sortie)
    {
    try {

	String fic_in=fichier_entree;
	String fic_out=fichier_sortie;

        //-----------------------------------------------------------------------
        // Demande des URL referencees par Alta-vista
        //-----------------------------------------------------------------------

        System.out.println("+------------------------------------------------+");
	System.out.println("| Demandes des URL referencees par Alta-vista    |");
	System.out.println("+------------------------------------------------+");

	// Chaine de caractere a traiter 

	String NEWREQUEST="";
	String serveur_str="";
	String requete_str="";
	String port_str=""; 
	String lignemail="";
	String lignedoc="";  
	String temp="";
	int r=0;

	// Fichier d'URL
	FileInputStream fin2 = null;
	DataInputStream streamin = null;

	StringTokenizer tk = null;

	// Fichier de mails
	FileOutputStream fout2 = null;
	PrintStream streamout = null; 

	int port_serveur=0;
	int compteur=0;	   

	fin2 = new FileInputStream(fic_in);
	streamin = new DataInputStream(fin2);
 
	fout2 = new FileOutputStream(fic_out);
	streamout = new PrintStream(fout2);
 
	// Tant que le fichier d'URL n'est pas termine
	while ((lignemail = streamin.readLine())!=null) 
	{
            tk = new StringTokenizer(lignemail," /");
	    temp = tk.nextToken();
	    serveur_str = tk.nextToken();
	    requete_str = tk.nextToken(" ");
	
	    r = serveur_str.indexOf(":");
	    if (r!= -1) {  // port special !!!
	        StringTokenizer stk = new StringTokenizer(serveur_str,":");
	        port_str=stk.nextToken();
	        port_str=stk.nextToken();
	        System.out.println(port_str);
		port_serveur= new Integer(port_str).intValue();

	        // Calcul longueur URL sans le port
	        int lg_serveur_str=serveur_str.length();
	        int lg_port_str=port_str.length();
	        serveur_str=serveur_str.substring(0,lg_serveur_str-lg_port_str-1);
	    } 
	    else {
	        port_str="80";
	        port_serveur=80;
	    }
				
	    System.out.println("Serveur HTTP: "+serveur_str +"    Port: " + port_str);
	    System.out.println("Requete      : "+requete_str);

	    NEWREQUEST = "GET "+requete_str;
	    RobotTelnet rob = new RobotTelnet(serveur_str, NEWREQUEST, port_serveur, this, streamout, 2, threadgrp);
	    rob.start();	   	
	}
       }
       catch(Exception e){ System.out.println("Erreur (RobotAltaVista) : Demande URL");       
       }
    }	

    //
    // Fonction : Realise une simulation de mailing. Seules les ligne de commandes sont affichees
    //            Prend en entree les adresses contenue dans fichier_entree
    //            C`est le fichier fichier_message qui est expedie
    //
    public void MailSimulation(String fichier_entree, String fichier_message)
    {
    try {

	String fic_email=fichier_entree;
	String fic_message=fichier_message;

	// Fichier des adresses email
	FileInputStream fin2 = null;
	DataInputStream streamin = null;
	String ligne_mail="";
	int compteur=0;

        //-----------------------------------------------------------------------
        // Send mail to mail-list
        //-----------------------------------------------------------------------

        System.out.println("+------------------------------------------------+");
	System.out.println("| Send mail to mail-list                         |");
	System.out.println("+------------------------------------------------+");
	
	// Open Zemail files (welcome to twillight zone)
	fin2 = new FileInputStream(fic_email);
	streamin = new DataInputStream(fin2);
 
	// Tant que le fichier d'emails n'est pas termine
	while ((ligne_mail = streamin.readLine())!=null) 
	{
		compteur++;
		String commande="mail "+ligne_mail+" < "+fichier_message;
		System.out.println(commande);
		finder.maj (3,((compteur*100)/nb_mails_tot),true);
	}
       }
       catch(Exception e){ System.out.println("Erreur (RobotAltaVista) : Send mail");       
       }
    } // end MailSimulation

  public void Mail (String filename_recipients, String filename_email)
  {

    String recipient;
    boolean verbose = false;
    String email_text = "";

        
    // Load mail-text
    try {
      DataInputStream dis = new DataInputStream(new FileInputStream(filename_email));
      String line = "";
      while ( (line = dis.readLine())	!= null)
	email_text += line + "\n";
    }
    catch (FileNotFoundException fnfe)
      {
	System.err.println("The file <" + filename_email + "> wasn't found");
      }
    catch ( IOException ioe)
      {
	System.err.println("IO-Error while reading file " + filename_email);
      }
    
    
    // Every line in filename_email is an e-mail-address.
    try {
      DataInputStream dis = new DataInputStream(new FileInputStream(filename_recipients));
      
      //-----------------------------------------------------------------------
      // Send mail to mail-list
      //-----------------------------------------------------------------------
      
      System.out.println("+------------------------------------------------+");
      System.out.println("| Send mail to mail-list                         |");
      System.out.println("+------------------------------------------------+");
      
      int compteur=0; // nb de mails envoyes

      while ( (recipient = dis.readLine()) != null){
	compteur++;
	finder.maj (3,((compteur*100)/nb_mails_tot),true);
	mail(recipient, email_text); 
      }	
    
    } catch (FileNotFoundException fnfe)
      {
	System.err.println("The file <" + filename_recipients + "> wasn't found");
      }
    catch ( IOException ioe )
      {
	System.err.println("IO-Error while reading file " + filename_recipients);
      }
  }
  
  
  private static void mail (String recipient, String email_text) 
  {
    String reply;
    String hostname;
    String username = "WebMailer";

    int mailport = 25;
    Socket socket;
    DataInputStream inStream;
    PrintStream outStream;

    // determine local hostname
    try {
      InetAddress ipaddress = InetAddress.getLocalHost();
      if ( (hostname = ipaddress.getHostName()) == null )
	hostname = "localhost";
    } catch (UnknownHostException uhe)
      {
	hostname = "localhost";
      }
    

    try
      {
	InetAddress add = InetAddress.getByName("essi.essi.fr");

	socket = new Socket(add, mailport);	
	inStream = new DataInputStream( socket.getInputStream() );
	outStream = new PrintStream(socket.getOutputStream() );
	
	reply = inStream.readLine();
	
	outStream.println("HELO " + hostname);
	outStream.flush();

	outStream.println("MAIL FROM: " + username);
	outStream.flush();
	
	outStream.println("RCPT TO: " + recipient);
	outStream.flush();
	
	outStream.println("DATA");
	outStream.flush();
	
	outStream.println(email_text);
	outStream.flush();

	outStream.println("\n.\n");
	outStream.flush();

	socket.close();
	System.out.println("mail sent: " + recipient);
      }
    
    catch(Exception e)
      {
	System.err.println("\nSocket-creation-Error\n");
      }
  }
  
  private static void doCommand (String command, DataInputStream inStream,  PrintStream outStream)
  {
    // note that this method should be checking the status of the
    // command and throwing an exception if an error occurs in the
    // SMTP conversation.  Perhaps next time...
    
        
    try
      {
	outStream.println( command );
	outStream.flush();
      }

    catch(Exception e)
     {
       System.err.println("\nSocket-IO-Error\n");
     }
    return;
  }
  
	
} // end class RobotAltaVista

//--------------------------------------------------------------------------------------
// classe RobotTelnet
//
// Fonction : Cette classe a pour fonction de recuperer de facon autonome un document 
//--------------------------------------------------------------------------------------
class RobotTelnet extends Thread {

      String url_srv=null;
      String requete=null;
      int num_port=0;	       // Port de connexion du serveur	
      RobotAltaVista rob_alta; // Robot maitre
      int num_bar=0;
      Socket t=null;
      DataInputStream is=null;
      PrintStream os=null;
      PrintStream pout=null;
      String ligne_srv;

      // Constructeur	     
      // Inputs:
      //	String u : url du serveur
      //	String r : requete
      //	int np   : numero du port
      //	RobotAltaVista rob : robot maitre
      //	Printstream ps : flot d'ecriture pour les resultats
      //	int num_barre : numero de la barre de progression concernee
      //	ThreadGroup p : ThreadGroup auquel appartient ce RobotTelnet
      // 
      public RobotTelnet(String u, String r, int np, RobotAltaVista rob, PrintStream ps, int num_barre,ThreadGroup p)
      {
	super(p, "Loading");
	url_srv=u;
	requete=r;
	num_port=np;
	rob_alta=rob;
	pout=ps;
	num_bar=num_barre;
      }

      public void run()
      {
        try 
	{
	  t = new Socket(url_srv, num_port);
	  is= new DataInputStream(t.getInputStream());	
	  os = new PrintStream(t.getOutputStream());

	  // Envoyer la requete a Alta-Vista
	  os.println(requete);

	  System.out.println(requete +" <Start> ");

	  while ((ligne_srv = is.readLine())!=null){
		pout.println(ligne_srv);
	  }	

	  System.out.println(requete+ " <End> ");
	  rob_alta.inc(num_bar,true);
	  
          t.close();     // Fermeture du socket
	  is.close();    // Fermeture canal lecture
	  os.close();    // Fermeture canal ecriture

	}
	catch(Exception e){ System.out.println("Erreur (RobotTelnet) : Connection lost");
			    rob_alta.inc(num_bar,false); 
			    }
      }	
} // class RobotTelnet

//-----------------------------------------------------------------------------------------------
// classe Scanner
//
// Fonction : Anime le clignotement d'un caratere pour refleter l'etat de l'application
//            Si clignotement la recherche de documents est en cours 
//-----------------------------------------------------------------------------------------------
class Scanner extends Thread 
{     Webmailer find=null;
      Label lab=null;
      int state=0;

      public Scanner(Label label1){
	     lab=label1;
      }
      public void run(){
	     try {
	     while(true){	
		if(state==0) { lab.setText("X"); }
		else { lab.setText("-"); }
		state++;
		if (state>1) { state=0;	}     
		sleep(300);
	     }
	     }
	     catch(Exception e){};
      }
      
} // end class Scanner


//-----------------------------------------------------------------------------------------------
// classe MonCanvas
//
// Fonction : Afficher a l'ecran sous une forme graphique la progression des differentes phases
//            du programme.
//-----------------------------------------------------------------------------------------------
class MonCanvas extends Canvas {
      int r1_x = 70, r1_y = 30;     //  abscisse, ordonnee de la premiere barre
      int r2_x = 70, r2_y = 70;     //                           seconde
      int r5_x = 70, r5_y = 110;    //                           troisieme

      int r3_w =0, r3_we=0, r3p =0, r3pe =0; 
      int r4_w =0, r4_we=0, r4p =0, r4pe =0;
      int r5_w =0, r5_we=0, r5p =0, r5pe =0;

      String r3p_str="0",r3pe_str="0";
      String r4p_str="0",r4pe_str="0";
      String r5p_str="0",r5pe_str="0";
 
      int ec=7;          // intervalle en pixel entre le texte et la barre de %
      int bar_height=15; // hauteur en pixels des barres
      int bar_width=200; // largeur en pixels des barres

      Image image1=null;
      Font font1=null;

      int nb_refs=0; // nb de references potentielles
      int nb_docs=0; // nb de documents HTML potentiels
      int nb_emails=0; // nb d`adresse email potentielles
      
      String nb_refs_str="";
      String nb_docs_str="";
      String nb_emails_str="";

      public void setNbRefs(int nb){ // Fixe le nombre total de reference potentielles
	     nb_refs=nb;
	     nb_refs_str= new Integer(nb_refs).toString(); 
      }

      public void setNbDocs(int nbd){ // Fixe le nombre total de documents HTML potentiels
	     nb_docs=nbd;
	     nb_docs_str= new Integer(nb_docs).toString(); 
      }

      public void setNbMails(int nbm){ // Fixe le nombre total de emails potentiels
	     nb_emails=nbm;
	     nb_emails_str= new Integer(nb_emails).toString();
      }

      public void paint (Graphics g) {

	     g.setColor(Color.black);
	     g.drawString("Collect Alta-Vista results",r1_x,r1_y-ec);
	     g.drawString("Collect HTML pages ",r2_x,r2_y-ec);
	     g.drawString("Mail",r5_x,r5_y-ec);

	     g.drawString("Hit",   r1_x + bar_width + 10, r1_y-bar_height);
	     g.drawString("rate",  r1_x + bar_width + 10, r1_y-bar_height+10);
	     g.drawString("Error", r1_x + bar_width + 50, r1_y-bar_height);
	     g.drawString("rate" , r1_x + bar_width + 50, r1_y-bar_height+10);

	     // Affichage du nb de URLs potentiel
	     if(nb_refs!=0){
		g.drawString("("+nb_refs_str+")",r1_x + bar_width + 90,r1_y+bar_height-2);
	     }

	     // Affichage du nb d'emails trouves
	     if(nb_emails!=0){
		g.drawString("("+nb_emails_str+")",r1_x + bar_width + 90,r5_y+bar_height-2);
	     }

	     // Affichage des pourcentages (Hit rate & Error rate)	     	     
	     g.drawString(r3p_str+"%",r1_x + bar_width + 10,r1_y+bar_height-2);
	     g.drawString(r4p_str+"%",r2_x + bar_width + 10,r2_y+bar_height-2);
	     g.drawString(r5p_str+"%",r5_x + bar_width + 10,r5_y+bar_height-2);

	     g.drawString(r3pe_str+"%",r1_x + bar_width + 50,r1_y+bar_height-2);
	     g.drawString(r4pe_str+"%",r2_x + bar_width + 50,r2_y+bar_height-2);
	     g.drawString(r5pe_str+"%",r5_x + bar_width + 50,r5_y+bar_height-2);	
	
	     // Dessin du contour des barres		
	     g.setColor(Color.black);
	     g.drawRect(r1_x,r1_y,bar_width+1,bar_height);     
	     g.drawRect(r2_x,r2_y,bar_width+1,bar_height);
	     g.drawRect(r5_x,r5_y,bar_width+1,bar_height);

	     // Dessin des barres de progression (Hit rate);
	     g.setColor(Color.green);
	     g.fillRect(r1_x+1,r1_y+1,r3_w,bar_height-1);
	     g.fillRect(r2_x+1,r2_y+1,r4_w,bar_height-1);
	     g.fillRect(r5_x+1,r5_y+1,r5_w,bar_height-1);
	     
	     // Dessin des barres de progression (Error rate)
	     g.setColor(Color.red);
	     g.fillRect(r1_x+r3_w+1,r1_y+1,r3_we,bar_height-1);
	     g.fillRect(r2_x+r4_w+1,r2_y+1,r4_we,bar_height-1);
	     g.fillRect(r5_x+r5_w+1,r5_y+1,r5_we,bar_height-1);

	     }

      //
      // Fonction : Mise a jour des barres de progression 
      // Inputs :
      //	int numbar : numero de la barre a modifier
      //        int val : nouvelle valeur (en %) 
      //	boolean rtype : true pour la barre verte
      //                        false pour la barre rouge
      //
      public void maj(int numbar, int val, boolean rtype) {

	     if (numbar==1){
	        if(rtype){
			r3p = val;
			r3p_str = new Integer(r3p).toString();
			r3_w = (r3p * bar_width) / 100;
		}
		else {
			r3pe = val;
			r3pe_str = new Integer(r3pe).toString();
			r3_we = (r3pe * bar_width) / 100;
		}		
	     }

	     if (numbar==2){
	        if(rtype){
			r4p = val;
			r4p_str = new Integer(r4p).toString();
			r4_w = (r4p * bar_width) / 100;
		}
		else {
			r4pe = val;
			r4pe_str = new Integer(r4pe).toString();
			r4_we = (r4pe * bar_width) / 100;
		}		
	     }

	     if (numbar==3){
	        if(rtype){
			r5p = val;
			r5p_str = new Integer(r5p).toString();
			r5_w = (r5p * bar_width) / 100;
		}
		else {
			r5pe = val;
			r5pe_str = new Integer(r5pe).toString();
			r5_we = (r5pe * bar_width) / 100;
		}		
	     }
	     this.show();
	     this.repaint();
      }
}

//-----------------------------------------------------------------------------------------------
// classe StatusCanvas
//
//-----------------------------------------------------------------------------------------------
class StatusCanvas extends Canvas {

      Image image1=null, image2=null, image3=null;
      
      Font font1=null;
      int etat=0; // 0 = red, 1 = green, 2 = yellow

      public void setState(int st){
	     etat=st;
      }

      public void paint (Graphics g) {
	     if(etat==0) { g.drawImage(image1,10,10,this); }
	     if(etat==1) { g.drawImage(image2,10,10,this); }
	     if(etat==2) { g.drawImage(image3,10,10,this); }
	     g.setColor(Color.red);
	     g.fillRect(0,0,200,200);
      }
      
      public void maj()
      {
	     this.show();
	     this.repaint();
      }

      public StatusCanvas() {
	     image1 = Toolkit.getDefaultToolkit().getImage("REDLED.gif");
	     image2 = Toolkit.getDefaultToolkit().getImage("GREENLED.gif");
	     image3 = Toolkit.getDefaultToolkit().getImage("YELLOWLED.gif");
      }

}

//-----------------------------------------------------------------------------------------------
// classe ComposeFen
//
// Fonction : Permet de composer et d'enregistre le message pour le mailing
//
//-----------------------------------------------------------------------------------------------
class ComposeFen extends Frame {

      TextField subj=null; 
      TextArea mess=null;
      Button okbutt=null, cancelbutt=null;
      Panel panel1=null, panel2=null, panel3=null;
      Label statuslabel=null, msglabel=null;

      public ComposeFen() {
	setTitle("Compose Mail");
	statuslabel= new Label("Subject : ");     
	subj = new TextField("",40);
	panel1 = new Panel();
	panel1.setLayout(new FlowLayout(FlowLayout.LEFT));
	panel1.add(statuslabel);
	panel1.add(subj);
	add("North",panel1);

	panel2 = new Panel();
	panel2.setLayout(new FlowLayout(FlowLayout.LEFT));
	mess = new TextArea(12,80);
	msglabel = new Label("Message :");
	panel2.add(msglabel);
	panel2.add(mess);
	add("Center",panel2);

	panel3 = new Panel();
	panel3.setLayout(new FlowLayout(FlowLayout.CENTER));
	okbutt = new Button(" Ok ");
	cancelbutt = new Button("Cancel");
	panel3.add(okbutt);
	panel3.add(cancelbutt);
	add("South",panel3);    
      }

     public void paint(Graphics g){

     }

     public boolean handleEvent(Event evt)
     {  if (evt.id == Event.WINDOW_DESTROY) dispose();
        return super.handleEvent(evt);
     }

     // Fonction : sauvegarde le message dans le fichier fname
     public void record(String fic_name){
	String fname = fic_name;    
	try {
	FileOutputStream fic_msg= new FileOutputStream(fname);
	PrintStream p_stream = new PrintStream(fic_msg);

	p_stream.println("Subject: "+subj.getText());
	p_stream.println("");
	p_stream.print(mess.getText());
	p_stream.println(" ");
	p_stream.println(".");
	p_stream.close();
	fic_msg.close();    
	}
	catch(IOException e){ System.out.println("Error (Compose Mail): Record message failed");}
     }


     public boolean action(Event evt, Object arg)
     {
         if (evt.target instanceof Button){		
           if (arg.equals(" Ok ")) {
				   record("message"); // Sauvegarder
				   dispose();	      // puis fermer la fenetre
			           }
	   else if (arg.equals("Cancel")) { // Fermer la fenetre sans sauvegarder
				   dispose();	  
		                   }			  	 		   
         }				   
	 return true;			   
     }	 
}


//----------------------------------    THE END   -----------------------------------------------








