import java.awt.*;
import java.util.*;
import java.lang.String;
import TreeView;


class DblVal {
    int a,b;

    public DblVal (int x, int y) {
        a=x; b=y;
    }

    public DblVal (DblVal d) {
     a = d.a; b = d.b;
    }
}


class TreeViewNode {

  Vector Sons;
  String Label;
  boolean Developed;
  boolean Selected;
  boolean Hilighted;
  int x, y;

  // Les coordonnes relatives d'affichage
  static int rx;
  static int ry;

  Image Img;
  Image DevImg;
  TreeViewNode Father;
  static FontMetrics FM;
  Font Ft;
  boolean fontsSet = false;   // Xavier
  int  lg_Label ;             // Xavier
  static  int tab = 10;      // L'ecart entre un noeud et ses fils sur l'axe des x
  static boolean Modified;
  /* Le canvas dans lequel on est dessine (utile pour les
     image observer) */

  static Canvas Canv;
  static Image plus = Toolkit.getDefaultToolkit().getImage("plus.gif"),
              moins = Toolkit.getDefaultToolkit().getImage("moins.gif");

  static int plH, plW, moH, moW;


  public void SetRx (int _rx) {
    rx = _rx;
    Modified = true;
  }
  
  public void SetRy (int _ry) {
    ry = _ry;
    Modified = true;
  }

  /* Le constructeur */

  public boolean Modified () {
    return Modified;
  }

  public void Modify() {
    Modified = true;
  }

  public TreeViewNode (TreeViewNode _Father, String text) {
    Image image;
    Sons = new Vector(3);
    Developed = false;
    Selected = false;
    Hilighted = false;
    Label = text;
    Father = _Father;
    Modified = true;
    // Ici il faut faire une ouverture d'image par defaut
    Img = Toolkit.getDefaultToolkit().getImage("folder.gif");
    DevImg = Toolkit.getDefaultToolkit().getImage("dvfolder.gif");
  }

  public TreeViewNode (TreeViewNode _Father, Canvas C, String text) {
    Canv = C;

    Sons = new Vector(3);
    Developed = false;
    Selected = false;
    Hilighted = false;
    Label = text;
    x = 0;
    y = 0;
    Father = _Father;

    Modified = true;
    rx = 0;
    ry = 0;

    // Ici il faut faire une ouverture d'image par defaut
    Img = Toolkit.getDefaultToolkit().getImage("folder.gif");
    DevImg = Toolkit.getDefaultToolkit().getImage("dvfolder.gif");
  }

  int max (int x, int y) {
    return (x > y ? x : y);
  }

  // Trouve la racine de l'arbre
  TreeViewNode FindRoot () {
    if (Father == null) {
      return this;
    }
    else return Father.FindRoot();
  }

  int ImgWidth () {

    if (Img == null)
      return 10;
    if (Img.getWidth(Canv) < 0) 
      return 10;
    else return Img.getWidth(Canv);
  }

  int ImgHeight () {
    if (Img == null)
      return 10;
    if (Img.getHeight(Canv) < 0) 
      return 10;
    else return Img.getHeight(Canv);
  }

  private void setFonts (Graphics g) {
    if (fontsSet) return;
    Ft = new Font("Courier", Font.BOLD, 12);
    FM = g.getFontMetrics(Ft);
    fontsSet = true;
  }

  public Point ReCalculate (int _x, int _y) {
    // On me passe la position a partir de laquelle il faut que je me dessine.
    Point P = new Point (0,0);
    if (FM == null)
      return (P);
    x = _x + ImgWidth() + 5;
    y = _y + max (FM.getHeight(), ImgHeight());
    int MaxX = x + FM.stringWidth(Label);

    if (Developed) {
      int i, j = y;
      for (i = 0; i < Sons.size(); i++) {
	j += 10;
	P = ((TreeViewNode) Sons.elementAt(i)).ReCalculate(x + tab, j);
	MaxX = max (P.x,MaxX);
	j = P.y;
      }
      _y = j;
    }
    else {
      _y = y;
    }
    if (Father == null) {
      Modified = false;
    }
    return new Point (MaxX, _y);
  }


public DblVal paint (Graphics g, int _x, boolean line) {

    setFonts(g);
    int X = x - rx, Y = y - ry, MaxY, PosSup, fontSize = Ft.getSize(), _y;
    DblVal dv;

    if (Modified())
        ReCalculate (0,0);

    // Il s'agit de faire afficher l'image associee, puis
    // de faire paint sur les fils si necessaire
    g.setPaintMode();
    if  (Hilighted) {
        g.setColor(Color.pink);
        g.fillRect (X,Y-2-fontSize,FM.stringWidth(Label),fontSize+4);
        g.setColor(Color.blue);
    } else
        g.setColor(Color.black);

    g.setFont(Ft);
    g.drawString (Label, X, Y);
    g.setColor(Color.black);

    if (Img != null) {
      if (Developed)
        g.drawImage(DevImg, X - 5 - ImgWidth(), Y - ImgHeight(),Canv);
      else
        g.drawImage(Img, X - 5 - ImgWidth(), Y - ImgHeight(),Canv);
    }

    int imgh = 0, imgw = 0;
    if (Img != null) {
        imgh = Img.getHeight(Canv);
        imgw = Img.getWidth(Canv);
    }

    int ix = X - 5 - imgw;

    _y = Y - ((imgh != 0) ? (imgh / 2) : (fontSize / 2));
    PosSup = _y;
    MaxY =   _y;

    plH = plus.getHeight(Canv); plW = plus.getWidth(Canv);
    moH = moins.getHeight(Canv); moW = moins.getWidth(Canv);


    if (Father != null) {
        if (Sons.size() != 0) {
            if (Developed == false) {
                PosSup =  _y - (plH / 2);
                MaxY   =  _y + (plH / 2);
                g.drawImage(plus, _x - (plW / 2), PosSup, Canv);
                if (line)
		  g.drawLine(_x + (plW / 2),_y,ix,_y);
            } else { // Developed == true
                PosSup =  _y - (moH / 2);
                MaxY   =  _y + (moH / 2);
                g.drawImage(moins, _x - (moW / 2), PosSup, Canv);
		if (line)
		  g.drawLine(_x + (moW / 2),_y,ix,_y);
            }
        } else 
	  if (line)
	    g.drawLine(_x,_y,ix,_y);

    }

    if (Developed == false) return new DblVal (PosSup,MaxY);

    ix = X - 5 - (imgw/2);

    int i, j = Sons.size();
    _y = ((Img != null) ? Y : _y);
    for (i = 0;line && i < j;i ++) {
      dv = new DblVal(((TreeViewNode) Sons.elementAt(i)).paint(g,ix,line));
      g.drawLine (ix,_y,ix,dv.a);
      _y = dv.b;
    }

    return new DblVal (PosSup,MaxY);
}

  public void move (int _x, int _y) {
    x = _x;
    y = _y;
  }

  public TreeViewNode Duplicate() {
    TreeViewNode N = new TreeViewNode(this, Label);
    N.Img = Img;
    N.Reduce();
    Hilighted = false;
    N.move(x, y); 
    return N;
  }

  /* Les fonctions de gestion de l'arbre */
  public TreeViewNode AddSon(String text) {
    TreeViewNode T = new TreeViewNode (this, text);
    Sons.addElement(T);
    Modified = true;
    return T;
  }

  // Prend un noeud deja existant et le deplace sous le noeud courant
  public TreeViewNode AddSon(TreeViewNode T) {
    T.Father.RemoveSon(T);
    if (T.Father.Sons.size() == 0)
      T.Father.Reduce();
    T.Father = this;
    Sons.addElement(T);
    Modified = true;
    return T;
  }

  public boolean IsASon(TreeViewNode T) {
    if (Father == null) return false;
    if (Father == T) return true;
    else return Father.IsASon(T);
  }

  public void RemoveSon(int index) {
    Sons.removeElementAt(index);
  }

  public void RemoveSon (TreeViewNode T) {
    Sons.removeElement(T);
  }

  public void Remove () {
    int i;
    // Attention, on ne doit pas pouvoir enlever la racine
    if (Father == null) {
      // Ici ca serait mieux d'envoyer une exception
      System.out.println ("Can't remove the root");
      return;
    }

    for (i = 0;i < Sons.size(); i ++) {
      ((TreeViewNode) Sons.elementAt(i)).Remove();
    }
    Father.Sons.removeElement(this);

    Modified = true;
  }

  public void Reduce () {
    Developed = false;
    Modified = true;
  }

  public void Develop () {
    if (Sons.size() != 0) {
      Developed = true;
      Modified = true;
    }
  }

  public void ToggleDevelop () {
    if (Developed)
     Reduce();
    else Develop();
  }

  public void SetIcon(Image I) {
    Img = I;
    DevImg = Img;
  }

  public void SetDevelopedIcon (Image I) {
    DevImg = I;
  }

  /* Les fonctions d'affichage */
  public void Highlight() {
    Hilighted = true;
  }
  public void Lowlight() {
    Hilighted = false;
  }

  boolean IHaveMotion (int _x, int _y) {
    int X = x - rx, Y = y - ry;
    return ((_x <= X-5) && (_x >= X-5 - ImgWidth()) && (_y <= Y) && (_y >= Y - ImgHeight()));
  }

  public TreeViewNode WhoHasMotion (int _x, int _y) {
    int i;
    TreeViewNode N;

    if ( IHaveMotion(_x, _y))
      return (this);
    for (i = 0; i < Sons.size(); i++) {
      N = ((TreeViewNode) Sons.elementAt(i)).WhoHasMotion(_x, _y);
      if (N != null)
	return N;
    }
    return (null);
  }

  public TreeViewNode Father () {
    return Father;
  }


  String GetName () {
    return Label;
  }
}
