import java.awt.*;
import TreeViewNode;
import java.lang.Thread;

class TVCanvas extends Canvas {
  TreeViewNode Root, Dragged;
  int rx, ry;

  public void paint(Graphics g) {
    super.paint(g);
    Root.paint(g,0,true);
    if (Dragged != null)
      Dragged.paint(g,0,false);
  }

  public TVCanvas (TreeViewNode R) {
    rx = 0;
    ry = 0;
    Root = R;
    Dragged = null;
  }
  public void SetDragged (TreeViewNode D) {
    Dragged = D;
  }

  /*  public void SetRx (int _rx) {
    rx = _rx;
    repaint();
  }

  public void SetRy (int _ry) {
    ry = _ry;
    repaint();
  }

  public int GetRy () {
    return ry;
  }
  public int GetRx () {
    return rx;
  } */
}

class TreeView extends Panel {

  TreeViewNode Root;
  TreeViewNode NodeDragged;  
  TVCanvas Canv;
  Scrollbar SBV;
  Scrollbar SBH;
  TreeViewNode Hilighted;
  
  public TreeView (String text) {
    Root = new TreeViewNode(null, Canv, text);
    Canv = new TVCanvas(Root);
    Canv.setBackground(Color.white);
    Canv.setForeground(Color.black);
    super.setBackground(Color.gray);
    setLayout(new BorderLayout());
    NodeDragged = null;
    Hilighted = null;
    Canv.show();
    add ("West",Canv);
  }
  
  // C'est ici que l'on doit verifier s'il y a besoin d'une scrollbar
  public void paint(Graphics g) {
    Canv.SetDragged(NodeDragged);
    Canv.repaint();
  }


  // Pour ces deux fonctions, il est i;possible de recuperer la taille reelle d'une scrollbar
  // C'est pour cela que des valeurs sont entrees en dur
  int SBHHeight() {
    if (SBH != null)
      // return SBH.size().height;
      return 15;
    else return 0;
  }

  int SBVWidth() {
    if (SBV != null)
      //      return SBV.size().width;
      return 15;
    else return 0;
  }

  void CheckScrollBars () {
    // ICI il faut toujours recalculer en fonction de 0, 0 et faire l'affichage en fonction des coordonnees relatives. 
    // Il faut aussi recalculer les clics souris dans la fonction de motion afin de savoir quel objet a ete adresse.
    Point P = Root.ReCalculate(0,0);
    int CW = size().width, CH = size().height;
    int OldXPos = 0, OldYPos = 0;



    if (SBV != null) {
      OldYPos = SBV.getValue();
      remove (SBV);
    }
    if (SBH != null) {
      remove (SBH);
      OldXPos = SBH.getValue();
    }

    SBV = null;
    SBH = null;

    if (P.y > Canv.size().height) {
      SBV = new Scrollbar (Scrollbar.VERTICAL, OldYPos, CH, 0, P.y);
      CW -= SBVWidth();
      if (P.x > CW) {
	SBH = new Scrollbar (Scrollbar.HORIZONTAL, OldXPos, CW, 0, P.y);	
	CH -= SBHHeight();	
	// Ici il faut aussi repositionner les valeurs de la scrollbar verticale
	SBV = new Scrollbar (Scrollbar.VERTICAL, OldYPos, CH, 0, P.y);
      }
    }
    if ((P.x > CW) && (SBH == null)) {
      SBH = new Scrollbar (Scrollbar.HORIZONTAL, OldXPos, CW, 0, P.x);
      CH -= SBHHeight();
      if (P.y > CH) {
	SBV = new Scrollbar (Scrollbar.VERTICAL, OldYPos, CH, 0, P.y);
	CW -= SBVWidth();
	// Ici il faut aussi repositionner les valeurs de la scrollbar horizontale
	SBH = new Scrollbar (Scrollbar.HORIZONTAL, OldXPos, CW, 0, P.x);
      }
    }

    Canv.resize(CW,CH);

    if (SBV != null) {

      add ("East", SBV);
      SBV.show();
      SBV.enable();
    }
    else Root.SetRy(0);

    if (SBH != null) {

      add ("South", SBH);
      SBH.show();
      SBH.enable();      
    }
    else Root.SetRx(0);

    validate();
  }
  
  public void resize (int i, int j) {
    super.resize(i,j);   
    Canv.resize(i,j);
    CheckScrollBars();
    repaint();
  }

  public TreeViewNode GetRoot () {
    return Root;
  }

  // Looks for the TreeViewNode on which the mouse is
  
  public boolean handleEvent(Event evt) {

    TreeViewNode N;
    switch (evt.id) {
    case Event.MOUSE_MOVE : 
      // Recherche du truc qui a ete clique
      N = Root.WhoHasMotion(evt.x,evt.y);
      break;
      
    case Event.MOUSE_DOWN : 
      N = Root.WhoHasMotion(evt.x,evt.y);
      
      if (N != null) {
	if (Hilighted != null)
	  Hilighted.Lowlight();
	N.Highlight();
	Hilighted = N;
	switch (evt.clickCount) {
	case 2 :
          N.ToggleDevelop();

	  CheckScrollBars();
	  //Canv.repaint();
	  //          super.repaint();
	  repaint();
	  break;    
        }
      }
      break;

    case Event.MOUSE_DRAG :
      if (NodeDragged == null) {
	NodeDragged = Root.WhoHasMotion(evt.x, evt.y).Duplicate();
      }	
      else {
	if (Hilighted != null)
	  Hilighted.Lowlight();
	Hilighted = Root.WhoHasMotion(evt.x, evt.y);
	if (Hilighted != null)
	  Hilighted.Highlight();
      }
      
      NodeDragged.move (evt.x, evt.y);
      repaint();
      break;

    case Event.MOUSE_UP :
      if (NodeDragged != null) {
	// On trouve la position d'insertion du noeud en question
	// ON VERIFIE SI ON EST PAS DANS UN FILS DU NOEUD DRAGGE !!
	TreeViewNode InsertNode = Root.WhoHasMotion (evt.x, evt.y);
	if ((NodeDragged != null) && (InsertNode != null)) {
	  if ((! InsertNode.IsASon(NodeDragged.Father())) && (NodeDragged.Father() != InsertNode))
	    InsertNode.AddSon(NodeDragged.Father());
	  // Ici ca serait mieux d'envoyer une exception
	  else System.out.println("Impossible de coller sur un fils");
	}
	NodeDragged = null;
      }
      repaint();
    case Event.SCROLL_ABSOLUTE : 
    case Event.SCROLL_LINE_DOWN :
    case Event.SCROLL_LINE_UP :    
    case Event.SCROLL_PAGE_DOWN :
    case Event.SCROLL_PAGE_UP :

      if (SBV != null) {
	Root.SetRy (SBV.getValue());
	repaint();
      }
      if (SBH != null) {
	Root.SetRx (SBH.getValue());
	repaint();
      }
      break;
    default :
      break;
    }
    return true;
  }
}
