//
// Topology of movings and enterings from/into an operator
//


class Moving
{
	// Constructor
	Moving(int newFromChild, int newDirection, int newToChild)
	{
		fromChild = newFromChild;
		direction = newDirection;
		toChild = newToChild;
	}

	// Try to match
	public boolean match(int withFromChild, int withDirection)
	{
		return (fromChild==withFromChild && direction==withDirection);
	}

	public int fromChild;
	public int direction;
	public int toChild;
}

class Topology
{
	// Add a moving
	public void setMovings(Moving[] movings)
	{
		m_movings = movings;
	}

	// Set entering
	public void setEntering(int enterByRight, int enterByUp, int enterByLeft, int enterByDown)
	{
		m_enterings = new int[4];
		m_enterings[RIGHT] = enterByRight;
		m_enterings[UP] = enterByUp;
		m_enterings[LEFT] = enterByLeft;
		m_enterings[DOWN] = enterByDown;
	}

	// Try to match a moving
	public Moving matchMoving(int fromChild, int direction)
	{
		if (m_movings == null)
			return null;

		for (int index=0; index<m_movings.length; ++index)
		{
			if (m_movings[index].match(fromChild, direction))
				return m_movings[index];
		}

		return null;
	}

	// Try to get an entering information from a direction
	public int getEntering(int direction)
	{
		if (m_enterings == null)
			return -1;

		switch (direction)
		{
		case RIGHT :
			return m_enterings[LEFT];
		case UP :
			return m_enterings[DOWN];
		case LEFT :
			return m_enterings[RIGHT];
		case DOWN :
			return m_enterings[UP];
		}

		return -1;
	}

	// List of movings
	protected Moving[] m_movings;
	
	// Enterings
	protected int[] m_enterings;

	// Four possible directions
	public static final int RIGHT = 0;
	public static final int UP    = 1;
	public static final int LEFT  = 2;
	public static final int DOWN  = 3;
}