//
// Selection for editable formula
//


import java.awt.Graphics;

import Display;
import GraphicBox;
import Operator;
import Topology;

class Selection
{
	// Constructor
	Selection(Operator operator)
	{
		node = operator;
		location = Topology.RIGHT;
		shape = (node.m_children==null ? GraphicBox.shapeStick : GraphicBox.shapeAngle);
		oldBox = new GraphicBox((GraphicBox)(operator.m_display));
	}

	// Node accessor
	public void changeNode(Operator newNode)
	{  
		node = newNode;
		shape = (node.m_children==null ? GraphicBox.shapeStick : GraphicBox.shapeAngle);
	}

	// Location accessor
	public void changeLocation(int newLocation)
	{
		location = newLocation;
	}

	// Change
	public void change(Operator newNode, int newLocation)
	{
		changeNode(newNode);
		changeLocation(newLocation);
	}

	// Draw
	public void draw(Graphics graphics)
	{
		GraphicBox graphicBox = (GraphicBox)(node.m_display);

		graphicBox.draw(graphics, shape, location, node.m_context.selectionColor);
		oldBox = new GraphicBox(graphicBox);
		oldShape = shape;
		oldLocation = location;
	}

	// Clear
	public void clear(Graphics graphics)
	{
		oldBox.draw(graphics, oldShape, oldLocation, node.m_context.background);
	}

	// Mouse selection
	public boolean mouseSelect(Operator node, int mouseX, int mouseY)
	{
		if (! node.m_display.inside(mouseX, mouseY))
			return false;

		changeNode(node);

		if (node.m_children == null)
			return true;

		for (int index=0; index<node.m_children.length; ++index)
		{
			if (mouseSelect(node.m_children[index], mouseX, mouseY))
				return true;
		}

		return true;
	}

	// Associated node
	public Operator node;

	// Graphical information
	public int location;
	public int shape;
	
	// Drawing and hidding
	protected GraphicBox oldBox;
	protected int oldShape;
	protected int oldLocation;
}


/*	// Mouse selection
	public void mouseSelect(int mouseX, int mouseY)
	{
		m_mouse = new Point(mouseX, mouseY);
		m_oldSelection = m_selection;
		m_selection = scanMouseSelection(this, m_absolute.x, m_absolute.y);
		m_hasOnlySelectionChanged = true;
	}
  */
	/*
	// Scan graphic areas to detect mouse selection
	protected Selection scanMouseSelection(Operator node, int x, int y)
	{
		Selection result;

		// Is it in a child ?
		if (node.m_children != null)
		{
			for (int index=0; index<node.m_children.length; ++index)
			{
				result = scanMouseSelection(node.m_children[index], x+node.m_box.relativeX, y+node.m_box.relativeY);
				if (result != null)
					return result;
			}
		}

		// Is it in this node ?
		if (node.m_box.inside(x, y, m_mouse.x, m_mouse.y))
		{
			Selection selection = new Selection(node, x, y);
			selection.location = (m_mouse.x<=x+node.m_box.relativeX+node.m_box.width/2
			                      ? Topology.LEFT
								  : Topology.RIGHT);
			return selection;
		}

		// Not in children nor this node
		return null;
	}	*/
	  	  /*
	// Rescan for selection, setting its new absolute coordinates
	// Pre-condition: selection does exist from node (not null)
	protected boolean rescanSelection(Operator node, int x, int y)
	{
		if (m_selection.node == node)
		{
			m_selection.absolute = new Point(x, y);
			return true;  // found, terminate recursion going up directly to parent
		}

		if (node.m_children != null)
		{
			for (int index=0; index<node.m_children.length; ++index)
			{
				if (rescanSelection(node.m_children[index], x+node.m_box.relativeX, y+node.m_box.relativeY))
					return true;
			}
		}

		return false;
	} */
	// Scan from a node to detect volatile regions
	/*protected void scanVolatile()
	{
		Operator node = (m_selection==null ? m_oldSelection.node : m_selection.node);

		if (node == null)
			return;

		if (m_mark!=null)
			m_mark.active = false;

		Mark newMark = new Mark();
		newMark.active = true;
		for (Operator index=node; index!=null; index=index.m_parent)
			index.m_mark = newMark;
	} */

