//
// Namers
//


class Namer
{
	// Detect string namer
	public static boolean isPrefixNamer(String string)
	{
		if (string.length()==0 || string.charAt(0)!='!')
			return false;

		if (string.length() == 1)
			return true;

		for (int index=0; index<namers.length; ++index)
		{
			if (string.regionMatches(1, namers[index], 0, string.length()-1))
				return true;
		}

		return false;
	}

	// Table of namers
	public static final String[] namers =
	{
		"sqrt",
		"matrix",
		"sigma",
		"pi"
	};
}

class Completion
{
	// Constructor
	Completion(String prefix)
	{
		m_prefix = prefix;
		m_state = 0;
	}

	// Return next suffix
	public String nextSuffix()
	{
		for (int index=0; index<Namer.namers.length; ++index)
		{
			// Find prefix matching
			if (m_prefix.regionMatches(1, Namer.namers[(m_state+index)%Namer.namers.length], 0, m_prefix.length()-1))
			{
				// Return corresponding suffix
				m_state = (m_state + index) % Namer.namers.length + 1;
				return Namer.namers[m_state-1].substring(m_prefix.length()-1);
			}
		}

		return null;
	}

	// Prefix accessor
	public String getPrefix()
	{
		return m_prefix;
	}

	// Namer
	public String getNamer()
	{
		return ("!" + Namer.namers[m_state-1]);
	}

	// String prefix
	protected String m_prefix;

	// Completion state
	protected int m_state;
}