//
//  JavaMath on the web
//
//  Version 1.0b
//
//  Copyright (c) 1997 Christophe MAGNANI, All Rights Reserved


import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

import Command;
import Context;
import DisplayedFormula;
import EditableFormula;

public class JavaMath extends java.applet.Applet
{
	// Initialize the applet
	public void init()
	{
		Context context = new Context(new Vector(),     // Garbage
		                              this,             // Panel
									  bounds(),			// Global bounds
									  new Rectangle(),	// Invalid area
									  getBackground(),  // Background color
									  getForeground(),  // Foreground color
									  getForeground(),  // Selection color
									  getForeground(),  // Syntactical color: identifiers
									  getForeground(),  // Syntactical color: numbers
									  getForeground(),  // Syntactical color: namers
									  "Courier",        // Font name
									  14,               // Default font size
									  8,                // Minimal font size
									  80);              // Font reduce (factor of conservation)

		String parameter;

		if ((parameter=getParameter("background")) != null)
			context.background = translateColor(parameter);

		if ((parameter=getParameter("foreground")) != null)
			context.foreground = translateColor(parameter);

		if ((parameter=getParameter("selection")) != null)
			context.selectionColor = translateColor(parameter);

		if ((parameter=getParameter("identifier")) != null)
			context.identifierColor = translateColor(parameter);

		if ((parameter=getParameter("number")) != null)
			context.numberColor = translateColor(parameter);

		if ((parameter=getParameter("namer")) != null)
			context.namerColor = translateColor(parameter);

		if ((parameter=getParameter("fontName")) != null)
			context.fontName = parameter;

		if ((parameter=getParameter("defaultFontSize")) != null)
			context.defaultFontSize = Integer.parseInt(parameter);

		if ((parameter=getParameter("minimalFontSize")) != null)
			context.minimalFontSize = Integer.parseInt(parameter);

		if ((parameter=getParameter("fontReduce")) != null)
			context.fontReduce = Integer.parseInt(parameter);

		setBackground(context.background);

		if ((parameter=getParameter("expression")) == null)
		{
			formula = new EditableFormula(context, 15, 15);
			m_editable = true;
		}
		else
		{
			formula = new DisplayedFormula(context, 15, 15, parameter);
			m_editable = false;
		}
	}

	// Start the applet
	public void start()
	{
		repaint();
	}

	// Update graphic area (with control of clearing)
	public void update(Graphics graphics)
	{
		paint(graphics);
	}

	// Paint graphic area
	public void paint(Graphics graphics)
	{
		formula.redraw(graphics, m_partialRefresh);
		m_partialRefresh = false;
	}

	// Mouse down event
	public boolean mouseDown(Event event, int x, int y)
	{
		if (! m_editable)
			return true;
		((EditableFormula)formula).mouseSelect(x, y);
		m_partialRefresh = true;
		repaint();
		return true;
	}

	// Keyboard event
	public boolean keyDown(Event event, int key)
	{
		if (!m_editable || m_busy)
			return true;
		m_busy = true;
		formula.executeCommand(new Command(event, key));
		m_partialRefresh = true;
		repaint();
		m_busy = false;
		return true;
	}

	// Translate color from string representation
	public Color translateColor(String string)
	{
		if (string.compareTo("black")==0)
			return Color.black;
		else if (string.compareTo("blue")==0)
			return Color.blue;
		else if (string.compareTo("cyan")==0)
			return Color.cyan;
		else if (string.compareTo("darkGray")==0)
			return Color.darkGray;
		else if (string.compareTo("gray")==0)
			return Color.gray;
		else if (string.compareTo("green")==0)
			return Color.green;
		else if (string.compareTo("lightGray")==0)
			return Color.lightGray;
		else if (string.compareTo("magenta")==0)
			return Color.magenta;
		else if (string.compareTo("orange")==0)
			return Color.orange;
		else if (string.compareTo("pink")==0)
			return Color.pink;
		else if (string.compareTo("red")==0)
			return Color.red;
		else if (string.compareTo("white")==0)
			return Color.white;
		else if (string.compareTo("yellow")==0)
			return Color.yellow;

		return getForeground();
	}

	// A formula
	public Formula formula;

	// Editability
	public boolean m_editable;

	// Forced refresh
	public boolean m_partialRefresh;

	// Busy flag
	public boolean m_busy;
}
