//
// Graphic box structure
//


import java.awt.Color;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;

class GraphicBox extends Rectangle
{
	// Constructor
	GraphicBox()
	{
		super();
		relativeX = relativeY = yarn = 0;
	}

	// Constructor
	GraphicBox(GraphicBox graphicBox)
	{
		super();
		x = graphicBox.x;
		y = graphicBox.y;
		width = graphicBox.width;
		height = graphicBox.height;
		relativeX = graphicBox.relativeX;
		relativeY = graphicBox.relativeY;
		yarn = graphicBox.yarn;
	}

	// Drawing
	public void draw(Graphics graphics, int shape, int location, Color color)
	{
		graphics.setColor(color);
		switch (location)
		{
		case Topology.LEFT :
			graphics.drawLine(x, y, x, y+height);
			break;
		case Topology.RIGHT :
			graphics.drawLine(x+width, y, x+width, y+height);
			break;
		}					 
		if (shape == shapeAngle)
			graphics.drawLine(x, y+height, x+width, y+height);
	}

	// Graphic area in relative coordinates
	public int relativeX, relativeY;

	// Yarn line for alignment
	public int yarn;

	// Delta value for space between boxes
	public static final int deltaWidth = 2;
	public static final int deltaHeight = 2;

	// Shape categories
	public static final int shapeStick = 0;
	public static final int shapeAngle = 1;
}