//
// Editable string
//


import java.util.Stack;

import Namer;

class EditableString
{
	// Constructor
	EditableString(char character)
	{
		m_value = new String();
		m_type = m_typeStart;
		m_stack = new Stack();
		insert(character);
	}

	// Constructor
	EditableString(String string)
	{
		m_value = new String();
		m_type = m_typeStart;
		m_stack = new Stack();
		insert(string);
	}

	// Insert string
	public void insert(String string)
	{
		for (int index=0; index<string.length(); ++index)
			insert(string.charAt(index));
	}

	// Insert character
	public void insert(char character)
	{
		m_value += (new Character(character)).toString();

		m_stack.push(new Integer(m_type));

		switch (m_type)
		{
		case m_typeStart :
			if (Namer.isPrefixNamer(m_value))
				m_type = m_typeNamer;
			else if (Character.isDigit(character))
				m_type = m_typeInteger;
			else if (character == '.')
				m_type = m_typeFloat;
			else if (Character.isLetter(character))
				m_type = m_typeIdentifier;
			else
				m_type = m_typeOther;
			break;
		case m_typeIdentifier :
			if (! Character.isLetterOrDigit(character))
				m_type = m_typeOther;
			break;
		case m_typeInteger :
			if (character == '.')
				m_type = m_typeFloat;
			else if (! Character.isDigit(character))
				m_type = m_typeIdentifier;
			break;
		case m_typeFloat :
			if (! Character.isDigit(character))
				m_type = m_typeIdentifier;
			break;
		case m_typeNamer :
			if (! Namer.isPrefixNamer(m_value))
				m_type = m_typeOther;
			break;
		}
	}

	// Delete
	public boolean delete()
	{
		if (m_value.length() < 2)
			return false;

		m_value = m_value.substring(0, m_value.length()-1);

		m_type = ((Integer)(m_stack.pop())).intValue();

		return true;
	}

	// Value accessor
	public String getValue()
	{
		return m_value;
	}

	// Value accessor
	public void setValue(String value)
	{
		m_value = new String();
		m_type = m_typeStart;
		insert(value);
	}

	// Type accessor
	public boolean isInteger()
	{
		return (m_type == m_typeInteger);
	}

	// Type accessor
	public boolean isFloat()
	{
		return (m_type == m_typeFloat);
	}

	// Type accessor
	public boolean isNumber()
	{
		return (m_type==m_typeInteger || m_type==m_typeFloat);
	}

	// Type accessor
	public boolean isIdentifier()
	{
		return (m_type==m_typeIdentifier || m_type==m_typeStart);
	}

	// Type accessor
	public boolean isNamer()
	{
		return (m_type == m_typeNamer);
	}

	// Type accessor
	public boolean isOther()
	{
		return (m_type == m_typeOther);
	}

	// Text information
	protected String m_value;

	// Type information
	protected int m_type;

	// Stack of types (to undo after deletion)
	protected Stack m_stack;

	// Possible types
	protected final int m_typeStart = 0;
	protected final int m_typeInteger = 1;
	protected final int m_typeFloat = 2;
	protected final int m_typeIdentifier = 3;
	protected final int m_typeNamer = 4;
	protected final int m_typeOther = 5;
}