//
// Displayed formula
//


import java.awt.Graphics;
import java.util.StringTokenizer;

import Context;
import Formula;
import GraphicBox;

class DisplayedFormula extends Formula
{
	DisplayedFormula(Context context, int x, int y, String expression)
	{
		super(context, x, y);
		generate(expression);
		update();
	}

	// Insert minus or opposite
	protected void insertMinusOrOpposite()
	{
		if (linear instanceof ConstantOperator)
			linear = (new Operator_minus(m_context)).flop(linear);
		else
			linear = (new Operator_opposite(m_context)).flop(linear);
	}

	// Insert a new operator
	protected void insertOperator(Operator operator)
	{
		linear = operator.flop(linear);
	}

	// Specific command action on the formula
	public void executeCommand(Command command)
	{
		Operator node;

		switch (command.getAction())
		{
		// NEW OPERATOR

		case Command.LETTER_OR_DIGIT :
			insertOperator(new ConstantOperator(m_context, command.getCharValue()));
			break;
		case Command.STRING :
			insertOperator(new ConstantOperator(m_context, command.getStringValue()));
			break;
		case Command.COMMA :
			insertOperator(new Operator_comma(m_context));
			break;
		case Command.EQUAL :
			insertOperator(new Operator_equal(m_context));
			break;
		case Command.PLUS :
			insertOperator(new Operator_plus(m_context));
			break;
		case Command.MINUS :
			insertMinusOrOpposite();
			break;
		case Command.MULTIPLY :
			insertOperator(new Operator_multiply(m_context));
			break;
		case Command.COMPOSE :
			insertOperator(new Operator_compose(m_context));
			break;
		case Command.SUPERSCRIPT:
			insertOperator(new Operator_superscript(m_context));
			break;
		case Command.SUBSCRIPT:
			insertOperator(new Operator_subscript(m_context));
			break;
		case Command.FRACTION :
			insertOperator(new Operator_fraction(m_context));
			break;
		case Command.AND :
			linear = (new Operator_matrixNextColumn(m_context)).flop(linear);
			break;
		case Command.OR :
			linear = (new Operator_matrixNextRow(m_context)).flop(linear);
			break;
		case Command.NEXT :
			linear = (new Operator_next(m_context)).flop(linear);
			break;
		case Command.JUMP :
			linear = (new Operator_jump(m_context)).flop(linear);
			break;
		case Command.BRACKETS :
			linear = (new BracketsOperator(m_context)).flop(linear);
			break;
		case Command.SIGMA :
			linear = (new Operator_sigma(m_context)).flop(linear);
			break;
		case Command.SQRT :
			linear = (new Operator_sqrt(m_context)).flop(linear);
			break;
		case Command.MATRIX :
			linear = (new Operator_matrix(m_context)).flop(linear);
			break;
		case Command.PI :
			linear = (new Operator_Pi(m_context)).flop(linear);
		}
	}

	// Generate commands from parsing
	protected void generate(String expression)
	{
		// Initialize linear to the unique child
		linear = m_children[0];

		// Create parsing environment
		StringTokenizer stringTokenizer = new StringTokenizer(expression, " ,=+-*:^_/;&|(){}", true);
		String token;

		// Loop for parsing
		while (stringTokenizer.hasMoreTokens())
		{
			token = stringTokenizer.nextToken();

			// White space
			if (token.charAt(0)==' ' || token.charAt(0)=='{')
				continue;

			executeCommand(new Command(token));
		}
	}

	// Linear node
	protected Operator linear;
}