//
// Context of propagation
//


import java.awt.Color;
import java.awt.Font;
import java.awt.Panel;
import java.awt.Rectangle;
import java.util.Vector;
							 
class Context
{
	// Constructor
	Context(Vector newGarbage,
	        Panel newPanel,
			Rectangle newBounds,
	        Rectangle newInvalidate,
			Color newBackground,
			Color newForeground,
			Color newSelectionColor,
			Color newIdentifierColor,
			Color newNumberColor,
			Color newNamerColor,
			String newFontName,
			int newDefaultFontSize,
			int newMinimalFontSize,
			int newFontReduce)
	{
		garbage = newGarbage;
		panel = newPanel;
		bounds = newBounds;
		invalidate = newInvalidate;
		background = newBackground;
		foreground = newForeground;
		selectionColor = newSelectionColor;
		identifierColor = newIdentifierColor;
		numberColor = newNumberColor;
		namerColor = newNamerColor;
		fontName = newFontName;
		defaultFontSize = newDefaultFontSize;
		minimalFontSize = newMinimalFontSize;
		fontReduce = newFontReduce;
	}

	// Garbage collector for nodes with no parent
	public Vector garbage;

	// Global attributes of the context
	public Panel panel;

	// Global bounds
	public Rectangle bounds;

	// Invalidate area
	public Rectangle invalidate;

	// Syntactic colors
	public Color background;
	public Color foreground;
	public Color selectionColor;
	public Color identifierColor;
	public Color numberColor;
	public Color namerColor;

	// Font name
	public String fontName;

	// Default font size
	public int defaultFontSize;

	// Minimal font size for readibility
	public int minimalFontSize;

	// Font reduce factor (in per cent)
	public int fontReduce;

	// Mark
	public Integer bracketsMark;
}

class LocalContext
{
	// Constructor
	LocalContext(String newFontName,
	             int newFontSize)
	{
		fontName = newFontName;
		fontSize = newFontSize;
	}

	// Constructor
	LocalContext(LocalContext localContext)
	{
		fontName = localContext.fontName;
		fontSize = localContext.fontSize;
	}

	// Font
	public String fontName;
	public int fontSize;
}