//
// Command actions
//


import java.awt.Event;

class Command
{
	// Constructor
	Command(int action)
	{
		m_action = action;
	}

	// Constructor
	Command(String value)
	{
		analysis(value);
	}

	// Constructor
	Command(Event event, int key)
	{
		// Convert key to char
		switch (key)
		{
		case Event.RIGHT :
			m_action = (event.shiftDown(), event.controlDown() ? CONTROL_RIGHT : RIGHT);
			break;
		case Event.UP :
			m_action = (event.shiftDown(), event.controlDown() ? CONTROL_UP : UP);
			break;
		case Event.LEFT :
			m_action = (event.shiftDown(), event.controlDown() ? CONTROL_LEFT : LEFT);
			break;
		case Event.DOWN :
			m_action = (event.shiftDown(), event.controlDown() ? CONTROL_DOWN : DOWN);
			break;
		default :
			analysis(event.shiftDown(), event.controlDown(), (char)key);
		}
	}

	// Character analysis
	protected void analysis(char key)
	{
		analysis(false, false, key);
	}

	// Character analysis
	protected void analysis(boolean shiftDown, boolean controlDown, char key)
	{
		switch (key)
		{
		case 16  :  // ^P
			m_action = RIGHT;
			break;
		case 17  :  // ^Q
		case 1   :  // ^A
			m_action = UP;
			break;
		case 15  :  // ^O
			m_action = LEFT;
			break;
		case 23  :  // ^W
		case 26  :  // ^Z
			m_action = DOWN;
			break;
		case 6   :  // ^F forward
			m_action = CONTROL_RIGHT;
			break;
		case 21  :  // ^U up
			m_action = CONTROL_UP;
			break;
		case 2   :  // ^B backward
			m_action = CONTROL_LEFT;
			break;
		case 4   :  // ^D down
			m_action = CONTROL_DOWN;
			break;
		case 18  :  // ^R control row
			m_action = CONTROL_ROW;
			break;
		case 3   :  // ^C control column
			m_action = CONTROL_COLUMN;
			break;
		case 10  : // LF
		case 13  : // CR
			m_action = ENTER;
			break;
		case 8   : // DELETE
			m_action = DELETE;
			break;
		case ',' :
			m_action = COMMA;
			break;
		case '=' :
			m_action = EQUAL;
			break;
		case '+' :
			m_action = PLUS;
			break;
		case '-' :
			m_action = MINUS;
			break;
		case '*' :
			m_action = MULTIPLY;
			break;
		case '/' :
			m_action = FRACTION;
			break;
		case '^' :
			m_action = SUPERSCRIPT;
			break;
		case '_' :
			m_action = SUBSCRIPT;
			break;
		case ':' :
			m_action = COMPOSE;
			break;
		case '(' :
			m_action = BRACKETS;
			break;
		case ')' :
			m_action = JUMP;
			break;
		case '&' :
			m_action = AND;
			break;
		case '|' :
			m_action = OR;
			break;
		case ';' :
			m_action = NEXT;
			break;
		case ' ' :
		case '}' :
			m_action = JUMP;
			break;
		case 9   : // TAB
			m_action = TAB;
			break;
		default :
			if (Character.isLetterOrDigit(key) || key=='.' || key=='!')
			{
				m_action = LETTER_OR_DIGIT;
				m_charValue = key;
			}
			else
				m_action = NOP;
		}
	}

	// String analysis
	protected void analysis(String value)
	{
		// One character symbol
		if (value.length() == 1)
			analysis(value.charAt(0));

		// Namer
		else if (value.charAt(0)=='!')
		{
			if (value.compareTo("!sqrt")==0)
				m_action = SQRT;
			else if (value.compareTo("!sigma")==0)
				m_action = SIGMA;
			else if (value.compareTo("!matrix")==0)
				m_action = MATRIX;
			else if (value.compareTo("!pi")==0)
				m_action = PI;
			else
				m_action = NOP;
		}

		// Other
		else
		{
			m_action = STRING;
			m_stringValue = value;
		}
	}

	// Get action
	public int getAction()
	{
		return m_action;
	}

	// Get char value
	public char getCharValue()
	{
		return m_charValue;
	}

	// Get string value
	public String getStringValue()
	{
		return m_stringValue;
	}

	// The memorized action
	protected int m_action;

	// Associated value
	protected char m_charValue;
	protected String m_stringValue;

	// Possible command actions
	public static final int NOP = 0;
	public static final int RIGHT = 8;
	public static final int UP = 9;
	public static final int LEFT = 10;
	public static final int DOWN = 11;
	public static final int CONTROL_RIGHT = 16;
	public static final int CONTROL_UP = 17;
	public static final int CONTROL_LEFT = 18;
	public static final int CONTROL_DOWN = 19;
	public static final int DELETE = 20;
	public static final int CONTROL_ROW = 21;
	public static final int CONTROL_COLUMN = 22;
	public static final int TAB = 23;
	public static final int COMPLETE = 22;
	public static final int ENTER = 32;
	public static final int NEXT = 35;
	public static final int JUMP = 36;
	public static final int AND = 37;
	public static final int OR = 38;
	public static final int LETTER_OR_DIGIT = 64;
	public static final int STRING = 65;
	public static final int PLUS = 66;
	public static final int MINUS = 67;
	public static final int MULTIPLY = 68;
	public static final int FRACTION = 69;
	public static final int COMPOSE = 70;
	public static final int SUPERSCRIPT = 71;
	public static final int SUBSCRIPT = 72;
	public static final int COMMA = 73;
	public static final int EQUAL = 74;
	public static final int BRACKETS = 128;
	public static final int SQRT = 129;
	public static final int MATRIX = 130;
	public static final int SIGMA = 131;
	public static final int PI = 132;
}