import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.util.*;
import java.io.*;
import java.net.*;

public class jFM {
  public static void main(String args[]) throws IOException {
    JFrame mainFrame;
    FMMainWindow mainWindow;
    FMClient client;
    FMSettings settings;
    int port;

    settings = new FMSettings();
    try {
      settings.read("Config/jFM.settings");
    }
    catch(IOException exception) {
      System.out.println("Error reading settings. Choose FindMe|Settings for setup");
    }

    if(args.length > 0) {
      try {
	port = Integer.parseInt(args[0]);
      }
      catch(NumberFormatException exception) {
	port = 7000;
      };
    }
    else port = 7000;

    System.out.println("Running client on port " + port);
    settings.setClientPort(port);
    
    mainFrame = null;
    try {
      mainFrame = new JFrame("Java Find Me on " + InetAddress.getLocalHost().getHostName() + " [" + port + "]");
    }
    catch(Exception e) {
      System.out.println("Cannot get local host address. Quitting");
      System.exit(0);
    };

    client = new FMClient(settings, mainFrame);		       
    client.start();

    mainWindow = new FMMainWindow(mainFrame, client);
    mainWindow.loadUserList();
    
    mainFrame.getContentPane().add("Center", mainWindow);
    mainFrame.pack();
    mainFrame.show();
  };
};
