import java.io.*;
import java.net.*;
import java.util.*;

/**
 * <B>FMUser</B>.<BR><BR>
 * Holds all the info regarding a user.
 */
public class FMUser {
  int ID; /* The user ID */
  String password; /* The user password */
  String nickName; /* The user nick name */
  String realName; /* The user real name */
  String eMail; /* The user e-mail */
  String info; /* User info line */
	
  /* Runtime data. This won't be always available */
  InetAddress hostAddress; /* The host where the user is calling from */
  String hostName; /* The name of the host */
  int hostPort; /* The port where the user client runs */
	
  int flags; /* User flags (Away, and so on) */
  Vector ignoreList; /* The user ID which will be ignored */
	
  /**
   * Public constructor.
   * Initializes the user.
   */
  public FMUser() {
    ID = 0;
    nickName = "nonick";
    realName = "noname";
    eMail = "nomail";
    info = "noinfo";
    flags = 0;
    ignoreList = new Vector(10, 5);
		
    hostAddress = null;
    hostName = null;
    hostPort = 0;
  };

  /**
   * Set the user ID.
   *
   * @param ID The user ID
   */
  public void setID(int ID) {
    this.ID = ID;
  };

  /**
   * Get the user ID.
   *
   * @return The user ID
   */
  public int getID() {
    return ID;
  };

  /**
   * Set the user password.
   *
   * @param password The user password
   */
  public void setPassword(String password) {
    this.password = password;
  };

  /**
   * Get the user password.
   *
   * @return The user password
   */
  public String getPassword() {
    return password;
  };
   
  /**
   * Set the user nickname.
   *
   * @param nickName The user nickname
   */
  public void setNickName(String nickName) {
    this.nickName = nickName;
  };
	
  /**
   * Get the user nickname.
   *
   * @return The user nickname
   */
  public String getNickName() {
    return nickName;
  };

  /**
   * Set the user real name.
   *
   * @param realName The user real name
   */
  public void setRealName(String realName) {
    this.realName = realName;
  };

  /**
   * Get the user real name.
   *
   * @return The user real name
   */
  public String getRealName() {
    return realName;
  };
	
  /**
   * Set the user e-mail.
   *
   * @param eMail The user e-mail
   */
  public void setEMail(String eMail) {
    this.eMail = eMail;
  };
	
  /**
   * Get the user e-mail.
   *
   * @return The user e-mail
   */
  public String getEMail() {
    return eMail;
  };
	
  /**
   * Set the user info line.
   *
   * @param info The user info line
   */
  public void setInfo(String info) {
    this.info = info;
  };
	
  /**
   * Get the user info line.
   *
   * @return The user info line
   */
  public String getInfo() {
    return info;
  };

  /**
   * Set the user host.
   *
   * @param hostAddress The user host
   */
  public void setHostAddress(InetAddress hostAddress) {
    this.hostAddress = hostAddress;
    hostName = hostAddress.getHostName();
  };
	
  /**
   * Get the user host.
   *
   * @return The user host
   */
  public InetAddress getHostAddress() {
    return hostAddress;
  };

  /**
   * Get the user host name.
   *
   * @return The user host name
   */
  public String getHostName() {
    return hostName;
  };
	
  /**
   * Set the user host port.
   *
   * @param hostPort The user host port
   */
  public void setHostPort(int hostPort) {
    this.hostPort = hostPort;
  };
	
  /**
   * Get the user host port.
   *
   * @return The user host port
   */
  public int getHostPort() {
    return hostPort;
  };

  /**
   * Add a user ID to the user ignore list.
   *
   * @param ID The user ID to be ignored
   */
  public void ignore(int ID) {
    ignoreList.addElement(new Integer(ID));
  };

  /**
   * Remove a user ID from the user ignore list.
   *
   * @param ID The user ID to be unignored
   */
  public void unIgnore(int ID) {
    Enumeration e;
    Integer currentID;
		
    e = ignoreList.elements();
    while(e.hasMoreElements()) {
      currentID = (Integer)e.nextElement();
			
      if(currentID.intValue() == ID) ignoreList.removeElement(currentID);
    };
  };
	
  /**
   * Check if a user ID is ignored.
   *
   * @param ID The user ID to be checked
   * @return true is the ID is ignored
   */
  public boolean isIgnored(int ID) {
    Enumeration e;
    Integer currentID;
		
    e = ignoreList.elements();
    while(e.hasMoreElements()) {
      currentID = (Integer)e.nextElement();
			
      if(currentID.intValue() == ID) return true;
    };
		
    return false;
  };
	
  /**
   * Read the user data from a file.
   *
   * @param fileName The file name which contains the user data
   * @exception java.io.IOException Error reading the file
   * @exception java.io.FileNotFoundException The file name was not found
   */
  public void read(String fileName) throws IOException, FileNotFoundException {
    DataInputStream is;
		
    is = new DataInputStream(new FileInputStream(fileName));
    read(is);
    is.close();
  };

  /**
   * Write user data to a file.
   * 
   * @param fileName The file name onto which write the user data
   * @exception java.io.IOException Error writing data
   */
  public void write(String fileName) throws IOException {
    DataOutputStream os;
		
    os = new DataOutputStream(new FileOutputStream(fileName));
    write(os);
    os.close();
  };
	
  /**
   * Read the user data from an input stream.
   *
   * @param is The stream from where we'll read the user data
   * @exception java.io.IOException Error reading data
   */
  public void read(DataInputStream is) throws IOException {
    ID = is.readInt();
    password = is.readUTF();
    nickName = is.readUTF();
    realName = is.readUTF();
    eMail = is.readUTF();
    info = is.readUTF();
  };
	
  /**
   * Write user data to an output stream.
   * 
   * @param os The stream onto which write the user data
   * @exception java.io.IOException Error writing data
   */
  public void write(DataOutputStream os) throws IOException {
    os.writeInt(ID);
    os.writeUTF(password);
    os.writeUTF(nickName);
    os.writeUTF(realName);
    os.writeUTF(eMail);
    os.writeUTF(info);
  };
	
  /**
   * Read the user data from an input stream, including host information.
   *
   * @param is The stream from where we'll read the user data
   * @exception java.io.IOException Error reading data
   */
  public void readAll(DataInputStream is) throws IOException {
    String hostIP;
		
    read(is);
    hostIP = is.readUTF();
		
    try {
      hostAddress = InetAddress.getByName(hostIP);
      hostName = hostAddress.getHostName();
    }
    catch(UnknownHostException exception) {
      hostAddress = null;
      hostName = null;
    };
		
    hostPort = is.readInt();
  };
	
  /**
   * Write user data to an output stream, including host information.
   * 
   * @param os The stream onto which write the user data
   * @exception java.io.IOException Error writing data
   */
  public void writeAll(DataOutputStream os) throws IOException {
    write(os);
    os.writeUTF(hostAddress.getHostAddress());
    os.writeInt(hostPort);
  };

  /**
   * Build a string representation of the user data.
   *
   * @return A string describing the user
   */
  public String toString() {
    //return "ID : " + ID + "\n" + "Password : " + password + "\n" + "Nickname : " + nickName + "\n" + "Realname : " + realName + "\n" + "EMail    : " + eMail + "\n" + "Info     : " + info + "\n" + "Host     : " + hostAddress + "\n" + "Port     : " + hostPort + "\n";

    return "[ID:" + ID + "] [" + nickName + "] [" + realName + "]";
  };
    
};











