import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.util.*;
import java.io.*;
import java.net.*;

class FMTalkConnection extends Thread {
  FMTalkDialog talkDialog;
  Socket socket;
  DataInputStream is;
  DataOutputStream os;

  public FMTalkConnection(FMTalkDialog talkDialog, Socket socket) throws IOException {
    this.talkDialog = talkDialog;
    this.socket = socket;
    is = new DataInputStream(socket.getInputStream());
    os = new DataOutputStream(socket.getOutputStream());
  };

  public void send(char c) {
    try {
      os.writeChar(c);
    }
    catch(IOException e) {
    };
  };

  public void close() {
    try {
      socket.close();
    }
    catch(IOException e) {
    };

    stop();
  };

  public void run() {
    char c;
    int bytesRead;

    while(true) {
      try {
	c = is.readChar();
	talkDialog.remoteArea.setText(talkDialog.remoteArea.getText() + c);
      }
      catch(EOFException e) {
	talkDialog.localArea.setEditable(false);
	talkDialog.remoteArea.setText(talkDialog.remoteArea.getText() + "\n\nRemote has closed connection");
	break;
      }
      catch(IOException e) {
	JOptionPane.showMessageDialog(talkDialog.frame, "Error reading");
      };
    };
  };
};

public class FMTalkDialog extends JDialog {
  JFrame frame;
  JTextArea localArea;
  JTextArea remoteArea;
  FMTalkConnection talkConnection;
  FMUser user;
  
  class DisconnectButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      talkConnection.close();
      FMTalkDialog.this.setVisible(false);
      FMTalkDialog.this.dispose();
    };
  };

  class TextKeyListener extends KeyAdapter {
    public void keyTyped(KeyEvent event) {
      talkConnection.send(event.getKeyChar());
    };
  };

  public FMTalkDialog(JFrame frame, FMUser user, Socket socket) throws IOException {	
    super(frame, "Talk to : " + user.getNickName() + " [" + user.getRealName() + "]", false);
    
    Container contentPane;
    GridBagLayout gridBag;
    GridBagConstraints c;
    JLabel label;
    JButton button;
    JPanel panel;
    JScrollPane scrollPane;
    JTextArea textArea;

    this.frame = frame;
    this.user = user;
    talkConnection = new FMTalkConnection(this, socket);
    talkConnection.start();

    contentPane = getContentPane();
    
    gridBag = new GridBagLayout();
    c = new GridBagConstraints();
    
    contentPane.setLayout(gridBag);
		
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1; c.weighty = 0;
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.gridheight = 1;
    
    label = new JLabel("Local :");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    localArea = new JTextArea(10, 40);
    localArea.setFont(new Font("fixed", Font.PLAIN, 14));
    scrollPane = new JScrollPane(localArea);
    localArea.addKeyListener(new TextKeyListener());
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(scrollPane, c);
    contentPane.add(scrollPane);

    label = new JLabel("Remote :");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    remoteArea = new JTextArea(10, 40);
    remoteArea.setEditable(false);
    remoteArea.setFont(new Font("fixed", Font.PLAIN, 14));
    scrollPane = new JScrollPane(remoteArea);
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(scrollPane, c);
    contentPane.add(scrollPane);

    panel = new JPanel();
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(panel, c);
    contentPane.add(panel);
    
    button = new JButton("Disconnect");
    button.addActionListener(new DisconnectButtonListener());
    panel.add(button);
  };
};
