import java.io.*;

public class FMSettings {
  String serverName;
  int serverPort;
  int clientPort;
  
  public FMSettings() {
    serverName = null;
    serverPort = 0;
  };
  
  public String getServerName() {
    return serverName;
  };
  
  public void setServerName(String serverName) {
    this.serverName = serverName;
  };
  
  public int getServerPort() {
    return serverPort;
  };
  
  public void setServerPort(int serverPort) {
    this.serverPort = serverPort;
  };

  public void setClientPort(int clientPort) {
    this.clientPort = clientPort;
  };

  public int getClientPort() {
    return clientPort;
  };
	
  public void read(String fileName) throws FileNotFoundException, IOException {
    DataInputStream is;
    
    is = new DataInputStream(new FileInputStream(fileName));
    read(is);
    is.close();
  };
  
  public void write(String fileName) throws IOException {
    DataOutputStream os;
    
    os = new DataOutputStream(new FileOutputStream(fileName));
    write(os);
    os.close();
  };
  
  public void read(DataInputStream is) throws IOException {
    serverName = is.readUTF();
    serverPort = is.readInt();
  };
  
  public void write(DataOutputStream os) throws IOException {
    os.writeUTF(serverName);
    os.writeInt(serverPort);
  };
  
  public String toString() {
    return "[" + serverName + " - " + serverPort + "]";
  };
};
